/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddFromSelectionAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveSelectedAction
extends AddFromSelectionAction {
    private static final long serialVersionUID = 1L;

    public RemoveSelectedAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, IRelationEditorUpdateOn.SELECTION_TABLE_CHANGE);
        this.putValue("ShortDescription", I18n.tr("Remove all members referring to one of the selected objects", new Object[0]));
        new ImageProvider("dialogs/relation", "deletemembers").getResource().attachImageIcon(this, true);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.getLayer().data;
        if (ds == null || ds.selectionEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.editorAccess.getMemberTableModel().hasMembersReferringTo(ds.getSelected()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.editorAccess.getMemberTableModel().removeMembersReferringTo(this.getSelectionTableModel().getSelection());
    }
}

