/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ValidatorListManagementDialog
extends ExtendedDialog {
    private static final String[] BUTTON_TEXTS = new String[]{BUTTONS.OK.getName(), BUTTONS.CANCEL.getName()};
    private static final ImageIcon[] BUTTON_IMAGES = new ImageIcon[]{BUTTONS.OK.getImageIcon(), BUTTONS.CANCEL.getImageIcon()};
    private final JPanel panel = new JPanel(new GridBagLayout());
    private final JTree ignoreErrors;
    private final String type;

    public ValidatorListManagementDialog(String type) {
        super((Component)MainApplication.getMainFrame(), I18n.tr("Validator {0} List Management", type), BUTTON_TEXTS, false);
        this.type = type.toLowerCase(Locale.ENGLISH);
        this.setButtonIcons(BUTTON_IMAGES);
        this.ignoreErrors = this.buildList();
        JScrollPane scroll = GuiHelper.embedInVerticalScrollPane(this.ignoreErrors);
        this.panel.add((Component)scroll, GBC.eol().fill(1).anchor(10));
        this.setContent(this.panel);
        this.setDefaultButton(1);
        this.setupDialog();
        this.setModal(true);
        this.showDialog();
    }

    @Override
    public void buttonAction(int buttonIndex, ActionEvent evt) {
        if (buttonIndex == BUTTONS.OK.getIndex()) {
            int answer;
            Map<String, String> tree;
            SortedMap<String, String> errors = OsmValidator.getIgnoredErrors();
            if (!(errors.equals(tree = OsmValidator.buildIgnore(this.ignoreErrors)) || (answer = this.rerunValidatorPrompt()) != 0 && answer != 1)) {
                OsmValidator.resetErrorList();
                tree.forEach(OsmValidator::addIgnoredError);
                OsmValidator.saveIgnoredErrors();
                OsmValidator.initialize();
            }
            this.dispose();
        } else {
            super.buttonAction(buttonIndex, evt);
        }
    }

    public JTree buildList() {
        if (!"ignore".equals(this.type)) {
            Logging.error(I18n.tr("Cannot understand the following type: {0}", this.type));
            return null;
        }
        final JTree tree = OsmValidator.buildJTreeList();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.process(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.process(e);
            }

            private void process(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    final TreePath[] paths = tree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    Rectangle bounds = tree.getUI().getPathBounds(tree, paths[0]);
                    if (bounds != null) {
                        JPopupMenu menu = new JPopupMenu();
                        JMenuItem delete = new JMenuItem(new AbstractAction(I18n.tr("Don''t ignore", new Object[0])){

                            @Override
                            public void actionPerformed(ActionEvent e1) {
                                ValidatorListManagementDialog.deleteAction(tree, paths);
                            }
                        });
                        menu.add(delete);
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        tree.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TreePath[] paths = tree.getSelectionPaths();
                if (e.getKeyCode() == 127 && paths != null) {
                    ValidatorListManagementDialog.deleteAction(tree, paths);
                }
            }
        });
        return tree;
    }

    private static void deleteAction(JTree tree, TreePath[] paths) {
        block0: for (TreePath path : paths) {
            tree.clearSelection();
            tree.addSelectionPath(path);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            node.removeAllChildren();
            while (node.getChildCount() == 0) {
                node.removeFromParent();
                node = parent;
                if (parent == null || parent.isRoot()) continue block0;
                parent = (DefaultMutableTreeNode)node.getParent();
            }
        }
        tree.updateUI();
    }

    public int rerunValidatorPrompt() {
        MapFrame map = MainApplication.getMap();
        List<TestError> errors = map.validatorDialog.tree.getErrors();
        ValidateAction validateAction = ValidatorDialog.validateAction;
        if (!validateAction.isEnabled() || Utils.isEmpty(errors)) {
            return 1;
        }
        int answer = ConditionalOptionPaneUtil.showOptionDialog("rerun_validation_when_ignorelist_changed", MainApplication.getMainFrame(), I18n.tr("{0}Should the validation be rerun?{1}", "<hmtl><h3>", "</h3></html>"), I18n.tr("Ignored error filter changed", new Object[0]), 1, 3, null, null);
        if (answer == 0) {
            validateAction.doValidate(true);
        }
        return answer;
    }

    static enum BUTTONS {
        OK(0, I18n.tr("OK", new Object[0]), new ImageProvider("ok")),
        CANCEL(1, I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"));

        private final int index;
        private final String name;
        private final ImageIcon icon;

        private BUTTONS(int index, String name, ImageProvider image) {
            this.index = index;
            this.name = name;
            Dimension dim = new Dimension();
            ImageIcon sizeto = new ImageProvider("ok").getResource().getImageIcon();
            dim.setSize(-1, sizeto.getIconHeight());
            this.icon = image.getResource().getImageIcon(dim);
        }

        public ImageIcon getImageIcon() {
            return this.icon;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

