/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateNode
extends Test {
    protected static final int DUPLICATE_NODE = 1;
    protected static final int DUPLICATE_NODE_MIXED = 2;
    protected static final int DUPLICATE_NODE_OTHER = 3;
    protected static final int DUPLICATE_NODE_BUILDING = 10;
    protected static final int DUPLICATE_NODE_BOUNDARY = 11;
    protected static final int DUPLICATE_NODE_HIGHWAY = 12;
    protected static final int DUPLICATE_NODE_LANDUSE = 13;
    protected static final int DUPLICATE_NODE_NATURAL = 14;
    protected static final int DUPLICATE_NODE_POWER = 15;
    protected static final int DUPLICATE_NODE_RAILWAY = 16;
    protected static final int DUPLICATE_NODE_WATERWAY = 17;
    private static final String[] TYPES = new String[]{"none", "highway", "railway", "waterway", "boundary", "power", "natural", "landuse", "building"};
    private Storage<Object> potentialDuplicates;

    public DuplicateNode() {
        super(I18n.tr("Duplicated nodes", new Object[0]), I18n.tr("This test checks that there are no nodes at the very same location.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.potentialDuplicates = new Storage<Object>(new NodeHash());
    }

    @Override
    public void endTest() {
        for (Object v : this.potentialDuplicates) {
            List nodes;
            Set eles;
            if (v instanceof Node || (eles = (nodes = (List)v).stream().map(n -> n.get("ele")).filter(Objects::nonNull).collect(Collectors.toSet())).size() == nodes.size()) continue;
            this.errors.addAll(this.buildTestErrors(this, nodes));
        }
        super.endTest();
        this.potentialDuplicates = null;
    }

    public List<TestError> buildTestErrors(Test parentTest, List<Node> nodes) {
        ArrayList<TestError> errors = new ArrayList<TestError>();
        MultiMap<Map, Node> mm = new MultiMap<Map, Node>();
        for (Node n : nodes) {
            mm.put(n.getKeys(), n);
        }
        HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
        Iterator it = mm.keySet().iterator();
        while (it.hasNext()) {
            Set primitives = mm.get((Map)it.next());
            if (primitives.size() <= 1) continue;
            for (String type : TYPES) {
                typeMap.put(type, Boolean.FALSE);
            }
            for (Node n : primitives) {
                for (Way w : n.getParentWays()) {
                    boolean typed = false;
                    TagMap keys = w.getKeys();
                    for (Map.Entry entry : typeMap.entrySet()) {
                        if (!keys.containsKey(entry.getKey())) continue;
                        entry.setValue(Boolean.TRUE);
                        typed = true;
                    }
                    if (typed) continue;
                    typeMap.put("none", Boolean.TRUE);
                }
            }
            long nbType = typeMap.entrySet().stream().filter(Map.Entry::getValue).count();
            TestError.Builder builder = nbType > 1L ? TestError.builder(parentTest, Severity.WARNING, 2).message(I18n.tr("Mixed type duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("highway")) ? TestError.builder(parentTest, Severity.ERROR, 12).message(I18n.tr("Highway duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("railway")) ? TestError.builder(parentTest, Severity.ERROR, 16).message(I18n.tr("Railway duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("waterway")) ? TestError.builder(parentTest, Severity.ERROR, 17).message(I18n.tr("Waterway duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("boundary")) ? TestError.builder(parentTest, Severity.ERROR, 11).message(I18n.tr("Boundary duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("power")) ? TestError.builder(parentTest, Severity.ERROR, 15).message(I18n.tr("Power duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("natural")) ? TestError.builder(parentTest, Severity.ERROR, 14).message(I18n.tr("Natural duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("building")) ? TestError.builder(parentTest, Severity.ERROR, 10).message(I18n.tr("Building duplicated nodes", new Object[0])) : (Boolean.TRUE.equals(typeMap.get("landuse")) ? TestError.builder(parentTest, Severity.ERROR, 13).message(I18n.tr("Landuse duplicated nodes", new Object[0])) : TestError.builder(parentTest, Severity.WARNING, 3).message(I18n.tr("Other duplicated nodes", new Object[0]))))))))));
            errors.add(builder.primitives(primitives).build());
            it.remove();
        }
        if (!mm.isEmpty()) {
            ArrayList duplicates = new ArrayList();
            for (Set l : mm.values()) {
                duplicates.addAll(l);
            }
            if (duplicates.size() > 1) {
                errors.add(TestError.builder(parentTest, Severity.WARNING, 1).message(I18n.tr("Nodes at same position", new Object[0])).primitives(duplicates).build());
            }
        }
        return errors;
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable()) {
            Object old = this.potentialDuplicates.get(n);
            if (old == null) {
                this.potentialDuplicates.put(n);
            } else if (old instanceof Node) {
                this.potentialDuplicates.put(Stream.of((Node)old, n).collect(Collectors.toList()));
            } else {
                ((List)old).add(n);
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (!this.isFixable(testError)) {
            return null;
        }
        Set nodes = testError.primitives(Node.class).filter(n -> !n.isDeleted()).collect(Collectors.toCollection(LinkedHashSet::new));
        Node target = nodes.stream().filter(n -> !n.isNew()).findFirst().orElseGet(() -> (Node)nodes.iterator().next());
        return MergeNodesAction.mergeNodes(nodes, target);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateNode)) {
            return false;
        }
        if (testError.getCode() == 1) {
            return false;
        }
        return testError.getPrimitives().stream().filter(p -> !p.isDeleted()).count() > 1L && Command.checkOutlyingOrIncompleteOperation(testError.getPrimitives(), null) == 0;
    }

    protected static class NodeHash
    implements Hash<Object, Object> {
        private final double precision = Config.getPref().getDouble("validator.duplicatenodes.precision", 0.0);

        protected NodeHash() {
        }

        private LatLon roundCoord(LatLon coor) {
            return new LatLon((double)Math.round(coor.lat() / this.precision) * this.precision, (double)Math.round(coor.lon() / this.precision) * this.precision);
        }

        protected LatLon getLatLon(Object o) {
            if (o instanceof Node) {
                LatLon coor = ((Node)o).getCoor();
                if (coor == null) {
                    return null;
                }
                if (this.precision == 0.0) {
                    return coor.getRoundedToOsmPrecision();
                }
                return this.roundCoord(coor);
            }
            if (o instanceof List) {
                LatLon coor = ((Node)((List)o).get(0)).getCoor();
                if (coor == null) {
                    return null;
                }
                if (this.precision == 0.0) {
                    return coor.getRoundedToOsmPrecision();
                }
                return this.roundCoord(coor);
            }
            throw new AssertionError();
        }

        @Override
        public boolean equals(Object k, Object t) {
            LatLon coorT;
            LatLon coorK = this.getLatLon(k);
            return coorK == (coorT = this.getLatLon(t)) || coorK != null && coorT != null && coorK.equals(coorT);
        }

        @Override
        public int getHashCode(Object k) {
            LatLon coorK = this.getLatLon(k);
            return coorK == null ? 0 : coorK.hashCode();
        }
    }
}

