/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ICentralMeridianProvider;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ObliqueMercator
extends AbstractProj
implements ICentralMeridianProvider {
    private static final double EPSILON = 1.0E-6;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    protected double azimuth;
    protected double rectifiedGridAngle;
    private double b;
    private double g;
    private double arb;
    private double ab;
    private double bra;
    private double vPoleN;
    private double vPoleS;
    private double singamma0;
    private double cosgamma0;
    private double sinrot;
    private double cosrot;
    private double uc;
    protected double centralMeridian;
    private LatLon referencePoint;

    @Override
    public String getName() {
        return I18n.tr("Oblique Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "omerc";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        boolean hotine;
        double gamma0;
        super.initialize(params);
        boolean twoPoint = params.alpha == null;
        double latCenter = 0.0;
        if (params.lat0 != null) {
            latCenter = Utils.toRadians(params.lat0);
        }
        double com = Math.sqrt(1.0 - this.e2);
        double sinph0 = Math.sin(latCenter);
        double cosph0 = Math.cos(latCenter);
        double con = 1.0 - this.e2 * sinph0 * sinph0;
        double temp = cosph0 * cosph0;
        this.b = Math.sqrt(1.0 + this.e2 * (temp * temp) / (1.0 - this.e2));
        double a = this.b * com / con;
        double d = this.b * com / (cosph0 * Math.sqrt(con));
        double f = d * d - 1.0;
        if (f < 0.0) {
            f = 0.0;
        } else {
            f = Math.sqrt(f);
            if (latCenter < 0.0) {
                f = -f;
            }
        }
        this.g = f += d;
        this.g = f * Math.pow(this.tsfn(latCenter, sinph0), this.b);
        Double lonCenter = null;
        if (twoPoint) {
            if (params.lon1 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lon_1"));
            }
            if (params.lat1 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_1"));
            }
            if (params.lon2 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lon_2"));
            }
            if (params.lat2 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_2"));
            }
            this.referencePoint = new LatLon(params.lat1, params.lat2);
            double lon1 = Utils.toRadians(params.lon1);
            double lat1 = Utils.toRadians(params.lat1);
            double lon2 = Utils.toRadians(params.lon2);
            double lat2 = Utils.toRadians(params.lat2);
            if (Math.abs(lat1 - lat2) <= 1.0E-6 || Math.abs(lat1) <= 1.0E-6 || Math.abs(Math.abs(lat1) - 1.5707963267948966) <= 1.0E-6 || Math.abs(Math.abs(latCenter) - 1.5707963267948966) <= 1.0E-6 || Math.abs(Math.abs(lat2) - 1.5707963267948966) <= 1.0E-6) {
                throw new ProjectionConfigurationException(I18n.tr("Unsuitable parameters ''{0}'' and ''{1}'' for two point method.", "lat_1", "lat_2"));
            }
            double h = Math.pow(this.tsfn(lat1, Math.sin(lat1)), this.b);
            double l = Math.pow(this.tsfn(lat2, Math.sin(lat2)), this.b);
            double fp = this.g / h;
            double p = (l - h) / (l + h);
            double j = this.g * this.g;
            j = (j - l * h) / (j + l * h);
            double diff = lon1 - lon2;
            if (diff < -Math.PI) {
                lon2 -= Math.PI * 2;
            } else if (diff > Math.PI) {
                lon2 += Math.PI * 2;
            }
            this.centralMeridian = ObliqueMercator.normalizeLonRad(0.5 * (lon1 + lon2) - Math.atan(j * Math.tan(0.5 * this.b * (lon1 - lon2)) / p) / this.b);
            gamma0 = Math.atan(2.0 * Math.sin(this.b * ObliqueMercator.normalizeLonRad(lon1 - this.centralMeridian)) / (fp - 1.0 / fp));
            this.rectifiedGridAngle = this.azimuth = Math.asin(d * Math.sin(gamma0));
        } else {
            if (params.lonc == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lonc"));
            }
            if (params.lat0 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
            }
            if (params.alpha == null) {
                throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "alpha"));
            }
            this.referencePoint = new LatLon(params.lat0, params.lonc);
            lonCenter = Utils.toRadians(params.lonc);
            this.azimuth = Utils.toRadians(params.alpha);
            if (this.azimuth > -4.71238898038469 && this.azimuth < -1.5707963267948966 || this.azimuth > 1.5707963267948966 && this.azimuth < 4.71238898038469) {
                throw new ProjectionConfigurationException(I18n.tr("Illegal value for parameter ''{0}'': {1}", "alpha", Double.toString(params.alpha)));
            }
            this.rectifiedGridAngle = params.gamma != null ? Utils.toRadians(params.gamma) : this.azimuth;
            gamma0 = Math.asin(Math.sin(this.azimuth) / d);
            temp = 0.5 * (f - 1.0 / f) * Math.tan(gamma0);
            if (Math.abs(temp) > 1.0) {
                if (Math.abs(Math.abs(temp) - 1.0) > 1.0E-6) {
                    throw new ProjectionConfigurationException(I18n.tr("error in initialization", new Object[0]));
                }
                temp = temp > 0.0 ? 1.0 : -1.0;
            }
            this.centralMeridian = lonCenter - Math.asin(temp) / this.b;
        }
        this.singamma0 = Math.sin(gamma0);
        this.cosgamma0 = Math.cos(gamma0);
        this.sinrot = Math.sin(this.rectifiedGridAngle);
        this.cosrot = Math.cos(this.rectifiedGridAngle);
        this.arb = a / this.b;
        this.ab = a * this.b;
        this.bra = this.b / a;
        this.vPoleN = this.arb * Math.log(Math.tan(0.5 * (1.5707963267948966 - gamma0)));
        this.vPoleS = this.arb * Math.log(Math.tan(0.5 * (1.5707963267948966 + gamma0)));
        boolean bl = hotine = params.no_off != null && params.no_off != false;
        if (hotine) {
            this.uc = 0.0;
        } else if (Math.abs(Math.abs(this.azimuth) - 1.5707963267948966) < 1.0E-10) {
            if (lonCenter == null) {
                throw new ProjectionConfigurationException("assertion error");
            }
            this.uc = a * (lonCenter - this.centralMeridian);
        } else {
            double uC = Math.abs(this.arb * Math.atan2(Math.sqrt(d * d - 1.0), Math.cos(this.azimuth)));
            if (latCenter < 0.0) {
                uC = -uC;
            }
            this.uc = uC;
        }
    }

    private static double normalizeLonRad(double a) {
        return Utils.toRadians(LatLon.normalizeLon(Utils.toDegrees(a)));
    }

    @Override
    public double[] project(double y, double x) {
        double u;
        double v;
        if (Math.abs(Math.abs(y) - 1.5707963267948966) > 1.0E-6) {
            double v2;
            double temp;
            double q = this.g / Math.pow(this.tsfn(y, Math.sin(y)), this.b);
            double s = 0.5 * (q - (temp = 1.0 / q));
            double u2 = (s * this.singamma0 - (v2 = Math.sin(this.b * x)) * this.cosgamma0) / (0.5 * (q + temp));
            v = Math.abs(Math.abs(u2) - 1.0) < 1.0E-6 ? 0.0 : 0.5 * this.arb * Math.log((1.0 - u2) / (1.0 + u2));
            temp = Math.cos(this.b * x);
            u = Math.abs(temp) < 1.0E-10 ? this.ab * x : this.arb * Math.atan2(s * this.cosgamma0 + v2 * this.singamma0, temp);
        } else {
            v = y > 0.0 ? this.vPoleN : this.vPoleS;
            u = this.arb * y;
        }
        x = v * this.cosrot + (u -= this.uc) * this.sinrot;
        y = u * this.cosrot - v * this.sinrot;
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        double v = x * this.cosrot - y * this.sinrot;
        double u = y * this.cosrot + x * this.sinrot + this.uc;
        double qp = Math.exp(-this.bra * v);
        double temp = 1.0 / qp;
        double sp = 0.5 * (qp - temp);
        double vp = Math.sin(this.bra * u);
        double up = (vp * this.cosgamma0 + sp * this.singamma0) / (0.5 * (qp + temp));
        if (Math.abs(Math.abs(up) - 1.0) < 1.0E-6) {
            return new double[]{up < 0.0 ? -1.5707963267948966 : 1.5707963267948966, 0.0};
        }
        return new double[]{this.cphi2(Math.pow(this.g / Math.sqrt((1.0 + up) / (1.0 - up)), 1.0 / this.b)), -Math.atan2(sp * this.cosgamma0 - vp * this.singamma0, Math.cos(this.bra * u)) / this.b};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        double lat = this.referencePoint.lat();
        double dLat = 3.0;
        double lon = this.referencePoint.lon() - Utils.toDegrees(this.centralMeridian);
        double dLon = 3.0;
        return new Bounds(lat - dLat, lon - dLon, lat + dLat, lon + dLon, false);
    }

    @Override
    public double getCentralMeridian() {
        return Utils.toDegrees(this.centralMeridian);
    }
}

