/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Feature;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Geometry;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;
import org.openstreetmap.josm.data.protobuf.ProtobufRecord;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class Layer
implements Destroyable {
    public static final byte LAYER_FIELD = 3;
    private static final byte VERSION_FIELD = 15;
    private static final byte NAME_FIELD = 1;
    private static final byte FEATURE_FIELD = 2;
    private static final byte KEY_FIELD = 3;
    private static final byte VALUE_FIELD = 4;
    private static final byte EXTENT_FIELD = 5;
    static final int DEFAULT_EXTENT = 4096;
    private static final byte DEFAULT_VERSION = 1;
    private final byte version;
    private final String name;
    private final int extent;
    private final List<String> keyList = new ArrayList<String>();
    private final List<Object> valueList = new ArrayList<Object>();
    private final List<Feature> featureCollection;

    public Layer(Collection<ProtobufRecord> records) throws IOException {
        Map<Integer, List<ProtobufRecord>> sorted = records.stream().collect(Collectors.groupingBy(ProtobufRecord::getField));
        this.version = sorted.getOrDefault(15, Collections.emptyList()).parallelStream().map(ProtobufRecord::asUnsignedVarInt).map(Number::byteValue).findFirst().orElse((byte)1);
        if (this.version != 1 && this.version != 2) {
            throw new IllegalArgumentException(I18n.tr("We do not understand version {0} of the vector tile specification", this.version));
        }
        this.name = sorted.getOrDefault(1, Collections.emptyList()).parallelStream().map(ProtobufRecord::asString).findFirst().orElseThrow(() -> new IllegalArgumentException(I18n.tr("Vector tile layers must have a layer name", new Object[0])));
        this.extent = sorted.getOrDefault(5, Collections.emptyList()).parallelStream().map(ProtobufRecord::asUnsignedVarInt).map(Number::intValue).findAny().orElse(4096);
        sorted.getOrDefault(3, Collections.emptyList()).parallelStream().map(ProtobufRecord::asString).forEachOrdered(this.keyList::add);
        sorted.getOrDefault(4, Collections.emptyList()).parallelStream().map(ProtobufRecord::getBytes).map(ProtobufParser::new).map(parser1 -> {
            try {
                return new ProtobufRecord((ProtobufParser)parser1);
            }
            catch (IOException e) {
                Logging.error(e);
                return null;
            }
        }).filter(Objects::nonNull).map(value -> ValueFields.MAPPERS.parallelStream().filter(v -> v.getField() == value.getField()).map(v -> v.convertValue((ProtobufRecord)value)).findFirst().orElseThrow(() -> new IllegalArgumentException(I18n.tr("Unknown field in vector tile layer value ({0})", value.getField())))).forEachOrdered(this.valueList::add);
        HashSet exceptions = new HashSet(0);
        this.featureCollection = sorted.getOrDefault(2, Collections.emptyList()).parallelStream().map(feature -> {
            try {
                return new Feature(this, (ProtobufRecord)feature);
            }
            catch (IOException e) {
                exceptions.add(e);
                return null;
            }
        }).collect(Collectors.toList());
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.iterator().next();
        }
        for (ProtobufRecord record : records) {
            record.close();
        }
    }

    private static Collection<ProtobufRecord> getAllRecords(byte[] bytes) throws IOException {
        try (ProtobufParser parser = new ProtobufParser(bytes);){
            Collection<ProtobufRecord> collection = parser.allRecords();
            return collection;
        }
    }

    public Layer(byte[] bytes) throws IOException {
        this(Layer.getAllRecords(bytes));
    }

    public int getExtent() {
        return this.extent;
    }

    public Collection<Feature> getFeatures() {
        return Collections.unmodifiableCollection(this.featureCollection);
    }

    public Collection<Geometry> getGeometry() {
        return this.getFeatures().stream().map(Feature::getGeometryObject).collect(Collectors.toList());
    }

    public String getKey(int index) {
        return this.keyList.get(index);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(int index) {
        return this.valueList.get(index);
    }

    public byte getVersion() {
        return this.version;
    }

    @Override
    public void destroy() {
        this.featureCollection.clear();
        this.keyList.clear();
        this.valueList.clear();
    }

    public boolean equals(Object other) {
        if (other instanceof Layer) {
            Layer o = (Layer)other;
            return this.extent == o.extent && this.version == o.version && Objects.equals(this.name, o.name) && Objects.equals(this.featureCollection, o.featureCollection) && Objects.equals(this.keyList, o.keyList) && Objects.equals(this.valueList, o.valueList);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.extent, this.featureCollection, this.keyList, this.valueList);
    }

    private static final class ValueFields<T> {
        static final ValueFields<String> STRING = new ValueFields<String>(1, ProtobufRecord::asString);
        static final ValueFields<Float> FLOAT = new ValueFields<Float>(2, ProtobufRecord::asFloat);
        static final ValueFields<Double> DOUBLE = new ValueFields<Double>(3, ProtobufRecord::asDouble);
        static final ValueFields<Number> INT64 = new ValueFields<Number>(4, ProtobufRecord::asUnsignedVarInt);
        static final ValueFields<Number> UINT64 = new ValueFields<Number>(5, ProtobufRecord::asUnsignedVarInt);
        static final ValueFields<Number> SINT64 = new ValueFields<Number>(6, ProtobufRecord::asSignedVarInt);
        static final ValueFields<Boolean> BOOL = new ValueFields<Boolean>(7, r -> r.asUnsignedVarInt().longValue() != 0L);
        public static final Collection<ValueFields<?>> MAPPERS = Collections.unmodifiableList(Arrays.asList(STRING, FLOAT, DOUBLE, INT64, UINT64, SINT64, BOOL));
        private final byte field;
        private final Function<ProtobufRecord, T> conversion;

        private ValueFields(int field, Function<ProtobufRecord, T> conversion) {
            this.field = (byte)field;
            this.conversion = conversion;
        }

        public byte getField() {
            return this.field;
        }

        public T convertValue(ProtobufRecord protobufRecord) {
            return this.conversion.apply(protobufRecord);
        }
    }
}

