/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Helix
extends ProteinStructure {
    Helix(AlphaPolymer apolymer, int monomerIndex, int monomerCount, STR subtype) {
        this.setupPS(apolymer, STR.HELIX, monomerIndex, monomerCount);
        this.subtype = subtype;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        P3[] points = new P3[this.nRes + 1];
        for (int i = 0; i <= this.nRes; ++i) {
            points[i] = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + i, points[i]);
        }
        this.axisA = new P3();
        this.axisUnitVector = new V3();
        Measure.calcBestAxisThroughPoints(points, points.length, this.axisA, this.axisUnitVector, this.vectorProjection, 4);
        this.axisB = P3.newP(points[this.nRes]);
        Measure.projectOntoAxis((P3)this.axisB, (P3)this.axisA, (V3)this.axisUnitVector, (V3)this.vectorProjection);
    }
}

