/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementFactory;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.beans.BeanConstructorElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import io.micronaut.inject.ast.beans.BeanFieldElement;
import io.micronaut.inject.ast.beans.BeanMethodElement;
import io.micronaut.inject.ast.beans.BeanParameterElement;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.BeanDefinitionReferenceWriter;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Internal
public abstract class AbstractBeanDefinitionBuilder
implements BeanElementBuilder {
    private static final Map<String, AtomicInteger> BEAN_COUNTER = new HashMap<String, AtomicInteger>(15);
    private static final Predicate<Set<ElementModifier>> PUBLIC_FILTER = elementModifiers -> elementModifiers.contains((Object)ElementModifier.PUBLIC);
    private static final Predicate<Set<ElementModifier>> NON_PUBLIC_FILTER = elementModifiers -> !elementModifiers.contains((Object)ElementModifier.PUBLIC);
    private static final Comparator<MemberElement> SORTER = (o1, o2) -> {
        String o2Type;
        ClassElement d1 = o1.getDeclaringType();
        ClassElement d2 = o2.getDeclaringType();
        String o1Type = d1.getName();
        if (o1Type.equals(o2Type = d2.getName())) {
            return 0;
        }
        if (d1.isAssignable(d2)) {
            return 1;
        }
        return -1;
    };
    protected final ConfigurationMetadataBuilder<?> metadataBuilder;
    protected final VisitorContext visitorContext;
    private final Element originatingElement;
    private final ClassElement originatingType;
    private final ClassElement beanType;
    private final int identifier;
    private final MutableAnnotationMetadata annotationMetadata;
    private final List<BeanMethodElement> executableMethods = new ArrayList<BeanMethodElement>(5);
    private final List<AbstractBeanDefinitionBuilder> childBeans = new ArrayList<AbstractBeanDefinitionBuilder>(5);
    private final List<BeanMethodElement> injectedMethods = new ArrayList<BeanMethodElement>(5);
    private final List<BeanMethodElement> preDestroyMethods = new ArrayList<BeanMethodElement>(5);
    private final List<BeanMethodElement> postConstructMethods = new ArrayList<BeanMethodElement>(5);
    private final List<BeanFieldElement> injectedFields = new ArrayList<BeanFieldElement>(5);
    private BeanConstructorElement constructorElement;
    private Map<String, Map<String, ClassElement>> typeArguments;
    private ClassElement[] exposedTypes;

    protected AbstractBeanDefinitionBuilder(Element originatingElement, ClassElement beanType, ConfigurationMetadataBuilder<?> metadataBuilder, VisitorContext visitorContext) {
        this.originatingElement = originatingElement;
        if (originatingElement instanceof MethodElement) {
            this.originatingType = ((MethodElement)originatingElement).getDeclaringType();
        } else if (originatingElement instanceof ClassElement) {
            this.originatingType = (ClassElement)originatingElement;
        } else {
            throw new IllegalArgumentException("Invalid originating element: " + originatingElement);
        }
        this.beanType = beanType;
        this.metadataBuilder = metadataBuilder;
        this.visitorContext = visitorContext;
        this.identifier = BEAN_COUNTER.computeIfAbsent(beanType.getName(), s -> new AtomicInteger(0)).getAndIncrement();
        AnnotationMetadata annotationMetadata = beanType.getAnnotationMetadata();
        this.annotationMetadata = annotationMetadata instanceof MutableAnnotationMetadata ? ((MutableAnnotationMetadata)annotationMetadata).clone() : new MutableAnnotationMetadata();
        this.annotationMetadata.addDeclaredAnnotation(Bean.class.getName(), Collections.emptyMap());
        this.constructorElement = this.initConstructor(beanType);
    }

    @Internal
    public static void writeBeanDefinitionBuilders(ClassWriterOutputVisitor classWriterOutputVisitor, List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders) throws IOException {
        for (AbstractBeanDefinitionBuilder beanDefinitionBuilder : beanDefinitionBuilders) {
            AbstractBeanDefinitionBuilder.writeBeanDefinition(classWriterOutputVisitor, beanDefinitionBuilder);
            List<AbstractBeanDefinitionBuilder> childBeans = beanDefinitionBuilder.getChildBeans();
            for (AbstractBeanDefinitionBuilder childBean : childBeans) {
                AbstractBeanDefinitionBuilder.writeBeanDefinition(classWriterOutputVisitor, childBean);
            }
        }
    }

    private static void writeBeanDefinition(ClassWriterOutputVisitor classWriterOutputVisitor, AbstractBeanDefinitionBuilder beanDefinitionBuilder) throws IOException {
        BeanDefinitionWriter beanDefinitionWriter = beanDefinitionBuilder.build();
        if (beanDefinitionWriter != null) {
            beanDefinitionWriter.accept(classWriterOutputVisitor);
            BeanDefinitionReferenceWriter beanDefinitionReferenceWriter = new BeanDefinitionReferenceWriter(beanDefinitionWriter);
            beanDefinitionReferenceWriter.setRequiresMethodProcessing(beanDefinitionWriter.requiresMethodProcessing());
            beanDefinitionReferenceWriter.accept(classWriterOutputVisitor);
        }
    }

    private InternalBeanConstructorElement initConstructor(ClassElement beanType) {
        return beanType.getPrimaryConstructor().map(m -> new InternalBeanConstructorElement((MethodElement)m, !m.isPublic(), this.initBeanParameters(m.getParameters()))).orElse(null);
    }

    @Override
    public BeanElementBuilder inject() {
        this.processInjectedMethods();
        this.processInjectedFields();
        return this;
    }

    public List<AbstractBeanDefinitionBuilder> getChildBeans() {
        return this.childBeans;
    }

    private void processInjectedFields() {
        ElementQuery<FieldElement> baseQuery = ElementQuery.ALL_FIELDS.onlyInstance().onlyInjected();
        HashSet accessibleFields = new HashSet();
        this.beanType.getEnclosedElements(baseQuery.modifiers(PUBLIC_FILTER)).forEach(fieldElement -> {
            accessibleFields.add(fieldElement);
            new InternalBeanElementField((FieldElement)fieldElement, false).inject();
        });
        this.beanType.getEnclosedElements(baseQuery.modifiers(NON_PUBLIC_FILTER)).forEach(fieldElement -> {
            if (!accessibleFields.contains(fieldElement)) {
                new InternalBeanElementField((FieldElement)fieldElement, true).inject();
            }
        });
    }

    private void processInjectedMethods() {
        ElementQuery<MethodElement> baseQuery = ElementQuery.ALL_METHODS.onlyInstance().onlyConcrete().onlyInjected();
        HashSet accessibleMethods = new HashSet();
        this.beanType.getEnclosedElements(baseQuery.modifiers(PUBLIC_FILTER)).forEach(methodElement -> {
            accessibleMethods.add(methodElement);
            this.handleMethod((MethodElement)methodElement, false);
        });
        this.beanType.getEnclosedElements(baseQuery.modifiers(NON_PUBLIC_FILTER)).forEach(methodElement -> {
            if (!accessibleMethods.contains(methodElement)) {
                this.handleMethod((MethodElement)methodElement, true);
            }
        });
    }

    private void handleMethod(MethodElement methodElement, boolean requiresReflection) {
        InternalBeanElementMethod m = new InternalBeanElementMethod(methodElement, requiresReflection);
        if (m.getAnnotationMetadata().hasDeclaredAnnotation(PreDestroy.class)) {
            m.preDestroy();
        } else if (m.getAnnotationMetadata().hasDeclaredAnnotation(PostConstruct.class)) {
            m.postConstruct();
        } else {
            m.inject();
        }
    }

    @Override
    @NonNull
    public Element getOriginatingElement() {
        return this.originatingElement;
    }

    @Override
    @NonNull
    public ClassElement getBeanType() {
        return this.beanType;
    }

    private BeanParameterElement[] initBeanParameters(ParameterElement[] constructorParameters) {
        if (ArrayUtils.isNotEmpty((Object[])constructorParameters)) {
            return (BeanParameterElement[])Arrays.stream(constructorParameters).map(x$0 -> new InternalBeanParameter((ParameterElement)x$0)).toArray(BeanParameterElement[]::new);
        }
        return new BeanParameterElement[0];
    }

    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    @NonNull
    public BeanElementBuilder createWith(@NonNull MethodElement element) {
        if (element != null) {
            this.constructorElement = new InternalBeanConstructorElement(element, !element.isPublic(), this.initBeanParameters(element.getParameters()));
        }
        return this;
    }

    @Override
    @NonNull
    public BeanElementBuilder typed(ClassElement ... types) {
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            this.exposedTypes = types;
        }
        return this;
    }

    @Override
    @NonNull
    public BeanElementBuilder typeArguments(ClassElement ... types) {
        Map<String, ClassElement> typeArguments = this.beanType.getTypeArguments();
        Map<String, ClassElement> resolvedTypes = this.resolveTypeArguments(typeArguments, types);
        if (resolvedTypes != null) {
            if (this.typeArguments == null) {
                this.typeArguments = new LinkedHashMap<String, Map<String, ClassElement>>();
            }
            this.typeArguments.put(this.beanType.getName(), typeArguments);
        }
        return this;
    }

    @Override
    @NonNull
    public BeanElementBuilder typeArgumentsForType(ClassElement type, ClassElement ... types) {
        Map<String, ClassElement> typeArguments;
        Map<String, ClassElement> resolvedTypes;
        if (type != null && (resolvedTypes = this.resolveTypeArguments(typeArguments = type.getTypeArguments(), types)) != null) {
            if (this.typeArguments == null) {
                this.typeArguments = new LinkedHashMap<String, Map<String, ClassElement>>();
            }
            this.typeArguments.put(type.getName(), typeArguments);
        }
        return this;
    }

    @Nullable
    private Map<String, ClassElement> resolveTypeArguments(Map<String, ClassElement> typeArguments, ClassElement ... types) {
        LinkedHashMap<String, ClassElement> resolvedTypes = null;
        if (typeArguments.size() == types.length) {
            resolvedTypes = new LinkedHashMap<String, ClassElement>(typeArguments.size());
            Iterator<String> i = typeArguments.keySet().iterator();
            for (ClassElement type : types) {
                String variable = i.next();
                resolvedTypes.put(variable, type);
            }
        }
        return resolvedTypes;
    }

    @Override
    public BeanElementBuilder withConstructor(Consumer<BeanConstructorElement> constructorElement) {
        if (constructorElement != null && this.constructorElement != null) {
            constructorElement.accept(this.constructorElement);
        }
        return this;
    }

    @Override
    @NonNull
    public BeanElementBuilder withMethods(@NonNull ElementQuery<MethodElement> methods, @NonNull Consumer<BeanMethodElement> beanMethods) {
        if (methods != null && beanMethods != null) {
            this.beanType.getEnclosedElements(methods.onlyInstance().onlyAccessible(this.originatingType)).forEach(methodElement -> beanMethods.accept(new InternalBeanElementMethod((MethodElement)methodElement, false)));
        }
        return this;
    }

    @Override
    @NonNull
    public BeanElementBuilder withFields(@NonNull ElementQuery<FieldElement> fields, @NonNull Consumer<BeanFieldElement> beanFields) {
        if (fields != null && beanFields != null) {
            this.beanType.getEnclosedElements(fields.onlyInstance().onlyAccessible(this.originatingType)).forEach(fieldElement -> beanFields.accept(new InternalBeanElementField((FieldElement)fieldElement, false)));
        }
        return this;
    }

    @Override
    @NonNull
    public BeanElementBuilder withParameters(Consumer<BeanParameterElement[]> parameters) {
        if (parameters != null && this.constructorElement != null) {
            parameters.accept(this.constructorElement.getParameters());
        }
        return this;
    }

    @Override
    @NonNull
    public String getName() {
        return this.beanType.getName();
    }

    @Override
    public boolean isProtected() {
        return this.beanType.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.beanType.isPublic();
    }

    @Override
    @NonNull
    public Object getNativeType() {
        return this.beanType;
    }

    @Override
    @NonNull
    public <T extends Annotation> BeanElementBuilder annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        this.annotate(this.annotationMetadata, annotationType, consumer);
        return this;
    }

    @Override
    public BeanElementBuilder removeAnnotation(@NonNull String annotationType) {
        this.removeAnnotation(this.annotationMetadata, annotationType);
        return this;
    }

    @Override
    public <T extends Annotation> BeanElementBuilder removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
        this.removeAnnotationIf(this.annotationMetadata, predicate);
        return this;
    }

    @Override
    public BeanElementBuilder removeStereotype(@NonNull String annotationType) {
        this.removeStereotype(this.annotationMetadata, annotationType);
        return this;
    }

    private BeanElementBuilder addChildBean(@NonNull MethodElement producerMethod, Consumer<BeanElementBuilder> childBeanBuilder) {
        AbstractBeanDefinitionBuilder childBuilder = this.createChildBean(producerMethod);
        this.childBeans.add(childBuilder);
        if (childBeanBuilder != null) {
            childBeanBuilder.accept(childBuilder);
        }
        return this;
    }

    private BeanElementBuilder addChildBean(@NonNull FieldElement producerMethod, Consumer<BeanElementBuilder> childBeanBuilder) {
        AbstractBeanDefinitionBuilder childBuilder = this.createChildBean(producerMethod);
        this.childBeans.add(childBuilder);
        if (childBeanBuilder != null) {
            childBeanBuilder.accept(childBuilder);
        }
        return this;
    }

    @Override
    public <E extends MemberElement> BeanElementBuilder produceBeans(ElementQuery<E> methodsOrFields, Consumer<BeanElementBuilder> childBeanBuilder) {
        methodsOrFields = methodsOrFields.onlyConcrete().onlyInstance().modifiers(modifiers -> modifiers.contains((Object)ElementModifier.PUBLIC));
        List<E> enclosedElements = this.beanType.getEnclosedElements(methodsOrFields);
        for (MemberElement enclosedElement : enclosedElements) {
            MethodElement me;
            FieldElement fe;
            ClassElement type;
            if (enclosedElement instanceof FieldElement && (type = (fe = (FieldElement)enclosedElement).getGenericField().getType()).isPublic() && !type.isPrimitive()) {
                return this.addChildBean(fe, childBeanBuilder);
            }
            if (!(enclosedElement instanceof MethodElement) || enclosedElement instanceof ConstructorElement || !(type = (me = (MethodElement)enclosedElement).getGenericReturnType().getType()).isPublic() || type.isPrimitive()) continue;
            return this.addChildBean(me, childBeanBuilder);
        }
        return this;
    }

    @NonNull
    protected abstract AbstractBeanDefinitionBuilder createChildBean(FieldElement var1);

    @NonNull
    protected abstract AbstractBeanDefinitionBuilder createChildBean(MethodElement var1);

    @Nullable
    public BeanDefinitionWriter build() {
        if (this.exposedTypes != null) {
            AnnotationClassValue[] annotationClassValues = (AnnotationClassValue[])Arrays.stream(this.exposedTypes).map(ce -> new AnnotationClassValue(ce.getName())).toArray(AnnotationClassValue[]::new);
            this.annotate(Bean.class, builder -> builder.member("typed", annotationClassValues));
        }
        BeanDefinitionWriter beanDefinitionWriter = this.createBeanDefinitionWriter();
        if (this.typeArguments != null) {
            beanDefinitionWriter.visitTypeArguments(this.typeArguments);
        }
        if (this.constructorElement == null) {
            this.constructorElement = this.initConstructor(this.beanType);
        }
        if (this.constructorElement == null) {
            this.visitorContext.fail("Cannot create associated bean with no accessible primary constructor. Consider supply the constructor with createWith(..)", this.originatingElement);
            return null;
        }
        beanDefinitionWriter.visitBeanDefinitionConstructor(this.constructorElement, !this.constructorElement.isPublic(), this.visitorContext);
        LinkedHashMap<ClassElement, List> sortedInjections = new LinkedHashMap<ClassElement, List>();
        ArrayList<MemberElement> allInjected = new ArrayList<MemberElement>();
        allInjected.addAll(this.injectedFields);
        allInjected.addAll(this.injectedMethods);
        allInjected.sort(SORTER);
        for (MemberElement memberElement : allInjected) {
            List list = sortedInjections.computeIfAbsent(memberElement.getDeclaringType(), classElement -> new ArrayList());
            list.add(memberElement);
        }
        for (List members : sortedInjections.values()) {
            members.sort((o1, o2) -> {
                if (o1 instanceof FieldElement && o2 instanceof MethodElement) {
                    return 1;
                }
                if (o1 instanceof MethodElement && o1 instanceof FieldElement) {
                    return -1;
                }
                return 0;
            });
        }
        for (List list : sortedInjections.values()) {
            for (MemberElement memberElement : list) {
                if (memberElement instanceof FieldElement) {
                    InternalBeanElementField ibf = (InternalBeanElementField)memberElement;
                    ibf.with(element -> this.visitField(beanDefinitionWriter, (BeanFieldElement)element, (InternalBeanElementField)element));
                    continue;
                }
                InternalBeanElementMethod ibm = (InternalBeanElementMethod)memberElement;
                ibm.with(element -> beanDefinitionWriter.visitMethodInjectionPoint(ibm.getDeclaringType(), ibm, ibm.isRequiresReflection(), this.visitorContext));
            }
        }
        for (BeanMethodElement executableMethod : this.executableMethods) {
            beanDefinitionWriter.visitExecutableMethod(this.beanType, executableMethod, this.visitorContext);
        }
        for (BeanMethodElement postConstructMethod : this.postConstructMethods) {
            if (!postConstructMethod.getDeclaringType().equals(this.beanType)) continue;
            beanDefinitionWriter.visitPostConstructMethod(this.beanType, postConstructMethod, ((InternalBeanElementMethod)postConstructMethod).isRequiresReflection(), this.visitorContext);
        }
        for (BeanMethodElement preDestroyMethod : this.preDestroyMethods) {
            if (!preDestroyMethod.getDeclaringType().equals(this.beanType)) continue;
            beanDefinitionWriter.visitPreDestroyMethod(this.beanType, preDestroyMethod, ((InternalBeanElementMethod)preDestroyMethod).isRequiresReflection(), this.visitorContext);
        }
        beanDefinitionWriter.visitBeanDefinitionEnd();
        return beanDefinitionWriter;
    }

    protected BeanDefinitionWriter createBeanDefinitionWriter() {
        return new BeanDefinitionWriter((Element)this, OriginatingElements.of(this.originatingElement), this.metadataBuilder, this.visitorContext, this.identifier);
    }

    private void visitField(BeanDefinitionWriter beanDefinitionWriter, BeanFieldElement injectedField, InternalBeanElementField ibf) {
        if (injectedField.hasAnnotation(Value.class) || injectedField.hasAnnotation(Property.class)) {
            beanDefinitionWriter.visitFieldValue(injectedField.getDeclaringType(), injectedField, ibf.isRequiresReflection(), injectedField.isNullable());
        } else {
            beanDefinitionWriter.visitFieldInjectionPoint(injectedField.getDeclaringType(), injectedField, ibf.isRequiresReflection());
        }
    }

    protected abstract <T extends Annotation> void annotate(AnnotationMetadata var1, String var2, Consumer<AnnotationValueBuilder<T>> var3);

    protected abstract void removeStereotype(AnnotationMetadata var1, String var2);

    protected abstract <T extends Annotation> void removeAnnotationIf(AnnotationMetadata var1, Predicate<AnnotationValue<T>> var2);

    protected abstract void removeAnnotation(AnnotationMetadata var1, String var2);

    private final class InternalBeanParameter
    extends InternalBeanElement<ParameterElement>
    implements BeanParameterElement {
        private final ParameterElement parameterElement;
        private ClassElement genericType;

        private InternalBeanParameter(ParameterElement element) {
            super(AbstractBeanDefinitionBuilder.this, element);
            this.parameterElement = element;
        }

        @Override
        @NonNull
        public ClassElement getGenericType() {
            if (this.genericType != null) {
                return this.genericType;
            }
            return this.parameterElement.getGenericType();
        }

        @Override
        @NonNull
        public ClassElement getType() {
            return this.parameterElement.getType();
        }

        @Override
        @NonNull
        public BeanParameterElement typeArguments(ClassElement ... types) {
            ClassElement genericType = this.parameterElement.getGenericType();
            Map<String, ClassElement> typeArguments = genericType.getTypeArguments();
            Map resolved = AbstractBeanDefinitionBuilder.this.resolveTypeArguments(typeArguments, types);
            if (resolved != null) {
                ElementFactory<?, ?, ?, ?> elementFactory = AbstractBeanDefinitionBuilder.this.visitorContext.getElementFactory();
                this.genericType = elementFactory.newClassElement(genericType.getNativeType(), this.getAnnotationMetadata(), resolved);
            }
            return this;
        }
    }

    private final class InternalBeanElementField
    extends InternalBeanElement<FieldElement>
    implements BeanFieldElement {
        private final FieldElement fieldElement;
        private final boolean requiresReflection;
        private ClassElement genericType;

        private InternalBeanElementField(FieldElement element, boolean requiresReflection) {
            super(AbstractBeanDefinitionBuilder.this, element);
            this.fieldElement = element;
            this.requiresReflection = requiresReflection;
        }

        public boolean isRequiresReflection() {
            return this.requiresReflection;
        }

        @Override
        public BeanFieldElement inject() {
            if (!AbstractBeanDefinitionBuilder.this.injectedFields.contains(this)) {
                AbstractBeanDefinitionBuilder.this.injectedFields.add(this);
            }
            return BeanFieldElement.super.inject();
        }

        @Override
        public BeanFieldElement injectValue(String expression) {
            if (!AbstractBeanDefinitionBuilder.this.injectedFields.contains(this)) {
                AbstractBeanDefinitionBuilder.this.injectedFields.add(this);
            }
            return BeanFieldElement.super.injectValue(expression);
        }

        @Override
        public ClassElement getDeclaringType() {
            return this.fieldElement.getDeclaringType();
        }

        @Override
        public ClassElement getOwningType() {
            return AbstractBeanDefinitionBuilder.this.beanType;
        }

        @Override
        @NonNull
        public ClassElement getType() {
            return this.fieldElement.getType();
        }

        @Override
        public ClassElement getGenericField() {
            if (this.genericType != null) {
                return this.genericType;
            }
            return this.fieldElement.getGenericField();
        }

        @Override
        @NonNull
        public BeanFieldElement typeArguments(ClassElement ... types) {
            ClassElement genericType = this.fieldElement.getGenericField();
            Map<String, ClassElement> typeArguments = genericType.getTypeArguments();
            Map resolved = AbstractBeanDefinitionBuilder.this.resolveTypeArguments(typeArguments, types);
            if (resolved != null) {
                String typeName = genericType.getName();
                this.genericType = ClassElement.of(typeName, genericType.isInterface(), this.getAnnotationMetadata(), resolved);
            }
            return this;
        }
    }

    private final class InternalBeanConstructorElement
    extends InternalBeanElement<MethodElement>
    implements BeanConstructorElement {
        private final MethodElement methodElement;
        private final boolean requiresReflection;
        private BeanParameterElement[] beanParameters;

        private InternalBeanConstructorElement(MethodElement methodElement, boolean requiresReflection, BeanParameterElement[] beanParameters) {
            super(AbstractBeanDefinitionBuilder.this, methodElement);
            this.methodElement = methodElement;
            this.requiresReflection = requiresReflection;
            this.beanParameters = beanParameters;
        }

        public boolean isRequiresReflection() {
            return this.requiresReflection;
        }

        @Override
        public boolean isPackagePrivate() {
            return this.methodElement.isPackagePrivate();
        }

        @Override
        public boolean isAbstract() {
            return this.methodElement.isAbstract();
        }

        @Override
        public boolean isStatic() {
            return this.methodElement.isStatic();
        }

        @Override
        public boolean isPrivate() {
            return this.methodElement.isPrivate();
        }

        @Override
        public boolean isFinal() {
            return this.methodElement.isFinal();
        }

        @Override
        public boolean isSuspend() {
            return this.methodElement.isSuspend();
        }

        @Override
        public boolean isDefault() {
            return this.methodElement.isDefault();
        }

        @Override
        public boolean isProtected() {
            return this.methodElement.isProtected();
        }

        @Override
        public boolean isPublic() {
            return this.methodElement.isPublic();
        }

        @Override
        @NonNull
        public BeanParameterElement[] getParameters() {
            return this.beanParameters;
        }

        @Override
        @NonNull
        public ClassElement getReturnType() {
            return this.methodElement.getReturnType();
        }

        @Override
        @NonNull
        public ClassElement getGenericReturnType() {
            return this.methodElement.getGenericReturnType();
        }

        @Override
        @NonNull
        public MethodElement withNewParameters(ParameterElement ... newParameters) {
            this.beanParameters = AbstractBeanDefinitionBuilder.this.initBeanParameters((ParameterElement[])ArrayUtils.concat((Object[])this.beanParameters, (Object[])newParameters));
            return this;
        }

        @Override
        public ClassElement getDeclaringType() {
            return this.methodElement.getDeclaringType();
        }

        @Override
        public ClassElement getOwningType() {
            return AbstractBeanDefinitionBuilder.this.beanType;
        }
    }

    private final class InternalBeanElementMethod
    extends InternalBeanElement<MethodElement>
    implements BeanMethodElement {
        private final MethodElement methodElement;
        private final boolean requiresReflection;
        private BeanParameterElement[] beanParameters;

        private InternalBeanElementMethod(MethodElement methodElement, boolean requiresReflection) {
            this(methodElement, requiresReflection, abstractBeanDefinitionBuilder.initBeanParameters(methodElement.getParameters()));
        }

        private InternalBeanElementMethod(MethodElement methodElement, boolean requiresReflection, BeanParameterElement[] beanParameters) {
            super(AbstractBeanDefinitionBuilder.this, methodElement);
            this.methodElement = methodElement;
            this.requiresReflection = requiresReflection;
            this.beanParameters = beanParameters;
        }

        public boolean isRequiresReflection() {
            return this.requiresReflection;
        }

        @Override
        public boolean isPackagePrivate() {
            return this.methodElement.isPackagePrivate();
        }

        @Override
        public boolean isAbstract() {
            return this.methodElement.isAbstract();
        }

        @Override
        public boolean isStatic() {
            return this.methodElement.isStatic();
        }

        @Override
        public boolean isPrivate() {
            return this.methodElement.isPrivate();
        }

        @Override
        public boolean isFinal() {
            return this.methodElement.isFinal();
        }

        @Override
        public boolean isSuspend() {
            return this.methodElement.isSuspend();
        }

        @Override
        public boolean isDefault() {
            return this.methodElement.isDefault();
        }

        @Override
        public boolean isProtected() {
            return this.methodElement.isProtected();
        }

        @Override
        public boolean isPublic() {
            return this.methodElement.isPublic();
        }

        @Override
        @NonNull
        public BeanMethodElement executable() {
            if (!AbstractBeanDefinitionBuilder.this.executableMethods.contains(this)) {
                AbstractBeanDefinitionBuilder.this.executableMethods.add(this);
            }
            return BeanMethodElement.super.executable();
        }

        @Override
        @NonNull
        public BeanMethodElement inject() {
            if (!AbstractBeanDefinitionBuilder.this.injectedMethods.contains(this)) {
                AbstractBeanDefinitionBuilder.this.injectedMethods.add(this);
            }
            return BeanMethodElement.super.inject();
        }

        @Override
        @NonNull
        public BeanMethodElement preDestroy() {
            if (!AbstractBeanDefinitionBuilder.this.preDestroyMethods.contains(this)) {
                AbstractBeanDefinitionBuilder.this.preDestroyMethods.add(this);
            }
            return BeanMethodElement.super.preDestroy();
        }

        @Override
        @NonNull
        public BeanMethodElement postConstruct() {
            if (!AbstractBeanDefinitionBuilder.this.postConstructMethods.contains(this)) {
                AbstractBeanDefinitionBuilder.this.postConstructMethods.add(this);
            }
            return BeanMethodElement.super.postConstruct();
        }

        @Override
        @NonNull
        public BeanParameterElement[] getParameters() {
            return this.beanParameters;
        }

        @Override
        @NonNull
        public ClassElement getReturnType() {
            return this.methodElement.getReturnType();
        }

        @Override
        @NonNull
        public ClassElement getGenericReturnType() {
            return this.methodElement.getGenericReturnType();
        }

        @Override
        @NonNull
        public MethodElement withNewParameters(ParameterElement ... newParameters) {
            this.beanParameters = AbstractBeanDefinitionBuilder.this.initBeanParameters((ParameterElement[])ArrayUtils.concat((Object[])this.beanParameters, (Object[])newParameters));
            return this;
        }

        @Override
        public ClassElement getDeclaringType() {
            return this.methodElement.getDeclaringType();
        }

        @Override
        public ClassElement getOwningType() {
            return AbstractBeanDefinitionBuilder.this.beanType;
        }
    }

    private static abstract class InternalBeanElement<E extends Element>
    implements Element {
        private final E element;
        private final MutableAnnotationMetadata elementMetadata;
        private AnnotationMetadata currentMetadata;
        final /* synthetic */ AbstractBeanDefinitionBuilder this$0;

        private InternalBeanElement(E element) {
            this.this$0 = var1_1;
            this.element = element;
            AnnotationMetadata annotationMetadata = element.getAnnotationMetadata();
            this.elementMetadata = annotationMetadata instanceof MutableAnnotationMetadata ? ((MutableAnnotationMetadata)annotationMetadata).clone() : new MutableAnnotationMetadata();
        }

        @NonNull
        public AnnotationMetadata getAnnotationMetadata() {
            if (this.currentMetadata != null) {
                return this.currentMetadata;
            }
            return this.elementMetadata;
        }

        @Override
        @NonNull
        public String getName() {
            return this.element.getName();
        }

        @Override
        public boolean isProtected() {
            return this.element.isProtected();
        }

        @Override
        public boolean isPublic() {
            return this.element.isPublic();
        }

        @Override
        @NonNull
        public Object getNativeType() {
            return this.element.getNativeType();
        }

        @Override
        @NonNull
        public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
            this.this$0.annotate(this.elementMetadata, annotationType, consumer);
            return this;
        }

        @Override
        public Element removeAnnotation(@NonNull String annotationType) {
            this.this$0.removeAnnotation(this.elementMetadata, annotationType);
            return this;
        }

        @Override
        public <T extends Annotation> Element removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
            this.this$0.removeAnnotationIf(this.elementMetadata, predicate);
            return this;
        }

        @Override
        public Element removeStereotype(@NonNull String annotationType) {
            this.this$0.removeStereotype(this.elementMetadata, annotationType);
            return this;
        }

        public <T extends InternalBeanElement<E>> void with(Consumer<T> consumer) {
            try {
                this.currentMetadata = this.elementMetadata.isEmpty() ? AnnotationMetadata.EMPTY_METADATA : this.elementMetadata;
                consumer.accept(this);
            }
            finally {
                this.currentMetadata = null;
            }
        }
    }
}

