/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.MissionaryMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;

public final class AIUnit
extends TransportableAIObject {
    private static final Logger logger = Logger.getLogger(AIUnit.class.getName());
    public static final String TAG = "aiUnit";
    private Unit unit;
    private Mission mission;

    public AIUnit(AIMain aiMain, String id) {
        super(aiMain, id);
        this.unit = null;
        this.mission = null;
        this.initialized = false;
    }

    public AIUnit(AIMain aiMain, Unit unit) {
        this(aiMain, unit.getId());
        this.unit = unit;
        this.mission = null;
        this.setInitialized();
    }

    public AIUnit(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.setInitialized();
    }

    @Override
    public void setInitialized() {
        this.initialized = this.getUnit() != null;
    }

    public final Unit getUnit() {
        return this.unit;
    }

    private final void setUnit(Unit unit) {
        if (this.unit != null && unit != this.unit) {
            throw new RuntimeException("Attempt to change AI Unit " + this.getId() + " to " + unit + "\n" + FreeColDebugger.stackTraceToString());
        }
        this.unit = unit;
    }

    public final boolean hasMission() {
        return this.mission != null;
    }

    public final Mission getMission() {
        return this.mission;
    }

    public final void setMission(Mission mission) {
        this.mission = mission;
    }

    private void requestLocalRearrange() {
        AIColony aiColony;
        Colony colony;
        Location loc;
        Unit unit = this.getUnit();
        if (unit != null && (loc = unit.getLocation()) != null && (colony = loc.getColony()) != null && (aiColony = this.getAIMain().getAIColony(colony)) != null) {
            aiColony.requestRearrange();
        }
    }

    private void takeTransport() {
        Unit carrier = this.getUnit().getCarrier();
        AIUnit aiCarrier = carrier == null ? null : this.getAIMain().getAIUnit(carrier);
        AIUnit transport = this.getTransport();
        if (transport != aiCarrier) {
            if (transport != null) {
                logger.warning("Taking different transport: " + aiCarrier);
                this.dropTransport();
            }
            this.setTransport(aiCarrier);
        }
    }

    public Player getOwner() {
        Unit unit = this.getUnit();
        return unit == null ? null : unit.getOwner();
    }

    public AIPlayer getAIOwner() {
        Player owner = this.getOwner();
        return owner == null ? null : this.getAIMain().getAIPlayer(owner);
    }

    public Random getAIRandom() {
        AIPlayer aiOwner = this.getAIOwner();
        return aiOwner == null ? null : aiOwner.getAIRandom();
    }

    public Location getTrivialTarget() {
        PathNode path;
        Unit unit = this.getUnit();
        return unit == null || (path = unit.getTrivialPath()) == null ? null : Location.upLoc(path.getLastNode().getLocation());
    }

    public final boolean hasCargo() {
        Unit unit = this.getUnit();
        return unit == null ? false : unit.hasCargo();
    }

    public <T extends Mission> boolean hasMission(Class<T> returnClass) {
        return this.getMission(returnClass) != null;
    }

    public <T extends Mission> T getMission(Class<T> returnClass) {
        try {
            return (T)((Mission)returnClass.cast(this.mission));
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public void doMission(LogBuilder lb) {
        if (this.mission != null) {
            this.mission.doMission(lb);
        }
    }

    public Mission changeMission(Mission mission) {
        if (this.mission == mission) {
            return this.mission;
        }
        this.removeMission();
        this.setMission(mission);
        if (mission != null) {
            this.setTransportPriority(mission.getBaseTransportPriority());
        }
        return this.mission;
    }

    public void removeMission() {
        if (this.mission != null) {
            this.mission.dispose();
            this.mission = null;
        }
    }

    public boolean hasDefendSettlementMission() {
        return this.hasMission(DefendSettlementMission.class);
    }

    public boolean isCompleteWishRealizationMission(Colony colony) {
        WishRealizationMission wm = this.getMission(WishRealizationMission.class);
        return wm != null && Map.isSameLocation(wm.getTarget(), colony);
    }

    public boolean isAvailableForWork(Colony colony) {
        Mission m = this.getMission();
        return m == null || m instanceof BuildColonyMission && (Map.isSameLocation(m.getTarget(), colony.getTile()) || colony.getUnitCount() <= 1) || m instanceof DefendSettlementMission || m instanceof IdleAtSettlementMission || m instanceof WorkInsideColonyMission;
    }

    public boolean tryWorkInsideColonyMission(AIColony aiColony, LogBuilder lb) {
        WorkInsideColonyMission wic = this.getMission(WorkInsideColonyMission.class);
        if (wic == null) {
            AIPlayer aiPlayer = this.getAIOwner();
            if (!(aiPlayer instanceof EuropeanAIPlayer) || ((EuropeanAIPlayer)aiPlayer).getWorkInsideColonyMission(this, aiColony) == null) {
                return false;
            }
            lb.add(", ", this.getMission());
            this.dropTransport();
        }
        return true;
    }

    public boolean tryPioneeringMission(LogBuilder lb) {
        EuropeanAIPlayer euaiPlayer;
        Mission m = this.getMission();
        Location oldTarget = m == null ? null : m.getTarget();
        AIPlayer aiPlayer = this.getAIOwner();
        if (aiPlayer instanceof EuropeanAIPlayer && (euaiPlayer = (EuropeanAIPlayer)aiPlayer).getPioneeringMission(this, null) != null) {
            lb.add(", ", this.getMission());
            euaiPlayer.updateTransport(this, oldTarget, lb);
            return true;
        }
        return false;
    }

    public boolean trySomeUsefulMission(Colony colony, LogBuilder lb) {
        Mission m = this.getMission();
        if (m instanceof BuildColonyMission || m instanceof DefendSettlementMission || m instanceof MissionaryMission || m instanceof PioneeringMission || m instanceof ScoutingMission || m instanceof UnitSeekAndDestroyMission) {
            return true;
        }
        Location oldTarget = m == null ? null : m.getTarget();
        AIPlayer aiPlayer = this.getAIOwner();
        Unit unit = this.getUnit();
        if (aiPlayer instanceof EuropeanAIPlayer) {
            EuropeanAIPlayer euaiPlayer = (EuropeanAIPlayer)this.getAIOwner();
            if (unit.hasAbility("model.ability.speakWithChief") && (m = euaiPlayer.getScoutingMission(this)) != null) {
                lb.add(", ", m);
                euaiPlayer.updateTransport(this, oldTarget, lb);
                return true;
            }
            if (unit.isDefensiveUnit() && (m = euaiPlayer.getDefendSettlementMission(this, colony)) != null) {
                lb.add(", ", m);
                euaiPlayer.updateTransport(this, oldTarget, lb);
                return true;
            }
            if (unit.hasAbility("model.ability.establishMission") && (m = euaiPlayer.getMissionaryMission(this)) != null) {
                lb.add(", ", m);
                euaiPlayer.updateTransport(this, oldTarget, lb);
                return true;
            }
        }
        return false;
    }

    public void removeTransportable(AIGoods ag) {
        TransportMission tm = this.getMission(TransportMission.class);
        if (tm != null) {
            tm.removeTransportable(ag);
        }
    }

    public boolean moveToAmerica() {
        return AIMessage.askMoveTo(this, this.getOwner().getGame().getMap());
    }

    public boolean moveToEurope() {
        return AIMessage.askMoveTo(this, this.getOwner().getEurope());
    }

    public boolean move(Direction direction) {
        Unit unit = this.getUnit();
        Tile start = unit.getTile();
        return unit.getMoveType(direction).isProgress() && AIMessage.askMove(this, direction) && unit.getTile() != start;
    }

    public boolean equipForRole(Role role) {
        Player player = this.getOwner();
        Unit unit = this.getUnit();
        Location loc = Location.upLoc(unit.getLocation());
        if (!(loc instanceof UnitLocation)) {
            return false;
        }
        int count = role.getMaximumCount();
        if (count > 0) {
            while (count > 0) {
                List<AbstractGoods> req = unit.getGoodsDifference(role, count);
                try {
                    int price = ((UnitLocation)loc).priceGoods(req);
                    if (player.checkGold(price)) {
                        break;
                    }
                }
                catch (FreeColException fce) {
                    // empty catch block
                }
                --count;
            }
            if (count <= 0) {
                return false;
            }
        }
        return AIMessage.askEquipForRole(this, role, count) && unit.getRole() == role && unit.getRoleCount() == count;
    }

    public int getBuilderScore() {
        int ret;
        Unit unit = this.getUnit();
        if (unit == null || BuildColonyMission.invalidMissionReason(this) != null) {
            return -1000;
        }
        int n = !unit.hasDefaultRole() ? 0 : (ret = unit.getSkillLevel() > 0 ? 100 : 500 + 100 * unit.getSkillLevel());
        if (unit.hasTile()) {
            ret += 50;
        }
        return ret;
    }

    public int getPioneerScore() {
        Unit unit = this.getUnit();
        return unit == null ? -1000 : unit.getPioneerScore();
    }

    public int getScoutScore() {
        Unit unit = this.getUnit();
        return unit == null ? -1000 : unit.getScoutScore();
    }

    @Override
    public int getTransportPriority() {
        return this.hasMission() ? super.getTransportPriority() : 0;
    }

    @Override
    public Locatable getTransportLocatable() {
        return this.getUnit();
    }

    @Override
    public Location getTransportSource() {
        Unit unit = this.getUnit();
        return unit == null || unit.isDisposed() ? null : unit.getLocation();
    }

    @Override
    public Location getTransportDestination() {
        Unit unit = this.getUnit();
        return unit == null || unit.isDisposed() || !this.hasMission() ? null : this.mission.getTransportDestination();
    }

    @Override
    public PathNode getDeliveryPath(Unit carrier, Location dst) {
        PathNode path;
        if (dst == null && (dst = this.getTransportDestination()) == null) {
            return null;
        }
        dst = Location.upLoc(dst);
        Unit unit = this.getUnit();
        if (unit.getLocation() == carrier) {
            path = unit.findPath(carrier.getLocation(), dst, carrier);
            if (path == null && dst.getTile() != null) {
                path = unit.findPathToNeighbour(carrier.getLocation(), dst.getTile(), carrier, null);
            }
        } else {
            if (unit.getLocation() instanceof Unit) {
                return null;
            }
            path = unit.findPath(unit.getLocation(), dst, carrier);
            if (path == null && dst.getTile() != null) {
                path = unit.findPathToNeighbour(unit.getLocation(), dst.getTile(), carrier, null);
            }
        }
        if (path != null) {
            path.ensureDisembark();
        }
        return path;
    }

    @Override
    public PathNode getIntermediatePath(Unit carrier, Location dst) {
        return null;
    }

    @Override
    public void setTransportDestination(Location destination) {
        throw new RuntimeException("AI unit transport destination set by mission:" + destination);
    }

    @Override
    public boolean carriableBy(Unit carrier) {
        return carrier.couldCarry(this.getUnit());
    }

    @Override
    public boolean canMove() {
        return this.getUnit().getMovesLeft() > 0;
    }

    @Override
    public boolean leaveTransport() {
        Location target;
        Unit unit = this.getUnit();
        if (!unit.isOnCarrier()) {
            return true;
        }
        if (unit.isInEurope()) {
            return this.leaveTransport(null);
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return false;
        }
        Mission mission = this.getMission();
        Location location = target = mission == null || !mission.isValid() ? null : mission.getTarget();
        if (target != null) {
            Direction direction;
            if (Map.isSameLocation(target, tile)) {
                return this.leaveTransport(null);
            }
            if (target.getTile() != null && (direction = tile.getDirection(target.getTile())) != null) {
                return this.leaveTransport(direction);
            }
            PathNode path = unit.findPath(target);
            if (path != null && (direction = tile.getDirection(path.next.getTile())) != null) {
                try {
                    return this.leaveTransport(direction);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Leave transport crash for " + this + "/" + unit.getMovesLeft(), e);
                }
            }
        }
        if (tile.isLand()) {
            return this.leaveTransport(null);
        }
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.isBlocked(unit)) continue;
            if (t.getSettlement() != null) {
                return this.leaveTransport(tile.getDirection(t));
            }
            tiles.add(t);
        }
        if (tiles.isEmpty()) {
            return false;
        }
        Player player = this.getOwner();
        Tile safe = (Tile)tiles.get(0);
        Tile best = null;
        int bestTurns = 10000;
        Settlement settlement = null;
        for (Tile t : tiles) {
            int turns;
            if (settlement == null || t.isConnectedTo(settlement.getTile())) {
                settlement = t.getNearestSettlement(player, 10, true);
            }
            if (settlement != null && bestTurns > (turns = unit.getTurnsToReach(t, settlement))) {
                bestTurns = turns;
                best = t;
            }
            if (!(safe.getDefenceValue() < t.getDefenceValue())) continue;
            safe = t;
        }
        return this.leaveTransport(tile.getDirection(best != null ? best : safe));
    }

    @Override
    public boolean leaveTransport(Direction direction) {
        boolean result;
        Unit unit = this.getUnit();
        if (!unit.isOnCarrier()) {
            return false;
        }
        Unit carrier = unit.getCarrier();
        boolean bl = direction == null ? AIMessage.askDisembark(this) && unit.getLocation() == carrier.getLocation() : (result = this.move(direction));
        if (result) {
            this.requestLocalRearrange();
            this.dropTransport();
        }
        return result;
    }

    @Override
    public boolean joinTransport(Unit carrier, Direction direction) {
        boolean result;
        AIUnit aiCarrier = this.getAIMain().getAIUnit(carrier);
        if (aiCarrier == null) {
            return false;
        }
        Unit unit = this.getUnit();
        boolean bl = result = AIMessage.askEmbark(aiCarrier, unit, direction) && unit.getLocation() == carrier;
        if (result) {
            this.requestLocalRearrange();
            this.takeTransport();
        }
        return result;
    }

    @Override
    public String invalidReason() {
        String reason = Mission.invalidTransportableReason(this);
        return reason != null ? reason : (this.hasMission() ? this.getMission().invalidReason() : null);
    }

    @Override
    public void dispose() {
        this.dropTransport();
        AIPlayer aiOwner = this.getAIOwner();
        if (aiOwner != null) {
            aiOwner.removeAIObject(this);
        }
        if (this.mission != null) {
            this.mission.dispose();
            this.mission = null;
        }
        super.dispose();
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        Unit unit = this.getUnit();
        if (unit == null) {
            lb.add("\n  AIUnit with null unit: ", this.getId());
            result = result.fail();
        } else if (unit.isDisposed()) {
            lb.add("\n  AIUnit with disposed unit: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.mission != null && !this.mission.isOneTime() && this.mission.isValid()) {
            this.mission.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        Unit u = xr.findFreeColGameObject(aiMain.getGame(), "id", Unit.class, null, true);
        if (!u.isInitialized()) {
            xr.nextTag();
            throw new XMLStreamException("AIUnit for uninitialized Unit: " + u.getId());
        }
        this.setUnit(u);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        AIMain aiMain = this.getAIMain();
        String tag = xr.getLocalName();
        this.mission = null;
        if ("buildColonyMission".equals(tag)) {
            this.mission = new BuildColonyMission(aiMain, this, xr);
        } else if ("cashInTreasureTrainMission".equals(tag)) {
            this.mission = new CashInTreasureTrainMission(aiMain, this, xr);
        } else if ("defendSettlementMission".equals(tag)) {
            this.mission = new DefendSettlementMission(aiMain, this, xr);
        } else if ("idleAtSettlementMission".equals(tag)) {
            this.mission = new IdleAtSettlementMission(aiMain, this, xr);
        } else if ("indianBringGiftMission".equals(tag)) {
            this.mission = new IndianBringGiftMission(aiMain, this, xr);
        } else if ("indianDemandMission".equals(tag)) {
            this.mission = new IndianDemandMission(aiMain, this, xr);
        } else if ("missionaryMission".equals(tag)) {
            this.mission = new MissionaryMission(aiMain, this, xr);
        } else if ("pioneeringMission".equals(tag)) {
            this.mission = new PioneeringMission(aiMain, this, xr);
        } else if ("privateerMission".equals(tag)) {
            this.mission = new PrivateerMission(aiMain, this, xr);
        } else if ("scoutingMission".equals(tag)) {
            this.mission = new ScoutingMission(aiMain, this, xr);
        } else if ("transportMission".equals(tag)) {
            this.mission = new TransportMission(aiMain, this, xr);
        } else if ("unitSeekAndDestroyMission".equals(tag)) {
            this.mission = new UnitSeekAndDestroyMission(aiMain, this, xr);
        } else if ("unitWanderHostileMission".equals(tag)) {
            this.mission = new UnitWanderHostileMission(aiMain, this, xr);
        } else if ("unitWanderMission".equals(tag)) {
            this.mission = new UnitWanderMission(aiMain, this, xr);
        } else if ("wishRealizationMission".equals(tag)) {
            this.mission = new WishRealizationMission(aiMain, this, xr);
        } else if ("workInsideColonyMission".equals(tag)) {
            this.mission = new WorkInsideColonyMission(aiMain, this, xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AIUnit)) {
            return false;
        }
        AIUnit other = (AIUnit)o;
        return Utils.equals(this.unit, other.unit) && Utils.equals(this.mission, other.mission) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.unit);
        return 37 * hash + Utils.hashCode(this.mission);
    }

    @Override
    public String toString() {
        return this.unit == null ? "AIUnit-null" : this.unit.toString("AIUnit ");
    }
}

