/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.VideoResource;

public class ResourceFactory {
    private static final Logger logger = Logger.getLogger(ResourceFactory.class.getName());
    private final Map<URI, Resource> resources = new HashMap<URI, Resource>();

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resource createResource(String primaryKey, URI uri) {
        Resource r = this.resources.get(uri);
        if (r != null) {
            return r;
        }
        String pathPart = uri.getPath() != null ? uri.getPath() : (uri.toString().indexOf("!/") >= 0 ? uri.toString().substring(uri.toString().indexOf("!/") + 2) : null);
        try {
            void var5_15;
            if ("urn".equals(uri.getScheme())) {
                if (uri.getSchemeSpecificPart().startsWith("color:")) {
                    ColorResource colorResource = new ColorResource(primaryKey, uri);
                } else {
                    if (!uri.getSchemeSpecificPart().startsWith("font:")) {
                        logger.log(Level.WARNING, "Unknown urn part: " + uri.getSchemeSpecificPart());
                        return null;
                    }
                    FontResource fontResource = new FontResource(primaryKey, uri);
                }
            } else if (pathPart.endsWith("\"") && pathPart.lastIndexOf(34, pathPart.length() - 1) >= 0) {
                StringResource stringResource = new StringResource(primaryKey, uri);
            } else if (pathPart.endsWith(".faf")) {
                FAFileResource fAFileResource = new FAFileResource(primaryKey, uri);
            } else if (pathPart.endsWith(".sza")) {
                SZAResource sZAResource = new SZAResource(primaryKey, uri);
            } else if (pathPart.endsWith(".ttf")) {
                FontResource fontResource = new FontResource(primaryKey, uri);
            } else if (pathPart.endsWith(".wav")) {
                AudioResource audioResource = new AudioResource(primaryKey, uri);
            } else if (pathPart.endsWith(".ogg")) {
                if (pathPart.endsWith(".video.ogg")) {
                    VideoResource videoResource = new VideoResource(primaryKey, uri);
                } else {
                    AudioResource audioResource = new AudioResource(primaryKey, uri);
                }
            } else {
                ImageResource imageResource = new ImageResource(primaryKey, uri);
            }
            this.resources.put(uri, (Resource)var5_15);
            return var5_15;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Failed to create " + uri, iOException);
            return null;
        }
    }
}

