/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlunderType;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitChangeType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionContainer;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.TextOption;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.LogBuilder;

public final class Specification
implements OptionContainer {
    private static final Logger logger = Logger.getLogger(Specification.class.getName());
    private static final Class[] newTypeClasses = new Class[]{String.class, Specification.class};
    public static final Source AMBUSH_BONUS_SOURCE = new Source("model.source.ambushBonus");
    public static final Source AMPHIBIOUS_ATTACK_PENALTY_SOURCE = new Source("model.source.amphibiousAttack");
    public static final Source ARTILLERY_PENALTY_SOURCE = new Source("model.source.artilleryInTheOpen");
    public static final Source ATTACK_BONUS_SOURCE = new Source("model.source.attackBonus");
    public static final Source BASE_DEFENCE_SOURCE = new Source("model.source.baseDefence");
    public static final Source BASE_OFFENCE_SOURCE = new Source("model.source.baseOffence");
    public static final Source CARGO_PENALTY_SOURCE = new Source("model.source.cargoPenalty");
    public static final Source COLONY_GOODS_PARTY_SOURCE = new Source("model.source.colonyGoodsParty");
    public static final Source FORTIFICATION_BONUS_SOURCE = new Source("model.source.fortified");
    public static final Source INDIAN_RAID_BONUS_SOURCE = new Source("model.source.artilleryAgainstRaid");
    public static final Source MOVEMENT_PENALTY_SOURCE = new Source("model.source.movementPenalty");
    public static final Source SHIP_TRADE_PENALTY_SOURCE = new Source("model.source.shipTradePenalty");
    public static final Source SOL_MODIFIER_SOURCE = new Source("model.source.solModifier");
    private static final Source[] sources = new Source[]{MOVEMENT_PENALTY_SOURCE, ARTILLERY_PENALTY_SOURCE, ATTACK_BONUS_SOURCE, FORTIFICATION_BONUS_SOURCE, INDIAN_RAID_BONUS_SOURCE, AMPHIBIOUS_ATTACK_PENALTY_SOURCE, BASE_OFFENCE_SOURCE, BASE_DEFENCE_SOURCE, CARGO_PENALTY_SOURCE, AMBUSH_BONUS_SOURCE, COLONY_GOODS_PARTY_SOURCE, SHIP_TRADE_PENALTY_SOURCE, SOL_MODIFIER_SOURCE};
    private static final Map<String, Color> defaultColors = new HashMap<String, Color>();
    public static final String TAG = "freecol-specification";
    public static final String DIFFICULTY_LEVELS = "difficultyLevels";
    public static final String ROLES_COMPAT_FILE_NAME = "roles-compat.xml";
    public static final String UNIT_CHANGE_TYPES_COMPAT_FILE_NAME = "unit-change-types-compat.xml";
    private static final String DEFAULT_FOOD_TYPE = "model.goods.food";
    private static final String DEFAULT_NATION_TYPE = "model.nationType.default";
    public static final String DEFAULT_ROLE_ID = "model.role.default";
    public static final int NUMBER_OF_AGES = 3;
    private static final String[] coreOptionGroups;
    private final Map<String, ChildReader> readerMap = new HashMap<String, ChildReader>(20);
    private final List<BuildingType> buildingTypeList = new ArrayList<BuildingType>();
    private final List<Disaster> disasters = new ArrayList<Disaster>();
    private final List<EuropeanNationType> europeanNationTypes = new ArrayList<EuropeanNationType>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<FoundingFather> foundingFathers = new ArrayList<FoundingFather>();
    private final List<GoodsType> goodsTypeList = new ArrayList<GoodsType>();
    private final List<IndianNationType> indianNationTypes = new ArrayList<IndianNationType>();
    private final List<Nation> nations = new ArrayList<Nation>();
    private final List<ResourceType> resourceTypeList = new ArrayList<ResourceType>();
    private final List<Role> roles = new ArrayList<Role>();
    private final List<TileType> tileTypeList = new ArrayList<TileType>();
    private final List<TileImprovementType> tileImprovementTypeList = new ArrayList<TileImprovementType>();
    private final List<UnitChangeType> unitChangeTypeList = new ArrayList<UnitChangeType>();
    private final List<UnitType> unitTypeList = new ArrayList<UnitType>();
    private final Map<String, List<Modifier>> allModifiers = new HashMap<String, List<Modifier>>();
    private final List<Modifier> specialModifiers = new ArrayList<Modifier>();
    private final Map<String, AbstractOption> allOptions = new HashMap<String, AbstractOption>();
    private final Map<String, OptionGroup> allOptionGroups = new HashMap<String, OptionGroup>();
    private final List<GoodsType> storableGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> farmedGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> foodGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> newWorldGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> newWorldLuxuryGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> libertyGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> immigrationGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> rawBuildingGoodsTypeList = new ArrayList<GoodsType>();
    private final List<Nation> europeanNations = new ArrayList<Nation>();
    private final List<Nation> REFNations = new ArrayList<Nation>();
    private final List<Nation> indianNations = new ArrayList<Nation>();
    private final List<NationType> nationTypes = new ArrayList<NationType>();
    private final List<EuropeanNationType> REFNationTypes = new ArrayList<EuropeanNationType>();
    private final ArrayList<UnitType> buildableUnitTypes = new ArrayList();
    private final Map<GoodsType, UnitType> experts = new HashMap<GoodsType, UnitType>();
    private final List<UnitType> unitTypesTrainedInEurope = new ArrayList<UnitType>();
    private final List<UnitType> unitTypesPurchasedInEurope = new ArrayList<UnitType>();
    private UnitType fastestLandUnitType = null;
    private UnitType fastestNavalUnitType = null;
    private final List<UnitType> defaultUnitTypes = new ArrayList<UnitType>();
    private final Map<String, FreeColSpecObjectType> allTypes = new HashMap<String, FreeColSpecObjectType>(256);
    private final Map<String, List<Ability>> allAbilities = new HashMap<String, List<Ability>>(128);
    private List<Role> militaryRoles = null;
    private boolean initialized = false;
    private String id;
    private String version;
    private String difficultyLevel = null;
    private final int[] ages = new int[3];
    private static final String BUILDING_TYPES_TAG = "building-types";
    private static final String DIFFICULTY_LEVEL_TAG = "difficulty-level";
    private static final String DISASTERS_TAG = "disasters";
    private static final String EUROPEAN_NATION_TYPES_TAG = "european-nation-types";
    private static final String EVENTS_TAG = "events";
    private static final String FOUNDING_FATHERS_TAG = "founding-fathers";
    private static final String GOODS_TYPES_TAG = "goods-types";
    private static final String INDIAN_NATION_TYPES_TAG = "indian-nation-types";
    private static final String MODIFIERS_TAG = "modifiers";
    private static final String NATIONS_TAG = "nations";
    private static final String OPTIONS_TAG = "options";
    private static final String RESOURCE_TYPES_TAG = "resource-types";
    private static final String ROLES_TAG = "roles";
    private static final String TILE_TYPES_TAG = "tile-types";
    private static final String TILE_IMPROVEMENT_TYPES_TAG = "tile-improvement-types";
    private static final String UNIT_CHANGE_TYPES_TAG = "unit-change-types";
    private static final String UNIT_TYPES_TAG = "unit-types";
    private static final String VERSION_TAG = "version";
    private static final String OLD_DIFFICULTY_LEVEL_TAG = "difficultyLevel";
    private static final String OLD_TILEIMPROVEMENT_TYPES_TAG = "tileimprovement-types";
    private static final String OLD_EQUIPMENT_TYPES_TAG = "equipment-types";

    public Specification() {
        logger.fine("Initializing Specification");
        for (Source source : sources) {
            this.addType(source.getId(), source);
        }
        this.readerMap.put(BUILDING_TYPES_TAG, new TypeReader<BuildingType>(BuildingType.class, this.buildingTypeList));
        this.readerMap.put(DISASTERS_TAG, new TypeReader<Disaster>(Disaster.class, this.disasters));
        this.readerMap.put(EUROPEAN_NATION_TYPES_TAG, new TypeReader<EuropeanNationType>(EuropeanNationType.class, this.europeanNationTypes));
        this.readerMap.put(EVENTS_TAG, new TypeReader<Event>(Event.class, this.events));
        this.readerMap.put(FOUNDING_FATHERS_TAG, new TypeReader<FoundingFather>(FoundingFather.class, this.foundingFathers));
        this.readerMap.put(GOODS_TYPES_TAG, new TypeReader<GoodsType>(GoodsType.class, this.goodsTypeList));
        this.readerMap.put(INDIAN_NATION_TYPES_TAG, new TypeReader<IndianNationType>(IndianNationType.class, this.indianNationTypes));
        this.readerMap.put(NATIONS_TAG, new TypeReader<Nation>(Nation.class, this.nations));
        this.readerMap.put(RESOURCE_TYPES_TAG, new TypeReader<ResourceType>(ResourceType.class, this.resourceTypeList));
        this.readerMap.put(ROLES_TAG, new TypeReader<Role>(Role.class, this.roles));
        this.readerMap.put(TILE_TYPES_TAG, new TypeReader<TileType>(TileType.class, this.tileTypeList));
        this.readerMap.put(TILE_IMPROVEMENT_TYPES_TAG, new TypeReader<TileImprovementType>(TileImprovementType.class, this.tileImprovementTypeList));
        this.readerMap.put(OLD_TILEIMPROVEMENT_TYPES_TAG, new TypeReader<TileImprovementType>(TileImprovementType.class, this.tileImprovementTypeList));
        this.readerMap.put(UNIT_CHANGE_TYPES_TAG, new TypeReader<UnitChangeType>(UnitChangeType.class, this.unitChangeTypeList));
        this.readerMap.put(UNIT_TYPES_TAG, new TypeReader<UnitType>(UnitType.class, this.unitTypeList));
        this.readerMap.put(MODIFIERS_TAG, new ModifierReader());
        this.readerMap.put(OPTIONS_TAG, new OptionReader());
    }

    public Specification(FreeColXMLReader xr) throws XMLStreamException {
        this();
        this.initialized = false;
        this.readFromXML(xr);
        this.prepare(null, this.difficultyLevel);
        this.clean("load from stream");
        this.initialized = true;
    }

    public Specification(InputStream in) throws XMLStreamException {
        this();
        this.initialized = false;
        this.load(in);
        this.prepare(null, this.difficultyLevel);
        this.clean("load from InputStream");
        this.initialized = true;
    }

    private void load(InputStream in) throws XMLStreamException {
        try (FreeColXMLReader xr = new FreeColXMLReader(in);){
            xr.nextTag();
            this.readFromXML(xr);
        }
    }

    public boolean loadMods(List<FreeColModFile> mods) {
        this.initialized = false;
        boolean loadedMod = false;
        for (FreeColModFile mod : mods) {
            InputStream sis = null;
            try {
                sis = mod.getSpecificationInputStream();
                if (sis != null) {
                    this.load(sis);
                }
                loadedMod = true;
                logger.info("Loaded mod " + mod.getId());
            }
            catch (IOException | XMLStreamException ex) {
                logger.log(Level.WARNING, "Read error in mod " + mod.getId(), ex);
            }
            catch (RuntimeException rte) {
                logger.log(Level.WARNING, "Parse error in mod " + mod.getId(), rte);
            }
        }
        if (loadedMod) {
            this.clean("mod loading");
        }
        this.initialized = true;
        return loadedMod;
    }

    public void prepare(NationOptions.Advantages advantages, String difficulty) {
        this.prepare(advantages, difficulty == null ? null : this.getDifficultyOptionGroup(difficulty));
    }

    public void prepare(NationOptions.Advantages advantages, OptionGroup difficulty) {
        this.applyFixes();
        if (advantages == NationOptions.Advantages.NONE) {
            this.clearEuropeanNationalAdvantages();
        }
        if (difficulty != null) {
            this.setDifficultyOptionGroup(difficulty);
            this.applyDifficultyLevel(difficulty);
        }
    }

    public void clean(String why) {
        logger.finest("Cleaning up specification following " + why + ".");
        CollectionUtils.removeInPlace(this.allTypes, e -> ((FreeColSpecObjectType)e.getValue()).isAbstractType());
        GoodsType.setDerivedAttributes(this);
        this.storableGoodsTypeList.clear();
        this.farmedGoodsTypeList.clear();
        this.foodGoodsTypeList.clear();
        this.newWorldGoodsTypeList.clear();
        this.newWorldLuxuryGoodsTypeList.clear();
        this.libertyGoodsTypeList.clear();
        this.immigrationGoodsTypeList.clear();
        this.rawBuildingGoodsTypeList.clear();
        for (GoodsType goodsType : this.goodsTypeList) {
            if (goodsType.isStorable()) {
                this.storableGoodsTypeList.add(goodsType);
            }
            if (goodsType.isFarmed()) {
                this.farmedGoodsTypeList.add(goodsType);
            }
            if (goodsType.isFoodType()) {
                this.foodGoodsTypeList.add(goodsType);
            }
            if (goodsType.isNewWorldGoodsType()) {
                this.newWorldGoodsTypeList.add(goodsType);
                if (goodsType.isNewWorldLuxuryType()) {
                    this.newWorldLuxuryGoodsTypeList.add(goodsType);
                }
            }
            if (goodsType.isLibertyType()) {
                this.libertyGoodsTypeList.add(goodsType);
            }
            if (goodsType.isImmigrationType()) {
                this.immigrationGoodsTypeList.add(goodsType);
            }
            if (!goodsType.isRawBuildingMaterial() || goodsType.isFoodType()) continue;
            this.rawBuildingGoodsTypeList.add(goodsType);
        }
        this.REFNations.clear();
        this.europeanNations.clear();
        this.indianNations.clear();
        for (Nation nation : this.nations) {
            if (nation.isUnknownEnemy()) continue;
            if (nation.getType().isEuropean()) {
                if (nation.getType().isREF()) {
                    this.REFNations.add(nation);
                    continue;
                }
                this.europeanNations.add(nation);
                continue;
            }
            this.indianNations.add(nation);
        }
        this.nationTypes.clear();
        this.nationTypes.addAll(this.indianNationTypes);
        this.nationTypes.addAll(this.europeanNationTypes);
        this.REFNationTypes.addAll(CollectionUtils.transform(this.europeanNationTypes, NationType::isREF));
        this.europeanNationTypes.removeAll(this.REFNationTypes);
        this.experts.clear();
        this.unitTypesTrainedInEurope.clear();
        this.unitTypesPurchasedInEurope.clear();
        this.defaultUnitTypes.clear();
        int bestLandValue = -1;
        int bestNavalValue = -1;
        for (UnitType unitType : this.unitTypeList) {
            if (unitType.isDefaultUnitType()) {
                this.defaultUnitTypes.add(unitType);
            }
            if (unitType.needsGoodsToBuild() && !unitType.hasAbility("model.ability.bornInColony")) {
                this.buildableUnitTypes.add(unitType);
            }
            if (unitType.getExpertProduction() != null) {
                this.experts.put(unitType.getExpertProduction(), unitType);
            }
            if (unitType.hasPrice()) {
                if (unitType.getSkill() > 0) {
                    this.unitTypesTrainedInEurope.add(unitType);
                } else if (!unitType.hasSkill()) {
                    this.unitTypesPurchasedInEurope.add(unitType);
                }
            }
            if (unitType.isNaval()) {
                if (bestNavalValue >= unitType.getMovement()) continue;
                bestNavalValue = unitType.getMovement();
                this.fastestNavalUnitType = unitType;
                continue;
            }
            if (bestLandValue >= unitType.getMovement()) continue;
            bestLandValue = unitType.getMovement();
            this.fastestLandUnitType = unitType;
        }
        for (OptionGroup og : this.allOptionGroups.values()) {
            og.generateChoices();
        }
        Turn.initialize(this.getInteger("model.option.startingYear"), this.getInteger("model.option.seasonYear"), this.getInteger("model.option.seasons"));
        boolean badAges = !this.hasOption("model.option.ages", TextOption.class);
        String agesValue = "";
        if (!badAges) {
            agesValue = this.getText("model.option.ages");
            String[] a = agesValue.split(",");
            boolean bl = badAges = a.length != 2;
            if (!badAges) {
                try {
                    this.ages[0] = 1;
                    this.ages[1] = Turn.yearToTurn(Integer.parseInt(a[0]));
                    this.ages[2] = Turn.yearToTurn(Integer.parseInt(a[1]));
                    if (this.ages[1] < 1 || this.ages[2] < 1) {
                        badAges = true;
                    } else if (this.ages[1] > this.ages[2]) {
                        int tmp = this.ages[1];
                        this.ages[1] = this.ages[2];
                        this.ages[2] = tmp;
                    }
                }
                catch (NumberFormatException nfe) {
                    badAges = true;
                }
            }
        }
        if (badAges) {
            logger.warning("Bad ages: " + agesValue);
            this.ages[0] = 1;
            this.ages[1] = Turn.yearToTurn(1600);
            this.ages[2] = Turn.yearToTurn(1700);
        }
        boolean customsOnCoast = this.getBoolean("model.option.customsOnCoast");
        for (Ability a : CollectionUtils.iterable(this.getBuildingType("model.building.customHouse").getAbilities("model.ability.coastalOnly"))) {
            a.setValue(customsOnCoast);
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Specification clean following ").append(why).append(" complete, starting year=").append(Turn.getStartingYear()).append(", season year=").append(Turn.getSeasonYear()).append(", ages=[").append(this.ages[0]).append(',').append(this.ages[1]).append(',').append(this.ages[2]).append("], seasons=").append(Turn.getSeasonNumber()).append(", difficulty=").append(this.difficultyLevel).append(", ").append(this.allTypes.size()).append(" Types").append(", ").append(this.allAbilities.size()).append(" Abilities").append(", ").append(this.buildingTypeList.size()).append(" BuildingTypes").append(", ").append(this.disasters.size()).append(" Disasters").append(", ").append(this.europeanNationTypes.size()).append(" EuropeanNationTypes").append(", ").append(this.events.size()).append(" Events").append(", ").append(this.foundingFathers.size()).append(" FoundingFathers").append(", ").append(this.goodsTypeList.size()).append(" GoodsTypes").append(", ").append(this.indianNationTypes.size()).append(" IndianNationTypes").append(", ").append(this.allModifiers.size()).append(" Modifiers").append(", ").append(this.nations.size()).append(" Nations").append(", ").append(this.allOptions.size()).append(" Options").append(", ").append(this.allOptionGroups.size()).append(" Option Groups").append(", ").append(this.resourceTypeList.size()).append(" ResourceTypes").append(", ").append(this.roles.size()).append(" Roles").append(", ").append(this.tileTypeList.size()).append(" TileTypes").append(", ").append(this.tileImprovementTypeList.size()).append(" TileImprovementTypes").append(", ").append(this.unitChangeTypeList.size()).append(" UnitChangeTypes").append(", ").append(this.unitTypeList.size()).append(" UnitTypes").append(" read.");
        logger.info(sb.toString());
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public FreeColSpecObjectType getType(String id) {
        return this.allTypes.get(id);
    }

    private <T extends FreeColSpecObjectType> T getType(String id, Class<T> returnClass) {
        FreeColSpecObjectType ret = this.getType(id);
        return (T)(ret == null ? null : (FreeColSpecObjectType)returnClass.cast(ret));
    }

    private void addType(String id, FreeColSpecObjectType type) {
        this.allTypes.put(id, type);
    }

    private FreeColSpecObjectType removeType(String id) {
        return this.allTypes.remove(id);
    }

    public void addAbility(Ability ability) {
        String id = ability.getId();
        this.addAbility(id);
        this.allAbilities.get(id).add(ability);
    }

    public void addAbility(String id) {
        if (!this.allAbilities.containsKey(id)) {
            this.allAbilities.put(id, new ArrayList());
        }
    }

    public Stream<Ability> getAbilities(String id) {
        List<Ability> result = this.allAbilities.get(id);
        return result == null ? Stream.empty() : result.stream();
    }

    public void addModifier(Modifier modifier) {
        String id = modifier.getId();
        if (!this.allModifiers.containsKey(id)) {
            this.allModifiers.put(id, new ArrayList());
        }
        this.allModifiers.get(id).add(modifier);
    }

    public Stream<Modifier> getModifiers(String id) {
        List<Modifier> result = this.allModifiers.get(id);
        return result == null ? Stream.empty() : result.stream();
    }

    public void addTestFather(FoundingFather ff) {
        this.addType(ff.getId(), ff);
        this.foundingFathers.add(ff);
    }

    public void disableEditing() {
        for (String s : coreOptionGroups) {
            OptionGroup og = this.allOptionGroups.get(s);
            if (og == null) continue;
            og.setEditable(false);
        }
    }

    private int compareVersion(String other) {
        String version = this.getVersion();
        if (version == null) {
            return 0;
        }
        String rex = "\\.";
        String[] sv = version.split("\\.", 2);
        String[] so = other.split("\\.", 2);
        if (sv.length == 2 && so.length == 2) {
            try {
                int cmp = Integer.compare(Integer.parseInt(sv[0]), Integer.parseInt(so[0]));
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(Integer.parseInt(sv[1]), Integer.parseInt(so[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Bad version: " + other);
    }

    @Override
    public <T extends Option> boolean hasOption(String id, Class<T> returnClass) {
        if (id == null) {
            return false;
        }
        AbstractOption val = this.allOptions.get(id);
        return val == null ? false : returnClass.isAssignableFrom(val.getClass());
    }

    @Override
    public <T extends Option> T getOption(String id, Class<T> returnClass) {
        if (id == null) {
            throw new RuntimeException("Null identifier for " + returnClass.getName());
        }
        if (!this.allOptions.containsKey(id)) {
            throw new RuntimeException("Missing option: " + id);
        }
        AbstractOption op = this.allOptions.get(id);
        try {
            return (T)((Option)returnClass.cast(op));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Not a " + returnClass.getName() + ": " + id, cce);
        }
    }

    @Override
    public OptionGroup getOptionGroup(String id) {
        if (id == null) {
            throw new RuntimeException("OptionGroup with null id: " + this);
        }
        if (!this.allOptionGroups.containsKey(id)) {
            throw new RuntimeException("Missing OptionGroup: " + id);
        }
        return this.allOptionGroups.get(id);
    }

    private void addOptionGroup(OptionGroup optionGroup, boolean recursive) {
        for (Option option : optionGroup.getOptions()) {
            if (option instanceof OptionGroup) {
                this.allOptionGroups.put(option.getId(), (OptionGroup)option);
                if (!recursive) continue;
                this.addOptionGroup((OptionGroup)option, true);
                continue;
            }
            this.addAbstractOption((AbstractOption)option);
        }
    }

    private void addAbstractOption(AbstractOption abstractOption) {
        this.allOptions.put(abstractOption.getId(), abstractOption);
    }

    private OptionGroup mergeGroup(OptionGroup group) {
        OptionGroup realGroup = this.allOptionGroups.get(group.getId());
        if (realGroup == null || !realGroup.isEditable()) {
            return realGroup;
        }
        for (Option o : group.getOptions()) {
            if (o instanceof OptionGroup) {
                this.mergeGroup((OptionGroup)o);
                continue;
            }
            realGroup.add(o);
        }
        return realGroup;
    }

    public List<OptionGroup> getDifficultyLevels() {
        OptionGroup group = this.allOptionGroups.get(DIFFICULTY_LEVELS);
        Stream stream = group == null ? Stream.empty() : group.getOptions().stream();
        return CollectionUtils.transform(stream, o -> o instanceof OptionGroup, o -> (OptionGroup)o);
    }

    public String getDifficultyLevel() {
        return this.difficultyLevel;
    }

    public OptionGroup getDifficultyOptionGroup() {
        return this.getDifficultyOptionGroup(this.difficultyLevel);
    }

    public OptionGroup getDifficultyOptionGroup(String id) {
        return CollectionUtils.find(this.getDifficultyLevels(), CollectionUtils.matchKeyEquals(id, FreeColObject::getId));
    }

    private void setDifficultyOptionGroup(OptionGroup difficulty) {
        OptionGroup group = this.allOptionGroups.get(DIFFICULTY_LEVELS);
        if (group != null) {
            group.add(difficulty);
        }
        this.allOptionGroups.put(difficulty.getId(), difficulty);
    }

    public void applyDifficultyLevel(String difficulty) {
        this.applyDifficultyLevel(this.getDifficultyOptionGroup(difficulty));
    }

    public void applyDifficultyLevel(OptionGroup level) {
        if (level == null) {
            logger.warning("Null difficulty level supplied");
            return;
        }
        logger.config("Applying difficulty level " + level.getId());
        this.addOptionGroup(level, true);
        this.difficultyLevel = level.getId();
    }

    public OptionGroup getGameOptions() {
        return this.getOptionGroup("gameOptions");
    }

    public void setGameOptions(OptionGroup go) {
        this.allOptionGroups.put("gameOptions", go);
        this.addOptionGroup(go, true);
    }

    public OptionGroup getMapGeneratorOptions() {
        return this.getOptionGroup("mapGeneratorOptions");
    }

    public void setMapGeneratorOptions(OptionGroup mgo) {
        this.allOptionGroups.put("mapGeneratorOptions", mgo);
        this.addOptionGroup(mgo, true);
    }

    public boolean updateGameAndMapOptions() {
        OptionGroup mog;
        OptionGroup gog;
        boolean ret = false;
        String gtag = "gameOptions";
        File gof = FreeColDirectories.getOptionsFile("game_options.xml");
        OptionGroup optionGroup = gog = !gof.exists() ? null : OptionGroup.loadOptionGroup(gof, gtag, this);
        if (gog != null) {
            gog = this.mergeGroup(gog);
            ret |= this.fixGameOptions();
        } else {
            gog = this.getOptionGroup(gtag);
        }
        gog.save(gof, null, true);
        String mtag = "mapGeneratorOptions";
        File mof = FreeColDirectories.getOptionsFile("map_generator_options.xml");
        OptionGroup optionGroup2 = mog = !mof.exists() ? null : OptionGroup.loadOptionGroup(mof, mtag, this);
        if (mog != null) {
            mog = this.mergeGroup(mog);
            ret |= this.fixMapGeneratorOptions();
        } else {
            mog = this.getOptionGroup(mtag);
        }
        mog.save(mof, null, true);
        return ret;
    }

    public void generateDynamicOptions() {
        logger.finest("Generating dynamic options.");
        OptionGroup prices = new OptionGroup("gameOptions.prices", this);
        this.allOptionGroups.put(prices.getId(), prices);
        for (GoodsType goodsType : this.goodsTypeList) {
            String name = goodsType.getSuffix("model.goods.");
            String base = "model.option." + name + ".";
            if (goodsType.getInitialSellPrice() > 0) {
                int diff = goodsType.isNewWorldGoodsType() || goodsType.isNewWorldLuxuryType() ? 3 : 0;
                IntegerOption minimum = new IntegerOption(base + "minimumPrice", this);
                minimum.setValue(goodsType.getInitialSellPrice());
                minimum.setMinimumValue(1);
                minimum.setMaximumValue(100);
                prices.add(minimum);
                this.addAbstractOption(minimum);
                IntegerOption maximum = new IntegerOption(base + "maximumPrice", this);
                maximum.setValue(goodsType.getInitialSellPrice() + diff);
                maximum.setMinimumValue(1);
                maximum.setMaximumValue(100);
                prices.add(maximum);
                this.addAbstractOption(maximum);
                IntegerOption spread = new IntegerOption(base + "spread", this);
                spread.setValue(goodsType.getPriceDifference());
                spread.setMinimumValue(1);
                spread.setMaximumValue(100);
                prices.add(spread);
                this.addAbstractOption(spread);
                continue;
            }
            if (goodsType.getPrice() >= Integer.MAX_VALUE) continue;
            IntegerOption price = new IntegerOption(base + "price", this);
            price.setValue(goodsType.getPrice());
            price.setMinimumValue(1);
            price.setMaximumValue(100);
            prices.add(price);
            this.addAbstractOption(price);
        }
        this.getGameOptions().add(prices);
    }

    public boolean mergeGameOptions(OptionGroup newGameOptions, String who) {
        OptionGroup go = this.getGameOptions();
        LogBuilder lb = new LogBuilder(64);
        boolean ret = go.merge(newGameOptions, lb);
        lb.shrink("\n");
        lb.log(logger, Level.FINEST);
        if (!ret) {
            return false;
        }
        this.addOptionGroup(go, true);
        this.clean("merged game options (" + who + ")");
        return true;
    }

    public boolean mergeMapGeneratorOptions(OptionGroup newMapGeneratorOptions, String who) {
        OptionGroup go = this.getMapGeneratorOptions();
        LogBuilder lb = new LogBuilder(64);
        boolean ret = go.merge(newMapGeneratorOptions, lb);
        lb.shrink("\n");
        lb.log(logger, Level.FINEST);
        if (!ret) {
            return false;
        }
        this.addOptionGroup(go, true);
        this.clean("merged map options (" + who + ")");
        return true;
    }

    public int getAge(Turn turn) {
        int n = turn.getNumber();
        return n < this.ages[0] ? -1 : (n < this.ages[1] ? 0 : (n < this.ages[2] ? 1 : 2));
    }

    public BuildableType getBuildableType(String id) {
        return this.getType(id, BuildableType.class);
    }

    public List<BuildingType> getBuildingTypeList() {
        return this.buildingTypeList;
    }

    public BuildingType getBuildingType(String id) {
        return this.getType(id, BuildingType.class);
    }

    public List<Disaster> getDisasters() {
        return this.disasters;
    }

    public Disaster getDisaster(String id) {
        return this.getType(id, Disaster.class);
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public Event getEvent(String id) {
        return this.getType(id, Event.class);
    }

    public List<FoundingFather> getFoundingFathers() {
        return this.foundingFathers;
    }

    public FoundingFather getFoundingFather(String id) {
        return this.getType(id, FoundingFather.class);
    }

    public List<GoodsType> getGoodsTypeList() {
        return new ArrayList<GoodsType>(this.goodsTypeList);
    }

    public List<GoodsType> getStorableGoodsTypeList() {
        return new ArrayList<GoodsType>(this.storableGoodsTypeList);
    }

    public List<GoodsType> getFarmedGoodsTypeList() {
        return new ArrayList<GoodsType>(this.farmedGoodsTypeList);
    }

    public List<GoodsType> getNewWorldGoodsTypeList() {
        return new ArrayList<GoodsType>(this.newWorldGoodsTypeList);
    }

    public List<GoodsType> getNewWorldLuxuryGoodsTypeList() {
        return new ArrayList<GoodsType>(this.newWorldLuxuryGoodsTypeList);
    }

    public List<GoodsType> getLibertyGoodsTypeList() {
        return new ArrayList<GoodsType>(this.libertyGoodsTypeList);
    }

    public List<GoodsType> getImmigrationGoodsTypeList() {
        return new ArrayList<GoodsType>(this.immigrationGoodsTypeList);
    }

    public List<GoodsType> getFoodGoodsTypeList() {
        return new ArrayList<GoodsType>(this.foodGoodsTypeList);
    }

    public final List<GoodsType> getRawBuildingGoodsTypeList() {
        return new ArrayList<GoodsType>(this.rawBuildingGoodsTypeList);
    }

    public GoodsType getPrimaryFoodType() {
        return this.getGoodsType(DEFAULT_FOOD_TYPE);
    }

    public int getInitialPrice(GoodsType goodsType) {
        String suffix = goodsType.getSuffix("model.goods.");
        String minPrice = "model.option." + suffix + ".minimumPrice";
        String maxPrice = "model.option." + suffix + ".maximumPrice";
        return this.hasOption(minPrice, IntegerOption.class) && this.hasOption(maxPrice, IntegerOption.class) ? Math.min(this.getInteger(minPrice), this.getInteger(maxPrice)) : goodsType.getInitialSellPrice();
    }

    public GoodsType getGoodsType(String id) {
        return this.getType(id, GoodsType.class);
    }

    public List<TileImprovementType> getTileImprovementTypeList() {
        return this.tileImprovementTypeList;
    }

    public TileImprovementType getTileImprovementType(String id) {
        return this.getType(id, TileImprovementType.class);
    }

    public List<NationType> getNationTypes() {
        return this.nationTypes;
    }

    public List<EuropeanNationType> getEuropeanNationTypes() {
        return this.europeanNationTypes;
    }

    public List<EuropeanNationType> getREFNationTypes() {
        return this.REFNationTypes;
    }

    public List<IndianNationType> getIndianNationTypes() {
        return this.indianNationTypes;
    }

    public NationType getNationType(String id) {
        return this.getType(id, NationType.class);
    }

    public NationType getDefaultNationType() {
        return this.getNationType(DEFAULT_NATION_TYPE);
    }

    public List<Nation> getNations() {
        return this.nations;
    }

    public List<Nation> getEuropeanNations() {
        return this.europeanNations;
    }

    public List<Nation> getIndianNations() {
        return this.indianNations;
    }

    public List<Nation> getREFNations() {
        return this.REFNations;
    }

    public Nation getNation(String id) {
        return this.getType(id, Nation.class);
    }

    public Nation getUnknownEnemyNation() {
        return this.getNation("model.nation.unknownEnemy");
    }

    public void clearEuropeanNationalAdvantages() {
        for (Nation n : this.getEuropeanNations()) {
            n.setType(this.getDefaultNationType());
        }
    }

    public List<ResourceType> getResourceTypeList() {
        return this.resourceTypeList;
    }

    public ResourceType getResourceType(String id) {
        return this.getType(id, ResourceType.class);
    }

    public List<Role> getRolesList() {
        return this.roles;
    }

    public Stream<Role> getRoles() {
        return this.getRolesList().stream();
    }

    public Role getRole(String id) {
        return this.getType(id, Role.class);
    }

    public Role getDefaultRole() {
        return this.getRole(DEFAULT_ROLE_ID);
    }

    public List<Role> getMilitaryRolesList() {
        if (this.militaryRoles == null) {
            this.militaryRoles = Collections.unmodifiableList(CollectionUtils.transform(this.roles, Role::isOffensive, Function.identity(), Role.militaryComparator));
        }
        return this.militaryRoles;
    }

    public Stream<Role> getMilitaryRoles() {
        return this.getMilitaryRolesList().stream();
    }

    public List<Role> getREFRolesList(boolean naval) {
        return CollectionUtils.transform(naval ? Stream.of(this.getDefaultRole()) : this.getMilitaryRoles(), r -> r.requiresAbility("model.ability.refUnit"));
    }

    public Stream<Role> getREFRoles(boolean naval) {
        return this.getREFRolesList(naval).stream();
    }

    public Role getRoleWithAbility(String id, List<Role> roles) {
        return CollectionUtils.find(this.getRoles(), r -> r.hasAbility(id));
    }

    public Role getMissionaryRole() {
        return this.getRoleWithAbility("model.ability.establishMission", null);
    }

    public Role getPioneerRole() {
        return this.getRoleWithAbility("model.ability.improveTerrain", null);
    }

    public Role getScoutRole() {
        return this.getRoleWithAbility("model.ability.speakWithChief", null);
    }

    public List<TileType> getTileTypeList() {
        return this.tileTypeList;
    }

    public TileType getTileType(String id) {
        return this.getType(id, TileType.class);
    }

    public List<UnitChangeType> getUnitChangeTypeList() {
        return this.unitChangeTypeList;
    }

    public UnitChangeType getUnitChangeType(String id) {
        return CollectionUtils.find(this.unitChangeTypeList, CollectionUtils.matchKeyEquals(id, FreeColObject::getId));
    }

    public List<UnitTypeChange> getUnitChanges(String id, UnitType fromType) {
        UnitChangeType uct = this.getUnitChangeType(id);
        return uct == null ? Collections.emptyList() : uct.getUnitChanges(fromType);
    }

    public UnitTypeChange getUnitChange(String id, UnitType fromType) {
        return this.getUnitChange(id, fromType, null);
    }

    public UnitTypeChange getUnitChange(String id, UnitType fromType, UnitType toType) {
        UnitChangeType uct = this.getUnitChangeType(id);
        return uct == null ? null : uct.getUnitChange(fromType, toType);
    }

    public int getNeededTurnsOfTraining(UnitType typeTeacher, UnitType typeStudent) {
        UnitType learn = typeStudent.getTeachingType(typeTeacher);
        if (learn == null) {
            throw new RuntimeException("Can not learn: teacher=" + typeTeacher + " student=" + typeStudent);
        }
        return this.getUnitChange((String)"model.unitChange.education", (UnitType)typeStudent, (UnitType)learn).turns;
    }

    public List<UnitType> getUnitTypeList() {
        return this.unitTypeList;
    }

    public UnitType getDefaultUnitType(Player player) {
        return player == null ? this.getDefaultUnitType() : this.getDefaultUnitType(player.getNationType());
    }

    public UnitType getDefaultUnitType(NationType nationType) {
        Predicate<UnitType> p = nationType == null ? ut -> !ut.hasAbility("model.ability.bornInIndianSettlement") && !ut.hasAbility("model.ability.refUnit") : (nationType.isIndian() ? ut -> ut.hasAbility("model.ability.bornInIndianSettlement") && !ut.hasAbility("model.ability.refUnit") : (nationType.isREF() ? ut -> !ut.hasAbility("model.ability.bornInIndianSettlement") && ut.hasAbility("model.ability.refUnit") : ut -> !ut.hasAbility("model.ability.bornInIndianSettlement") && !ut.hasAbility("model.ability.refUnit")));
        return CollectionUtils.find(this.defaultUnitTypes, p, this.getDefaultUnitType());
    }

    public UnitType getDefaultUnitType() {
        return this.getUnitType("model.unit.freeColonist");
    }

    public List<UnitType> getBuildableUnitTypes() {
        return this.buildableUnitTypes;
    }

    public UnitType getExpertForProducing(GoodsType goodsType) {
        return this.experts.get(goodsType);
    }

    public List<UnitType> getUnitTypesWithAbility(String ... abilities) {
        return this.getTypesWithAbility(UnitType.class, abilities);
    }

    public List<UnitType> getUnitTypesWithoutAbility(String ... abilities) {
        return this.getTypesWithoutAbility(UnitType.class, abilities);
    }

    public List<UnitType> getUnitTypesTrainedInEurope() {
        return this.unitTypesTrainedInEurope;
    }

    public List<UnitType> getUnitTypesPurchasedInEurope() {
        return this.unitTypesPurchasedInEurope;
    }

    public UnitType getFastestLandUnitType() {
        return this.fastestLandUnitType;
    }

    public UnitType getFastestNavalUnitType() {
        return this.fastestNavalUnitType;
    }

    public List<UnitType> getREFUnitTypes(boolean naval) {
        return CollectionUtils.transform(this.getUnitTypesWithAbility("model.ability.refUnit"), CollectionUtils.matchKey(naval, UnitType::isNaval));
    }

    public UnitType getUnitType(String id) {
        return this.getType(id, UnitType.class);
    }

    public <T extends FreeColSpecObjectType> T findType(String id, Class<T> returnClass) {
        T o = this.getType(id, returnClass);
        if (o != null) {
            return o;
        }
        if (this.initialized) {
            throw new RuntimeException("Undefined FCGOT: " + id);
        }
        o = this.newType(id, returnClass);
        this.addType(id, (FreeColSpecObjectType)o);
        return o;
    }

    private <T extends FreeColSpecObjectType> T newType(String id, Class<T> returnClass) {
        try {
            return (T)((FreeColSpecObjectType)Introspector.instantiate(returnClass, newTypeClasses, new Object[]{id, this}));
        }
        catch (Introspector.IntrospectorException ie) {
            logger.log(Level.WARNING, "newType(" + id + "," + returnClass.getName() + ") failed", ie);
            return null;
        }
    }

    public List<FreeColSpecObjectType> getTypesProviding(String id, boolean value) {
        return CollectionUtils.transform(this.getAbilities(id), a -> a.getValue() == value && a.getSource() instanceof FreeColSpecObjectType, a -> (FreeColSpecObjectType)a.getSource());
    }

    public <T extends FreeColSpecObjectType> List<T> getTypesWithAbility(Class<T> resultType, String ... abilities) {
        return CollectionUtils.transform(this.allTypes.values(), type -> resultType.isInstance(type) && CollectionUtils.any(abilities, a -> type.hasAbility((String)a)), type -> (FreeColSpecObjectType)resultType.cast(type));
    }

    public <T extends FreeColSpecObjectType> List<T> getTypesWithoutAbility(Class<T> resultType, String ... abilities) {
        return CollectionUtils.transform(this.allTypes.values(), type -> resultType.isInstance(type) && CollectionUtils.none(abilities, a -> type.hasAbility((String)a)), type -> (FreeColSpecObjectType)resultType.cast(type));
    }

    private boolean applyFixes() {
        boolean ret = false;
        ret |= this.fixDifficultyOptions();
        ret |= this.fixGameOptions();
        ret |= this.fixMapGeneratorOptions();
        ret |= this.fixOrphanOptions();
        ret |= this.fixRoles();
        ret |= this.fixUnitChanges();
        return ret |= this.fixSpec();
    }

    private boolean fixOrphanOptions() {
        HashSet<AbstractOption> allO = new HashSet<AbstractOption>(this.allOptions.values());
        HashSet<AbstractOption> allG = new HashSet<AbstractOption>(this.allOptionGroups.values());
        for (String id : coreOptionGroups) {
            this.dropOptions(this.allOptionGroups.get(id), allO);
            this.dropOptions(this.allOptionGroups.get(id), allG);
        }
        for (AbstractOption ao : allO) {
            this.dropOptions(ao, this.allOptions.values());
            if (ao instanceof OptionGroup) {
                this.allOptionGroups.remove(ao.getId());
            }
            logger.warning("Dropping orphan option: " + ao);
        }
        for (AbstractOption ao : allG) {
            this.allOptionGroups.remove(ao.getId());
            logger.warning("Dropping orphan option group: " + ao);
        }
        return !allO.isEmpty() || !allG.isEmpty();
    }

    private void dropOptions(AbstractOption o, Collection<AbstractOption> all) {
        all.remove(o);
        if (o instanceof OptionGroup) {
            OptionGroup og = (OptionGroup)o;
            for (Option op : og.getOptions()) {
                if (!(op instanceof AbstractOption)) continue;
                this.dropOptions((AbstractOption)op, all);
            }
        }
    }

    private boolean fixRoles() {
        if (!this.roles.isEmpty()) {
            return false;
        }
        if (this.compareVersion("0.85") > 0) {
            return false;
        }
        File rolf = FreeColDirectories.getCompatibilityFile(ROLES_COMPAT_FILE_NAME);
        try (InputStream fis = Files.newInputStream(rolf.toPath(), new OpenOption[0]);){
            this.load(fis);
        }
        catch (IOException | XMLStreamException e) {
            logger.log(Level.WARNING, "Failed to load remedial roles.", e);
            return false;
        }
        logger.info("Loading role backward compatibility fragment: roles-compat.xml with roles: " + CollectionUtils.transform(this.getRoles(), CollectionUtils.alwaysTrue(), FreeColObject::getId, Collectors.joining(" ")));
        return true;
    }

    private boolean fixUnitChanges() {
        if (this.compareVersion("0.116") > 0) {
            return false;
        }
        UnitChangeType enter = CollectionUtils.find(this.unitChangeTypeList, CollectionUtils.matchKeyEquals("model.unitChange.enterColony", FreeColObject::getId));
        File uctf = FreeColDirectories.getCompatibilityFile(UNIT_CHANGE_TYPES_COMPAT_FILE_NAME);
        try (InputStream fis = Files.newInputStream(uctf.toPath(), new OpenOption[0]);){
            this.load(fis);
        }
        catch (IOException | XMLStreamException e) {
            logger.log(Level.WARNING, "Failed to load unit changes.", e);
            return false;
        }
        if (enter != null) {
            this.unitChangeTypeList.add(enter);
        }
        logger.info("Loading unit-changes backward compatibility fragment: unit-change-types-compat.xml with changes: " + CollectionUtils.transform(this.getUnitChangeTypeList(), CollectionUtils.alwaysTrue(), FreeColObject::getId, Collectors.joining(" ")));
        return true;
    }

    private boolean fixSpec() {
        UnitType mow;
        UnitType hardyPioneer;
        Limit limit;
        Event event;
        BuildingType customs;
        boolean ret = false;
        Nation ue = this.findType("model.nation.unknownEnemy", Nation.class);
        ue.setType(this.getNationType(DEFAULT_NATION_TYPE));
        if (!this.nations.contains(ue)) {
            this.nations.add(ue);
            ret = true;
        }
        for (Nation nation : this.nations) {
            if (nation.getColor() != null) continue;
            nation.setColor(defaultColors.get(nation.getId()));
            ret = true;
        }
        FoundingFather coronado = this.getFoundingFather("model.foundingFather.franciscoDeCoronado");
        if ("freecol".equals(this.getId()) && !coronado.hasAbility("model.ability.seeAllColonies")) {
            coronado.addAbility(new Ability("model.ability.seeAllColonies", coronado, true));
            ret = true;
        }
        for (OptionGroup level : this.getDifficultyLevels()) {
            Option monarch = level.getOption("model.difficulty.monarch");
            Option refSize = ((OptionGroup)(monarch instanceof OptionGroup ? monarch : level)).getOption("model.option.refSize");
            if (!(refSize instanceof UnitListOption)) continue;
            for (AbstractUnit au : ((UnitListOption)refSize).getOptionValues()) {
                boolean changed = true;
                if ("DEFAULT".equals(au.getRoleId())) {
                    au.setRoleId(DEFAULT_ROLE_ID);
                } else if ("model.role.soldier".equals(au.getRoleId()) || "SOLDIER".equals(au.getRoleId())) {
                    au.setRoleId("model.role.infantry");
                } else if ("model.role.dragoon".equals(au.getRoleId()) || "DRAGOON".equals(au.getRoleId())) {
                    au.setRoleId("model.role.cavalry");
                } else {
                    changed = false;
                }
                if (!changed) continue;
                ret = true;
            }
        }
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>(this.getDifficultyLevels());
        while (!arrayList.isEmpty()) {
            Option o = (Option)arrayList.remove(0);
            if (o instanceof OptionGroup) {
                List<Option> next = ((OptionGroup)o).getOptions();
                arrayList.addAll(new ArrayList<Option>(next));
                continue;
            }
            if (!(o instanceof UnitListOption)) continue;
            for (AbstractUnit au : ((UnitListOption)o).getOptionValues()) {
                String roleId = au.getRoleId();
                boolean changed = true;
                if (roleId == null) {
                    au.setRoleId(DEFAULT_ROLE_ID);
                } else if (au.getRoleId().startsWith("model.role.")) {
                    changed = false;
                } else if ("DEFAULT".equals(au.getRoleId())) {
                    au.setRoleId(DEFAULT_ROLE_ID);
                } else if ("DRAGOON".equals(au.getRoleId())) {
                    au.setRoleId("model.role.dragoon");
                } else if ("MISSIONARY".equals(au.getRoleId())) {
                    au.setRoleId("model.role.missionary");
                } else if ("PIONEER".equals(au.getRoleId())) {
                    au.setRoleId("model.role.pioneer");
                } else if ("SCOUT".equals(au.getRoleId())) {
                    au.setRoleId("model.role.scout");
                } else if ("SOLDIER".equals(au.getRoleId())) {
                    au.setRoleId("model.role.soldier");
                } else {
                    au.setRoleId(DEFAULT_ROLE_ID);
                }
                if (!changed) continue;
                ret = true;
            }
        }
        GoodsType goodsType = this.getGoodsType("model.goods.horses");
        if (!goodsType.getMilitary()) {
            goodsType.setMilitary();
            ret = true;
        }
        if (!(goodsType = this.getGoodsType("model.goods.muskets")).getMilitary()) {
            goodsType.setMilitary();
            ret = true;
        }
        FoundingFather bolivar = this.getFoundingFather("model.foundingFather.simonBolivar");
        boolean bolivarAdd = false;
        if (!bolivar.getEvents().isEmpty()) {
            bolivar.setEvents(Collections.emptyList());
            bolivarAdd = true;
        } else if (bolivar.hasModifier("model.modifier.liberty")) {
            bolivar.removeModifiers("model.modifier.liberty");
            bolivarAdd = true;
        }
        if (bolivarAdd) {
            bolivar.addModifier(new Modifier("model.modifier.SoL", 20.0f, Modifier.ModifierType.ADDITIVE, bolivar, 0));
            ret = true;
        }
        if (!(customs = this.getBuildingType("model.building.customHouse")).hasAbility("model.ability.coastalOnly")) {
            customs.addAbility(new Ability("model.ability.coastalOnly", null, false));
            ret = true;
        }
        if (CollectionUtils.none(this.getModifiers("model.modifier.cargoPenalty"))) {
            this.addModifier(new Modifier("model.modifier.cargoPenalty", -12.5f, Modifier.ModifierType.PERCENTAGE, CARGO_PENALTY_SOURCE, 50));
            ret = true;
        }
        if ((event = this.getEvent("model.event.declareIndependence")) != null && (limit = event.getLimit("model.limit.independence.coastalColonies")) != null) {
            limit.setOperator(Limit.Operator.GE);
            limit.getRightHandSide().setValue(1);
            ret = true;
        }
        if (CollectionUtils.none((hardyPioneer = this.getUnitType("model.unit.hardyPioneer")).getModifiers("model.modifier.tileTypeChangeProduction"))) {
            Modifier m = new Modifier("model.modifier.tileTypeChangeProduction", 2.0f, Modifier.ModifierType.MULTIPLICATIVE);
            Scope scope = new Scope();
            scope.setType("model.goods.lumber");
            m.addScope(scope);
            hardyPioneer.addModifier(m);
            ret = true;
        }
        if (!coronado.hasModifier("model.modifier.exposedTilesRadius")) {
            coronado.addModifier(new Modifier("model.modifier.exposedTilesRadius", 3.0f, Modifier.ModifierType.ADDITIVE, coronado, 0));
            ret = true;
        }
        for (IndianNationType nt : this.indianNationTypes) {
            for (SettlementType st : nt.getSettlementTypes()) {
                for (PlunderType pt : st.getPlunderTypes()) {
                    if (pt.getId() != null) continue;
                    Scope scope = CollectionUtils.find(pt.getScopes(), CollectionUtils.matchKey("model.ability.plunderNatives", Scope::getAbilityId));
                    String id = "plunder." + nt.getSuffix() + (st.isCapital() ? ".capital" : "") + (scope == null ? "" : ".extra");
                    pt.setId(id);
                    ret = true;
                }
            }
        }
        FoundingFather casas = this.getFoundingFather("model.foundingFather.bartolomeDeLasCasas");
        if (casas != null && !casas.hasAbility("model.ability.upgradeConvert")) {
            Ability uc = new Ability("model.ability.upgradeConvert", casas, true);
            this.addAbility(uc);
            casas.addAbility(uc);
            ret = true;
        }
        if ((mow = this.getUnitType("model.unit.manOWar")) != null && mow.getMercenaryPrice() < 0) {
            mow.setMercenaryPrice(10000);
            ret = true;
        }
        String maidId = "model.ability.independenceDeclared";
        if (mow != null && mow.requiresAbility("model.ability.independenceDeclared")) {
            mow.removeRequiredAbility("model.ability.independenceDeclared");
            mow.addRequiredAbility("model.ability.independentNation", true);
            ret = true;
        }
        for (UnitType ut : this.getUnitTypesWithAbility("model.ability.refUnit")) {
            if (ut.containsAbilityKey("model.ability.canBeSurrendered")) continue;
            ut.addAbility(new Ability("model.ability.canBeSurrendered", null, "model.unit.artillery".equals(ut.getId())));
            ret = true;
        }
        return ret;
    }

    private boolean fixDifficultyOptions() {
        AbstractUnitOption menOfWar;
        AbstractUnitOption artillery;
        AbstractUnitOption dragoons;
        AbstractUnitOption regulars;
        boolean ret = false;
        LogBuilder lb = new LogBuilder(64);
        lb.mark();
        ret |= this.checkDifficultyOptionGroup("model.difficulty.immigration", lb, "model.option.crossesIncrement", "model.option.recruitPriceIncrease", "model.option.lowerCapIncrease", "model.option.priceIncrease.artillery", "model.option.priceIncreasePerType", "model.option.expertStartingUnits", "model.option.immigrants");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.natives", lb, "model.option.landPriceFactor", "model.option.nativeConvertProbability", "model.option.burnProbability", "model.option.nativeDemands", "model.option.rumourDifficulty", "model.option.shipTradePenalty", "model.option.buildOnNativeLand", "model.option.settlementNumber");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.monarch", lb, "model.option.monarchMeddling", "model.option.taxAdjustment", "model.option.mercenaryPrice", "model.option.maximumTax", "model.option.monarchSupport", "model.option.treasureTransportFee", "model.option.refSize", "model.option.interventionBells", "model.option.interventionTurns", "model.option.interventionForce", "model.option.mercenaryForce");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.government", lb, "model.option.badGovernmentLimit", "model.option.veryBadGovernmentLimit", "model.option.goodGovernmentLimit", "model.option.veryGoodGovernmentLimit");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.other", lb, "model.option.startingMoney", "model.option.foundingFatherFactor", "model.option.arrearsFactor", "model.option.unitsThatUseNoBells", "model.option.tileProduction");
        ret |= this.checkDifficultyOptionGroup("model.difficulty.cheat", lb, "model.option.liftBoycottCheat", "model.option.equipScoutCheat", "model.option.landUnitCheat", "model.option.offensiveNavalUnitCheat", "model.option.transportNavalUnitCheat");
        String id = "model.option.refSize";
        UnitListOption ulo = this.checkDifficultyUnitListOption(id, "model.difficulty.monarch", lb);
        if (ulo != null) {
            regulars = new AbstractUnitOption(id + ".regulars", this);
            regulars.setValue(new AbstractUnit("model.unit.kingsRegular", "model.role.infantry", 31));
            ulo.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons", this);
            dragoons.setValue(new AbstractUnit("model.unit.kingsRegular", "model.role.cavalry", 15));
            ulo.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery", this);
            artillery.setValue(new AbstractUnit("model.unit.artillery", DEFAULT_ROLE_ID, 14));
            ulo.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar", this);
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", DEFAULT_ROLE_ID, 8));
            ulo.getValue().add(menOfWar);
            ret = true;
        }
        if ((ulo = this.checkDifficultyUnitListOption(id = "model.option.immigrants", "model.difficulty.immigration", lb)) != null) {
            AbstractUnitOption i1 = new AbstractUnitOption(id + ".1", this);
            i1.setValue(new AbstractUnit("model.unit.masterCarpenter", DEFAULT_ROLE_ID, 1));
            ulo.getValue().add(i1);
            ret = true;
        }
        ret |= this.checkDifficultyIntegerOption("model.option.interventionBells", "model.difficulty.monarch", lb, 5000);
        ret |= this.checkDifficultyIntegerOption("model.option.interventionTurns", "model.difficulty.monarch", lb, 52);
        id = "model.option.interventionForce";
        ulo = this.checkDifficultyUnitListOption(id, "model.difficulty.monarch", lb);
        if (ulo != null) {
            regulars = new AbstractUnitOption(id + ".regulars", this);
            regulars.setValue(new AbstractUnit("model.unit.colonialRegular", "model.role.soldier", 2));
            ulo.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons", this);
            dragoons.setValue(new AbstractUnit("model.unit.colonialRegular", "model.role.dragoon", 2));
            ulo.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery", this);
            artillery.setValue(new AbstractUnit("model.unit.artillery", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar", this);
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(menOfWar);
            ret = true;
        }
        if ((ulo = this.checkDifficultyUnitListOption(id = "model.option.mercenaryForce", "model.difficulty.monarch", lb)) != null) {
            regulars = new AbstractUnitOption(id + ".regulars", this);
            regulars.setValue(new AbstractUnit("model.unit.veteranSoldier", "model.role.soldier", 2));
            ulo.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons", this);
            dragoons.setValue(new AbstractUnit("model.unit.veteranSoldier", "model.role.dragoon", 2));
            ulo.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery", this);
            artillery.setValue(new AbstractUnit("model.unit.artillery", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar", this);
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", DEFAULT_ROLE_ID, 2));
            ulo.getValue().add(menOfWar);
            ret = true;
        }
        ret |= this.checkDifficultyIntegerOption("model.option.goodGovernmentLimit", "model.difficulty.government", lb, 50);
        ret |= this.checkDifficultyIntegerOption("model.option.veryGoodGovernmentLimit", "model.difficulty.government", lb, 100);
        ret |= this.checkDifficultyIntegerOption("model.option.liftBoycottCheat", "model.difficulty.cheat", lb, 10);
        ret |= this.checkDifficultyIntegerOption("model.option.equipScoutCheat", "model.difficulty.cheat", lb, 10);
        ret |= this.checkDifficultyIntegerOption("model.option.landUnitCheat", "model.difficulty.cheat", lb, 10);
        ret |= this.checkDifficultyIntegerOption("model.option.offensiveNavalUnitCheat", "model.difficulty.cheat", lb, 10);
        ret |= this.checkDifficultyIntegerOption("model.option.transportNavalUnitCheat", "model.difficulty.cheat", lb, 10);
        ret |= this.checkDifficultyIntegerOption("model.option.destroySettlementScore", "model.difficulty.natives", lb, -5);
        ret |= this.checkDifficultyPercentageOption("model.option.badRumour", "model.difficulty.other", lb, 23);
        ret |= this.checkDifficultyPercentageOption("model.option.goodRumour", "model.difficulty.other", lb, 48);
        ret |= this.checkDifficultyIntegerOption("model.option.offensiveLandUnitCheat", "model.difficulty.cheat", lb, 4);
        ret |= this.checkDifficultyIntegerOption("model.option.equipPioneerCheat", "model.difficulty.cheat", lb, 10);
        id = "model.option.warSupportForce";
        ulo = this.checkDifficultyUnitListOption(id, "model.difficulty.monarch", lb);
        if (ulo != null) {
            AbstractUnitOption support = new AbstractUnitOption(id, this);
            support.setValue(new AbstractUnit("model.unit.veteranSoldier", "model.role.soldier", 4));
            ulo.getValue().add(support);
            ret = true;
        }
        ret |= this.checkDifficultyIntegerOption("model.option.warSupportGold", "model.difficulty.monarch", lb, 1500);
        for (OptionGroup level : this.getDifficultyLevels()) {
            for (Option o : level.getOptions()) {
                if (o instanceof OptionGroup) {
                    OptionGroup og = (OptionGroup)o;
                    for (Option o2 : og.getOptions()) {
                        if (!(o2 instanceof OptionGroup)) continue;
                        lb.add("?-group ", level.getId() + "/" + og.getId() + "/" + o2.getId());
                    }
                    continue;
                }
                lb.add("? ", level.getId() + "/" + o.getId());
            }
        }
        if (lb.grew("Check difficulty options:")) {
            lb.log(logger, Level.INFO);
        }
        return ret;
    }

    private boolean checkDifficultyOptionGroup(String gr, LogBuilder lb, String ... ids) {
        boolean ret = false;
        for (OptionGroup level : this.getDifficultyLevels()) {
            OptionGroup og = null;
            for (Option o : level.getOptions()) {
                if (!o.getId().equals(gr) || !(o instanceof OptionGroup)) continue;
                og = (OptionGroup)o;
                break;
            }
            if (og == null) {
                level.remove(gr);
                og = new OptionGroup(gr, this);
                level.add(og);
                og.setGroup(level.getId());
                lb.add("\n  +", level.getId(), "/", gr);
                ret = true;
            }
            for (String id : ids) {
                ObjectWithId op = null;
                for (Option o : level.getOptions()) {
                    if (!o.getId().equals(id) || o instanceof OptionGroup) continue;
                    op = o;
                    break;
                }
                if (op == null) continue;
                level.remove(op.getId());
                if (op instanceof AbstractOption) {
                    ((AbstractOption)op).setGroup(og.getId());
                }
                og.add((Option)op);
                lb.add("\n  ~", level.getId(), "/", id, " -> ", level.getId(), "/" + og.getId());
                ret = true;
            }
        }
        return ret;
    }

    private boolean checkDifficultyIntegerOption(String id, String gr, LogBuilder lb, int defaultValue) {
        boolean ret = false;
        for (OptionGroup level : this.getDifficultyLevels()) {
            OptionGroup og = null;
            for (Option option : level.getOptions()) {
                if (!option.getId().equals(gr) || !(option instanceof OptionGroup)) continue;
                og = (OptionGroup)option;
                break;
            }
            if (og == null) continue;
            ObjectWithId op = null;
            for (Option o3 : level.getOptions()) {
                if (!o3.getId().equals(id) || o3 instanceof OptionGroup) continue;
                op = o3;
                break;
            }
            if (op != null) {
                level.remove(op.getId());
                if (!(op instanceof IntegerOption)) {
                    IntegerOption integerOption = new IntegerOption(id, this);
                    integerOption.setValue(defaultValue);
                    op = integerOption;
                }
                op.setGroup(gr);
                og.add((Option)op);
                lb.add("\n  ~", level.getId(), "/", id, " -> ", level.getId(), "/" + og.getId());
            } else {
                op = null;
                for (Option o : og.getOptions()) {
                    if (!o.getId().equals(id)) continue;
                    op = o;
                    break;
                }
                if (op instanceof IntegerOption) continue;
                if (op != null) {
                    og.remove(id);
                }
                IntegerOption integerOption = new IntegerOption(id, this);
                integerOption.setGroup(gr);
                integerOption.setValue(defaultValue);
                og.add(integerOption);
                lb.add("\n  +", level.getId(), "/", og.getId(), "/", id, "=", defaultValue);
            }
            ret = true;
        }
        return ret;
    }

    private boolean checkDifficultyPercentageOption(String id, String gr, LogBuilder lb, int defaultValue) {
        boolean ret = false;
        for (OptionGroup level : this.getDifficultyLevels()) {
            OptionGroup og = null;
            for (Option option : level.getOptions()) {
                if (!option.getId().equals(gr) || !(option instanceof OptionGroup)) continue;
                og = (OptionGroup)option;
                break;
            }
            if (og == null) continue;
            ObjectWithId op = null;
            for (Option o3 : level.getOptions()) {
                if (!o3.getId().equals(id) || o3 instanceof OptionGroup) continue;
                op = o3;
                break;
            }
            if (op != null) {
                level.remove(op.getId());
                if (!(op instanceof PercentageOption)) {
                    PercentageOption percentageOption = new PercentageOption(id, this);
                    percentageOption.setValue(defaultValue);
                    op = percentageOption;
                }
                op.setGroup(gr);
                og.add((Option)op);
                lb.add("\n  ~", level.getId(), "/", id, " -> ", level.getId(), "/" + og.getId());
            } else {
                op = null;
                for (Option o : og.getOptions()) {
                    if (!o.getId().equals(id)) continue;
                    op = o;
                    break;
                }
                if (op instanceof PercentageOption) continue;
                if (op != null) {
                    og.remove(id);
                }
                PercentageOption percentageOption = new PercentageOption(id, this);
                percentageOption.setValue(defaultValue);
                percentageOption.setGroup(gr);
                og.add(percentageOption);
                lb.add("\n  +", level.getId(), "/", og.getId(), "/", id, "=", defaultValue);
            }
            ret = true;
        }
        return ret;
    }

    private UnitListOption checkDifficultyUnitListOption(String id, String gr, LogBuilder lb) {
        UnitListOption ulo = null;
        for (OptionGroup level : this.getDifficultyLevels()) {
            OptionGroup og = null;
            for (Option o : level.getOptions()) {
                if (!o.getId().equals(gr) || !(o instanceof OptionGroup)) continue;
                og = (OptionGroup)o;
                break;
            }
            if (og == null) continue;
            ObjectWithId op = null;
            for (Option o : level.getOptions()) {
                if (!o.getId().equals(id) || o instanceof OptionGroup) continue;
                op = o;
                break;
            }
            if (op != null) {
                level.remove(op.getId());
                if (op instanceof AbstractOption) {
                    ((AbstractOption)op).setGroup(og.getId());
                }
                og.add((Option)op);
                lb.add("\n  ~", level.getId(), "/", id, " -> ", level.getId(), "/" + og.getId());
                continue;
            }
            op = null;
            for (Option o : og.getOptions()) {
                if (!o.getId().equals(id)) continue;
                op = o;
                break;
            }
            if (op instanceof UnitListOption) continue;
            if (op != null) {
                og.remove(id);
            }
            if (ulo == null) {
                ulo = new UnitListOption(id, this);
            }
            og.add(ulo);
            lb.add("\n  +", level.getId(), "/", og.getId(), "/[", id, "]");
        }
        return ulo;
    }

    private boolean fixGameOptions() {
        boolean ret = false;
        ret |= this.checkOp("model.option.enableUpkeep", "gameOptions.colony", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.naturalDisasters", "gameOptions.colony", 0, PercentageOption.class);
        ret |= this.checkOp("model.option.giftProbability", "gameOptions.map", 5, PercentageOption.class);
        ret |= this.checkOp("model.option.demandProbability", "gameOptions.map", 10, PercentageOption.class);
        ret |= this.checkOp("model.option.emptyTraders", "gameOptions.map", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.onlyNaturalImprovements", "gameOptions.colony", Boolean.TRUE, BooleanOption.class);
        ret |= this.checkOp("model.option.peaceProbability", "gameOptions.map", 90, PercentageOption.class);
        ret |= this.checkOp("model.option.initialImmigration", "gameOptions.map", 15, IntegerOption.class);
        ret |= this.checkOp("model.option.europeanUnitImmigrationPenalty", "gameOptions.map", -4, IntegerOption.class);
        ret |= this.checkOp("model.option.playerImmigrationBonus", "gameOptions.map", 2, IntegerOption.class);
        ret |= this.checkOp("model.option.foundColonyDuringRebellion", "gameOptions.colony", Boolean.TRUE, BooleanOption.class);
        ret |= this.checkOp("model.option.bellAccumulationCapped", "gameOptions.colony", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.captureUnitsUnderRepair", "gameOptions.colony", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.payForBuilding", "gameOptions.colony", Boolean.TRUE, BooleanOption.class);
        ret |= this.checkOp("model.option.clearHammersOnConstructionSwitch", "gameOptions.colony", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.customsOnCoast", "gameOptions.colony", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.equipEuropeanRecruits", "gameOptions.colony", Boolean.TRUE, BooleanOption.class);
        ret |= this.checkOp("model.option.missionInfluence", "gameOptions.map", -10, IntegerOption.class);
        ret |= this.checkOp("model.option.independenceTurn", "gameOptions.years", 468, IntegerOption.class);
        ret |= this.checkOp("model.option.ages", "gameOptions.years", "1600,1700", TextOption.class);
        ret |= this.checkOp("model.option.seasons", "gameOptions.years", 2, IntegerOption.class);
        ret |= this.checkOp("model.option.disembarkInColony", "gameOptions.colony", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.enhancedTradeRoutes", "gameOptions.map", Boolean.FALSE, BooleanOption.class);
        ret |= this.checkOp("model.option.settlementNumberOfGoodsToSell", "gameOptions.map", 3, IntegerOption.class);
        ret |= this.checkOp("model.option.alarmBonusBuy", "gameOptions.map", 20, PercentageOption.class);
        ret |= this.checkOp("model.option.alarmBonusSell", "gameOptions.map", 20, PercentageOption.class);
        ret |= this.checkOp("model.option.alarmBonusGift", "gameOptions.map", 40, PercentageOption.class);
        return ret |= this.checkOp("model.option.claimAllTiles", "gameOptions.colony", Boolean.FALSE, BooleanOption.class);
    }

    private boolean fixMapGeneratorOptions() {
        boolean ret = false;
        return ret;
    }

    private <R, T extends Option<R>> boolean checkOp(String id, String gr, R defaultValue, Class<T> returnClass) {
        Option op;
        if (this.hasOption(id, returnClass)) {
            return false;
        }
        try {
            op = (Option)Introspector.instantiate(returnClass, new Class[]{String.class, Specification.class}, new Object[]{id, this});
        }
        catch (Introspector.IntrospectorException ie) {
            logger.warning("Failed to make " + returnClass.getName() + ": " + id);
            return false;
        }
        op.setGroup(gr);
        op.setValue(defaultValue);
        this.getOptionGroup(gr).add(op);
        this.addAbstractOption((AbstractOption)op);
        return true;
    }

    protected void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeStartElement(TAG);
        xw.writeAttribute("id", this.getId());
        if (this.difficultyLevel != null) {
            xw.writeAttribute(DIFFICULTY_LEVEL_TAG, this.difficultyLevel);
        }
        if (this.version != null) {
            xw.writeAttribute(VERSION_TAG, this.version);
        }
        this.writeSection(xw, MODIFIERS_TAG, this.specialModifiers);
        this.writeSection(xw, EVENTS_TAG, this.events);
        this.writeSection(xw, DISASTERS_TAG, this.disasters);
        this.writeSection(xw, GOODS_TYPES_TAG, this.goodsTypeList);
        this.writeSection(xw, RESOURCE_TYPES_TAG, this.resourceTypeList);
        this.writeSection(xw, TILE_TYPES_TAG, this.tileTypeList);
        this.writeSection(xw, ROLES_TAG, this.roles);
        this.writeSection(xw, TILE_IMPROVEMENT_TYPES_TAG, this.tileImprovementTypeList);
        this.writeSection(xw, UNIT_CHANGE_TYPES_TAG, this.unitChangeTypeList);
        this.writeSection(xw, UNIT_TYPES_TAG, this.unitTypeList);
        this.writeSection(xw, BUILDING_TYPES_TAG, this.buildingTypeList);
        this.writeSection(xw, FOUNDING_FATHERS_TAG, this.foundingFathers);
        this.writeSection(xw, EUROPEAN_NATION_TYPES_TAG, this.europeanNationTypes);
        this.writeSection(xw, EUROPEAN_NATION_TYPES_TAG, this.REFNationTypes);
        this.writeSection(xw, INDIAN_NATION_TYPES_TAG, this.indianNationTypes);
        this.writeSection(xw, NATIONS_TAG, this.nations);
        xw.writeStartElement(OPTIONS_TAG);
        for (String id : coreOptionGroups) {
            OptionGroup og = this.allOptionGroups.get(id);
            if (og == null) continue;
            og.toXML(xw);
        }
        xw.writeEndElement();
        xw.writeEndElement();
    }

    private <T extends FreeColObject> void writeSection(FreeColXMLWriter xw, String section, Collection<T> items) throws XMLStreamException {
        xw.writeStartElement(section);
        for (FreeColObject item : items) {
            item.toXML(xw);
        }
        xw.writeEndElement();
    }

    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        String newId = xr.readId();
        if (this.id == null) {
            this.id = newId;
        }
        if (this.difficultyLevel == null) {
            this.difficultyLevel = xr.getAttribute(DIFFICULTY_LEVEL_TAG, null);
            if (this.difficultyLevel == null) {
                this.difficultyLevel = xr.getAttribute(OLD_DIFFICULTY_LEVEL_TAG, null);
            }
        }
        if (this.version == null) {
            this.version = xr.getAttribute(VERSION_TAG, null);
        }
        logger.fine("Reading specification " + newId + " difficulty=" + this.difficultyLevel + " version=" + this.version);
        String parentId = xr.getAttribute("extends", null);
        if (parentId != null) {
            try {
                FreeColTcFile parent = FreeColTcFile.getFreeColTcFile(parentId);
                this.load(parent.getSpecificationInputStream());
                this.initialized = false;
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to open parent specification: ", e);
            }
        }
        while (xr.moreTags()) {
            String childName = xr.getLocalName();
            if (OLD_EQUIPMENT_TYPES_TAG.equals(childName)) {
                xr.swallowTag(OLD_EQUIPMENT_TYPES_TAG);
                continue;
            }
            ChildReader reader = this.readerMap.get(childName);
            if (reader == null) {
                logger.warning("No reader found for: " + childName);
                continue;
            }
            reader.readChildren(xr);
        }
    }

    public String getXMLTagName() {
        return TAG;
    }

    static {
        defaultColors.put("model.nation.dutch", new Color(16751932));
        defaultColors.put("model.nation.french", new Color(255));
        defaultColors.put("model.nation.english", new Color(0xFF0000));
        defaultColors.put("model.nation.spanish", new Color(0xFFFF00));
        defaultColors.put("model.nation.inca", new Color(16052420));
        defaultColors.put("model.nation.aztec", new Color(12886048));
        defaultColors.put("model.nation.arawak", new Color(6850752));
        defaultColors.put("model.nation.cherokee", new Color(7093272));
        defaultColors.put("model.nation.iroquois", new Color(7644236));
        defaultColors.put("model.nation.sioux", new Color(12627076));
        defaultColors.put("model.nation.apache", new Color(0x900000));
        defaultColors.put("model.nation.tupi", new Color(285700));
        defaultColors.put("model.nation.dutchREF", new Color(0xCC5500));
        defaultColors.put("model.nation.frenchREF", new Color(6312156));
        defaultColors.put("model.nation.englishREF", new Color(14561635));
        defaultColors.put("model.nation.spanishREF", new Color(0xFFDF00));
        defaultColors.put("model.nation.portuguese", new Color(65280));
        defaultColors.put("model.nation.swedish", new Color(49151));
        defaultColors.put("model.nation.danish", new Color(0xFF00BF));
        defaultColors.put("model.nation.russian", new Color(0xFFFFFF));
        defaultColors.put("model.nation.portugueseREF", new Color(0xBFFF00));
        defaultColors.put("model.nation.swedishREF", new Color(3569032));
        defaultColors.put("model.nation.danishREF", new Color(9502829));
        defaultColors.put("model.nation.russianREF", new Color(0xBEBEBE));
        defaultColors.put("model.nation.unknownEnemy", Nation.UNKNOWN_NATION_COLOR);
        coreOptionGroups = new String[]{"gameOptions", "mapGeneratorOptions", DIFFICULTY_LEVELS};
    }

    public static class Source
    extends FreeColSpecObjectType {
        public Source(String id) {
            super(id);
        }

        @Override
        public void toXML(FreeColXMLWriter xw) {
            throw new RuntimeException("Can not happen: " + this);
        }

        @Override
        public String getXMLTagName() {
            return "source";
        }

        @Override
        public String toString() {
            return this.getId();
        }
    }

    private class TypeReader<T extends FreeColSpecObjectType>
    implements ChildReader {
        private final Class<T> type;
        private final List<T> result;
        private int index = 0;

        public TypeReader(Class<T> type, List<T> listToFill) {
            this.result = listToFill;
            this.type = type;
        }

        @Override
        @SuppressFBWarnings(value={"DLC_DUBIOUS_LIST_COLLECTION"}, justification="List required externally")
        public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
            while (xr.moreTags()) {
                FreeColSpecObjectType object;
                String tag = xr.getLocalName();
                String id = xr.readId();
                if (id == null) {
                    logger.warning("Null identifier, tag: " + tag);
                    continue;
                }
                if ("delete".equals(tag)) {
                    object = Specification.this.removeType(id);
                    if (object != null) {
                        this.result.remove(object);
                        continue;
                    }
                    logger.warning("Delete " + id + " failed");
                    continue;
                }
                object = Specification.this.getType(id, this.type);
                if (object == null) {
                    object = Specification.this.newType(id, this.type);
                    Specification.this.addType(id, object);
                }
                if (object.getId() != null && xr.getAttribute("preserve", false)) {
                    object.readChildren(xr);
                } else {
                    object.readFromXML(xr);
                }
                if (object.isAbstractType() || this.result.contains(object)) continue;
                this.result.add(object);
                object.setIndex(this.index);
                ++this.index;
            }
        }
    }

    private class OptionReader
    implements ChildReader {
        private static final String RECURSIVE_TAG = "recursive";

        private OptionReader() {
        }

        @Override
        public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
            while (xr.moreTags()) {
                this.readChild(xr);
            }
        }

        private void readChild(FreeColXMLReader xr) throws XMLStreamException {
            String tag = xr.getLocalName();
            boolean recursive = xr.getAttribute(RECURSIVE_TAG, true);
            if ("optionGroup".equals(tag)) {
                String id = xr.readId();
                OptionGroup group = Specification.this.allOptionGroups.get(id);
                if (group == null) {
                    group = new OptionGroup(id, Specification.this);
                    Specification.this.allOptionGroups.put(id, group);
                }
                group.readFromXML(xr);
                Specification.this.addOptionGroup(group, recursive);
            } else {
                logger.warning("optionGroup expected in OptionReader, not: " + tag);
                xr.nextTag();
            }
        }
    }

    private class ModifierReader
    implements ChildReader {
        private ModifierReader() {
        }

        @Override
        public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
            while (xr.moreTags()) {
                Modifier modifier = new Modifier(xr, Specification.this);
                Specification.this.addModifier(modifier);
                Specification.this.specialModifiers.add(modifier);
            }
        }
    }

    private static interface ChildReader {
        public void readChildren(FreeColXMLReader var1) throws XMLStreamException;
    }
}

