/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.util.CollectionUtils;

public class FreeColSavegameFile
extends FreeColDataFile {
    public static final String VERSION_TAG = "version";
    public static final String SAVEGAME_FILE = "savegame.xml";
    public static final String SAVEGAME_PROPERTIES = "savegame.properties";
    public static final String CLIENT_OPTIONS = "client-options.xml";
    public static final String THUMBNAIL_FILE = "thumbnail.png";
    private static final List<String> versionList = CollectionUtils.makeUnmodifiableList("version");

    public FreeColSavegameFile(File file) throws IOException {
        super(file);
    }

    public List<String> peekAttributes(List<String> attributes) throws IOException, XMLStreamException {
        FreeColXMLReader xr = this.getSavedGameFreeColXMLReader();
        xr.nextTag();
        List<String> ret = CollectionUtils.transform(attributes, CollectionUtils.alwaysTrue(), a -> xr.getAttribute((String)a, null));
        xr.close();
        return ret;
    }

    public Properties getProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(this.getInputStream(SAVEGAME_PROPERTIES));
        return properties;
    }

    public int getSavegameVersion() throws IOException, XMLStreamException {
        List<String> v = this.peekAttributes(versionList);
        int ret = -1;
        if (v != null && v.size() == 1) {
            try {
                ret = Integer.parseInt(v.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public BufferedInputStream getSavegameInputStream() throws IOException {
        return this.getInputStream(SAVEGAME_FILE);
    }

    public BufferedInputStream getThumbnailInputStream() throws IOException {
        return this.getInputStream(THUMBNAIL_FILE);
    }

    public FreeColXMLReader getClientOptionsFreeColXMLReader() throws IOException, XMLStreamException {
        return new FreeColXMLReader(this.getInputStream(CLIENT_OPTIONS));
    }

    public FreeColXMLReader getSavedGameFreeColXMLReader() throws IOException, XMLStreamException {
        return new FreeColXMLReader(this.getInputStream(SAVEGAME_FILE));
    }
}

