/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.tooltip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.label.ProductionLabel;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;

public class RebelToolTip
extends JToolTip {
    public RebelToolTip(FreeColClient freeColClient, Colony colony) {
        int grow;
        Specification spec = colony.getSpecification();
        List<GoodsType> libertyGoods = spec.getLibertyGoodsTypeList();
        int population = colony.getUnitCount();
        int solPercent = colony.getSoL();
        int rebels = Colony.calculateRebels(population, solPercent);
        Turn turn = colony.getGame().getTurn();
        this.setLayout(new BorderLayout());
        MigPanel content = new MigPanel(new MigLayout("fill, wrap 3", "[300px][50px, right][50px, right]", ""));
        content.add(Utility.localizedLabel(StringTemplate.template("rebelToolTip.rebelLabel").addName("%number%", "")));
        content.add(new JLabel(Integer.toString(rebels)));
        content.add(new JLabel(solPercent + "%"));
        content.add(Utility.localizedLabel(StringTemplate.template("rebelToolTip.royalistLabel").addName("%number%", "")));
        content.add(new JLabel(Integer.toString(population - rebels)));
        content.add(new JLabel(colony.getTory() + "%"));
        int libertyProduction = 0;
        for (GoodsType goodsType : libertyGoods) {
            content.add(new JLabel(Messages.getName(goodsType)));
            int production = colony.getNetProductionOf(goodsType);
            libertyProduction += production;
            content.add((Component)new ProductionLabel(freeColClient, new AbstractGoods(goodsType, production)), "span 2");
        }
        libertyProduction = (int)FeatureContainer.applyModifiers((float)libertyProduction, turn, colony.getOwner().getModifiers("model.modifier.liberty"));
        CollectionUtils.forEach(colony.getOwner().getModifiers("model.modifier.liberty"), m -> {
            for (JLabel j : ModifierFormat.getModifierLabels(m, null, turn)) {
                content.add(j);
            }
        });
        boolean capped = spec.getBoolean("model.option.bellAccumulationCapped") && colony.getSoL() >= 100;
        int liberty = colony.getLiberty();
        int modulo = liberty % 200;
        FreeColProgressBar progress = new FreeColProgressBar(freeColClient, libertyGoods.get(0), 0, 200, modulo, capped ? 0 : libertyProduction);
        content.add((Component)progress, "span 3, alignx center, height 20:");
        double turnsNext = -1.0;
        double turns100 = -1.0;
        double turns50 = -1.0;
        if (libertyProduction > 0 && !capped) {
            int requiredLiberty = 200 - modulo;
            turnsNext = (double)(1 + requiredLiberty) / (double)libertyProduction;
            requiredLiberty = 200 * colony.getUnitCount();
            if (liberty < requiredLiberty) {
                turns100 = (double)(1 + requiredLiberty - liberty) / (double)libertyProduction;
            }
            if (liberty < (requiredLiberty /= 2)) {
                turns50 = (double)(1 + requiredLiberty - liberty) / (double)libertyProduction;
            }
        }
        String na = Messages.message("notApplicable");
        content.add(Utility.localizedLabel("rebelToolTip.nextMember"));
        content.add((Component)new JLabel(turnsNext < 0.0 ? na : String.valueOf((int)Math.ceil(turnsNext))), "skip");
        if (turns50 > 0.0) {
            content.add(Utility.localizedLabel("rebelToolTip.50percent"));
            content.add((Component)new JLabel(String.valueOf((int)Math.ceil(turns50))), "skip");
        }
        if (turns100 > 0.0) {
            content.add(Utility.localizedLabel("rebelToolTip.100percent"));
            content.add((Component)new JLabel(String.valueOf((int)Math.ceil(turns100))), "skip");
        }
        if ((grow = colony.getPreferredSizeChange()) >= 10) {
            content.add(Utility.localizedLabel("rebelToolTip.changeMore"));
            content.add((Component)Utility.localizedLabel("many"), "skip");
        } else if (grow >= 0) {
            content.add(Utility.localizedLabel("rebelToolTip.changeMore"));
            content.add((Component)new JLabel(String.valueOf(grow)), "skip");
        } else {
            content.add(Utility.localizedLabel("rebelToolTip.changeLess"));
            content.add((Component)new JLabel(String.valueOf(-grow)), "skip");
        }
        this.setPreferredSize(content.getPreferredSize());
        this.add((Component)content, "Center");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.setLayout(null);
    }
}

