/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ServerListTableModel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.util.CollectionUtils;

public final class ServerListPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(ServerListPanel.class.getName());
    private final ConnectController connectController;
    private final JTable table;
    private final ServerListTableModel tableModel;
    private final JButton connect;

    public ServerListPanel(FreeColClient freeColClient, ConnectController connectController) {
        super(freeColClient, null, new MigLayout("", "", ""));
        this.connectController = connectController;
        FreeColButton cancel = Utility.localizedButton("cancel");
        this.setCancelComponent(cancel);
        this.connect = Utility.localizedButton("connect");
        this.tableModel = new ServerListTableModel(new ArrayList<ServerInfo>());
        this.table = new JTable(this.tableModel);
        ServerListTableCellRenderer dtcr = new ServerListTableCellRenderer();
        for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(dtcr);
        }
        this.table.setRowHeight(22);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane tableScroll = new JScrollPane(this.table);
        this.table.addNotify();
        tableScroll.getViewport().setOpaque(false);
        tableScroll.getColumnHeader().setOpaque(false);
        this.connect.addActionListener(ae -> {
            ServerInfo si = this.tableModel.getItem(this.table.getSelectedRow());
            connectController.joinMultiplayerGame(si.getAddress(), si.getPort());
        });
        cancel.addActionListener(ae -> {
            this.getGUI().removeComponent(this);
            this.getGUI().showNewPanel();
        });
        this.add((Component)tableScroll, "width 400:, height 350:");
        this.add((Component)this.connect, "newline 20, split 2");
        this.add((Component)cancel, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.connect.requestFocus();
    }

    public void initialize(List<ServerInfo> servers) {
        CollectionUtils.removeInPlace(servers, si -> !si.getVersion().equals(FreeCol.getVersion()));
        this.tableModel.setItems(servers);
        this.setEnabled(true);
        if (servers.isEmpty()) {
            this.connect.setEnabled(false);
        } else {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        super.setEnabled(enabled);
        for (Component component : components = this.getComponents()) {
            component.setEnabled(enabled);
        }
        this.table.setEnabled(enabled);
    }

    public void refreshTable() {
        this.tableModel.fireTableDataChanged();
    }

    private static class ServerListTableCellRenderer
    extends DefaultTableCellRenderer {
        private ServerListTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(isSelected);
            return super.getTableCellRendererComponent(t, o, isSelected, hasFocus, row, column);
        }
    }
}

