/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Color;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.Utils;

public final class PreGameController
extends FreeColClientHolder {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());

    public PreGameController(FreeColClient freeColClient) {
        super(freeColClient);
    }

    public void addPlayerHandler(List<Player> players) {
        this.getGame().addPlayers(players);
        this.getFreeColClient().getGUI().refreshPlayersTable();
    }

    public void sendChat(String message) {
        Player player = this.getMyPlayer();
        this.askServer().chat(player, message);
    }

    public void chatHandler(String sender, String message, Color color, boolean pri) {
        this.getGUI().displayStartChat(sender, message, pri);
    }

    public void errorHandler(StringTemplate template, String message) {
        this.getGUI().showErrorPanel(template, message);
    }

    public void logoutHandler(Player player, Game.LogoutReason reason) {
        FreeColClient freeColClient = this.getFreeColClient();
        this.getGame().removePlayer(player);
        this.getGUI().refreshPlayersTable();
        if (player == this.getMyPlayer()) {
            freeColClient.getConnectController().logout(reason);
        }
    }

    public void readyHandler(Player player, boolean ready) {
        player.setReady(ready);
        this.getGUI().refreshPlayersTable();
    }

    public void requestLaunch() {
        if (this.getGame().allPlayersReadyToLaunch()) {
            this.getGUI().showStatusPanel(Messages.message("status.startingGame"));
            this.askServer().requestLaunch();
        } else {
            this.getGUI().showErrorPanel(StringTemplate.template("server.notAllReady"));
        }
    }

    public void setAvailable(Nation nation, NationOptions.NationState state) {
        this.getGame().getNationOptions().getNations().put(nation, state);
        this.askServer().setAvailable(nation, state);
    }

    public void setAvailableHandler(Nation nation, NationOptions.NationState nationState) {
        this.getGame().getNationOptions().setNationState(nation, nationState);
    }

    public void setColor(Nation nation, Color color) {
        nation.setColor(color);
        this.askServer().setColor(nation, color);
    }

    public void setColorHandler(Nation nation, Color color) {
        nation.setColor(color);
    }

    public void setNation(Nation nation) {
        this.getMyPlayer().setNation(nation);
        this.askServer().setNation(nation);
    }

    public void setNationType(NationType nationType) {
        this.getMyPlayer().changeNationType(nationType);
        this.askServer().setNationType(nationType);
    }

    public void setNationTypeHandler(NationType nationType) {
        this.getMyPlayer().changeNationType(nationType);
    }

    public void setReady(boolean ready) {
        this.getMyPlayer().setReady(ready);
        this.askServer().setReady(ready);
    }

    public void startGameHandler() {
        final FreeColClient fcc = this.getFreeColClient();
        final GUI gui = this.getGUI();
        new Thread("FreeColClient:Starting game"){

            @Override
            public void run() {
                logger.info("Client starting game");
                for (int tries = 50; tries >= 0; --tries) {
                    if (fcc.isReadyToStart()) {
                        SwingUtilities.invokeLater(() -> PreGameController.this.startGameInternal());
                        return;
                    }
                    Utils.delay(200L, "StartGame has been interupted.");
                }
                String err = PreGameController.this.getGame() == null ? "client.noGame" : "client.noMap";
                gui.closeMainPanel();
                gui.closeMenus();
                gui.closeStatusPanel();
                gui.showMainPanel(Messages.message(StringTemplate.template(err)));
            }
        }.start();
    }

    private boolean startGameInternal() {
        String logMe;
        FreeColClient fcc = this.getFreeColClient();
        Player player = this.getMyPlayer();
        GUI gui = this.getGUI();
        gui.closeMainPanel();
        gui.closeMenus();
        gui.closeStatusPanel();
        gui.playSound(null);
        gui.playSound("sound.intro." + player.getNationId());
        fcc.changeClientState(true);
        fcc.restoreGUI(player);
        ClientOptions co = this.getClientOptions();
        if (player.isAdmin() && co.getBoolean("model.option.autosaveDelete") && (logMe = FreeColDirectories.removeAutosaves(co.getText("model.option.autoSavePrefix"))) != null) {
            logger.info(logMe);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && FreeColDebugger.getDebugRunTurns() > 0) {
            fcc.skipTurns(FreeColDebugger.getDebugRunTurns());
            return false;
        }
        if (this.getGame().getTurn().getNumber() == 1) {
            player.addStartGameMessage();
        }
        this.igc().nextModelMessage();
        return true;
    }

    public void updateHandler(List<FreeColObject> objects) {
        Game game = this.getGame();
        for (FreeColObject fco : objects) {
            if (fco instanceof Game) {
                if (game.preGameUpdate((Game)fco)) {
                    FreeColClient fcc = this.getFreeColClient();
                    fcc.addSpecificationActions(((Game)fco).getSpecification());
                    continue;
                }
                logger.warning("Pre-game copy-in failed: " + fco.getId());
                continue;
            }
            logger.warning("Game node expected: " + fco.getId());
        }
    }

    public void updateGameOptions() {
        OptionGroup gameOptions = this.getGame().getGameOptions();
        this.getSpecification().clean("update game options (client initiated)");
        this.askServer().updateGameOptions(gameOptions);
    }

    public void updateGameOptionsHandler(OptionGroup gameOptions) {
        if (!this.getSpecification().mergeGameOptions(gameOptions, "client")) {
            logger.warning("Game option update failed");
        }
    }

    public void updateMapGeneratorOptions() {
        OptionGroup mgo = this.getGame().getMapGeneratorOptions();
        this.askServer().updateMapGeneratorOptions(mgo);
    }

    public void updateMapGeneratorOptionsHandler(OptionGroup mapOptions) {
        if (!this.getSpecification().mergeMapGeneratorOptions(mapOptions, "client")) {
            logger.warning("Map generator option update failed");
        }
    }
}

