/// <reference types="node" />
import { OAuth2Client, JWT, UserRefreshClient, BaseExternalAccountClient, GaxiosPromise, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace compute_alpha {
    export interface Options extends GlobalOptions {
        version: 'alpha';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * Data format for the response.
         */
        alt?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * An opaque string that represents a user for quota purposes. Must not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Deprecated. Please use quotaUser instead.
         */
        userIp?: string;
    }
    /**
     * Compute Engine API
     *
     * Creates and runs virtual machines on Google Cloud Platform.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const compute = google.compute('alpha');
     * ```
     */
    export class Compute {
        context: APIRequestContext;
        acceleratorTypes: Resource$Acceleratortypes;
        addresses: Resource$Addresses;
        autoscalers: Resource$Autoscalers;
        backendBuckets: Resource$Backendbuckets;
        backendServices: Resource$Backendservices;
        disks: Resource$Disks;
        diskTypes: Resource$Disktypes;
        externalVpnGateways: Resource$Externalvpngateways;
        firewallPolicies: Resource$Firewallpolicies;
        firewalls: Resource$Firewalls;
        forwardingRules: Resource$Forwardingrules;
        globalAddresses: Resource$Globaladdresses;
        globalForwardingRules: Resource$Globalforwardingrules;
        globalNetworkEndpointGroups: Resource$Globalnetworkendpointgroups;
        globalOperations: Resource$Globaloperations;
        globalOrganizationOperations: Resource$Globalorganizationoperations;
        globalPublicDelegatedPrefixes: Resource$Globalpublicdelegatedprefixes;
        healthChecks: Resource$Healthchecks;
        httpHealthChecks: Resource$Httphealthchecks;
        httpsHealthChecks: Resource$Httpshealthchecks;
        imageFamilyViews: Resource$Imagefamilyviews;
        images: Resource$Images;
        instanceGroupManagers: Resource$Instancegroupmanagers;
        instanceGroups: Resource$Instancegroups;
        instances: Resource$Instances;
        instanceTemplates: Resource$Instancetemplates;
        interconnectAttachments: Resource$Interconnectattachments;
        interconnectLocations: Resource$Interconnectlocations;
        interconnects: Resource$Interconnects;
        licenseCodes: Resource$Licensecodes;
        licenses: Resource$Licenses;
        machineImages: Resource$Machineimages;
        machineTypes: Resource$Machinetypes;
        networkEndpointGroups: Resource$Networkendpointgroups;
        networkFirewallPolicies: Resource$Networkfirewallpolicies;
        networks: Resource$Networks;
        nodeGroups: Resource$Nodegroups;
        nodeTemplates: Resource$Nodetemplates;
        nodeTypes: Resource$Nodetypes;
        organizationSecurityPolicies: Resource$Organizationsecuritypolicies;
        packetMirrorings: Resource$Packetmirrorings;
        projects: Resource$Projects;
        publicAdvertisedPrefixes: Resource$Publicadvertisedprefixes;
        publicDelegatedPrefixes: Resource$Publicdelegatedprefixes;
        regionAutoscalers: Resource$Regionautoscalers;
        regionBackendServices: Resource$Regionbackendservices;
        regionCommitments: Resource$Regioncommitments;
        regionDisks: Resource$Regiondisks;
        regionDiskTypes: Resource$Regiondisktypes;
        regionHealthChecks: Resource$Regionhealthchecks;
        regionHealthCheckServices: Resource$Regionhealthcheckservices;
        regionInPlaceSnapshots: Resource$Regioninplacesnapshots;
        regionInstanceGroupManagers: Resource$Regioninstancegroupmanagers;
        regionInstanceGroups: Resource$Regioninstancegroups;
        regionInstances: Resource$Regioninstances;
        regionInstantSnapshots: Resource$Regioninstantsnapshots;
        regionNetworkEndpointGroups: Resource$Regionnetworkendpointgroups;
        regionNetworkFirewallPolicies: Resource$Regionnetworkfirewallpolicies;
        regionNotificationEndpoints: Resource$Regionnotificationendpoints;
        regionOperations: Resource$Regionoperations;
        regions: Resource$Regions;
        regionSslCertificates: Resource$Regionsslcertificates;
        regionTargetHttpProxies: Resource$Regiontargethttpproxies;
        regionTargetHttpsProxies: Resource$Regiontargethttpsproxies;
        regionUrlMaps: Resource$Regionurlmaps;
        reservations: Resource$Reservations;
        resourcePolicies: Resource$Resourcepolicies;
        routers: Resource$Routers;
        routes: Resource$Routes;
        securityPolicies: Resource$Securitypolicies;
        serviceAttachments: Resource$Serviceattachments;
        snapshots: Resource$Snapshots;
        sslCertificates: Resource$Sslcertificates;
        sslPolicies: Resource$Sslpolicies;
        subnetworks: Resource$Subnetworks;
        targetGrpcProxies: Resource$Targetgrpcproxies;
        targetHttpProxies: Resource$Targethttpproxies;
        targetHttpsProxies: Resource$Targethttpsproxies;
        targetInstances: Resource$Targetinstances;
        targetPools: Resource$Targetpools;
        targetSslProxies: Resource$Targetsslproxies;
        targetTcpProxies: Resource$Targettcpproxies;
        targetVpnGateways: Resource$Targetvpngateways;
        urlMaps: Resource$Urlmaps;
        vpnGateways: Resource$Vpngateways;
        vpnTunnels: Resource$Vpntunnels;
        zoneInPlaceSnapshots: Resource$Zoneinplacesnapshots;
        zoneInstantSnapshots: Resource$Zoneinstantsnapshots;
        zoneOperations: Resource$Zoneoperations;
        zones: Resource$Zones;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * A specification of the type and number of accelerator cards attached to the instance.
     */
    export interface Schema$AcceleratorConfig {
        /**
         * The number of the guest accelerator cards exposed to this instance.
         */
        acceleratorCount?: number | null;
        /**
         * Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
         */
        acceleratorType?: string | null;
    }
    /**
     * Represents an Accelerator Type resource.
     *
     * Google Cloud Platform provides graphics processing units (accelerators) that you can add to VM instances to improve or accelerate performance when working with intensive workloads. For more information, read GPUs on Compute Engine. (== resource_for {$api_version\}.acceleratorTypes ==)
     */
    export interface Schema$AcceleratorType {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this accelerator type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.
         */
        kind?: string | null;
        /**
         * [Output Only] Maximum number of accelerator cards allowed per instance.
         */
        maximumCardsPerInstance?: number | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined, fully qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$AcceleratorTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AcceleratorTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$AcceleratorTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of accelerator types.
     */
    export interface Schema$AcceleratorTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AcceleratorType resources.
         */
        items?: Schema$AcceleratorType[];
        /**
         * [Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AcceleratorTypesScopedList {
        /**
         * [Output Only] A list of accelerator types contained in this scope.
         */
        acceleratorTypes?: Schema$AcceleratorType[];
        /**
         * [Output Only] An informational warning that appears when the accelerator types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * An access configuration attached to an instance's network interface. Only one access config per instance is supported.
     */
    export interface Schema$AccessConfig {
        /**
         * [Output Only] The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. The field is output only, an IPv6 address from a subnetwork associated with the instance will be allocated dynamically.
         */
        externalIpv6?: string | null;
        /**
         * [Output Only] The prefix length of the external IPv6 range.
         */
        externalIpv6PrefixLength?: number | null;
        /**
         * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
         */
        kind?: string | null;
        /**
         * The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
         */
        name?: string | null;
        /**
         * An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
         */
        natIP?: string | null;
        /**
         * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD.
         *
         * If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier.
         *
         * If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
         */
        networkTier?: string | null;
        /**
         * [Output Only] The public DNS domain name for the instance.
         */
        publicDnsName?: string | null;
        /**
         * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled.
         */
        publicPtrDomainName?: string | null;
        /**
         * Specifies whether a public DNS 'A' record should be created for the external IP address of this access configuration.
         */
        setPublicDns?: boolean | null;
        /**
         * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name.
         */
        setPublicPtr?: boolean | null;
        /**
         * The type of configuration. The default and only option is ONE_TO_ONE_NAT.
         */
        type?: string | null;
    }
    /**
     * Use global external addresses for GFE-based external HTTP(S) load balancers in Premium Tier.
     *
     * Use global internal addresses for reserved peering network range.
     *
     * Use regional external addresses for the following resources:
     *
     * - External IP addresses for VM instances - Regional external forwarding rules - Cloud NAT external IP addresses - GFE based LBs in Standard Tier - Network LBs in Premium or Standard Tier - Cloud VPN gateways (both Classic and HA)
     *
     * Use regional internal IP addresses for subnet IP ranges (primary and secondary). This includes:
     *
     * - Internal IP addresses for VM instances - Alias IP ranges of VM instances (/32 only) - Regional internal forwarding rules - Internal TCP/UDP load balancer addresses - Internal HTTP(S) load balancer addresses - Cloud DNS inbound forwarding IP addresses
     *
     * For more information, read reserved IP address.
     *
     * (== resource_for {$api_version\}.addresses ==) (== resource_for {$api_version\}.globalAddresses ==)
     */
    export interface Schema$Address {
        /**
         * The static IP address represented by this resource.
         */
        address?: string | null;
        /**
         * The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
         */
        addressType?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
         */
        ipVersion?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#address for addresses.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this Address, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an Address.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string | null;
        /**
         * The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.
         */
        network?: string | null;
        /**
         * This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Global forwarding rules can only be Premium Tier. Regional forwarding rules can be either Premium or Standard Tier. Standard Tier addresses applied to regional forwarding rules can be used with any external load balancer. Regional forwarding rules in Premium Tier can only be used with a network load balancer.
         *
         * If this field is not specified, it is assumed to be PREMIUM.
         */
        networkTier?: string | null;
        /**
         * The prefix length if the resource represents an IP range.
         */
        prefixLength?: number | null;
        /**
         * The purpose of this resource, which can be one of the following values:
         * - `GCE_ENDPOINT` for addresses that are used by VM instances, alias IP ranges, internal load balancers, and similar resources.
         * - `DNS_RESOLVER` for a DNS resolver address in a subnetwork
         * - `VPC_PEERING` for addresses that are reserved for VPC peer networks.
         * - `NAT_AUTO` for addresses that are external IP addresses automatically reserved for Cloud NAT.
         * - `IPSEC_INTERCONNECT` for addresses created from a private IP range that are reserved for a VLAN attachment in an IPsec-encrypted Cloud Interconnect configuration. These addresses are regional resources.
         */
        purpose?: string | null;
        /**
         * [Output Only] The URL of the region where a regional address resides. For regional addresses, you must specify the region as a path parameter in the HTTP request URL. This field is not applicable to global addresses.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
         */
        status?: string | null;
        /**
         * The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork's IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
         */
        subnetwork?: string | null;
        /**
         * [Output Only] The URLs of the resources that are using this address.
         */
        users?: string[] | null;
    }
    export interface Schema$AddressAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AddressesScopedList resources.
         */
        items?: {
            [key: string]: Schema$AddressesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AddressesScopedList {
        /**
         * [Output Only] A list of addresses contained in this scope.
         */
        addresses?: Schema$Address[];
        /**
         * [Output Only] Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of addresses.
     */
    export interface Schema$AddressList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Address resources.
         */
        items?: Schema$Address[];
        /**
         * [Output Only] Type of resource. Always compute#addressList for lists of addresses.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
     */
    export interface Schema$AdvancedMachineFeatures {
        /**
         * Whether to enable nested virtualization or not (default is false).
         */
        enableNestedVirtualization?: boolean | null;
        /**
         * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
         */
        threadsPerCore?: number | null;
        /**
         * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
         */
        visibleCoreCount?: number | null;
    }
    /**
     * An alias IP range attached to an instance's network interface.
     */
    export interface Schema$AliasIpRange {
        /**
         * The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
         */
        ipCidrRange?: string | null;
        /**
         * The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
         */
        subnetworkRangeName?: string | null;
    }
    export interface Schema$AllocationShareSettings {
        /**
         * A List of Project names to specify consumer projects for this shared-reservation. This is only valid when share_type's value is SPECIFIC_PROJECTS.
         */
        projects?: string[] | null;
        /**
         * Type of sharing for this shared-reservation
         */
        shareType?: string | null;
    }
    export interface Schema$AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk {
        /**
         * Specifies the size of the disk in base-2 GB.
         */
        diskSizeGb?: string | null;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
         */
        interface?: string | null;
    }
    /**
     * Properties of the SKU instances being reserved. Next ID: 9
     */
    export interface Schema$AllocationSpecificSKUAllocationReservedInstanceProperties {
        /**
         * Specifies accelerator type and count.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
         */
        localSsds?: Schema$AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk[];
        /**
         * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
         */
        locationHint?: string | null;
        /**
         * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
         */
        machineType?: string | null;
        /**
         * Specifies the number of hours after reservation creation where instances using the reservation won't be scheduled for maintenance.
         */
        maintenanceFreezeDurationHours?: number | null;
        /**
         * Specifies whether this VM may be a stable fleet VM. Setting this to "Periodic" designates this VM as a Stable Fleet VM.
         *
         * See go/stable-fleet-ug for more details.
         */
        maintenanceInterval?: string | null;
        /**
         * Minimum cpu platform the reservation.
         */
        minCpuPlatform?: string | null;
    }
    /**
     * This reservation type allows to pre allocate specific instance configuration.
     */
    export interface Schema$AllocationSpecificSKUReservation {
        /**
         * Specifies the number of resources that are allocated.
         */
        count?: string | null;
        /**
         * The instance properties for the reservation.
         */
        instanceProperties?: Schema$AllocationSpecificSKUAllocationReservedInstanceProperties;
        /**
         * [Output Only] Indicates how many instances are in use.
         */
        inUseCount?: string | null;
    }
    /**
     * `Any` contains an arbitrary serialized protocol buffer message along with a URL that describes the type of the serialized message.
     *
     * Protobuf library provides support to pack/unpack Any values in the form of utility functions or additional generated methods of the Any type.
     *
     * Example 1: Pack and unpack a message in C++.
     *
     * Foo foo = ...; Any any; any.PackFrom(foo); ... if (any.UnpackTo(&foo)) { ... \}
     *
     * Example 2: Pack and unpack a message in Java.
     *
     * Foo foo = ...; Any any = Any.pack(foo); ... if (any.is(Foo.class)) { foo = any.unpack(Foo.class); \}
     *
     * Example 3: Pack and unpack a message in Python.
     *
     * foo = Foo(...) any = Any() any.Pack(foo) ... if any.Is(Foo.DESCRIPTOR): any.Unpack(foo) ...
     *
     * Example 4: Pack and unpack a message in Go
     *
     * foo := &pb.Foo{...\} any, err := anypb.New(foo) if err != nil { ... \} ... foo := &pb.Foo{\} if err := any.UnmarshalTo(foo); err != nil { ... \}
     *
     * The pack methods provided by protobuf library will by default use 'type.googleapis.com/full.type.name' as the type URL and the unpack methods only use the fully qualified type name after the last '/' in the type URL, for example "foo.bar.com/x/y.z" will yield type name "y.z".
     *
     *
     *
     * JSON ==== The JSON representation of an `Any` value uses the regular representation of the deserialized, embedded message, with an additional field `@type` which contains the type URL. Example:
     *
     * package google.profile; message Person { string first_name = 1; string last_name = 2; \}
     *
     * { "@type": "type.googleapis.com/google.profile.Person", "firstName": , "lastName":  \}
     *
     * If the embedded message type is well-known and has a custom JSON representation, that representation will be embedded adding a field `value` which holds the custom JSON in addition to the `@type` field. Example (for message [google.protobuf.Duration][]):
     *
     * { "@type": "type.googleapis.com/google.protobuf.Duration", "value": "1.212s" \}
     */
    export interface Schema$Any {
        /**
         * A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. This string must contain at least one "/" character. The last segment of the URL's path must represent the fully qualified name of the type (as in `path/google.protobuf.Duration`). The name should be in a canonical form (e.g., leading "." is not accepted).
         *
         * In practice, teams usually precompile into the binary all types that they expect it to use in the context of Any. However, for URLs which use the scheme `http`, `https`, or no scheme, one can optionally set up a type server that maps type URLs to message definitions as follows:
         *
         * * If no scheme is provided, `https` is assumed. * An HTTP GET on the URL must yield a [google.protobuf.Type][] value in binary format, or produce an error. * Applications are allowed to cache lookup results based on the URL, or have them precompiled into a binary to avoid any lookup. Therefore, binary compatibility needs to be preserved on changes to types. (Use versioned type names to manage breaking changes.)
         *
         * Note: this functionality is not currently available in the official protobuf release, and it is not used for type URLs beginning with type.googleapis.com.
         *
         * Schemes other than `http`, `https` (or the empty scheme) might be used with implementation specific semantics.
         */
        typeUrl?: string | null;
        /**
         * Must be a valid serialized protocol buffer of the above specified type.
         */
        value?: string | null;
    }
    /**
     * An instance-attached disk resource.
     */
    export interface Schema$AttachedDisk {
        /**
         * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
         */
        autoDelete?: boolean | null;
        /**
         * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
         */
        boot?: boolean | null;
        /**
         * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance.
         *
         * If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
         */
        deviceName?: string | null;
        /**
         * Encrypts or decrypts a disk using a customer-supplied encryption key.
         *
         * If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key.
         *
         * If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance.
         *
         * If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
         *
         * Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The size of the disk in GB.
         */
        diskSizeGb?: string | null;
        /**
         * [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
         */
        forceAttach?: boolean | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
         */
        index?: number | null;
        /**
         * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
         *
         * This property is mutually exclusive with the source property; you can only define one or the other, but not both.
         */
        initializeParams?: Schema$AttachedDiskInitializeParams;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
         */
        interface?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
         */
        kind?: string | null;
        /**
         * [Output Only] Any valid publicly visible licenses.
         */
        licenses?: string[] | null;
        /**
         * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
         */
        mode?: string | null;
        /**
         * For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
         */
        savedState?: string | null;
        /**
         * [Output Only] shielded vm initial state stored on disk
         */
        shieldedInstanceInitialState?: Schema$InitialStateConfig;
        /**
         * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
         *
         * If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks.
         *
         * Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
         */
        source?: string | null;
        /**
         * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
         */
        type?: string | null;
        /**
         * [Output Only] A list of user provided licenses. It represents a list of URLs to the license resource. Unlike regular licenses, user provided licenses can be modified after the disk is created.
         */
        userLicenses?: string[] | null;
    }
    /**
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
     *
     * This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     */
    export interface Schema$AttachedDiskInitializeParams {
        /**
         * An optional description. Provide this property when creating the disk.
         */
        description?: string | null;
        /**
         * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
         */
        diskName?: string | null;
        /**
         * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
         */
        diskSizeGb?: string | null;
        /**
         * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example:
         * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
         *
         *
         * Other values include pd-ssd and local-ssd. If you define this field, you can provide either the full or partial URL. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
         * - projects/project/zones/zone/diskTypes/diskType
         * - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the name of the disk type, not URL.
         */
        diskType?: string | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         *
         * Guest OS features are applied by merging initializeParams.guestOsFeatures and disks.guestOsFeatures
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Indicates whether or not the disk can be read/write attached to more than one instance.
         */
        multiWriter?: boolean | null;
        /**
         * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
         */
        onUpdateAction?: string | null;
        /**
         * Indicates how many IOPS must be provisioned for the disk.
         */
        provisionedIops?: string | null;
        /**
         * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
         */
        replicaZones?: string[] | null;
        /**
         * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
         */
        resourcePolicies?: string[] | null;
        /**
         * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
         *
         * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
         * projects/debian-cloud/global/images/family/debian-9
         *
         *
         * Alternatively, use a specific version of a public operating system image:
         * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
         *
         *
         * To create a disk with a custom image that you created, specify the image name in the following format:
         * global/images/my-custom-image
         *
         *
         * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
         * global/images/family/my-image-family
         *
         *
         * If the source image is deleted later, this field will not be set.
         */
        sourceImage?: string | null;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
         *
         * Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD.
         *
         * To create a disk with a snapshot that you created, specify the snapshot name in the following format:
         * global/snapshots/my-backup
         *
         *
         * If the source snapshot is deleted later, this field will not be set.
         */
        sourceSnapshot?: string | null;
        /**
         * The customer-supplied encryption key of the source snapshot.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
    }
    /**
     * Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.
     *
     * If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.
     *
     * Example Policy with multiple AuditConfigs:
     *
     * { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] \}, { "log_type": "DATA_WRITE" \}, { "log_type": "ADMIN_READ" \} ] \}, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" \}, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] \} ] \} ] \}
     *
     * For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
     */
    export interface Schema$AuditConfig {
        /**
         * The configuration for logging of each type of permission.
         */
        auditLogConfigs?: Schema$AuditLogConfig[];
        exemptedMembers?: string[] | null;
        /**
         * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
         */
        service?: string | null;
    }
    /**
     * Provides the configuration for logging a type of permissions. Example:
     *
     * { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] \}, { "log_type": "DATA_WRITE" \} ] \}
     *
     * This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
     */
    export interface Schema$AuditLogConfig {
        /**
         * Specifies the identities that do not cause logging for this type of permission. Follows the same format of [Binding.members][].
         */
        exemptedMembers?: string[] | null;
        ignoreChildExemptions?: boolean | null;
        /**
         * The log type that this config enables.
         */
        logType?: string | null;
    }
    /**
     * [Deprecated] The authentication settings for the backend service. The authentication settings for the backend service.
     */
    export interface Schema$AuthenticationPolicy {
        /**
         * List of authentication methods that can be used for origin authentication. Similar to peers, these will be evaluated in order the first valid one will be used to set origin identity. If none of these methods pass, the request will be rejected with authentication failed error (401). Leave the list empty if origin authentication is not required.
         */
        origins?: Schema$OriginAuthenticationMethod[];
        /**
         * List of authentication methods that can be used for peer authentication. They will be evaluated in order the first valid one will be used to set peer identity. If none of these methods pass, the request will be rejected with authentication failed error (401). Leave the list empty if peer authentication is not required.
         */
        peers?: Schema$PeerAuthenticationMethod[];
        /**
         * Define whether peer or origin identity should be used for principal. Default value is USE_PEER. If peer (or origin) identity is not available, either because peer/origin authentication is not defined, or failed, principal will be left unset. In other words, binding rule does not affect the decision to accept or reject request. This field can be set to one of the following: USE_PEER: Principal will be set to the identity from peer authentication. USE_ORIGIN: Principal will be set to the identity from origin authentication.
         */
        principalBinding?: string | null;
        /**
         * Configures the mechanism to obtain server-side security certificates and identity information.
         */
        serverTlsContext?: Schema$TlsContext;
    }
    /**
     * [Deprecated] Authorization configuration provides service-level and method-level access control for a service. control for a service.
     */
    export interface Schema$AuthorizationConfig {
        /**
         * List of RbacPolicies.
         */
        policies?: Schema$RbacPolicy[];
    }
    /**
     * Authorization-related information used by Cloud Audit Logging.
     */
    export interface Schema$AuthorizationLoggingOptions {
        /**
         * The type of the permission that was checked.
         */
        permissionType?: string | null;
    }
    /**
     * Represents an Autoscaler resource.
     *
     * Google Compute Engine has two Autoscaler resources:
     *
     * * [Zonal](/compute/docs/reference/rest/{$api_version\}/autoscalers) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionAutoscalers)
     *
     * Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances.
     *
     * For zonal managed instance groups resource, use the autoscaler resource.
     *
     * For regional managed instance groups, use the regionAutoscalers resource. (== resource_for {$api_version\}.autoscalers ==) (== resource_for {$api_version\}.regionAutoscalers ==)
     */
    export interface Schema$Autoscaler {
        /**
         * The configuration parameters for the autoscaling algorithm. You can define one or more of the policies for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization.
         *
         * If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
         */
        autoscalingPolicy?: Schema$AutoscalingPolicy;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
         */
        recommendedSize?: number | null;
        /**
         * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
         */
        region?: string | null;
        /**
         * [Output Only] Status information of existing scaling schedules.
         */
        scalingScheduleStatus?: {
            [key: string]: Schema$ScalingScheduleStatus;
        } | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of the autoscaler configuration. Current set of possible values:
         * - PENDING: Autoscaler backend hasn't read new/updated configuration.
         * - DELETING: Configuration is being deleted.
         * - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field.
         * - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field.  New values might be added in the future.
         */
        status?: string | null;
        /**
         * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
         */
        statusDetails?: Schema$AutoscalerStatusDetails[];
        /**
         * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
         */
        target?: string | null;
        /**
         * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
         */
        zone?: string | null;
    }
    export interface Schema$AutoscalerAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of AutoscalersScopedList resources.
         */
        items?: {
            [key: string]: Schema$AutoscalersScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#autoscalerAggregatedList for aggregated lists of autoscalers.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of Autoscaler resources.
     */
    export interface Schema$AutoscalerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Autoscaler resources.
         */
        items?: Schema$Autoscaler[];
        /**
         * [Output Only] Type of resource. Always compute#autoscalerList for lists of autoscalers.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AutoscalersScopedList {
        /**
         * [Output Only] A list of autoscalers contained in this scope.
         */
        autoscalers?: Schema$Autoscaler[];
        /**
         * [Output Only] Informational warning which replaces the list of autoscalers when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$AutoscalerStatusDetails {
        /**
         * The status message.
         */
        message?: string | null;
        /**
         * The type of error, warning, or notice returned. Current set of possible values:
         * - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state).
         * - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group.
         * - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas.
         * - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling.
         * - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels.
         * - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group.
         * - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling.
         * - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer.
         * - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved.
         * - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any.
         * - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it.
         * - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances.
         * - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region.
         * - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist.
         * - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate.
         * - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout.  New values might be added in the future. Some of the values might not be available in all API versions.
         */
        type?: string | null;
    }
    /**
     * Cloud Autoscaler policy.
     */
    export interface Schema$AutoscalingPolicy {
        /**
         * The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds.
         *
         * Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
         */
        coolDownPeriodSec?: number | null;
        /**
         * Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
         */
        cpuUtilization?: Schema$AutoscalingPolicyCpuUtilization;
        /**
         * Configuration parameters of autoscaling based on a custom metric.
         */
        customMetricUtilizations?: Schema$AutoscalingPolicyCustomMetricUtilization[];
        /**
         * Configuration parameters of autoscaling based on load balancer.
         */
        loadBalancingUtilization?: Schema$AutoscalingPolicyLoadBalancingUtilization;
        /**
         * The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
         */
        maxNumReplicas?: number | null;
        /**
         * The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
         */
        minNumReplicas?: number | null;
        /**
         * Defines operating mode for this policy.
         */
        mode?: string | null;
        scaleDownControl?: Schema$AutoscalingPolicyScaleDownControl;
        scaleInControl?: Schema$AutoscalingPolicyScaleInControl;
        /**
         * Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
         */
        scalingSchedules?: {
            [key: string]: Schema$AutoscalingPolicyScalingSchedule;
        } | null;
    }
    /**
     * CPU utilization policy.
     */
    export interface Schema$AutoscalingPolicyCpuUtilization {
        /**
         * Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:
         *
         * * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
         */
        predictiveMethod?: string | null;
        /**
         * The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6.
         *
         * If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization.
         *
         * If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
         */
        utilizationTarget?: number | null;
    }
    /**
     * Custom utilization metric policy.
     */
    export interface Schema$AutoscalingPolicyCustomMetricUtilization {
        /**
         * A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data.
         *
         * For the filter to be valid for autoscaling purposes, the following rules apply:
         * - You can only use the AND operator for joining selectors.
         * - You can only use direct equality comparison operator (=) without any functions for each selector.
         * - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical.
         * - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels.
         * If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a per-group metric for the purpose of autoscaling.
         *
         * If not specified, the type defaults to gce_instance.
         *
         * Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
         */
        filter?: string | null;
        /**
         * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values.
         *
         * The metric must have a value type of INT64 or DOUBLE.
         */
        metric?: string | null;
        /**
         * If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing.
         *
         * A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances.
         *
         * A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
         */
        singleInstanceAssignment?: number | null;
        /**
         * The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric.
         *
         * For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
         */
        utilizationTarget?: number | null;
        /**
         * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
         */
        utilizationTargetType?: string | null;
    }
    /**
     * Configuration parameters of autoscaling based on load balancing.
     */
    export interface Schema$AutoscalingPolicyLoadBalancingUtilization {
        /**
         * Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
         */
        utilizationTarget?: number | null;
    }
    /**
     * Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
     */
    export interface Schema$AutoscalingPolicyScaleDownControl {
        /**
         * Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
         */
        maxScaledDownReplicas?: Schema$FixedOrPercent;
        /**
         * How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
         */
        timeWindowSec?: number | null;
    }
    /**
     * Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
     */
    export interface Schema$AutoscalingPolicyScaleInControl {
        /**
         * Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
         */
        maxScaledInReplicas?: Schema$FixedOrPercent;
        /**
         * How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
         */
        timeWindowSec?: number | null;
    }
    /**
     * Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
     */
    export interface Schema$AutoscalingPolicyScalingSchedule {
        /**
         * A description of a scaling schedule.
         */
        description?: string | null;
        /**
         * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
         */
        disabled?: boolean | null;
        /**
         * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
         */
        durationSec?: number | null;
        /**
         * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
         */
        minRequiredReplicas?: number | null;
        /**
         * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
         */
        schedule?: string | null;
        /**
         * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of ?UTC? if left empty.
         */
        timeZone?: string | null;
    }
    /**
     * Message containing information of one individual backend.
     */
    export interface Schema$Backend {
        /**
         * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see  Connection balancing mode.
         */
        balancingMode?: string | null;
        /**
         * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
         *
         * Not supported by:
         *
         * - Internal TCP/UDP Load Balancing - Network Load Balancing
         */
        capacityScaler?: number | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
         */
        failover?: boolean | null;
        /**
         * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type of backend that a backend service supports depends on the backend service's loadBalancingScheme.
         *
         *
         * - When the loadBalancingScheme for the backend service is EXTERNAL (except Network Load Balancing),  INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED , the backend can be either an instance group or a NEG. The backends on the backend service must be either all instance groups or all NEGs. You cannot mix instance group and NEG backends on the same backend service.
         *
         *
         * - When the loadBalancingScheme for the backend service is EXTERNAL for Network Load Balancing or INTERNAL for Internal TCP/UDP Load Balancing, the backend must be an instance group. NEGs are not supported.
         *
         * For regional services, the backend must be in the same region as the backend service.
         *
         * You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
         */
        group?: string | null;
        /**
         * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE. Not supported by:
         *
         * - Internal TCP/UDP Load Balancing - Network Load Balancing
         */
        maxConnections?: number | null;
        /**
         * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode.
         *
         * Not available if the backend's balancingMode is RATE. Not supported by:
         *
         * - Internal TCP/UDP Load Balancing - Network Load Balancing.
         */
        maxConnectionsPerEndpoint?: number | null;
        /**
         * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode.
         *
         * Not available if the backend's balancingMode is RATE. Not supported by:
         *
         * - Internal TCP/UDP Load Balancing - Network Load Balancing.
         */
        maxConnectionsPerInstance?: number | null;
        /**
         * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode.
         *
         * Not available if the backend's balancingMode is CONNECTION.
         */
        maxRate?: number | null;
        /**
         * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode.
         *
         * Not available if the backend's balancingMode is CONNECTION.
         */
        maxRatePerEndpoint?: number | null;
        /**
         * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode.
         *
         * Not available if the backend's balancingMode is CONNECTION.
         */
        maxRatePerInstance?: number | null;
        maxUtilization?: number | null;
    }
    /**
     * Represents a Cloud Storage Bucket resource.
     *
     * This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
     */
    export interface Schema$BackendBucket {
        /**
         * Cloud Storage bucket name.
         */
        bucketName?: string | null;
        /**
         * Cloud CDN configuration for this BackendBucket.
         */
        cdnPolicy?: Schema$BackendBucketCdnPolicy;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Headers that the HTTP/S load balancer should add to proxied responses.
         */
        customResponseHeaders?: string[] | null;
        /**
         * An optional textual description of the resource; provided by the client when the resource is created.
         */
        description?: string | null;
        /**
         * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
         */
        edgeSecurityPolicy?: string | null;
        /**
         * If true, enable Cloud CDN for this BackendBucket.
         */
        enableCdn?: boolean | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * Type of the resource.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Message containing Cloud CDN configuration for a backend bucket.
     */
    export interface Schema$BackendBucketCdnPolicy {
        /**
         * Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
         */
        bypassCacheOnRequestHeaders?: Schema$BackendBucketCdnPolicyBypassCacheOnRequestHeader[];
        /**
         * Specifies the cache setting for all responses from this backend. The possible values are:
         *
         * USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
         *
         * FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
         *
         * CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
         */
        cacheMode?: string | null;
        /**
         * Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 86400s (1 day).
         */
        clientTtl?: number | null;
        /**
         * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        defaultTtl?: number | null;
        /**
         * Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        maxTtl?: number | null;
        /**
         * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
         */
        negativeCaching?: boolean | null;
        /**
         * Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
         */
        negativeCachingPolicy?: Schema$BackendBucketCdnPolicyNegativeCachingPolicy[];
        /**
         * If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
         */
        requestCoalescing?: boolean | null;
        /**
         * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
         */
        serveWhileStale?: number | null;
        /**
         * Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
         */
        signedUrlCacheMaxAgeSec?: string | null;
        /**
         * [Output Only] Names of the keys for signing request URLs.
         */
        signedUrlKeyNames?: string[] | null;
    }
    /**
     * Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
     */
    export interface Schema$BackendBucketCdnPolicyBypassCacheOnRequestHeader {
        /**
         * The header field name to match on when bypassing cache. Values are case-insensitive.
         */
        headerName?: string | null;
    }
    /**
     * Specify CDN TTLs for response error codes.
     */
    export interface Schema$BackendBucketCdnPolicyNegativeCachingPolicy {
        /**
         * The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
         */
        code?: number | null;
        /**
         * The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        ttl?: number | null;
    }
    /**
     * Contains a list of BackendBucket resources.
     */
    export interface Schema$BackendBucketList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendBucket resources.
         */
        items?: Schema$BackendBucket[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Backend Service resource.
     *
     * A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly.
     *
     * Backend services in Google Compute Engine can be either regionally or globally scoped.
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/backendServices) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionBackendServices)
     *
     * For more information, see Backend Services.
     *
     * (== resource_for {$api_version\}.backendService ==)
     */
    export interface Schema$BackendService {
        /**
         * Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
         *
         * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
         *
         * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        affinityCookieTtlSec?: number | null;
        /**
         * The list of backends that serve this BackendService.
         */
        backends?: Schema$Backend[];
        /**
         * Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
         */
        cdnPolicy?: Schema$BackendServiceCdnPolicy;
        /**
         * Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
         *
         * This field is applicable to either:
         * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
         * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
         *
         * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        circuitBreakers?: Schema$CircuitBreakers;
        connectionDraining?: Schema$ConnectionDraining;
        connectionTrackingPolicy?: Schema$BackendServiceConnectionTrackingPolicy;
        /**
         * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
         *
         * This field is applicable to either:
         * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
         * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
         *
         * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        consistentHash?: Schema$ConsistentHashLoadBalancerSettings;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Headers that the HTTP/S load balancer should add to proxied requests.
         */
        customRequestHeaders?: string[] | null;
        /**
         * Headers that the HTTP/S load balancer should add to proxied responses.
         */
        customResponseHeaders?: string[] | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The resource URL for the edge security policy associated with this backend service.
         */
        edgeSecurityPolicy?: string | null;
        /**
         * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
         */
        enableCDN?: boolean | null;
        /**
         * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
         */
        failoverPolicy?: Schema$BackendServiceFailoverPolicy;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a BackendService.
         */
        fingerprint?: string | null;
        /**
         * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
         */
        healthChecks?: string[] | null;
        /**
         * The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
         */
        iap?: Schema$BackendServiceIAP;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#backendService for backend services.
         */
        kind?: string | null;
        /**
         * Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
         */
        loadBalancingScheme?: string | null;
        /**
         * The load balancing algorithm used within the scope of the locality. The possible values are:
         * - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
         * - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
         * - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
         * - RANDOM: The load balancer selects a random healthy host.
         * - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
         * - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
         *
         * This field is applicable to either:
         * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
         * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
         *
         * If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
         *
         * Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        localityLbPolicy?: string | null;
        /**
         * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
         */
        logConfig?: Schema$BackendServiceLogConfig;
        /**
         * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
         * If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
         * This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
         */
        maxStreamDuration?: Schema$Duration;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
         */
        network?: string | null;
        /**
         * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
         *
         * This field is applicable to either:
         * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
         * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
         *
         * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        outlierDetection?: Schema$OutlierDetection;
        /**
         * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
         *
         * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
         */
        port?: number | null;
        /**
         * A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
         *
         *
         *
         * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
         */
        portName?: string | null;
        /**
         * The protocol this BackendService uses to communicate with backends.
         *
         * Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
         *
         * Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
         */
        protocol?: string | null;
        /**
         * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] The resource URL for the security policy associated with this backend service.
         */
        securityPolicy?: string | null;
        /**
         * This field specifies the security policy that applies to this backend service. This field is applicable to either:
         * - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
         * - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
         */
        securitySettings?: Schema$SecuritySettings;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Type of session affinity to use. The default is NONE.
         *
         * When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
         *
         * When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
         *
         * When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
         *
         * Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        sessionAffinity?: string | null;
        subsetting?: Schema$Subsetting;
        /**
         * The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
         */
        timeoutSec?: number | null;
    }
    /**
     * Contains a list of BackendServicesScopedList.
     */
    export interface Schema$BackendServiceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendServicesScopedList resources.
         */
        items?: {
            [key: string]: Schema$BackendServicesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Message containing Cloud CDN configuration for a backend service.
     */
    export interface Schema$BackendServiceCdnPolicy {
        /**
         * Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
         */
        bypassCacheOnRequestHeaders?: Schema$BackendServiceCdnPolicyBypassCacheOnRequestHeader[];
        /**
         * The CacheKeyPolicy for this CdnPolicy.
         */
        cacheKeyPolicy?: Schema$CacheKeyPolicy;
        /**
         * Specifies the cache setting for all responses from this backend. The possible values are:
         *
         * USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
         *
         * FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
         *
         * CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
         */
        cacheMode?: string | null;
        /**
         * Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 86400s (1 day).
         */
        clientTtl?: number | null;
        /**
         * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        defaultTtl?: number | null;
        /**
         * Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        maxTtl?: number | null;
        /**
         * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
         */
        negativeCaching?: boolean | null;
        /**
         * Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
         */
        negativeCachingPolicy?: Schema$BackendServiceCdnPolicyNegativeCachingPolicy[];
        /**
         * If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
         */
        requestCoalescing?: boolean | null;
        /**
         * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
         */
        serveWhileStale?: number | null;
        /**
         * Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
         */
        signedUrlCacheMaxAgeSec?: string | null;
        /**
         * [Output Only] Names of the keys for signing request URLs.
         */
        signedUrlKeyNames?: string[] | null;
    }
    /**
     * Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
     */
    export interface Schema$BackendServiceCdnPolicyBypassCacheOnRequestHeader {
        /**
         * The header field name to match on when bypassing cache. Values are case-insensitive.
         */
        headerName?: string | null;
    }
    /**
     * Specify CDN TTLs for response error codes.
     */
    export interface Schema$BackendServiceCdnPolicyNegativeCachingPolicy {
        /**
         * The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
         */
        code?: number | null;
        /**
         * The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
         */
        ttl?: number | null;
    }
    /**
     * Connection Tracking configuration for this BackendService.
     */
    export interface Schema$BackendServiceConnectionTrackingPolicy {
        /**
         * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL.
         *
         * If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP.
         *
         * If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy).
         *
         * If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default.
         */
        connectionPersistenceOnUnhealthyBackends?: string | null;
        /**
         * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds).
         *
         * For L4 ILB the minimum(default) is 10 minutes and maximum is 16 hours.
         *
         * For NLB the minimum(default) is 60 seconds and the maximum is 16 hours.
         *
         * This field will be supported only if the Connection Tracking key is less than 5-tuple.
         */
        idleTimeoutSec?: number | null;
        /**
         * Specifies the key used for connection tracking. There are two options:
         *
         * PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol.
         *
         * PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity.
         */
        trackingMode?: string | null;
    }
    /**
     * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. On failover or failback, this field indicates whether connection draining will be honored. GCP has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
     */
    export interface Schema$BackendServiceFailoverPolicy {
        /**
         * This can be set to true only if the protocol is TCP.
         *
         * The default is false.
         */
        disableConnectionDrainOnFailover?: boolean | null;
        /**
         * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing, If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. The default is false.
         */
        dropTrafficIfUnhealthy?: boolean | null;
        /**
         * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio.
         */
        failoverRatio?: number | null;
    }
    export interface Schema$BackendServiceGroupHealth {
        /**
         * Metadata defined as annotations on the network endpoint group.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * Health state of the backend instances or endpoints in requested instance or network endpoint group, determined based on configured health checks.
         */
        healthStatus?: Schema$HealthStatus[];
        /**
         * [Output Only] Type of resource. Always compute#backendServiceGroupHealth for the health of backend services.
         */
        kind?: string | null;
    }
    /**
     * Identity-Aware Proxy
     */
    export interface Schema$BackendServiceIAP {
        /**
         * Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.
         */
        enabled?: boolean | null;
        /**
         * OAuth2 client ID to use for the authentication flow.
         */
        oauth2ClientId?: string | null;
        /**
         * [Input Only] OAuth client info required to generate client id to be used for IAP.
         */
        oauth2ClientInfo?: Schema$BackendServiceIAPOAuth2ClientInfo;
        /**
         * OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
         */
        oauth2ClientSecret?: string | null;
        /**
         * [Output Only] SHA256 hash value for the field oauth2_client_secret above.
         */
        oauth2ClientSecretSha256?: string | null;
    }
    export interface Schema$BackendServiceIAPOAuth2ClientInfo {
        /**
         * Application name to be used in OAuth consent screen.
         */
        applicationName?: string | null;
        /**
         * Name of the client to be generated. Optional - If not provided, the name will be autogenerated by the backend.
         */
        clientName?: string | null;
        /**
         * Developer's information to be used in OAuth consent screen.
         */
        developerEmailAddress?: string | null;
    }
    /**
     * Contains a list of BackendService resources.
     */
    export interface Schema$BackendServiceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of BackendService resources.
         */
        items?: Schema$BackendService[];
        /**
         * [Output Only] Type of resource. Always compute#backendServiceList for lists of backend services.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * The available logging options for the load balancer traffic served by this backend service.
     */
    export interface Schema$BackendServiceLogConfig {
        /**
         * This field denotes whether to enable logging for the load balancer traffic served by this backend service.
         */
        enable?: boolean | null;
        /**
         * This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
         */
        sampleRate?: number | null;
    }
    export interface Schema$BackendServiceReference {
        backendService?: string | null;
    }
    export interface Schema$BackendServicesScopedList {
        /**
         * A list of BackendServices contained in this scope.
         */
        backendServices?: Schema$BackendService[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$BfdPacket {
        /**
         * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        authenticationPresent?: boolean | null;
        /**
         * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        controlPlaneIndependent?: boolean | null;
        /**
         * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        demand?: boolean | null;
        /**
         * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
         */
        diagnostic?: string | null;
        /**
         * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        final?: boolean | null;
        /**
         * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
         */
        length?: number | null;
        /**
         * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        minEchoRxIntervalMs?: number | null;
        /**
         * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        minRxIntervalMs?: number | null;
        /**
         * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        minTxIntervalMs?: number | null;
        /**
         * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        multiplier?: number | null;
        /**
         * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        multipoint?: boolean | null;
        /**
         * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        myDiscriminator?: number | null;
        /**
         * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
         */
        poll?: boolean | null;
        /**
         * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
         */
        state?: string | null;
        /**
         * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
         */
        version?: number | null;
        /**
         * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
         */
        yourDiscriminator?: number | null;
    }
    /**
     * Next free: 15
     */
    export interface Schema$BfdStatus {
        /**
         * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
         */
        bfdSessionInitializationMode?: string | null;
        /**
         * Unix timestamp of the most recent config update.
         */
        configUpdateTimestampMicros?: string | null;
        /**
         * Control packet counts for the current BFD session.
         */
        controlPacketCounts?: Schema$BfdStatusPacketCounts;
        /**
         * Inter-packet time interval statistics for control packets.
         */
        controlPacketIntervals?: Schema$PacketIntervals[];
        /**
         * Echo packet counts for the current BFD session.
         */
        echoPacketCounts?: Schema$BfdStatusPacketCounts;
        /**
         * Inter-packet time interval statistics for echo packets.
         */
        echoPacketIntervals?: Schema$PacketIntervals[];
        /**
         * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
         */
        localDiagnostic?: string | null;
        /**
         * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
         */
        localState?: string | null;
        /**
         * Negotiated transmit interval for control packets.
         */
        negotiatedLocalControlTxIntervalMs?: number | null;
        /**
         * Negotiated transmit interval for echo packets.
         */
        negotiatedLocalEchoTxIntervalMs?: number | null;
        /**
         * The most recent Rx control packet for this BFD session.
         */
        rxPacket?: Schema$BfdPacket;
        /**
         * The most recent Tx control packet for this BFD session.
         */
        txPacket?: Schema$BfdPacket;
        /**
         * Session uptime in milliseconds. Value will be 0 if session is not up.
         */
        uptimeMs?: string | null;
        /**
         * Indicates if echo mode is currently being used.
         */
        usingEchoMode?: boolean | null;
    }
    export interface Schema$BfdStatusPacketCounts {
        /**
         * Number of packets received since the beginning of the current BFD session.
         */
        numRx?: number | null;
        /**
         * Number of packets received that were rejected because of errors since the beginning of the current BFD session.
         */
        numRxRejected?: number | null;
        /**
         * Number of packets received that were successfully processed since the beginning of the current BFD session.
         */
        numRxSuccessful?: number | null;
        /**
         * Number of packets transmitted since the beginning of the current BFD session.
         */
        numTx?: number | null;
    }
    /**
     * Associates `members` with a `role`.
     */
    export interface Schema$Binding {
        bindingId?: string | null;
        /**
         * The condition that is associated with this binding.
         *
         * If the condition evaluates to `true`, then this binding applies to the current request.
         *
         * If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.
         *
         * To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        condition?: Schema$Expr;
        /**
         * Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values:
         *
         * * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account.
         *
         * * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account.
         *
         * * `user:{emailid\}`: An email address that represents a specific Google account. For example, `alice@example.com` .
         *
         *
         *
         * * `serviceAccount:{emailid\}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`.
         *
         * * `group:{emailid\}`: An email address that represents a Google group. For example, `admins@example.com`.
         *
         * * `deleted:user:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid\}` and the recovered user retains the role in the binding.
         *
         * * `deleted:serviceAccount:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid\}` and the undeleted service account retains the role in the binding.
         *
         * * `deleted:group:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid\}` and the recovered group retains the role in the binding.
         *
         *
         *
         * * `domain:{domain\}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`.
         */
        members?: string[] | null;
        /**
         * Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
         */
        role?: string | null;
    }
    export interface Schema$BulkInsertInstanceResource {
        /**
         * The maximum number of instances to create.
         */
        count?: string | null;
        /**
         * DEPRECATED: Please use instance_properties instead.
         */
        instance?: Schema$Instance;
        /**
         * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
         */
        instanceProperties?: Schema$InstanceProperties;
        /**
         * Policy for chosing target zone.
         */
        locationPolicy?: Schema$LocationPolicy;
        /**
         * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
         */
        minCount?: string | null;
        /**
         * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern should contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: name_pattern of inst-#### will generate instance names such as inst-0001, inst-0002, ... . If there already exist instance(s) whose names match the name pattern in the same project and zone, then the generated instance numbers will start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### will be inst-0051, inst-0052, etc. The name pattern placeholder #...# can contain up to 18 characters.
         */
        namePattern?: string | null;
        /**
         * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
         */
        perInstanceProperties?: {
            [key: string]: Schema$BulkInsertInstanceResourcePerInstanceProperties;
        } | null;
        /**
         * DEPRECATED: Please use per_instance_properties instead.
         */
        predefinedNames?: string[] | null;
        /**
         * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396.
         *
         * It can be a full or partial URL. For example, the following are all valid URLs to an instance template:
         * - https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/instanceTemplate
         * - projects/project/global/instanceTemplates/instanceTemplate
         * - global/instanceTemplates/instanceTemplate
         *
         * This field is optional.
         */
        sourceInstanceTemplate?: string | null;
    }
    /**
     * Per-instance properties to be set on individual instances. To be extended in the future.
     */
    export interface Schema$BulkInsertInstanceResourcePerInstanceProperties {
        /**
         * This field is only temporary. It will be removed. Do not use it.
         */
        name?: string | null;
    }
    export interface Schema$CacheInvalidationRule {
        /**
         * If set, this invalidation rule will only apply to requests with a Host header matching host.
         */
        host?: string | null;
        path?: string | null;
    }
    /**
     * Message containing what to include in the cache key for a request for Cloud CDN.
     */
    export interface Schema$CacheKeyPolicy {
        /**
         * If true, requests to different hosts will be cached separately.
         */
        includeHost?: boolean | null;
        /**
         * If true, http and https requests will be cached separately.
         */
        includeProtocol?: boolean | null;
        /**
         * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
         */
        includeQueryString?: boolean | null;
        /**
         * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
         */
        queryStringBlacklist?: string[] | null;
        /**
         * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
         */
        queryStringWhitelist?: string[] | null;
    }
    /**
     * [Deprecated] gRPC call credentials to access the SDS server. gRPC call credentials to access the SDS server.
     */
    export interface Schema$CallCredentials {
        /**
         * The type of call credentials to use for GRPC requests to the SDS server. This field can be set to one of the following:
         * - GCE_VM: The local GCE VM service account credentials are used to access the SDS server.
         * - FROM_PLUGIN: Custom authenticator credentials are used to access the SDS server.
         */
        callCredentialType?: string | null;
        /**
         * Custom authenticator credentials. Valid if callCredentialType is FROM_PLUGIN.
         */
        fromPlugin?: Schema$MetadataCredentialsFromPlugin;
    }
    /**
     * [Deprecated] gRPC channel credentials to access the SDS server. gRPC channel credentials to access the SDS server.
     */
    export interface Schema$ChannelCredentials {
        /**
         * The call credentials to access the SDS server.
         */
        certificates?: Schema$TlsCertificatePaths;
        /**
         * The channel credentials to access the SDS server. This field can be set to one of the following: CERTIFICATES: Use TLS certificates to access the SDS server. GCE_VM: Use local GCE VM credentials to access the SDS server.
         */
        channelCredentialType?: string | null;
    }
    /**
     * Settings controlling the volume of connections to a backend service.
     */
    export interface Schema$CircuitBreakers {
        /**
         * The timeout for new network connections to hosts.
         */
        connectTimeout?: Schema$Duration;
        /**
         * The maximum number of connections to the backend service. If not specified, there is no limit.
         */
        maxConnections?: number | null;
        /**
         * The maximum number of pending requests allowed to the backend service. If not specified, there is no limit.
         */
        maxPendingRequests?: number | null;
        /**
         * The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
         */
        maxRequests?: number | null;
        /**
         * Maximum requests for a single connection to the backend service. This parameter is respected by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this parameter to 1 will effectively disable keep alive.
         */
        maxRequestsPerConnection?: number | null;
        /**
         * The maximum number of parallel retries allowed to the backend cluster. If not specified, the default is 1.
         */
        maxRetries?: number | null;
    }
    /**
     * [Deprecated] The client side authentication settings for connection originating from the backend service. the backend service.
     */
    export interface Schema$ClientTlsSettings {
        /**
         * Configures the mechanism to obtain client-side security certificates and identity information. This field is only applicable when mode is set to MUTUAL.
         */
        clientTlsContext?: Schema$TlsContext;
        /**
         * Indicates whether connections to this port should be secured using TLS. The value of this field determines how TLS is enforced. This can be set to one of the following values: DISABLE: Do not setup a TLS connection to the backends. SIMPLE: Originate a TLS connection to the backends. MUTUAL: Secure connections to the backends using mutual TLS by presenting client certificates for authentication.
         */
        mode?: string | null;
        /**
         * SNI string to present to the server during TLS handshake. This field is applicable only when mode is SIMPLE or MUTUAL.
         */
        sni?: string | null;
        /**
         * A list of alternate names to verify the subject identity in the certificate.If specified, the proxy will verify that the server certificate's subject alt name matches one of the specified values. This field is applicable only when mode is SIMPLE or MUTUAL.
         */
        subjectAltNames?: string[] | null;
    }
    /**
     * Represents a regional Commitment resource.
     *
     * Creating a commitment resource means that you are purchasing a committed use contract with an explicit start and end time. You can create commitments based on vCPUs and memory usage and receive discounted rates. For full details, read Signing Up for Committed Use Discounts. (== resource_for {$api_version\}.regionCommitments ==)
     */
    export interface Schema$Commitment {
        /**
         * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
         */
        category?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Commitment end time in RFC3339 text format.
         */
        endTimestamp?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#commitment for commitments.
         */
        kind?: string | null;
        /**
         * The license specification required as part of a license commitment.
         */
        licenseResource?: Schema$LicenseResourceCommitment;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
         */
        plan?: string | null;
        /**
         * [Output Only] URL of the region where this commitment may be used.
         */
        region?: string | null;
        /**
         * List of reservations in this commitment.
         */
        reservations?: Schema$Reservation[];
        /**
         * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
         */
        resources?: Schema$ResourceCommitment[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] Commitment start time in RFC3339 text format.
         */
        startTimestamp?: string | null;
        /**
         * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
         */
        status?: string | null;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string | null;
        /**
         * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
         */
        type?: string | null;
    }
    export interface Schema$CommitmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of CommitmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$CommitmentsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#commitmentAggregatedList for aggregated lists of commitments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of Commitment resources.
     */
    export interface Schema$CommitmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Commitment resources.
         */
        items?: Schema$Commitment[];
        /**
         * [Output Only] Type of resource. Always compute#commitmentList for lists of commitments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$CommitmentsScopedList {
        /**
         * [Output Only] A list of commitments contained in this scope.
         */
        commitments?: Schema$Commitment[];
        /**
         * [Output Only] Informational warning which replaces the list of commitments when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A condition to be met.
     */
    export interface Schema$Condition {
        /**
         * Trusted attributes supplied by the IAM system.
         */
        iam?: string | null;
        /**
         * An operator to apply the subject with.
         */
        op?: string | null;
        /**
         * Trusted attributes discharged by the service.
         */
        svc?: string | null;
        /**
         * Trusted attributes supplied by any service that owns resources and uses the IAM system for access control.
         */
        sys?: string | null;
        /**
         * The objects of the condition.
         */
        values?: string[] | null;
    }
    /**
     * A set of Confidential Instance options.
     */
    export interface Schema$ConfidentialInstanceConfig {
        /**
         * Defines whether the instance should have confidential compute enabled.
         */
        enableConfidentialCompute?: boolean | null;
    }
    /**
     * Message containing connection draining configuration.
     */
    export interface Schema$ConnectionDraining {
        /**
         * Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
         */
        drainingTimeoutSec?: number | null;
    }
    /**
     * This message defines settings for a consistent hash style load balancer.
     */
    export interface Schema$ConsistentHashLoadBalancerSettings {
        /**
         * Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE.
         */
        httpCookie?: Schema$ConsistentHashLoadBalancerSettingsHttpCookie;
        /**
         * The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
         */
        httpHeaderName?: string | null;
        /**
         * The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
         */
        minimumRingSize?: string | null;
    }
    /**
     * The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
     */
    export interface Schema$ConsistentHashLoadBalancerSettingsHttpCookie {
        /**
         * Name of the cookie.
         */
        name?: string | null;
        /**
         * Path to set for the cookie.
         */
        path?: string | null;
        /**
         * Lifetime of the cookie.
         */
        ttl?: Schema$Duration;
    }
    /**
     * The specification for allowing client side cross-origin requests. Please see W3C Recommendation for Cross Origin Resource Sharing
     */
    export interface Schema$CorsPolicy {
        /**
         * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This translates to the Access-Control-Allow-Credentials header.
         * Default is false.
         */
        allowCredentials?: boolean | null;
        /**
         * Specifies the content for the Access-Control-Allow-Headers header.
         */
        allowHeaders?: string[] | null;
        /**
         * Specifies the content for the Access-Control-Allow-Methods header.
         */
        allowMethods?: string[] | null;
        /**
         * Specifies the regualar expression patterns that match allowed origins. For regular expression grammar please see github.com/google/re2/wiki/Syntax
         * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
         */
        allowOriginRegexes?: string[] | null;
        /**
         * Specifies the list of origins that will be allowed to do CORS requests.
         * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
         */
        allowOrigins?: string[] | null;
        /**
         * If true, specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
         */
        disabled?: boolean | null;
        /**
         * Specifies the content for the Access-Control-Expose-Headers header.
         */
        exposeHeaders?: string[] | null;
        /**
         * Specifies how long results of a preflight request can be cached in seconds. This translates to the Access-Control-Max-Age header.
         */
        maxAge?: number | null;
    }
    export interface Schema$CustomerEncryptionKey {
        /**
         * The name of the encryption key that is stored in Google Cloud KMS.
         */
        kmsKeyName?: string | null;
        /**
         * The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used.
         */
        kmsKeyServiceAccount?: string | null;
        /**
         * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
         */
        rawKey?: string | null;
        /**
         * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource.
         *
         * The key must meet the following requirements before you can provide it to Compute Engine:
         * - The key is wrapped using a RSA public key certificate provided by Google.
         * - After being wrapped, the key must be encoded in RFC 4648 base64 encoding.  Gets the RSA public key certificate provided by Google at:
         * https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
         */
        rsaEncryptedKey?: string | null;
        /**
         * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
         */
        sha256?: string | null;
    }
    export interface Schema$CustomerEncryptionKeyProtectedDisk {
        /**
         * Decrypts data associated with the disk with a customer-supplied encryption key.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
         */
        source?: string | null;
    }
    /**
     * Deprecation status for a public resource.
     */
    export interface Schema$DeprecationStatus {
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
         */
        deleted?: string | null;
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
         */
        deprecated?: string | null;
        /**
         * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
         */
        obsolete?: string | null;
        /**
         * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
         */
        replacement?: string | null;
        /**
         * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
         */
        state?: string | null;
        /**
         * The rollout policy of this deprecation. This policy is only enforced by image family views. The rollout policy restricts the zones where the associated resource is considered in a deprecated state. When the rollout policy does not include the user specified zone, or if the zone is rolled out, the associated resource is considered in a deprecated state.
         */
        stateOverride?: Schema$RolloutPolicy;
    }
    /**
     * Represents a Persistent Disk resource.
     *
     * Google Compute Engine has two Disk resources:
     *
     * * [Zonal](/compute/docs/reference/rest/{$api_version\}/disks) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionDisks)
     *
     * Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options.
     *
     * The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks.
     *
     * The regionDisks resource represents a regional persistent disk. For more information, read  Regional resources. (== resource_for {$api_version\}.disks ==) (== resource_for {$api_version\}.regionDisks ==)
     */
    export interface Schema$Disk {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Encrypts the disk using a customer-supplied encryption key.
         *
         * After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine).
         *
         * Customer-supplied encryption keys do not protect access to metadata of the disk.
         *
         * If you do not provide an encryption key when creating the disk, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Specifies whether the disk restored from a source snapshot should erase Windows specific VSS signature.
         */
        eraseWindowsVssSignature?: boolean | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
         */
        interface?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#disk for disks.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a disk.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this disk. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Last attach timestamp in RFC3339 text format.
         */
        lastAttachTimestamp?: string | null;
        /**
         * [Output Only] Last detach timestamp in RFC3339 text format.
         */
        lastDetachTimestamp?: string | null;
        /**
         * Integer license codes indicating which licenses are attached to this disk.
         */
        licenseCodes?: string[] | null;
        /**
         * A list of publicly visible licenses. Reserved for Google's use.
         */
        licenses?: string[] | null;
        /**
         * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
         */
        locationHint?: string | null;
        /**
         * Indicates whether or not the disk can be read/write attached to more than one instance.
         */
        multiWriter?: boolean | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Internal use only.
         */
        options?: string | null;
        /**
         * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
         */
        physicalBlockSizeBytes?: string | null;
        /**
         * Indicates how many IOPS must be provisioned for the disk.
         */
        provisionedIops?: string | null;
        /**
         * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
         */
        replicaZones?: string[] | null;
        /**
         * Resource policies applied to this disk for automatic snapshot creations.
         */
        resourcePolicies?: string[] | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk.
         *
         * If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
         */
        sizeGb?: string | null;
        /**
         * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
         * - https://www.googleapis.com/compute/v1/projects/project/regions/region/disks/disk
         * - projects/project/zones/zone/disks/disk
         * - projects/project/regions/region/disks/disk
         * - zones/zone/disks/disk
         * - regions/region/disks/disk
         */
        sourceDisk?: string | null;
        /**
         * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
         */
        sourceDiskId?: string | null;
        /**
         * The source image used to create this disk. If the source image is deleted, this field will not be set.
         *
         * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
         * projects/debian-cloud/global/images/family/debian-9
         *
         *
         * Alternatively, use a specific version of a public operating system image:
         * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
         *
         *
         * To create a disk with a custom image that you created, specify the image name in the following format:
         * global/images/my-custom-image
         *
         *
         * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
         * global/images/family/my-image-family
         */
        sourceImage?: string | null;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
         */
        sourceImageId?: string | null;
        /**
         * [Deprecated] The source in-place snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/global/inPlaceSnapshots/inPlaceSnapshots
         * - projects/project/global/inPlaceSnapshots/inPlaceSnapshots
         * - global/inPlaceSnapshots/inPlaceSnapshots
         */
        sourceInPlaceSnapshot?: string | null;
        /**
         * [Deprecated] [Output Only] The unique ID of the in-place snapshot used to create this disk. This value identifies the exact in-place snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an in-place snapshot that was later deleted and recreated under the same name, the source in-place snapshot ID would identify the exact version of the in-place snapshot that was used.
         */
        sourceInPlaceSnapshotId?: string | null;
        /**
         * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instantSnapshots/instantSnapshot
         * - projects/project/zones/zone/instantSnapshots/instantSnapshot
         * - zones/zone/instantSnapshots/instantSnapshot
         */
        sourceInstantSnapshot?: string | null;
        /**
         * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
         */
        sourceInstantSnapshotId?: string | null;
        /**
         * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
         * - projects/project/global/snapshots/snapshot
         * - global/snapshots/snapshot
         */
        sourceSnapshot?: string | null;
        /**
         * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
         */
        sourceSnapshotId?: string | null;
        /**
         * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
         */
        sourceStorageObject?: string | null;
        /**
         * [Output Only] The status of disk creation.
         * - CREATING: Disk is provisioning.
         * - RESTORING: Source data is being copied into the disk.
         * - FAILED: Disk creation failed.
         * - READY: Disk is ready for use.
         * - DELETING: Disk is deleting.
         */
        status?: string | null;
        /**
         * [Deprecated] Storage type of the persistent disk.
         */
        storageType?: string | null;
        /**
         * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard  or pd-ssd
         */
        type?: string | null;
        /**
         * A list of publicly visible user-licenses. Unlike regular licenses, user provided licenses can be modified after the disk is created. This includes a list of URLs to the license resource. For example, to provide a debian license:
         * https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch
         */
        userLicenses?: string[] | null;
        /**
         * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
         */
        users?: string[] | null;
        /**
         * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$DiskAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DisksScopedList resources.
         */
        items?: {
            [key: string]: Schema$DisksScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#diskAggregatedList for aggregated lists of persistent disks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
     */
    export interface Schema$DiskInstantiationConfig {
        /**
         * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
         */
        autoDelete?: boolean | null;
        /**
         * The custom source image to be used to restore this disk when instantiating this instance template.
         */
        customImage?: string | null;
        /**
         * Specifies the device name of the disk to which the configurations apply to.
         */
        deviceName?: string | null;
        /**
         * Specifies whether to include the disk and what image to use. Possible values are:
         * - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks.
         * - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks.
         * - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks.
         * - attach-read-only: to attach a read-only disk. Applicable to read-only disks.
         * - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
         */
        instantiateFrom?: string | null;
    }
    /**
     * A list of Disk resources.
     */
    export interface Schema$DiskList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Disk resources.
         */
        items?: Schema$Disk[];
        /**
         * [Output Only] Type of resource. Always compute#diskList for lists of disks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$DiskMoveRequest {
        /**
         * The URL of the destination zone to move the disk. This can be a full or partial URL. For example, the following are all valid URLs to a zone:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone
         * - projects/project/zones/zone
         * - zones/zone
         */
        destinationZone?: string | null;
        /**
         * The URL of the target disk to move. This can be a full or partial URL. For example, the following are all valid URLs to a disk:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
         * - projects/project/zones/zone/disks/disk
         * - zones/zone/disks/disk
         */
        targetDisk?: string | null;
    }
    export interface Schema$DisksAddResourcePoliciesRequest {
        /**
         * Resource policies to be added to this disk. Currently you can only specify one policy here.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$DisksRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this disk.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$DisksResizeRequest {
        /**
         * The new size of the persistent disk, which is specified in GB.
         */
        sizeGb?: string | null;
    }
    export interface Schema$DisksScopedList {
        /**
         * [Output Only] A list of disks contained in this scope.
         */
        disks?: Schema$Disk[];
        /**
         * [Output Only] Informational warning which replaces the list of disks when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Disk Type resource.
     *
     * Google Compute Engine has two Disk Type resources:
     *
     * * [Regional](/compute/docs/reference/rest/{$api_version\}/regionDiskTypes) * [Zonal](/compute/docs/reference/rest/{$api_version\}/diskTypes)
     *
     * You can choose from a variety of disk types based on your needs. For more information, read Storage options.
     *
     * The diskTypes resource represents disk types for a zonal persistent disk. For more information, read Zonal persistent disks.
     *
     * The regionDiskTypes resource represents disk types for a regional persistent disk. For more information, read Regional persistent disks. (== resource_for {$api_version\}.diskTypes ==) (== resource_for {$api_version\}.regionDiskTypes ==)
     */
    export interface Schema$DiskType {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] Server-defined default disk size in GB.
         */
        defaultDiskSizeGb?: string | null;
        /**
         * [Output Only] The deprecation status associated with this disk type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional description of this resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#diskType for disk types.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the disk type resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] An optional textual description of the valid disk size, such as "10GB-10TB".
         */
        validDiskSize?: string | null;
        /**
         * [Output Only] URL of the zone where the disk type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$DiskTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DiskTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$DiskTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#diskTypeAggregatedList.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of disk types.
     */
    export interface Schema$DiskTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DiskType resources.
         */
        items?: Schema$DiskType[];
        /**
         * [Output Only] Type of resource. Always compute#diskTypeList for disk types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$DiskTypesScopedList {
        /**
         * [Output Only] A list of disk types contained in this scope.
         */
        diskTypes?: Schema$DiskType[];
        /**
         * [Output Only] Informational warning which replaces the list of disk types when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A set of Display Device options
     */
    export interface Schema$DisplayDevice {
        /**
         * Defines whether the instance has Display enabled.
         */
        enableDisplay?: boolean | null;
    }
    export interface Schema$DistributionPolicy {
        /**
         * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
         */
        targetShape?: string | null;
        /**
         * Zones where the regional managed instance group will create and manage its instances.
         */
        zones?: Schema$DistributionPolicyZoneConfiguration[];
    }
    export interface Schema$DistributionPolicyZoneConfiguration {
        /**
         * The URL of the zone. The zone must exist in the region where the managed instance group is located.
         */
        zone?: string | null;
    }
    /**
     * A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
     */
    export interface Schema$Duration {
        /**
         * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
         */
        nanos?: number | null;
        /**
         * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
         */
        seconds?: string | null;
    }
    export interface Schema$ExchangedPeeringRoute {
        /**
         * The destination range of the route.
         */
        destRange?: string | null;
        /**
         * True if the peering route has been imported from a peer. The actual import happens if the field networkPeering.importCustomRoutes is true for this network, and networkPeering.exportCustomRoutes is true for the peer network, and the import does not result in a route conflict.
         */
        imported?: boolean | null;
        /**
         * The region of peering route next hop, only applies to dynamic routes.
         */
        nextHopRegion?: string | null;
        /**
         * The priority of the peering route.
         */
        priority?: number | null;
        /**
         * The type of the peering route.
         */
        type?: string | null;
    }
    export interface Schema$ExchangedPeeringRoutesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ExchangedPeeringRoute resources.
         */
        items?: Schema$ExchangedPeeringRoute[];
        /**
         * [Output Only] Type of resource. Always compute#exchangedPeeringRoutesList for exchanged peering routes lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.
     *
     * Example (Comparison):
     *
     * title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100"
     *
     * Example (Equality):
     *
     * title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email"
     *
     * Example (Logic):
     *
     * title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'"
     *
     * Example (Data Manipulation):
     *
     * title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)"
     *
     * The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
     */
    export interface Schema$Expr {
        /**
         * Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string | null;
        /**
         * Textual representation of an expression in Common Expression Language syntax.
         */
        expression?: string | null;
        /**
         * Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
         */
        location?: string | null;
        /**
         * Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
         */
        title?: string | null;
    }
    /**
     * Represents an external VPN gateway.
     *
     * External VPN gateway is the on-premises VPN gateway(s) or another cloud provider's VPN gateway that connects to your Google Cloud VPN gateway.
     *
     * To create a highly available VPN from Google Cloud Platform to your VPN gateway or another cloud provider's VPN gateway, you must create a external VPN gateway resource with information about the other gateway.
     *
     * For more information about using external VPN gateways, see  Creating an HA VPN gateway and tunnel pair to a peer VPN. (== resource_for {$api_version\}.externalVpnGateways ==)
     */
    export interface Schema$ExternalVpnGateway {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * List of interfaces for this external VPN gateway.
         */
        interfaces?: Schema$ExternalVpnGatewayInterface[];
        /**
         * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Indicates the user-supplied redundancy type of this external VPN gateway.
         */
        redundancyType?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
    }
    /**
     * The interface for the external VPN gateway.
     */
    export interface Schema$ExternalVpnGatewayInterface {
        /**
         * The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: SINGLE_IP_INTERNALLY_REDUNDANT - 0 TWO_IPS_REDUNDANCY - 0, 1 FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
         */
        id?: number | null;
        /**
         * IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
         */
        ipAddress?: string | null;
    }
    /**
     * Response to the list request, and contains a list of externalVpnGateways.
     */
    export interface Schema$ExternalVpnGatewayList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ExternalVpnGateway resources.
         */
        items?: Schema$ExternalVpnGateway[];
        /**
         * [Output Only] Type of resource. Always compute#externalVpnGatewayList  for lists of externalVpnGateways.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$FileContentBuffer {
        /**
         * The raw content in the secure keys file.
         */
        content?: string | null;
        /**
         * The file type of source file.
         */
        fileType?: string | null;
    }
    /**
     * Represents a Firewall Rule resource.
     *
     * Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
     */
    export interface Schema$Firewall {
        /**
         * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
         */
        allowed?: Array<{
            IPProtocol?: string;
            ports?: string[];
        }> | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
         */
        denied?: Array<{
            IPProtocol?: string;
            ports?: string[];
        }> | null;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string | null;
        /**
         * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Only IPv4 is supported.
         */
        destinationRanges?: string[] | null;
        /**
         * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify the destinationRanges field, and for `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags fields.
         */
        direction?: string | null;
        /**
         * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
         */
        disabled?: boolean | null;
        /**
         * Deprecated in favor of enable in LogConfig. This field denotes whether to enable logging for a particular firewall rule. If logging is enabled, logs will be exported t Cloud Logging.
         */
        enableLogging?: boolean | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
         */
        kind?: string | null;
        /**
         * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
         */
        logConfig?: Schema$FirewallLogConfig;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string | null;
        /**
         * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used:
         * global/networks/default
         * If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs:
         * - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network
         * - projects/myproject/global/networks/my-network
         * - global/networks/default
         */
        network?: string | null;
        /**
         * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
         */
        priority?: number | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Only IPv4 is supported.
         */
        sourceRanges?: string[] | null;
        /**
         * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
         */
        sourceServiceAccounts?: string[] | null;
        /**
         * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
         */
        sourceTags?: string[] | null;
        /**
         * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
         */
        targetServiceAccounts?: string[] | null;
        /**
         * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
         */
        targetTags?: string[] | null;
    }
    /**
     * Contains a list of firewalls.
     */
    export interface Schema$FirewallList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Firewall resources.
         */
        items?: Schema$Firewall[];
        /**
         * [Output Only] Type of resource. Always compute#firewallList for lists of firewalls.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * The available logging options for a firewall rule.
     */
    export interface Schema$FirewallLogConfig {
        /**
         * This field denotes whether to enable logging for a particular firewall rule.
         */
        enable?: boolean | null;
        /**
         * This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
         */
        metadata?: string | null;
    }
    export interface Schema$FirewallPoliciesListAssociationsResponse {
        /**
         * A list of associations.
         */
        associations?: Schema$FirewallPolicyAssociation[];
        /**
         * [Output Only] Type of firewallPolicy associations. Always compute#FirewallPoliciesListAssociations for lists of firewallPolicy associations.
         */
        kind?: string | null;
    }
    /**
     * Represents a Firewall Policy resource. (== resource_for {$api_version\}.firewallPolicies ==)
     */
    export interface Schema$FirewallPolicy {
        /**
         * A list of associations that belong to this firewall policy.
         */
        associations?: Schema$FirewallPolicyAssociation[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Depreacted, please use short name instead. User-provided name of the Organization firewall plicy. The name should be unique in the organization in which the firewall policy is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        displayName?: string | null;
        /**
         * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make get() request to the firewall policy.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource. It is a numeric ID allocated by GCP which uniquely identifies the Firewall Policy.
         */
        name?: string | null;
        /**
         * [Output Only] The parent of the firewall policy.
         */
        parent?: string | null;
        /**
         * [Output Only] URL of the region where the regional firewall policy resides. This field is not applicable to global firewall policies. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a default rule with action "allow" will be added.
         */
        rules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
         */
        ruleTupleCount?: number | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * User-provided name of the Organization firewall plicy. The name should be unique in the organization in which the firewall policy is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        shortName?: string | null;
    }
    export interface Schema$FirewallPolicyAssociation {
        /**
         * The target that the firewall policy is attached to.
         */
        attachmentTarget?: string | null;
        /**
         * [Output Only] Deprecated, please use short name instead. The display name of the firewall policy of the association.
         */
        displayName?: string | null;
        /**
         * [Output Only] The firewall policy ID of the association.
         */
        firewallPolicyId?: string | null;
        /**
         * The name for an association.
         */
        name?: string | null;
        /**
         * [Output Only] The short name of the firewall policy of the association.
         */
        shortName?: string | null;
    }
    export interface Schema$FirewallPolicyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of FirewallPolicy resources.
         */
        items?: Schema$FirewallPolicy[];
        /**
         * [Output Only] Type of resource. Always compute#firewallPolicyList for listsof FirewallPolicies
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
     */
    export interface Schema$FirewallPolicyRule {
        /**
         * The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
         */
        action?: string | null;
        /**
         * An optional description for this resource.
         */
        description?: string | null;
        /**
         * The direction in which this rule applies.
         */
        direction?: string | null;
        /**
         * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
         */
        disabled?: boolean | null;
        /**
         * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
         */
        enableLogging?: boolean | null;
        /**
         * [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
         */
        kind?: string | null;
        /**
         * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
         */
        match?: Schema$FirewallPolicyRuleMatcher;
        /**
         * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
         */
        priority?: number | null;
        /**
         * [Output Only] Calculation of the complexity of a single firewall policy rule.
         */
        ruleTupleCount?: number | null;
        /**
         * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
         */
        targetResources?: string[] | null;
        /**
         * A list of secure labels that controls which instances the firewall rule applies to. If targetSecureLabel are specified, then the firewall rule applies only to instances in the VPC network that have one of those secure labels. targetSecureLabel may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureLabel are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label values allowed is 256.
         */
        targetSecureLabels?: string[] | null;
        /**
         * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
         */
        targetSecureTags?: Schema$FirewallPolicyRuleSecureTag[];
        /**
         * A list of service accounts indicating the sets of instances that are applied with this rule.
         */
        targetServiceAccounts?: string[] | null;
    }
    /**
     * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
     */
    export interface Schema$FirewallPolicyRuleMatcher {
        /**
         * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 256.
         */
        destIpRanges?: string[] | null;
        /**
         * Pairs of IP protocols and ports that the rule should match.
         */
        layer4Configs?: Schema$FirewallPolicyRuleMatcherLayer4Config[];
        /**
         * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 256.
         */
        srcIpRanges?: string[] | null;
        /**
         * List of firewall label values, which should be matched at the source of the traffic. Maximum number of source label values allowed is 256.
         */
        srcSecureLabels?: string[] | null;
        /**
         * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
         */
        srcSecureTags?: Schema$FirewallPolicyRuleSecureTag[];
    }
    export interface Schema$FirewallPolicyRuleMatcherLayer4Config {
        /**
         * The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
         */
        ipProtocol?: string | null;
        /**
         * An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port.
         *
         * Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
         */
        ports?: string[] | null;
    }
    export interface Schema$FirewallPolicyRuleSecureTag {
        /**
         * Name of the secure tag, created with TagManager's TagValue API.
         */
        name?: string | null;
        /**
         * [Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.
         */
        state?: string | null;
    }
    /**
     * Encapsulates numeric value that can be either absolute or relative.
     */
    export interface Schema$FixedOrPercent {
        /**
         * [Output Only] Absolute value of VM instances calculated based on the specific mode.
         *
         *
         * - If the value is fixed, then the calculated value is equal to the fixed value.
         * - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded up.
         */
        calculated?: number | null;
        /**
         * Specifies a fixed number of VM instances. This must be a positive integer.
         */
        fixed?: number | null;
        /**
         * Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
         */
        percent?: number | null;
    }
    /**
     * Represents a Forwarding Rule resource.
     *
     * Forwarding rule resources in GCP can be either regional or global in scope:
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/globalForwardingRules) * [Regional](/compute/docs/reference/rest/{$api_version\}/forwardingRules)
     *
     * A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud Platform load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway).
     *
     * For more information, read Forwarding rule concepts and Using protocol forwarding.
     *
     * (== resource_for {$api_version\}.forwardingRules ==) (== resource_for {$api_version\}.globalForwardingRules ==) (== resource_for {$api_version\}.regionForwardingRules ==)
     */
    export interface Schema$ForwardingRule {
        /**
         * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
         */
        allowGlobalAccess?: boolean | null;
        /**
         * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.
         *
         * When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
         */
        allPorts?: boolean | null;
        /**
         * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
         */
        backendService?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.
         *
         * To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.
         *
         * If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:
         *
         * * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:
         * - projects/project_id/regions/region/addresses/address-name
         * - regions/region/addresses/address-name
         * - global/addresses/address-name
         * - address-name
         *
         * The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
         *
         * Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.
         *
         * For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
         */
        IPAddress?: string | null;
        /**
         * The IP protocol to which this rule applies.
         *
         * For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
         *
         * The valid IP protocols are different for different load balancing products:
         * - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
         * - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.
         * - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid.
         * - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid.
         * - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
         */
        IPProtocol?: string | null;
        /**
         * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
         */
        ipVersion?: string | null;
        /**
         * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
         */
        isMirroringCollector?: boolean | null;
        /**
         * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Specifies the forwarding rule type.
         *
         *
         * - EXTERNAL is used for:
         * - Classic Cloud VPN gateways
         * - Protocol forwarding to VMs from an external IP address
         * - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
         * - INTERNAL is used for:
         * - Protocol forwarding to VMs from an internal IP address
         * - Internal TCP/UDP Load Balancing
         * - INTERNAL_MANAGED is used for:
         * - Internal HTTP(S) Load Balancing
         * - INTERNAL_SELF_MANAGED is used for:
         * - Traffic Director
         *
         * For more information about forwarding rules, refer to Forwarding rule concepts.
         */
        loadBalancingScheme?: string | null;
        /**
         * Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
         * For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
         * metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
         * metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         */
        metadataFilters?: Schema$MetadataFilter[];
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * This field is not used for external load balancing.
         *
         * For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
         *
         * For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
         */
        network?: string | null;
        /**
         * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
         *
         * For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
         *
         * If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
         */
        networkTier?: string | null;
        /**
         * This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.
         *
         * Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
         *
         * Some types of forwarding target have constraints on the acceptable ports:
         * - TargetHttpProxy: 80, 8080
         * - TargetHttpsProxy: 443
         * - TargetGrpcProxy: no constraints
         * - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
         * - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
         * - TargetVpnGateway: 500, 4500
         */
        portRange?: string | null;
        /**
         * The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.
         *
         * You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.
         *
         * You can specify a list of up to five ports, which can be non-contiguous.
         *
         * For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.
         *
         * For more information, see [Port specifications](/load-balancing/docs/forwarding-rule-concepts#port_specifications).
         */
        ports?: string[] | null;
        /**
         * [Output Only] The PSC connection id of the PSC Forwarding Rule.
         */
        pscConnectionId?: string | null;
        pscConnectionStatus?: string | null;
        /**
         * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
         *
         * It is only supported for Internal TCP/UDP Load Balancing and Internal HTTP(S) Load Balancing.
         */
        serviceDirectoryRegistrations?: Schema$ForwardingRuleServiceDirectoryRegistration[];
        /**
         * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.
         *
         * The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         *
         * This field is only used for internal load balancing.
         */
        serviceLabel?: string | null;
        /**
         * [Output Only] The internal fully qualified service name for this Forwarding Rule.
         *
         * This field is only used for internal load balancing.
         */
        serviceName?: string | null;
        /**
         * This field is only used for internal load balancing.
         *
         * For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.
         *
         * If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
         */
        subnetwork?: string | null;
        target?: string | null;
    }
    export interface Schema$ForwardingRuleAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ForwardingRulesScopedList resources.
         */
        items?: {
            [key: string]: Schema$ForwardingRulesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#forwardingRuleAggregatedList for lists of forwarding rules.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of ForwardingRule resources.
     */
    export interface Schema$ForwardingRuleList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ForwardingRule resources.
         */
        items?: Schema$ForwardingRule[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$ForwardingRuleReference {
        forwardingRule?: string | null;
    }
    /**
     * Describes the auto-registration of the Forwarding Rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this Forwarding Rule.
     */
    export interface Schema$ForwardingRuleServiceDirectoryRegistration {
        /**
         * Service Directory namespace to register the forwarding rule under.
         */
        namespace?: string | null;
        /**
         * Service Directory service to register the forwarding rule under.
         */
        service?: string | null;
        /**
         * [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.
         */
        serviceDirectoryRegion?: string | null;
    }
    export interface Schema$ForwardingRulesScopedList {
        /**
         * A list of forwarding rules contained in this scope.
         */
        forwardingRules?: Schema$ForwardingRule[];
        /**
         * Informational warning which replaces the list of forwarding rules when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$GetOwnerInstanceResponse {
        /**
         * Full instance resource URL.
         */
        instance?: string | null;
    }
    export interface Schema$GlobalNetworkEndpointGroupsAttachEndpointsRequest {
        /**
         * The list of network endpoints to be attached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$GlobalNetworkEndpointGroupsDetachEndpointsRequest {
        /**
         * The list of network endpoints to be detached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$GlobalOrganizationSetPolicyRequest {
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
         */
        etag?: string | null;
        /**
         * REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    export interface Schema$GlobalSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string | null;
        /**
         * A list of labels to apply for this resource. Each label key & value must comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For example, "webserver-frontend": "images". A label value can also be empty (e.g. "my-label": "").
         */
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GlobalSetPolicyRequest {
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
         */
        etag?: string | null;
        /**
         * REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    export interface Schema$GRPCHealthCheck {
        /**
         * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention:
         * - Empty service_name means the overall status of all services at the backend.
         * - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service.
         * The grpc_service_name can only be ASCII.
         */
        grpcServiceName?: string | null;
        /**
         * The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.
         */
        portName?: string | null;
        /**
         * Specifies how port is selected for health checking, can be one of following values:
         * USE_FIXED_PORT: The port number in port is used for health checking.
         * USE_NAMED_PORT: The portName is used for health checking.
         * USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
         *
         *
         * If not specified, gRPC health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string | null;
    }
    /**
     * [Deprecated] gRPC config to access the SDS server. gRPC config to access the SDS server.
     */
    export interface Schema$GrpcServiceConfig {
        /**
         * The call credentials to access the SDS server.
         */
        callCredentials?: Schema$CallCredentials;
        /**
         * The channel credentials to access the SDS server.
         */
        channelCredentials?: Schema$ChannelCredentials;
        /**
         * The target URI of the SDS server.
         */
        targetUri?: string | null;
    }
    /**
     * A guest attributes entry.
     */
    export interface Schema$GuestAttributes {
        /**
         * [Output Only] Type of the resource. Always compute#guestAttributes for guest attributes entry.
         */
        kind?: string | null;
        /**
         * The path to be queried. This can be the default namespace ('/') or a nested namespace ('/\/') or a specified key ('/\/\')
         */
        queryPath?: string | null;
        /**
         * [Output Only] The value of the requested queried path.
         */
        queryValue?: Schema$GuestAttributesValue;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * The key to search for.
         */
        variableKey?: string | null;
        /**
         * [Output Only] The value found for the requested key.
         */
        variableValue?: string | null;
    }
    /**
     * A guest attributes namespace/key/value entry.
     */
    export interface Schema$GuestAttributesEntry {
        /**
         * Key for the guest attribute entry.
         */
        key?: string | null;
        /**
         * Namespace for the guest attribute entry.
         */
        namespace?: string | null;
        /**
         * Value for the guest attribute entry.
         */
        value?: string | null;
    }
    /**
     * Array of guest attribute namespace/key/value tuples.
     */
    export interface Schema$GuestAttributesValue {
        items?: Schema$GuestAttributesEntry[];
    }
    /**
     * Guest OS features.
     */
    export interface Schema$GuestOsFeature {
        /**
         * The ID of a supported feature. Read  Enabling guest operating system features to see a list of available options.
         */
        type?: string | null;
    }
    /**
     * Represents a Health Check resource.
     *
     * Google Compute Engine has two Health Check resources:
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/healthChecks) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionHealthChecks)
     *
     * Internal HTTP(S) load balancers must use regional health checks (`compute.v1.regionHealthChecks`).
     *
     * Traffic Director must use global health checks (`compute.v1.HealthChecks`).
     *
     * Internal TCP/UDP load balancers can use either regional or global health checks (`compute.v1.regionHealthChecks` or `compute.v1.HealthChecks`).
     *
     * External HTTP(S), TCP proxy, and SSL proxy load balancers as well as managed instance group auto-healing must use global health checks (`compute.v1.HealthChecks`).
     *
     * Network load balancers must use legacy HTTP health checks (httpHealthChecks).
     *
     * For more information, see Health checks overview.
     */
    export interface Schema$HealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number | null;
        /**
         * [Output Only] Creation timestamp in 3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        grpcHealthCheck?: Schema$GRPCHealthCheck;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number | null;
        http2HealthCheck?: Schema$HTTP2HealthCheck;
        httpHealthCheck?: Schema$HTTPHealthCheck;
        httpsHealthCheck?: Schema$HTTPSHealthCheck;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Type of the resource.
         */
        kind?: string | null;
        /**
         * Configure logging on this health check.
         */
        logConfig?: Schema$HealthCheckLogConfig;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Region where the health check resides. Not applicable to global health checks.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        sslHealthCheck?: Schema$SSLHealthCheck;
        tcpHealthCheck?: Schema$TCPHealthCheck;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
         */
        timeoutSec?: number | null;
        /**
         * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2. If not specified, the default is TCP. Exactly one of the protocol-specific health check field must be specified, which must match type field.
         */
        type?: string | null;
        udpHealthCheck?: Schema$UDPHealthCheck;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number | null;
    }
    /**
     * Contains a list of HealthCheck resources.
     */
    export interface Schema$HealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthCheck resources.
         */
        items?: Schema$HealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
     */
    export interface Schema$HealthCheckLogConfig {
        /**
         * Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
         */
        enable?: boolean | null;
    }
    /**
     * A full or valid partial URL to a health check. For example, the following are valid URLs:
     * - https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check
     * - projects/project-id/global/httpHealthChecks/health-check
     * - global/httpHealthChecks/health-check
     */
    export interface Schema$HealthCheckReference {
        healthCheck?: string | null;
    }
    export interface Schema$HealthChecksAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthChecksScopedList resources.
         */
        items?: {
            [key: string]: Schema$HealthChecksScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Health-Check as a Service resource.
     *
     * (== resource_for {$api_version\}.regionHealthCheckServices ==)
     */
    export interface Schema$HealthCheckService {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthCheckService. An up-to-date fingerprint must be provided in order to patch/update the HealthCheckService; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthCheckService.
         */
        fingerprint?: string | null;
        /**
         * List of URLs to the HealthCheck resources. Must have at least one HealthCheck, and not more than 10. HealthCheck resources must have portSpecification=USE_SERVING_PORT. For regional HealthCheckService, the HealthCheck must be regional and in the same region. For global HealthCheckService, HealthCheck must be global. Mix of regional and global HealthChecks is not supported. Multiple regional HealthChecks must belong to the same region. Regional HealthChecks</code? must belong to the same region as zones of NEGs.
         */
        healthChecks?: string[] | null;
        /**
         * Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified.
         * - NO_AGGREGATION. An EndpointHealth message is returned for each backend in the health check service.
         * - AND. If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY. .
         */
        healthStatusAggregationPolicy?: string | null;
        /**
         * This field is deprecated. Use health_status_aggregation_policy instead.
         *
         * Policy for how the results from multiple health checks for the same endpoint are aggregated.
         * - NO_AGGREGATION. An EndpointHealth message is returned for each backend in the health check service.
         * - AND. If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY. .
         */
        healthStatusAggregationStrategy?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#healthCheckServicefor health check services.
         */
        kind?: string | null;
        /**
         * Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * List of URLs to the NetworkEndpointGroup resources. Must not have more than 100. For regional HealthCheckService, NEGs must be in zones in the region of the HealthCheckService.
         */
        networkEndpointGroups?: string[] | null;
        /**
         * List of URLs to the NotificationEndpoint resources. Must not have more than 10. A list of endpoints for receiving notifications of change in health status. For regional HealthCheckService, NotificationEndpoint must be regional and in the same region. For global HealthCheckService, NotificationEndpoint must be global.
         */
        notificationEndpoints?: string[] | null;
        /**
         * [Output Only] URL of the region where the health check service resides. This field is not applicable to global health check services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Contains a list of HealthCheckServicesScopedList.
     */
    export interface Schema$HealthCheckServiceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthCheckServicesScopedList resources.
         */
        items?: {
            [key: string]: Schema$HealthCheckServicesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A full or valid partial URL to a health check service. For example, the following are valid URLs:
     * - https://www.googleapis.com/compute/beta/projects/project-id/regions/us-west1/healthCheckServices/health-check-service
     * - projects/project-id/regions/us-west1/healthCheckServices/health-check-service
     * - regions/us-west1/healthCheckServices/health-check-service
     */
    export interface Schema$HealthCheckServiceReference {
        healthCheckService?: string | null;
    }
    export interface Schema$HealthCheckServicesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HealthCheckService resources.
         */
        items?: Schema$HealthCheckService[];
        /**
         * [Output Only] Type of the resource. Always compute#healthCheckServicesList for lists of HealthCheckServices.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthCheckServicesScopedList {
        /**
         * A list of HealthCheckServices contained in this scope.
         */
        resources?: Schema$HealthCheckService[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthChecksScopedList {
        /**
         * A list of HealthChecks contained in this scope.
         */
        healthChecks?: Schema$HealthCheck[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$HealthStatus {
        /**
         * Metadata defined as annotations for network endpoint.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * URL of the forwarding rule associated with the health status of the instance.
         */
        forwardingRule?: string | null;
        /**
         * A forwarding rule IP address assigned to this instance.
         */
        forwardingRuleIp?: string | null;
        /**
         * Health state of the instance.
         */
        healthState?: string | null;
        /**
         * URL of the instance resource.
         */
        instance?: string | null;
        /**
         * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
         */
        ipAddress?: string | null;
        /**
         * The named port of the instance group, not necessarily the port that is health-checked.
         */
        port?: number | null;
        weight?: string | null;
        weightError?: string | null;
    }
    export interface Schema$HealthStatusForNetworkEndpoint {
        /**
         * URL of the backend service associated with the health state of the network endpoint.
         */
        backendService?: Schema$BackendServiceReference;
        /**
         * URL of the forwarding rule associated with the health state of the network endpoint.
         */
        forwardingRule?: Schema$ForwardingRuleReference;
        /**
         * URL of the health check associated with the health state of the network endpoint.
         */
        healthCheck?: Schema$HealthCheckReference;
        /**
         * URL of the health check service associated with the health state of the network endpoint.
         */
        healthCheckService?: Schema$HealthCheckServiceReference;
        /**
         * Health state of the network endpoint determined based on the health checks configured.
         */
        healthState?: string | null;
    }
    /**
     * UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
     */
    export interface Schema$HostRule {
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in the pattern by either - or ..
         * * based matching is not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        hosts?: string[] | null;
        /**
         * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
         */
        pathMatcher?: string | null;
    }
    export interface Schema$HTTP2HealthCheck {
        /**
         * The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
         */
        host?: string | null;
        /**
         * The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string | null;
        /**
         * Specifies how port is selected for health checking, can be one of following values:
         * USE_FIXED_PORT: The port number in port is used for health checking.
         * USE_NAMED_PORT: The portName is used for health checking.
         * USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
         *
         *
         * If not specified, HTTP2 health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The request path of the HTTP/2 health check request. The default value is /.
         */
        requestPath?: string | null;
        /**
         * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
         */
        response?: string | null;
        /**
         * Weight report mode. used for weighted Load Balancing.
         */
        weightReportMode?: string | null;
    }
    /**
     * Specification for how requests are aborted as part of fault injection.
     */
    export interface Schema$HttpFaultAbort {
        /**
         * The HTTP status code used to abort the request.
         * The value must be between 200 and 599 inclusive.
         */
        httpStatus?: number | null;
        /**
         * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
         * The value must be between 0.0 and 100.0 inclusive.
         */
        percentage?: number | null;
    }
    /**
     * Specifies the delay introduced by Loadbalancer before forwarding the request to the backend service as part of fault injection.
     */
    export interface Schema$HttpFaultDelay {
        /**
         * Specifies the value of the fixed delay interval.
         */
        fixedDelay?: Schema$Duration;
        /**
         * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
         * The value must be between 0.0 and 100.0 inclusive.
         */
        percentage?: number | null;
    }
    /**
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by Loadbalancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the Loadbalancer for a percentage of requests.
     */
    export interface Schema$HttpFaultInjection {
        /**
         * The specification for how client requests are aborted as part of fault injection.
         */
        abort?: Schema$HttpFaultAbort;
        /**
         * The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
         */
        delay?: Schema$HttpFaultDelay;
    }
    /**
     * HttpFilterConfiguration supplies additional contextual settings for networkservices.HttpFilter resources enabled by Traffic Director.
     */
    export interface Schema$HttpFilterConfig {
        /**
         * The configuration needed to enable the networkservices.HttpFilter resource. The configuration must be YAML formatted and only contain fields defined in the protobuf identified in configTypeUrl
         */
        config?: string | null;
        /**
         * The fully qualified versioned proto3 type url of the protobuf that the filter expects for its contextual settings, for example: type.googleapis.com/google.protobuf.Struct
         */
        configTypeUrl?: string | null;
        /**
         * Name of the networkservices.HttpFilter resource this configuration belongs to. This name must be known to the xDS client. Example: envoy.wasm
         */
        filterName?: string | null;
    }
    /**
     * The request and response header transformations that take effect before the request is passed along to the selected backendService.
     */
    export interface Schema$HttpHeaderAction {
        /**
         * Headers to add to a matching request prior to forwarding the request to the backendService.
         */
        requestHeadersToAdd?: Schema$HttpHeaderOption[];
        /**
         * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
         */
        requestHeadersToRemove?: string[] | null;
        /**
         * Headers to add the response prior to sending the response back to the client.
         */
        responseHeadersToAdd?: Schema$HttpHeaderOption[];
        /**
         * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
         */
        responseHeadersToRemove?: string[] | null;
    }
    /**
     * matchRule criteria for request header matches.
     */
    export interface Schema$HttpHeaderMatch {
        /**
         * The value should exactly match contents of exactMatch.
         * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        exactMatch?: string | null;
        /**
         * The name of the HTTP header to match.
         * For matching against the HTTP request's authority, use a headerMatch with the header name ":authority".
         * For matching a request's method, use the headerName ":method".
         * When the URL map is bound to target gRPC proxy that has validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin.
         */
        headerName?: string | null;
        /**
         * If set to false, the headerMatch is considered a match if the match criteria above are met. If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
         * The default setting is false.
         */
        invertMatch?: boolean | null;
        /**
         * The value of the header must start with the contents of prefixMatch.
         * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        prefixMatch?: string | null;
        /**
         * A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value.
         * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        presentMatch?: boolean | null;
        /**
         * The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails.
         * For example for a range [-5, 0]
         * - -3 will match.
         * - 0 will not match.
         * - 0.25 will not match.
         * - -3someString will not match.
         * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         * Note that rangeMatch is not supported for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
         */
        rangeMatch?: Schema$Int64RangeMatch;
        /**
         * The value of the header must match the regular expression specified in regexMatch. For regular expression grammar, please see:  github.com/google/re2/wiki/Syntax
         * For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier.
         * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         * Note that regexMatch only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         */
        regexMatch?: string | null;
        /**
         * The value of the header must end with the contents of suffixMatch.
         * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
         */
        suffixMatch?: string | null;
    }
    /**
     * Specification determining how headers are added to requests or responses.
     */
    export interface Schema$HttpHeaderOption {
        /**
         * The name of the header.
         */
        headerName?: string | null;
        /**
         * The value of the header to add.
         */
        headerValue?: string | null;
        /**
         * If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header.
         * The default value is false.
         */
        replace?: boolean | null;
    }
    export interface Schema$HTTPHealthCheck {
        /**
         * The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
         */
        host?: string | null;
        /**
         * The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string | null;
        /**
         * Specifies how port is selected for health checking, can be one of following values:
         * USE_FIXED_PORT: The port number in port is used for health checking.
         * USE_NAMED_PORT: The portName is used for health checking.
         * USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
         *
         *
         * If not specified, HTTP health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The request path of the HTTP health check request. The default value is /.
         */
        requestPath?: string | null;
        /**
         * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
         */
        response?: string | null;
        /**
         * Weight report mode. used for weighted Load Balancing.
         */
        weightReportMode?: string | null;
    }
    /**
     * Represents a legacy HTTP Health Check resource.
     *
     * Legacy health checks are required by network load balancers. For more information, read Health Check Concepts.
     */
    export interface Schema$HttpHealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number | null;
        /**
         * The value of the host header in the HTTP health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.
         */
        host?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#httpHealthCheck for HTTP health checks.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The TCP port number for the HTTP health check request. The default value is 80.
         */
        port?: number | null;
        /**
         * The request path of the HTTP health check request. The default value is /. This field does not support query parameters.
         */
        requestPath?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
         */
        timeoutSec?: number | null;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number | null;
    }
    /**
     * Contains a list of HttpHealthCheck resources.
     */
    export interface Schema$HttpHealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HttpHealthCheck resources.
         */
        items?: Schema$HttpHealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * HttpRouteRuleMatch criteria for a request's query parameter.
     */
    export interface Schema$HttpQueryParameterMatch {
        /**
         * The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
         * Only one of presentMatch, exactMatch or regexMatch must be set.
         */
        exactMatch?: string | null;
        /**
         * The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
         */
        name?: string | null;
        /**
         * Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
         * Only one of presentMatch, exactMatch or regexMatch must be set.
         */
        presentMatch?: boolean | null;
        /**
         * The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For the regular expression grammar, please see github.com/google/re2/wiki/Syntax
         * Only one of presentMatch, exactMatch or regexMatch must be set.
         * Note that regexMatch only applies when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
         */
        regexMatch?: string | null;
    }
    /**
     * Specifies settings for an HTTP redirect.
     */
    export interface Schema$HttpRedirectAction {
        /**
         * The host that will be used in the redirect response instead of the one that was supplied in the request.
         * The value must be between 1 and 255 characters.
         */
        hostRedirect?: string | null;
        /**
         * If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
         * This must only be set for UrlMaps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted.
         * The default is set to false.
         */
        httpsRedirect?: boolean | null;
        /**
         * The path that will be used in the redirect response instead of the one that was supplied in the request.
         * pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
         * The value must be between 1 and 1024 characters.
         */
        pathRedirect?: string | null;
        /**
         * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
         * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
         * The value must be between 1 and 1024 characters.
         */
        prefixRedirect?: string | null;
        /**
         * The HTTP Status code to use for this RedirectAction.
         * Supported values are:
         * - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
         * - FOUND, which corresponds to 302.
         * - SEE_OTHER which corresponds to 303.
         * - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
         * - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
         */
        redirectResponseCode?: string | null;
        /**
         * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
         * The default is set to false.
         */
        stripQuery?: boolean | null;
    }
    /**
     * The retry policy associates with HttpRouteRule
     */
    export interface Schema$HttpRetryPolicy {
        /**
         * Specifies the allowed number retries. This number must be \> 0. If not specified, defaults to 1.
         */
        numRetries?: number | null;
        /**
         * Specifies a non-zero timeout per retry attempt.
         * If not specified, will use the timeout set in HttpRouteAction. If timeout in HttpRouteAction is not set, will use the largest timeout among all backend services associated with the route.
         */
        perTryTimeout?: Schema$Duration;
        /**
         * Specfies one or more conditions when this retry rule applies. Valid values are:
         * - 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code, or if the backend service does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
         * - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
         * -
         * - connect-failure: Loadbalancer will retry on failures connecting to backend services, for example due to connection timeouts.
         * - retriable-4xx: Loadbalancer will retry for retriable 4xx response codes. Currently the only retriable error supported is 409.
         * - refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
         * - cancelledLoadbalancer will retry if the gRPC status code in the response header is set to cancelled
         * - deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
         * - resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
         * - unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
         */
        retryConditions?: string[] | null;
    }
    export interface Schema$HttpRouteAction {
        /**
         * The specification for allowing client side cross-origin requests. Please see W3C Recommendation for Cross Origin Resource Sharing
         * Not supported when the URL map is bound to target gRPC proxy.
         */
        corsPolicy?: Schema$CorsPolicy;
        /**
         * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by Loadbalancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the Loadbalancer for a percentage of requests.
         * timeout and retry_policy will be ignored by clients that are configured with a fault_injection_policy.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        faultInjectionPolicy?: Schema$HttpFaultInjection;
        /**
         * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (i.e. end-of-stream), the duration in this field is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
         * If not specified, will use the largest maxStreamDuration among all backend services associated with the route.
         * This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         */
        maxStreamDuration?: Schema$Duration;
        /**
         * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. Loadbalancer does not wait for responses from the shadow service. Prior to sending traffic to the shadow service, the host / authority header is suffixed with -shadow.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        requestMirrorPolicy?: Schema$RequestMirrorPolicy;
        /**
         * Specifies the retry policy associated with this route.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        retryPolicy?: Schema$HttpRetryPolicy;
        /**
         * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (i.e. end-of-stream) up until the response has been completely processed. Timeout includes all retries.
         * If not specified, will use the largest timeout among all backend services associated with the route.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        timeout?: Schema$Duration;
        /**
         * The spec to modify the URL of the request, prior to forwarding the request to the matched service.
         * urlRewrite is the only action supported in UrlMaps for external HTTP(S) load balancers.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        urlRewrite?: Schema$UrlRewrite;
        /**
         * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one  weightedBackendService with weight set to a non-zero number.
         * Once a backendService is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
         */
        weightedBackendServices?: Schema$WeightedBackendService[];
    }
    /**
     * An HttpRouteRule specifies how to match an HTTP request and the corresponding routing action that load balancing proxies will perform.
     */
    export interface Schema$HttpRouteRule {
        /**
         * The short description conveying the intent of this routeRule.
         * The description can have a maximum length of 1024 characters.
         */
        description?: string | null;
        /**
         * Specifies changes to request and response headers that need to take effect for the selected backendService.
         * The headerAction specified here are applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction
         * Note that headerAction is not supported for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        headerAction?: Schema$HttpHeaderAction;
        /**
         * Outbound route specific configuration for networkservices.HttpFilter resources enabled by Traffic Director. httpFilterConfigs only applies for Loadbalancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        httpFilterConfigs?: Schema$HttpFilterConfig[];
        /**
         * Outbound route specific metadata supplied to networkservices.HttpFilter resources enabled by Traffic Director. httpFilterMetadata only applies for Loadbalancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details.
         * The only configTypeUrl supported is type.googleapis.com/google.protobuf.Struct
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        httpFilterMetadata?: Schema$HttpFilterConfig[];
        /**
         * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
         */
        matchRules?: Schema$HttpRouteRuleMatch[];
        /**
         * For routeRules within a given pathMatcher, priority determines the order in which load balancer will interpret routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied.
         * You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 0 and 2147483647 inclusive.
         * Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
         */
        priority?: number | null;
        /**
         * In response to a matching matchRule, the load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If  routeAction specifies any  weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any  weightedBackendServices.
         * Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
         * UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a routeRule's routeAction.
         */
        routeAction?: Schema$HttpRouteAction;
        /**
         * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any  weightedBackendServices, service must not be specified.
         * Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
         */
        service?: string | null;
        /**
         * When this rule is matched, the request is redirected to a URL specified by urlRedirect.
         * If urlRedirect is specified, service or routeAction must not be set.
         * Not supported when the URL map is bound to target gRPC proxy.
         */
        urlRedirect?: Schema$HttpRedirectAction;
    }
    /**
     * HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
     */
    export interface Schema$HttpRouteRuleMatch {
        /**
         * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
         * fullPathMatch must be between 1 and 1024 characters.
         * Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
         */
        fullPathMatch?: string | null;
        /**
         * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
         */
        headerMatches?: Schema$HttpHeaderMatch[];
        /**
         * Specifies that prefixMatch and fullPathMatch matches are case sensitive.
         * The default value is false.
         * ignoreCase must not be used with regexMatch.
         * Not supported when the URL map is bound to target gRPC proxy.
         */
        ignoreCase?: boolean | null;
        /**
         * Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies.
         * For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
         * metadataFilters specified here will be applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to.
         * metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        metadataFilters?: Schema$MetadataFilter[];
        /**
         * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /.
         * The value must be between 1 and 1024 characters.
         * Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
         */
        prefixMatch?: string | null;
        /**
         * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request.
         * Not supported when the URL map is bound to target gRPC proxy.
         */
        queryParameterMatches?: Schema$HttpQueryParameterMatch[];
        /**
         * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For regular expression grammar please see github.com/google/re2/wiki/Syntax
         * Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
         * Note that regexMatch only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         */
        regexMatch?: string | null;
    }
    export interface Schema$HTTPSHealthCheck {
        /**
         * The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
         */
        host?: string | null;
        /**
         * The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string | null;
        /**
         * Specifies how port is selected for health checking, can be one of following values:
         * USE_FIXED_PORT: The port number in port is used for health checking.
         * USE_NAMED_PORT: The portName is used for health checking.
         * USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
         *
         *
         * If not specified, HTTPS health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The request path of the HTTPS health check request. The default value is /.
         */
        requestPath?: string | null;
        /**
         * The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
         */
        response?: string | null;
        /**
         * Weight report mode. used for weighted Load Balancing.
         */
        weightReportMode?: string | null;
    }
    /**
     * Represents a legacy HTTPS Health Check resource.
     *
     * Legacy health checks are required by network load balancers. For more information, read Health Check Concepts.
     */
    export interface Schema$HttpsHealthCheck {
        /**
         * How often (in seconds) to send a health check. The default value is 5 seconds.
         */
        checkIntervalSec?: number | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
         */
        healthyThreshold?: number | null;
        /**
         * The value of the host header in the HTTPS health check request. If left empty (default value), the public IP on behalf of which this health check is performed will be used.
         */
        host?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Type of the resource.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The TCP port number for the HTTPS health check request. The default value is 443.
         */
        port?: number | null;
        /**
         * The request path of the HTTPS health check request. The default value is "/".
         */
        requestPath?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have a greater value than checkIntervalSec.
         */
        timeoutSec?: number | null;
        /**
         * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
         */
        unhealthyThreshold?: number | null;
    }
    /**
     * Contains a list of HttpsHealthCheck resources.
     */
    export interface Schema$HttpsHealthCheckList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of HttpsHealthCheck resources.
         */
        items?: Schema$HttpsHealthCheck[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Image resource.
     *
     * You can use images to create boot disks for your VM instances. For more information, read Images. (== resource_for {$api_version\}.images ==)
     */
    export interface Schema$Image {
        /**
         * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
         */
        archiveSizeBytes?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * The deprecation status associated with this image.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Size of the image when restored onto a persistent disk (in GB).
         */
        diskSizeGb?: string | null;
        /**
         * The name of the image family to which this image belongs. You can create disks by specifying an image family instead of a specific image name. The image family always returns its latest image that is not deprecated. The name of the image family must comply with RFC1035.
         */
        family?: string | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Encrypts the image using a customer-supplied encryption key.
         *
         * After you encrypt an image with a customer-supplied key, you must provide the same key if you use the image later (e.g. to create a disk from the image).
         *
         * Customer-supplied encryption keys do not protect access to metadata of the disk.
         *
         * If you do not provide an encryption key when creating the image, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the image later.
         */
        imageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] Type of the resource. Always compute#image for images.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this image, which is essentially a hash of the labels used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an image.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this image. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Integer license codes indicating which licenses are attached to this image.
         */
        licenseCodes?: string[] | null;
        /**
         * Any applicable license URI.
         */
        licenses?: string[] | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The parameters of the raw disk image.
         */
        rawDisk?: {
            containerType?: string;
            sha1Checksum?: string;
            source?: string;
        } | null;
        /**
         * A rollout policy to apply to this image. When specified, the rollout policy overrides per-zone references to the image via the associated image family. The rollout policy restricts the zones where this image is accessible when using a zonal image family reference. When the rollout policy does not include the user specified zone, or if the zone is rolled out, this image is accessible.
         */
        rolloutOverride?: Schema$RolloutPolicy;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Set the secure boot keys of shielded instance.
         */
        shieldedInstanceInitialState?: Schema$InitialStateConfig;
        /**
         * URL of the source disk used to create this image. This can be a full or valid partial URL. You must provide either this property or the rawDisk.source property but not both to create an image. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
         * - projects/project/zones/zone/disks/disk
         * - zones/zone/disks/disk
         */
        sourceDisk?: string | null;
        /**
         * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the disk used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string | null;
        /**
         * URL of the source image used to create this image.
         *
         * In order to create an image, you must provide the full or partial URL of one of the following:
         * - The selfLink URL
         * - This property
         * - The rawDisk.source URL
         * - The sourceDisk URL
         */
        sourceImage?: string | null;
        /**
         * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
         */
        sourceImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the image used to create this image. This value may be used to determine whether the image was taken from the current or a previous instance of a given image name.
         */
        sourceImageId?: string | null;
        /**
         * URL of the source snapshot used to create this image.
         *
         * In order to create an image, you must provide the full or partial URL of one of the following:
         * - The selfLink URL
         * - This property
         * - The sourceImage URL
         * - The rawDisk.source URL
         * - The sourceDisk URL
         */
        sourceSnapshot?: string | null;
        /**
         * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
         */
        sourceSnapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the snapshot used to create this image. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given snapshot name.
         */
        sourceSnapshotId?: string | null;
        /**
         * The type of the image used to create this disk. The default and only value is RAW
         */
        sourceType?: string | null;
        /**
         * [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
         */
        status?: string | null;
        /**
         * Cloud Storage bucket storage location of the image (regional or multi-regional).
         */
        storageLocations?: string[] | null;
    }
    export interface Schema$ImageFamilyView {
        /**
         * The latest image that is part of the specified image family in the requested location, and that is not deprecated.
         */
        image?: Schema$Image;
    }
    /**
     * Contains a list of images.
     */
    export interface Schema$ImageList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Image resources.
         */
        items?: Schema$Image[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Initial State for shielded instance, these are public keys which are safe to store in public
     */
    export interface Schema$InitialStateConfig {
        /**
         * The Key Database (db).
         */
        dbs?: Schema$FileContentBuffer[];
        /**
         * The forbidden key database (dbx).
         */
        dbxs?: Schema$FileContentBuffer[];
        /**
         * The Key Exchange Key (KEK).
         */
        keks?: Schema$FileContentBuffer[];
        /**
         * The Platform Key (PK).
         */
        pk?: Schema$FileContentBuffer;
    }
    /**
     * Represents a InPlaceSnapshot resource.
     *
     * You can use in-place snapshots to create disk rollback points quickly.. (== resource_for {$api_version\}.inPlaceSnapshots ==)
     */
    export interface Schema$InPlaceSnapshot {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Size of the source disk, specified in GB.
         */
        diskSizeGb?: string | null;
        /**
         * Specifies to create an application consistent in-place snapshot by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
         */
        guestFlush?: boolean | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#inPlaceSnapshot for InPlaceSnapshot resources.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this InPlaceSnapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a InPlaceSnapshot.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this InPlaceSnapshot. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the in-place snapshot resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * URL of the source disk used to create this in-place snapshot. Note that the source disk must be in the same zone/region as the in-place snapshot to be created. This can be a full or valid partial URL. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
         * - projects/project/zones/zone/disks/disk
         * - zones/zone/disks/disk
         */
        sourceDisk?: string | null;
        /**
         * [Output Only] The ID value of the disk used to create this InPlaceSnapshot. This value may be used to determine whether the InPlaceSnapshot was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string | null;
        /**
         * [Output Only] The status of the inPlaceSnapshot. This can be CREATING, DELETING, FAILED, or READY.
         */
        status?: string | null;
        /**
         * [Output Only] URL of the zone where the in-place snapshot resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    /**
     * Contains a list of InPlaceSnapshot resources.
     */
    export interface Schema$InPlaceSnapshotList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InPlaceSnapshot resources.
         */
        items?: Schema$InPlaceSnapshot[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Instance resource.
     *
     * An instance is a virtual machine that is hosted on Google Cloud Platform. For more information, read Virtual Machine Instances. (== resource_for {$api_version\}.instances ==)
     */
    export interface Schema$Instance {
        /**
         * Controls for advanced machine-related behavior features.
         */
        advancedMachineFeatures?: Schema$AdvancedMachineFeatures;
        /**
         * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
         */
        canIpForward?: boolean | null;
        confidentialInstanceConfig?: Schema$ConfidentialInstanceConfig;
        /**
         * [Output Only] The CPU platform used by this instance.
         */
        cpuPlatform?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Whether the resource should be protected against deletion.
         */
        deletionProtection?: boolean | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
         */
        disks?: Schema$AttachedDisk[];
        /**
         * Enables display device for the instance.
         */
        displayDevice?: Schema$DisplayDevice;
        /**
         * Specifies whether the disks restored from source snapshots or source machine image should erase Windows specific VSS signature.
         */
        eraseWindowsVssSignature?: boolean | null;
        /**
         * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance.
         *
         * To see the latest fingerprint, make get() request to the instance.
         */
        fingerprint?: string | null;
        /**
         * A list of the type and count of accelerator cards attached to the instance.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
         */
        hostname?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Encrypts or decrypts data for an instance with a customer-supplied encryption key.
         *
         * If you are creating a new instance, this field encrypts the local SSD and in-memory contents of the instance using a key that you provide.
         *
         * If you are restarting an instance protected with a customer-supplied encryption key, you must provide the correct key in order to successfully restart the instance.
         *
         * If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key and you do not need to provide a key to start the instance later.
         *
         * Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt local SSDs and in-memory content in a managed instance group.
         */
        instanceEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] Type of the resource. Always compute#instance for instances.
         */
        kind?: string | null;
        /**
         * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.
         *
         * To see the latest fingerprint, make get() request to the instance.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this instance. These can be later modified by the setLabels method.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Last start timestamp in RFC3339 text format.
         */
        lastStartTimestamp?: string | null;
        /**
         * [Output Only] Last stop timestamp in RFC3339 text format.
         */
        lastStopTimestamp?: string | null;
        /**
         * [Output Only] Last suspended timestamp in RFC3339 text format.
         */
        lastSuspendedTimestamp?: string | null;
        /**
         * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type:
         * zones/us-central1-f/machineTypes/n1-standard-1
         *
         *
         * To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
         * zones/zone/machineTypes/custom-CPUS-MEMORY
         *
         *
         * For example: zones/us-central1-f/machineTypes/custom-4-5120
         *
         * For a full list of restrictions, read the Specifications for custom machine types.
         */
        machineType?: string | null;
        /**
         * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
         */
        metadata?: Schema$Metadata;
        /**
         * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
         */
        minCpuPlatform?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
         */
        networkInterfaces?: Schema$NetworkInterface[];
        networkPerformanceConfig?: Schema$NetworkPerformanceConfig;
        /**
         * PostKeyRevocationActionType of the instance.
         */
        postKeyRevocationActionType?: string | null;
        /**
         * Total amount of preserved state for SUSPENDED instances. Read-only in the api.
         */
        preservedStateSizeGb?: string | null;
        /**
         * The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
         */
        privateIpv6GoogleAccess?: string | null;
        /**
         * Specifies the reservations that this instance can consume from.
         */
        reservationAffinity?: Schema$ReservationAffinity;
        /**
         * Resource policies applied to this instance.
         */
        resourcePolicies?: string[] | null;
        /**
         * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
         */
        resourceStatus?: Schema$ResourceStatus;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Sets the scheduling options for this instance.
         */
        scheduling?: Schema$Scheduling;
        /**
         * Secure labels to apply to this instance. These can be later modified by the update method. Maximum number of secure labels allowed is 300.
         */
        secureLabels?: string[] | null;
        /**
         * Secure tags to apply to this instance. These can be later modified by the update method. Maximum number of secure tags allowed is 300.
         */
        secureTags?: string[] | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.
         *
         * Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
         */
        serviceAccounts?: Schema$ServiceAccount[];
        shieldedInstanceConfig?: Schema$ShieldedInstanceConfig;
        shieldedInstanceIntegrityPolicy?: Schema$ShieldedInstanceIntegrityPolicy;
        /**
         * Deprecating, please use shielded_instance_config.
         */
        shieldedVmConfig?: Schema$ShieldedVmConfig;
        /**
         * Deprecating, please use shielded_instance_integrity_policy.
         */
        shieldedVmIntegrityPolicy?: Schema$ShieldedVmIntegrityPolicy;
        /**
         * Source machine image
         */
        sourceMachineImage?: string | null;
        /**
         * Source machine image encryption key when creating an instance from a machine image.
         */
        sourceMachineImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
         */
        startRestricted?: boolean | null;
        /**
         * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
         */
        status?: string | null;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string | null;
        /**
         * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
         */
        tags?: Schema$Tags;
        /**
         * [Output Only] Specifies upcoming maintenance for the instance.
         */
        upcomingMaintenance?: Schema$UpcomingMaintenance;
        /**
         * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$InstanceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * An object that contains a list of instances scoped by zone.
         */
        items?: {
            [key: string]: Schema$InstancesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#instanceAggregatedList for aggregated lists of Instance resources.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Instance Group resource.
     *
     * Instance Groups can be used to configure a target for load balancing.
     *
     * Instance groups can either be managed or unmanaged.
     *
     * To create  managed instance groups, use the instanceGroupManager or regionInstanceGroupManager resource instead.
     *
     * Use zonal unmanaged instance groups if you need to apply load balancing to groups of heterogeneous instances or if you need to manage the instances yourself. You cannot create regional unmanaged instance groups.
     *
     * For more information, read Instance groups.
     *
     * (== resource_for {$api_version\}.instanceGroups ==) (== resource_for {$api_version\}.regionInstanceGroups ==)
     */
    export interface Schema$InstanceGroup {
        /**
         * [Output Only] The creation timestamp for this instance group in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect conflicts when multiple users change the named ports concurrently.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] A unique identifier for this instance group, generated by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroup for instance groups.
         */
        kind?: string | null;
        /**
         * The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string | null;
        /**
         * Assigns a name to a port number. For example: {name: "http", port: 80\}
         *
         * This allows the system to reference ports by the assigned name instead of a port number. Named ports can also contain multiple ports. For example: [{name: "http", port: 80\},{name: "http", port: 8080\}]
         *
         * Named ports apply to all instances in this instance group.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * [Output Only] The URL of the network to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).
         */
        network?: string | null;
        /**
         * [Output Only] The URL of the region where the instance group is located (for regional resources).
         */
        region?: string | null;
        /**
         * [Output Only] The URL for this instance group. The server generates this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The total number of instances in the instance group.
         */
        size?: number | null;
        /**
         * [Output Only] The URL of the subnetwork to which all instances in the instance group belong. If your instance has multiple network interfaces, then the network and subnetwork fields only refer to the network and subnet used by your primary interface (nic0).
         */
        subnetwork?: string | null;
        /**
         * [Output Only] The URL of the zone where the instance group is located (for zonal resources).
         */
        zone?: string | null;
    }
    export interface Schema$InstanceGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstanceGroupsScopedList;
        } | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupAggregatedList for aggregated lists of instance groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A list of InstanceGroup resources.
     */
    export interface Schema$InstanceGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroup resources.
         */
        items?: Schema$InstanceGroup[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupList for instance group lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Managed Instance Group resource.
     *
     * An instance group is a collection of VM instances that you can manage as a single entity. For more information, read Instance groups.
     *
     * For zonal Managed Instance Group, use the instanceGroupManagers resource.
     *
     * For regional Managed Instance Group, use the regionInstanceGroupManagers resource. (== resource_for {$api_version\}.instanceGroupManagers ==) (== resource_for {$api_version\}.regionInstanceGroupManagers ==)
     */
    export interface Schema$InstanceGroupManager {
        /**
         * The autohealing policy for this managed instance group. You can specify only one value.
         */
        autoHealingPolicies?: Schema$InstanceGroupManagerAutoHealingPolicy[];
        /**
         * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
         */
        baseInstanceName?: string | null;
        /**
         * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
         */
        currentActions?: Schema$InstanceGroupManagerActionsSummary;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
         */
        distributionPolicy?: Schema$DistributionPolicy;
        /**
         * The action to perform in case of zone failure. Only one value is supported, NO_FAILOVER. The default is NO_FAILOVER.
         */
        failoverAction?: string | null;
        /**
         * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] The URL of the Instance Group resource.
         */
        instanceGroup?: string | null;
        /**
         * Instance lifecycle policy for this Instance Group Manager.
         */
        instanceLifecyclePolicy?: Schema$InstanceGroupManagerInstanceLifecyclePolicy;
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
         */
        instanceTemplate?: string | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
         */
        kind?: string | null;
        /**
         * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string | null;
        /**
         * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
         */
        region?: string | null;
        /**
         * [Output Only] The URL for this managed instance group. The server defines this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The service account to be used as credentials for all operations performed by the managed instance group on instances. The service accounts needs all permissions required to create and delete instances. By default, the service account {projectNumber\}@cloudservices.gserviceaccount.com is used.
         */
        serviceAccount?: string | null;
        /**
         * Stateful configuration for this Instanced Group Manager
         */
        statefulPolicy?: Schema$StatefulPolicy;
        /**
         * [Output Only] The status of this managed instance group.
         */
        status?: Schema$InstanceGroupManagerStatus;
        /**
         * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
         */
        targetPools?: string[] | null;
        /**
         * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
         */
        targetSize?: number | null;
        /**
         * The target number of stopped instances for this managed instance group. This number changes when you:
         * - Stop instance using the stopInstances method or start instances using the startInstances method.
         * - Manually change the targetStoppedSize using the update method.
         */
        targetStoppedSize?: number | null;
        /**
         * The target number of suspended instances for this managed instance group. This number changes when you:
         * - Suspend instance using the suspendInstances method or resume instances using the resumeInstances method.
         * - Manually change the targetSuspendedSize using the update method.
         */
        targetSuspendedSize?: number | null;
        /**
         * The update policy for this managed instance group.
         */
        updatePolicy?: Schema$InstanceGroupManagerUpdatePolicy;
        /**
         * Specifies the instance templates used by this managed instance group to create instances.
         *
         * Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
         */
        versions?: Schema$InstanceGroupManagerVersion[];
        /**
         * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
         */
        zone?: string | null;
    }
    export interface Schema$InstanceGroupManagerActionsSummary {
        /**
         * [Output Only] The total number of instances in the managed instance group that are scheduled to be abandoned. Abandoning an instance removes it from the managed instance group without deleting it.
         */
        abandoning?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be created or are currently being created. If the group fails to create any of these instances, it tries again until it creates the instance successfully.
         *
         * If you have disabled creation retries, this field will not be populated; instead, the creatingWithoutRetries field will be populated.
         */
        creating?: number | null;
        /**
         * [Output Only] The number of instances that the managed instance group will attempt to create. The group attempts to create each instance only once. If the group fails to create any of these instances, it decreases the group's targetSize value accordingly.
         */
        creatingWithoutRetries?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be deleted or are currently being deleted.
         */
        deleting?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are running and have no scheduled actions.
         */
        none?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be recreated or are currently being being recreated. Recreating an instance deletes the existing root persistent disk and creates a new disk from the image that is defined in the instance template.
         */
        recreating?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are being reconfigured with properties that do not require a restart or a recreate action. For example, setting or removing target pools for the instance.
         */
        refreshing?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be restarted or are currently being restarted.
         */
        restarting?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be resumed or are currently being resumed.
         */
        resuming?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be started or are currently being started.
         */
        starting?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be stopped or are currently being stopped.
         */
        stopping?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are scheduled to be suspended or are currently being suspended.
         */
        suspending?: number | null;
        /**
         * [Output Only] The number of instances in the managed instance group that are being verified. See the managedInstances[].currentAction property in the listManagedInstances method documentation.
         */
        verifying?: number | null;
    }
    export interface Schema$InstanceGroupManagerAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupManagersScopedList resources.
         */
        items?: {
            [key: string]: Schema$InstanceGroupManagersScopedList;
        } | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerAggregatedList for an aggregated list of managed instance groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupManagerAutoHealingPolicy {
        /**
         * The URL for the health check that signals autohealing.
         */
        healthCheck?: string | null;
        /**
         * The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].
         */
        initialDelaySec?: number | null;
        /**
         * Maximum number of instances that can be unavailable when autohealing. When 'percent' is used, the value is rounded UP. The instance is considered available if all of the following conditions are satisfied: 1. Instance's status is RUNNING. 2. Instance's currentAction is NONE (in particular its liveness health check result was observed to be HEALTHY at least once as it passed VERIFYING). 3. There is no outgoing action on an instance triggered by IGM.
         *
         * By default, number of concurrently autohealed instances is smaller than the managed instance group target size. However, if a zonal managed instance group has only one instance, or a regional managed instance group has only one instance per zone, autohealing will recreate these instances when they become unhealthy.
         */
        maxUnavailable?: Schema$FixedOrPercent;
    }
    export interface Schema$InstanceGroupManagerInstanceLifecyclePolicy {
        /**
         * The configuration for metadata based readiness signal sent by the instance during initialization when stopping / suspending an instance. The Instance Group Manager will wait for a signal that indicates successful initialization before stopping / suspending an instance.
         *
         * If a successful readiness signal is not sent before timeout, the corresponding instance will not be stopped / suspended. Instead, an error will be visible in the lastAttempt.errors field of the managed instance in the listmanagedinstances method.
         *
         * If metadataBasedReadinessSignal.timeoutSec is unset, the Instance Group Manager will directly proceed to suspend / stop instances, skipping initialization on them.
         */
        metadataBasedReadinessSignal?: Schema$InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal;
    }
    export interface Schema$InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal {
        /**
         * The number of seconds to wait for a readiness signal during initialization before timing out.
         */
        timeoutSec?: number | null;
    }
    /**
     * [Output Only] A list of managed instance groups.
     */
    export interface Schema$InstanceGroupManagerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupManager resources.
         */
        items?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupManagersAbandonInstancesRequest {
        /**
         * The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    /**
     * InstanceGroupManagers.applyUpdatesToInstances
     */
    export interface Schema$InstanceGroupManagersApplyUpdatesRequest {
        /**
         * Flag to update all instances instead of specified list of ?instances?. If the flag is set to true then the instances may not be specified in the request.
         */
        allInstances?: boolean | null;
        /**
         * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
        /**
         * The maximal action that should be performed on the instances. By default REPLACE. This field is deprecated, please use most_disruptive_allowed_action.
         */
        maximalAction?: string | null;
        /**
         * The minimal action that you want to perform on each instance during the update:
         * - REPLACE: At minimum, delete the instance and create it again.
         * - RESTART: Stop the instance and start it again.
         * - REFRESH: Do not stop the instance.
         * - NONE: Do not disrupt the instance at all.  By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
         */
        minimalAction?: string | null;
        /**
         * The most disruptive action that you want to perform on each instance during the update:
         * - REPLACE: Delete the instance and create it again.
         * - RESTART: Stop the instance and start it again.
         * - REFRESH: Do not stop the instance.
         * - NONE: Do not disrupt the instance at all.  By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
         */
        mostDisruptiveAllowedAction?: string | null;
    }
    /**
     * InstanceGroupManagers.createInstances
     */
    export interface Schema$InstanceGroupManagersCreateInstancesRequest {
        /**
         * [Required] List of specifications of per-instance configs.
         */
        instances?: Schema$PerInstanceConfig[];
    }
    export interface Schema$InstanceGroupManagersDeleteInstancesRequest {
        /**
         * The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    /**
     * InstanceGroupManagers.deletePerInstanceConfigs
     */
    export interface Schema$InstanceGroupManagersDeletePerInstanceConfigsReq {
        /**
         * The list of instance names for which we want to delete per-instance configs on this managed instance group.
         */
        names?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersListErrorsResponse {
        /**
         * [Output Only] The list of errors of the managed instance group.
         */
        items?: Schema$InstanceManagedByIgmError[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$InstanceGroupManagersListManagedInstancesResponse {
        /**
         * [Output Only] The list of instances in the managed instance group.
         */
        managedInstances?: Schema$ManagedInstance[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$InstanceGroupManagersListPerInstanceConfigsResp {
        /**
         * [Output Only] The list of PerInstanceConfig.
         */
        items?: Schema$PerInstanceConfig[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * InstanceGroupManagers.patchPerInstanceConfigs
     */
    export interface Schema$InstanceGroupManagersPatchPerInstanceConfigsReq {
        /**
         * The list of per-instance configs to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$InstanceGroupManagersRecreateInstancesRequest {
        /**
         * The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersResizeAdvancedRequest {
        /**
         * If this flag is true, the managed instance group attempts to create all instances initiated by this resize request only once. If there is an error during creation, the managed instance group does not retry create this instance, and we will decrease the targetSize of the request instead. If the flag is false, the group attempts to recreate each instance continuously until it succeeds.
         *
         * This flag matters only in the first attempt of creation of an instance. After an instance is successfully created while this flag is enabled, the instance behaves the same way as all the other instances created with a regular resize request. In particular, if a running instance dies unexpectedly at a later time and needs to be recreated, this mode does not affect the recreation behavior in that scenario.
         *
         * This flag is applicable only to the current resize request. It does not influence other resize requests in any way.
         *
         * You can see which instances is being creating in which mode by calling the get or listManagedInstances API.
         */
        noCreationRetries?: boolean | null;
        /**
         * The number of running instances that the managed instance group should maintain at any given time. The group automatically adds or removes instances to maintain the number of instances specified by this parameter.
         */
        targetSize?: number | null;
    }
    export interface Schema$InstanceGroupManagersResumeInstancesRequest {
        /**
         * The URLs of one or more instances to resume. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersScopedList {
        /**
         * [Output Only] The list of managed instance groups that are contained in the specified project and zone.
         */
        instanceGroupManagers?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The warning that replaces the list of managed instance groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupManagersSetAutoHealingRequest {
        autoHealingPolicies?: Schema$InstanceGroupManagerAutoHealingPolicy[];
    }
    export interface Schema$InstanceGroupManagersSetInstanceTemplateRequest {
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
         */
        instanceTemplate?: string | null;
    }
    export interface Schema$InstanceGroupManagersSetTargetPoolsRequest {
        /**
         * The fingerprint of the target pools information. Use this optional property to prevent conflicts when multiple users change the target pools settings concurrently. Obtain the fingerprint with the instanceGroupManagers.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.
         */
        fingerprint?: string | null;
        /**
         * The list of target pool URLs that instances in this managed instance group belong to. The managed instance group applies these target pools to all of the instances in the group. Existing instances and new instances in the group all receive these target pool settings.
         */
        targetPools?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersStartInstancesRequest {
        /**
         * The URLs of one or more instances to start. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersStopInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to stop the instances, skipping initialization on them.
         */
        forceStop?: boolean | null;
        /**
         * The URLs of one or more instances to stop. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagersSuspendInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to suspend the instances, skipping initialization on them.
         */
        forceSuspend?: boolean | null;
        /**
         * The URLs of one or more instances to suspend. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$InstanceGroupManagerStatus {
        /**
         * [Output Only] The URL of the Autoscaler that targets this instance group manager.
         */
        autoscaler?: string | null;
        /**
         * [Output Only] A bit indicating whether the managed instance group is in a stable state. A stable state means that: none of the instances in the managed instance group is currently undergoing any type of change (for example, creation, restart, or deletion); no future changes are scheduled for instances in the managed instance group; and the managed instance group itself is not being modified.
         */
        isStable?: boolean | null;
        /**
         * [Output Only] Stateful status of the given Instance Group Manager.
         */
        stateful?: Schema$InstanceGroupManagerStatusStateful;
        /**
         * [Output Only] A status of consistency of Instances' versions with their target version specified by version field on Instance Group Manager.
         */
        versionTarget?: Schema$InstanceGroupManagerStatusVersionTarget;
    }
    export interface Schema$InstanceGroupManagerStatusStateful {
        /**
         * [Output Only] A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful config even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions.
         */
        hasStatefulConfig?: boolean | null;
        /**
         * [Output Only] A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful config even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions. This field is deprecated in favor of has_stateful_config.
         */
        isStateful?: boolean | null;
        /**
         * [Output Only] Status of per-instance configs on the instance.
         */
        perInstanceConfigs?: Schema$InstanceGroupManagerStatusStatefulPerInstanceConfigs;
    }
    export interface Schema$InstanceGroupManagerStatusStatefulPerInstanceConfigs {
        /**
         * A bit indicating if all of the group's per-instance configs (listed in the output of a listPerInstanceConfigs API call) have status EFFECTIVE or there are no per-instance-configs.
         */
        allEffective?: boolean | null;
    }
    export interface Schema$InstanceGroupManagerStatusVersionTarget {
        /**
         * [Output Only] A bit indicating whether version target has been reached in this managed instance group, i.e. all instances are in their target version. Instances' target version are specified by version field on Instance Group Manager.
         */
        isReached?: boolean | null;
    }
    /**
     * InstanceGroupManagers.updatePerInstanceConfigs
     */
    export interface Schema$InstanceGroupManagersUpdatePerInstanceConfigsReq {
        /**
         * The list of per-instance configs to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$InstanceGroupManagerUpdatePolicy {
        /**
         * The  instance redistribution policy for regional managed instance groups. Valid values are:
         * - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region.
         * - NONE: For non-autoscaled groups, proactive redistribution is disabled.
         */
        instanceRedistributionType?: string | null;
        /**
         * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded up if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates.
         *
         * At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
         */
        maxSurge?: Schema$FixedOrPercent;
        /**
         * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied:
         *
         *
         * - The instance's status is RUNNING.
         * - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available.  This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded up if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates.
         *
         * At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
         */
        maxUnavailable?: Schema$FixedOrPercent;
        /**
         * Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
         */
        minimalAction?: string | null;
        /**
         * Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
         */
        minReadySec?: number | null;
        /**
         * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
         */
        mostDisruptiveAllowedAction?: string | null;
        /**
         * What action should be used to replace instances. See minimal_action.REPLACE
         */
        replacementMethod?: string | null;
        /**
         * The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
         */
        type?: string | null;
    }
    export interface Schema$InstanceGroupManagerVersion {
        /**
         * The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.
         */
        instanceTemplate?: string | null;
        /**
         * Name of the version. Unique among all versions in the scope of this managed instance group.
         */
        name?: string | null;
        /**
         * Tag describing the version. Used to trigger rollout of a target version even if instance_template remains unchanged. Deprecated in favor of 'name'.
         */
        tag?: string | null;
        /**
         * Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to:
         * - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used.
         * - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded up.  If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
         */
        targetSize?: Schema$FixedOrPercent;
    }
    export interface Schema$InstanceGroupsAddInstancesRequest {
        /**
         * The list of instances to add to the instance group.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$InstanceGroupsListInstances {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceWithNamedPorts resources.
         */
        items?: Schema$InstanceWithNamedPorts[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupsListInstances for the list of instances in the specified instance group.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupsListInstancesRequest {
        /**
         * A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
         */
        instanceState?: string | null;
    }
    export interface Schema$InstanceGroupsRemoveInstancesRequest {
        /**
         * The list of instances to remove from the instance group.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$InstanceGroupsScopedList {
        /**
         * [Output Only] The list of instance groups that are contained in this scope.
         */
        instanceGroups?: Schema$InstanceGroup[];
        /**
         * [Output Only] An informational warning that replaces the list of instance groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceGroupsSetNamedPortsRequest {
        /**
         * The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request. A request with an incorrect fingerprint will fail with error 412 conditionNotMet.
         */
        fingerprint?: string | null;
        /**
         * The list of named ports to set for this instance group.
         */
        namedPorts?: Schema$NamedPort[];
    }
    /**
     * Contains a list of instances.
     */
    export interface Schema$InstanceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Instance resources.
         */
        items?: Schema$Instance[];
        /**
         * [Output Only] Type of resource. Always compute#instanceList for lists of Instance resources.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of instance referrers.
     */
    export interface Schema$InstanceListReferrers {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Reference resources.
         */
        items?: Schema$Reference[];
        /**
         * [Output Only] Type of resource. Always compute#instanceListReferrers for lists of Instance referrers.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceManagedByIgmError {
        /**
         * [Output Only] Contents of the error.
         */
        error?: Schema$InstanceManagedByIgmErrorManagedInstanceError;
        /**
         * [Output Only] Details of the instance action that triggered this error. May be null, if the error was not caused by an action on an instance. This field is optional.
         */
        instanceActionDetails?: Schema$InstanceManagedByIgmErrorInstanceActionDetails;
        /**
         * [Output Only] The time that this error occurred. This value is in RFC3339 text format.
         */
        timestamp?: string | null;
    }
    export interface Schema$InstanceManagedByIgmErrorInstanceActionDetails {
        /**
         * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
         */
        action?: string | null;
        /**
         * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
         */
        instance?: string | null;
        /**
         * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
         */
        version?: Schema$ManagedInstanceVersion;
    }
    export interface Schema$InstanceManagedByIgmErrorManagedInstanceError {
        /**
         * [Output Only] Error code.
         */
        code?: string | null;
        /**
         * [Output Only] Error message.
         */
        message?: string | null;
    }
    export interface Schema$InstanceMoveRequest {
        /**
         * The URL of the destination zone to move the instance. This can be a full or partial URL. For example, the following are all valid URLs to a zone:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone
         * - projects/project/zones/zone
         * - zones/zone
         */
        destinationZone?: string | null;
        /**
         * The URL of the target instance to move. This can be a full or partial URL. For example, the following are all valid URLs to an instance:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
         * - projects/project/zones/zone/instances/instance
         * - zones/zone/instances/instance
         */
        targetInstance?: string | null;
    }
    export interface Schema$InstanceProperties {
        /**
         * Controls for advanced machine-related behavior features.
         */
        advancedMachineFeatures?: Schema$AdvancedMachineFeatures;
        /**
         * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
         */
        canIpForward?: boolean | null;
        /**
         * Specifies the Confidential Instance options.
         */
        confidentialInstanceConfig?: Schema$ConfidentialInstanceConfig;
        /**
         * An optional text description for the instances that are created from these properties.
         */
        description?: string | null;
        /**
         * An array of disks that are associated with the instances that are created from these properties.
         */
        disks?: Schema$AttachedDisk[];
        /**
         * Display Device properties to enable support for remote display products like: Teradici, VNC and TeamViewer
         */
        displayDevice?: Schema$DisplayDevice;
        /**
         * A list of guest accelerator cards' type and count to use for instances created from these properties.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Labels to apply to instances that are created from these properties.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The machine type to use for instances that are created from these properties.
         */
        machineType?: string | null;
        /**
         * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
         */
        metadata?: Schema$Metadata;
        /**
         * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
         */
        minCpuPlatform?: string | null;
        /**
         * An array of network access configurations for this interface.
         */
        networkInterfaces?: Schema$NetworkInterface[];
        networkPerformanceConfig?: Schema$NetworkPerformanceConfig;
        /**
         * PostKeyRevocationActionType of the instance.
         */
        postKeyRevocationActionType?: string | null;
        /**
         * The private IPv6 google access type for VMs. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
         */
        privateIpv6GoogleAccess?: string | null;
        /**
         * Specifies the reservations that instances can consume from.
         */
        reservationAffinity?: Schema$ReservationAffinity;
        /**
         * Resource policies (names, not ULRs) applied to instances created from these properties.
         */
        resourcePolicies?: string[] | null;
        /**
         * Specifies the scheduling options for the instances that are created from these properties.
         */
        scheduling?: Schema$Scheduling;
        /**
         * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
         */
        serviceAccounts?: Schema$ServiceAccount[];
        shieldedInstanceConfig?: Schema$ShieldedInstanceConfig;
        /**
         * Specifies the Shielded VM options for the instances that are created from these properties.
         */
        shieldedVmConfig?: Schema$ShieldedVmConfig;
        /**
         * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
         */
        tags?: Schema$Tags;
    }
    export interface Schema$InstanceReference {
        /**
         * The URL for a specific instance.
         */
        instance?: string | null;
    }
    export interface Schema$InstancesAddResourcePoliciesRequest {
        /**
         * Resource policies to be added to this instance.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$InstancesGetEffectiveFirewallsResponse {
        /**
         * Effective firewalls from firewall policies.
         */
        firewallPolicys?: Schema$InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy[];
        /**
         * Effective firewalls on the instance.
         */
        firewalls?: Schema$Firewall[];
        /**
         * Effective firewalls from organization policies.
         */
        organizationFirewalls?: Schema$InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy[];
    }
    export interface Schema$InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy {
        /**
         * [Output Only] Deprecated, please use short name instead. The display name of the firewall policy.
         */
        displayName?: string | null;
        /**
         * [Output Only] The name of the firewall policy.
         */
        name?: string | null;
        /**
         * The rules that apply to the network.
         */
        rules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] The short name of the firewall policy.
         */
        shortName?: string | null;
        /**
         * [Output Only] The type of the firewall policy.
         */
        type?: string | null;
    }
    /**
     * A pruned SecurityPolicy containing ID and any applicable firewall rules.
     */
    export interface Schema$InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy {
        /**
         * The unique identifier for the security policy. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * The rules that apply to the network.
         */
        rules?: Schema$SecurityPolicyRule[];
    }
    export interface Schema$InstancesRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this instance.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$InstancesResumeRequest {
        /**
         * Array of disks associated with this instance that are protected with a customer-supplied encryption key.
         *
         * In order to resume the instance, the disk url and its corresponding key must be provided.
         *
         * If the disk is not protected with a customer-supplied encryption key it should not be specified.
         */
        disks?: Schema$CustomerEncryptionKeyProtectedDisk[];
        /**
         * Decrypts data associated with an instance that is protected with a customer-supplied encryption key.
         *
         * If the instance you are starting is protected with a customer-supplied encryption key, the correct key must be provided otherwise the instance resume will not succeed.
         */
        instanceEncryptionKey?: Schema$CustomerEncryptionKey;
    }
    export interface Schema$InstancesScopedList {
        /**
         * [Output Only] A list of instances contained in this scope.
         */
        instances?: Schema$Instance[];
        /**
         * [Output Only] Informational warning which replaces the list of instances when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstancesSetLabelsRequest {
        /**
         * Fingerprint of the previous set of labels for this resource, used to prevent conflicts. Provide the latest fingerprint value when making a request to add or change labels.
         */
        labelFingerprint?: string | null;
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$InstancesSetMachineResourcesRequest {
        /**
         * A list of the type and count of accelerator cards attached to the instance.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
    }
    export interface Schema$InstancesSetMachineTypeRequest {
        /**
         * Full or partial URL of the machine type resource. See Machine Types for a full list of machine types. For example: zones/us-central1-f/machineTypes/n1-standard-1
         */
        machineType?: string | null;
    }
    export interface Schema$InstancesSetMinCpuPlatformRequest {
        /**
         * Minimum cpu/platform this instance should be started at.
         */
        minCpuPlatform?: string | null;
    }
    export interface Schema$InstancesSetNameRequest {
        /**
         * The current name of this resource, used to prevent conflicts. Provide the latest name when making a request to change name.
         */
        currentName?: string | null;
        /**
         * The name to be applied to the instance. Needs to be RFC 1035 compliant.
         */
        name?: string | null;
    }
    export interface Schema$InstancesSetServiceAccountRequest {
        /**
         * Email address of the service account.
         */
        email?: string | null;
        /**
         * The list of scopes to be made available for this service account.
         */
        scopes?: string[] | null;
    }
    export interface Schema$InstancesStartWithEncryptionKeyRequest {
        /**
         * Array of disks associated with this instance that are protected with a customer-supplied encryption key.
         *
         * In order to start the instance, the disk url and its corresponding key must be provided.
         *
         * If the disk is not protected with a customer-supplied encryption key it should not be specified.
         */
        disks?: Schema$CustomerEncryptionKeyProtectedDisk[];
        /**
         * Decrypts data associated with an instance that is protected with a customer-supplied encryption key.
         *
         * If the instance you are starting is protected with a customer-supplied encryption key, the correct key must be provided otherwise the instance start will not succeed.
         */
        instanceEncryptionKey?: Schema$CustomerEncryptionKey;
    }
    /**
     * Represents an Instance Template resource.
     *
     * You can use instance templates to create VM instances and managed instance groups. For more information, read Instance Templates. (== resource_for {$api_version\}.instanceTemplates ==)
     */
    export interface Schema$InstanceTemplate {
        /**
         * [Output Only] The creation timestamp for this instance template in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] A unique identifier for this instance template. The server defines this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] The resource type, which is always compute#instanceTemplate for instance templates.
         */
        kind?: string | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The instance properties for this instance template.
         */
        properties?: Schema$InstanceProperties;
        /**
         * [Output Only] The URL for this instance template. The server defines this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The source instance used to create the template. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
         * - projects/project/zones/zone/instances/instance
         */
        sourceInstance?: string | null;
        /**
         * The source instance params to use to create this instance template.
         */
        sourceInstanceParams?: Schema$SourceInstanceParams;
    }
    /**
     * A list of instance templates.
     */
    export interface Schema$InstanceTemplateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceTemplate resources.
         */
        items?: Schema$InstanceTemplate[];
        /**
         * [Output Only] The resource type, which is always compute#instanceTemplatesListResponse for instance template lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$InstanceWithNamedPorts {
        /**
         * [Output Only] The URL of the instance.
         */
        instance?: string | null;
        /**
         * [Output Only] The named ports that belong to this instance group.
         */
        namedPorts?: Schema$NamedPort[];
        /**
         * [Output Only] The status of the instance.
         */
        status?: string | null;
    }
    /**
     * Represents a InstantSnapshot resource.
     *
     * You can use instant snapshots to create disk rollback points quickly.. (== resource_for {$api_version\}.instantSnapshots ==)
     */
    export interface Schema$InstantSnapshot {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Size of the source disk, specified in GB.
         */
        diskSizeGb?: string | null;
        /**
         * Whether to attempt an application consistent instant snapshot by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
         */
        guestFlush?: boolean | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#instantSnapshot for InstantSnapshot resources.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this InstantSnapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a InstantSnapshot.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this InstantSnapshot. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the instant snapshot resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * URL of the source disk used to create this instant snapshot. Note that the source disk must be in the same zone/region as the instant snapshot to be created. This can be a full or valid partial URL. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
         * - https://www.googleapis.com/compute/v1/projects/project/regions/region/disks/disk
         * - projects/project/zones/zone/disks/disk
         * - projects/project/regions/region/disks/disk
         * - zones/zone/disks/disk
         * - regions/region/disks/disk
         */
        sourceDisk?: string | null;
        /**
         * [Output Only] The ID value of the disk used to create this InstantSnapshot. This value may be used to determine whether the InstantSnapshot was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string | null;
        /**
         * [Output Only] The status of the instantSnapshot. This can be CREATING, DELETING, FAILED, or READY.
         */
        status?: string | null;
        /**
         * [Output Only] URL of the zone where the instant snapshot resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$InstantSnapshotExportParams {
        /**
         * An optional base instant snapshot that this resource is compared against. If not specified, all blocks of this resource are exported. The base instant snapshot and this resource must be created from the same disk. The base instant snapshot must be created earlier in time than this resource.
         */
        baseInstantSnapshot?: string | null;
        /**
         * The name of an existing bucket in Cloud Storage where the changed blocks will be stored. The Google Service Account must have read and write access to this bucket. The bucket has to be in the same region as this resource.
         */
        bucketName?: string | null;
        /**
         * Encryption key used to encrypt the instant snapshot.
         */
        encryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Name of the output Bigstore object storing the changed blocks. Object name must be less than 1024 bytes in length.
         */
        objectName?: string | null;
        /**
         * The format of the output file.
         */
        outputType?: string | null;
    }
    /**
     * Contains a list of InstantSnapshot resources.
     */
    export interface Schema$InstantSnapshotList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstantSnapshot resources.
         */
        items?: Schema$InstantSnapshot[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * HttpRouteRuleMatch criteria for field values that must stay within the specified integer range.
     */
    export interface Schema$Int64RangeMatch {
        /**
         * The end of the range (exclusive) in signed long integer format.
         */
        rangeEnd?: string | null;
        /**
         * The start of the range (inclusive) in signed long integer format.
         */
        rangeStart?: string | null;
    }
    /**
     * Represents an Interconnect resource.
     *
     * An Interconnect resource is a dedicated connection between the GCP network and your on-premises network. For more information, read the  Dedicated Interconnect Overview. (== resource_for {$api_version\}.interconnects ==)
     */
    export interface Schema$Interconnect {
        /**
         * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
         */
        adminEnabled?: boolean | null;
        /**
         * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
         */
        circuitInfos?: Schema$InterconnectCircuitInfo[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
         */
        customerName?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] A list of outages expected for this Interconnect.
         */
        expectedOutages?: Schema$InterconnectOutageNotification[];
        /**
         * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
         */
        googleIpAddress?: string | null;
        /**
         * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
         */
        googleReferenceId?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
         */
        interconnectAttachments?: string[] | null;
        /**
         * Type of interconnect, which can take one of the following values:
         * - PARTNER: A partner-managed interconnection shared between customers though a partner.
         * - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
         */
        interconnectType?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this Interconnect, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an Interconnect.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Type of link requested, which can take one of the following values:
         * - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
         * - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
         */
        linkType?: string | null;
        /**
         * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
         */
        location?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Stackdriver logs alerting and Cloud Notifications.
         */
        nocContactEmail?: string | null;
        /**
         * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values:
         * - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect.
         * - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect.
         * - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
         */
        operationalStatus?: string | null;
        /**
         * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
         */
        peerIpAddress?: string | null;
        /**
         * [Output Only] Number of links actually provisioned in this interconnect.
         */
        provisionedLinkCount?: number | null;
        /**
         * Target number of physical links in the link bundle, as requested by the customer.
         */
        requestedLinkCount?: number | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The current state of Interconnect functionality, which can take one of the following values:
         * - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect.
         * - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect.
         * - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
         */
        state?: string | null;
    }
    /**
     * Represents an Interconnect Attachment (VLAN) resource.
     *
     * You can use Interconnect attachments (VLANS) to connect your Virtual Private Cloud networks to your on-premises networks through an Interconnect. For more information, read  Creating VLAN Attachments. (== resource_for {$api_version\}.interconnectAttachments ==)
     */
    export interface Schema$InterconnectAttachment {
        /**
         * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
         */
        adminEnabled?: boolean | null;
        /**
         * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values:
         * - BPS_50M: 50 Mbit/s
         * - BPS_100M: 100 Mbit/s
         * - BPS_200M: 200 Mbit/s
         * - BPS_300M: 300 Mbit/s
         * - BPS_400M: 400 Mbit/s
         * - BPS_500M: 500 Mbit/s
         * - BPS_1G: 1 Gbit/s
         * - BPS_2G: 2 Gbit/s
         * - BPS_5G: 5 Gbit/s
         * - BPS_10G: 10 Gbit/s
         * - BPS_20G: 20 Gbit/s
         * - BPS_50G: 50 Gbit/s
         */
        bandwidth?: string | null;
        /**
         * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
         */
        candidateSubnets?: string[] | null;
        /**
         * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
         */
        cloudRouterIpAddress?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
         */
        customerRouterIpAddress?: string | null;
        /**
         * [Output Only] Dataplane version for this InterconnectAttachment.
         */
        dataplaneVersion?: number | null;
        /**
         * An optional description of this resource.
         */
        description?: string | null;
        /**
         * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values:
         * - AVAILABILITY_DOMAIN_ANY
         * - AVAILABILITY_DOMAIN_1
         * - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
         */
        edgeAvailabilityDomain?: string | null;
        /**
         * Indicates the user-supplied encryption option of this interconnect attachment:
         * - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment.
         * - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option.
         * Not currently available in all Interconnect locations.
         */
        encryption?: string | null;
        /**
         * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
         */
        googleReferenceId?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
         */
        interconnect?: string | null;
        /**
         * URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway?s IP address will be allocated from the IP address range specified here. For example, if the HA VPN gateway?s interface 0 is paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this interconnect attachment. If this field is not specified for interconnect attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment, the HA VPN gateway's IP address will be allocated from regional external IP address pool.
         * Not currently available in all Interconnect locations.
         */
        ipsecInternalAddresses?: string[] | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
         */
        mtu?: number | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values:
         * - OS_ACTIVE: The attachment has been turned up and is ready to use.
         * - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
         */
        operationalStatus?: string | null;
        /**
         * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
         */
        pairingKey?: string | null;
        /**
         * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerAsn?: string | null;
        /**
         * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
         */
        partnerMetadata?: Schema$InterconnectAttachmentPartnerMetadata;
        /**
         * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
         */
        privateInterconnectInfo?: Schema$InterconnectAttachmentPrivateInfo;
        /**
         * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
         */
        router?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values:
         * - ACTIVE: The attachment has been turned up and is ready to use.
         * - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
         * - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side.
         * - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
         * - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it.
         * - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
         */
        state?: string | null;
        /**
         * The type of interconnect attachment this is, which can take one of the following values:
         * - DEDICATED: an attachment to a Dedicated Interconnect.
         * - PARTNER: an attachment to a Partner Interconnect, created by the customer.
         * - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
         */
        type?: string | null;
        /**
         * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
         */
        vlanTag8021q?: number | null;
    }
    export interface Schema$InterconnectAttachmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectAttachmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$InterconnectAttachmentsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#interconnectAttachmentAggregatedList for aggregated lists of interconnect attachments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Response to the list request, and contains a list of interconnect attachments.
     */
    export interface Schema$InterconnectAttachmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectAttachment resources.
         */
        items?: Schema$InterconnectAttachment[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectAttachmentList for lists of interconnect attachments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Informational metadata about Partner attachments from Partners to display to customers. These fields are propagated from PARTNER_PROVIDER attachments to their corresponding PARTNER attachments.
     */
    export interface Schema$InterconnectAttachmentPartnerMetadata {
        /**
         * Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner's portal. For instance "Chicago 1". This value may be validated to match approved Partner values.
         */
        interconnectName?: string | null;
        /**
         * Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
         */
        partnerName?: string | null;
        /**
         * URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
         */
        portalUrl?: string | null;
    }
    /**
     * Information for an interconnect attachment when this belongs to an interconnect of type DEDICATED.
     */
    export interface Schema$InterconnectAttachmentPrivateInfo {
        /**
         * [Output Only] 802.1q encapsulation tag to be used for traffic between Google and the customer, going to and from this network and region.
         */
        tag8021q?: number | null;
    }
    export interface Schema$InterconnectAttachmentsScopedList {
        /**
         * A list of interconnect attachments contained in this scope.
         */
        interconnectAttachments?: Schema$InterconnectAttachment[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Describes a single physical circuit between the Customer and Google. CircuitInfo objects are created by Google, so all fields are output only.
     */
    export interface Schema$InterconnectCircuitInfo {
        /**
         * Customer-side demarc ID for this circuit.
         */
        customerDemarcId?: string | null;
        /**
         * Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
         */
        googleCircuitId?: string | null;
        /**
         * Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to the customer in the LOA.
         */
        googleDemarcId?: string | null;
    }
    /**
     * Diagnostics information about interconnect, contains detailed and current technical information about Google's side of the connection.
     */
    export interface Schema$InterconnectDiagnostics {
        /**
         * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
         */
        arpCaches?: Schema$InterconnectDiagnosticsARPEntry[];
        /**
         * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
         */
        links?: Schema$InterconnectDiagnosticsLinkStatus[];
        /**
         * The MAC address of the Interconnect's bundle interface.
         */
        macAddress?: string | null;
    }
    /**
     * Describing the ARP neighbor entries seen on this link
     */
    export interface Schema$InterconnectDiagnosticsARPEntry {
        /**
         * The IP address of this ARP neighbor.
         */
        ipAddress?: string | null;
        /**
         * The MAC address of this ARP neighbor.
         */
        macAddress?: string | null;
    }
    export interface Schema$InterconnectDiagnosticsLinkLACPStatus {
        /**
         * System ID of the port on Google's side of the LACP exchange.
         */
        googleSystemId?: string | null;
        /**
         * System ID of the port on the neighbor's side of the LACP exchange.
         */
        neighborSystemId?: string | null;
        /**
         * The state of a LACP link, which can take one of the following values:
         * - ACTIVE: The link is configured and active within the bundle.
         * - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
         */
        state?: string | null;
    }
    export interface Schema$InterconnectDiagnosticsLinkOpticalPower {
        /**
         * The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include:
         * - OK: The value has not crossed a warning threshold.
         * - LOW_WARNING: The value has crossed below the low warning threshold.
         * - HIGH_WARNING: The value has crossed above the high warning threshold.
         * - LOW_ALARM: The value has crossed below the low alarm threshold.
         * - HIGH_ALARM: The value has crossed above the high alarm threshold.
         */
        state?: string | null;
        /**
         * Value of the current receiving or transmitting optical power, read in dBm. Take a known good optical value, give it a 10% margin and trigger warnings relative to that value. In general, a -7dBm warning and a -11dBm alarm are good optical value estimates for most links.
         */
        value?: number | null;
    }
    export interface Schema$InterconnectDiagnosticsLinkStatus {
        /**
         * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
         */
        arpCaches?: Schema$InterconnectDiagnosticsARPEntry[];
        /**
         * The unique ID for this link assigned during turn up by Google.
         */
        circuitId?: string | null;
        /**
         * The Demarc address assigned by Google and provided in the LoA.
         */
        googleDemarc?: string | null;
        lacpStatus?: Schema$InterconnectDiagnosticsLinkLACPStatus;
        /**
         * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
         */
        receivingOpticalPower?: Schema$InterconnectDiagnosticsLinkOpticalPower;
        /**
         * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
         */
        transmittingOpticalPower?: Schema$InterconnectDiagnosticsLinkOpticalPower;
    }
    /**
     * Response to the list request, and contains a list of interconnects.
     */
    export interface Schema$InterconnectList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Interconnect resources.
         */
        items?: Schema$Interconnect[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectList for lists of interconnects.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Interconnect Attachment (VLAN) Location resource.
     *
     * You can use this resource to find location details about an Interconnect attachment (VLAN). For more information about interconnect attachments, read  Creating VLAN Attachments.
     */
    export interface Schema$InterconnectLocation {
        /**
         * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
         */
        address?: string | null;
        /**
         * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
         */
        availabilityZone?: string | null;
        /**
         * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
         */
        city?: string | null;
        /**
         * [Output Only] Continent for this location, which can take one of the following values:
         * - AFRICA
         * - ASIA_PAC
         * - EUROPE
         * - NORTH_AMERICA
         * - SOUTH_AMERICA
         */
        continent?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] An optional description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
         */
        facilityProvider?: string | null;
        /**
         * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
         */
        facilityProviderFacilityId?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
         */
        peeringdbFacilityId?: string | null;
        /**
         * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
         */
        regionInfos?: Schema$InterconnectLocationRegionInfo[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of this InterconnectLocation, which can take one of the following values:
         * - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects.
         * - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
         */
        status?: string | null;
    }
    /**
     * Response to the list request, and contains a list of interconnect locations.
     */
    export interface Schema$InterconnectLocationList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InterconnectLocation resources.
         */
        items?: Schema$InterconnectLocation[];
        /**
         * [Output Only] Type of resource. Always compute#interconnectLocationList for lists of interconnect locations.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Information about any potential InterconnectAttachments between an Interconnect at a specific InterconnectLocation, and a specific Cloud Region.
     */
    export interface Schema$InterconnectLocationRegionInfo {
        /**
         * Expected round-trip time in milliseconds, from this InterconnectLocation to a VM in this region.
         */
        expectedRttMs?: string | null;
        /**
         * Identifies the network presence of this location.
         */
        locationPresence?: string | null;
        /**
         * URL for the region of this location.
         */
        region?: string | null;
    }
    /**
     * Description of a planned outage on this Interconnect.
     */
    export interface Schema$InterconnectOutageNotification {
        /**
         * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
         */
        affectedCircuits?: string[] | null;
        /**
         * A description about the purpose of the outage.
         */
        description?: string | null;
        /**
         * Scheduled end time for the outage (milliseconds since Unix epoch).
         */
        endTime?: string | null;
        /**
         * Form this outage is expected to take, which can take one of the following values:
         * - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window.
         * - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
         */
        issueType?: string | null;
        /**
         * Unique identifier for this outage notification.
         */
        name?: string | null;
        /**
         * The party that generated this notification, which can take the following value:
         * - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
         */
        source?: string | null;
        /**
         * Scheduled start time for the outage (milliseconds since Unix epoch).
         */
        startTime?: string | null;
        /**
         * State of this notification, which can take one of the following values:
         * - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling.
         * - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
         */
        state?: string | null;
    }
    /**
     * Response for the InterconnectsGetDiagnosticsRequest.
     */
    export interface Schema$InterconnectsGetDiagnosticsResponse {
        result?: Schema$InterconnectDiagnostics;
    }
    export interface Schema$InternalIpAddress {
        /**
         * IP CIDR address or range.
         */
        cidr?: string | null;
        /**
         * The owner of the internal IP address.
         */
        owner?: string | null;
        /**
         * The purpose of the internal IP address if applicable.
         */
        purpose?: string | null;
        /**
         * The region of the internal IP address if applicable.
         */
        region?: string | null;
        /**
         * The type of the internal IP address.
         */
        type?: string | null;
    }
    export interface Schema$InternalIpOwner {
        /**
         * IP CIDR range being owned.
         */
        ipCidrRange?: string | null;
        /**
         * URLs of the IP owners of the IP CIDR range.
         */
        owners?: string[] | null;
        /**
         * Whether this IP CIDR range is reserved for system use.
         */
        systemOwned?: boolean | null;
    }
    export interface Schema$IpAddressesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InternalIpAddress resources.
         */
        items?: Schema$InternalIpAddress[];
        /**
         * [Output Only] Type of resource. Always compute#ipAddressesList for IP addresses lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of IP owners.
     */
    export interface Schema$IpOwnerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InternalIpOwner resources.
         */
        items?: Schema$InternalIpOwner[];
        /**
         * [Output Only] Type of resource. Always compute#ipOwnerList for lists of IP owners.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * [Deprecated] JWT configuration for origin authentication. JWT configuration for origin authentication.
     */
    export interface Schema$Jwt {
        /**
         * A JWT containing any of these audiences will be accepted. The service name will be accepted if audiences is empty. Examples: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
         */
        audiences?: string[] | null;
        /**
         * Identifies the issuer that issued the JWT, which is usually a URL or an email address. Examples: https://securetoken.google.com, 1234567-compute@developer.gserviceaccount.com
         */
        issuer?: string | null;
        /**
         * The provider's public key set to validate the signature of the JWT.
         */
        jwksPublicKeys?: string | null;
        /**
         * jwt_headers and jwt_params define where to extract the JWT from an HTTP request. If no explicit location is specified, the following default locations are tried in order:
         *
         * 1. The Authorization header using the Bearer schema. See `here `_. Example:
         *
         * Authorization: Bearer .
         *
         * 2. `access_token` query parameter. See `this `_
         *
         * Multiple JWTs can be verified for a request. Each JWT has to be extracted from the locations its issuer specified or from the default locations.
         *
         * This field is set if JWT is sent in a request header. This field specifies the header name. For example, if `header=x-goog-iap-jwt-assertion`, the header format will be x-goog-iap-jwt-assertion: .
         */
        jwtHeaders?: Schema$JwtHeader[];
        /**
         * This field is set if JWT is sent in a query parameter. This field specifies the query parameter name. For example, if jwt_params[0] is jwt_token, the JWT format in the query parameter is /path?jwt_token=.
         */
        jwtParams?: string[] | null;
    }
    /**
     * [Deprecated] This message specifies a header location to extract JWT token. This message specifies a header location to extract JWT token.
     */
    export interface Schema$JwtHeader {
        /**
         * The HTTP header name.
         */
        name?: string | null;
        /**
         * The value prefix. The value format is "value_prefix" For example, for "Authorization: Bearer ", value_prefix="Bearer " with a space at the end.
         */
        valuePrefix?: string | null;
    }
    /**
     * Represents a License resource.
     *
     * A License represents billing and aggregate usage data for public and marketplace images.  Caution This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. (== resource_for {$api_version\}.licenses ==)
     */
    export interface Schema$License {
        /**
         * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
         */
        chargesUseFee?: boolean | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional textual description of the resource; provided by the client when the resource is created.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#license for licenses.
         */
        kind?: string | null;
        /**
         * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
         */
        licenseCode?: string | null;
        /**
         * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
         */
        name?: string | null;
        resourceRequirements?: Schema$LicenseResourceRequirements;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
         */
        transferable?: boolean | null;
    }
    /**
     * Represents a License Code resource.
     *
     * A License Code is a unique identifier used to represent a license resource.  Caution This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. (== resource_for {$api_version\}.licenseCodes ==)
     */
    export interface Schema$LicenseCode {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] Description of this License Code.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#licenseCode for licenses.
         */
        kind?: string | null;
        /**
         * [Output Only] URL and description aliases of Licenses with the same License Code.
         */
        licenseAlias?: Schema$LicenseCodeLicenseAlias[];
        /**
         * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit integer.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Current state of this License Code.
         */
        state?: string | null;
        /**
         * [Output Only] If true, the license will remain attached when creating images or snapshots from disks. Otherwise, the license is not transferred.
         */
        transferable?: boolean | null;
    }
    export interface Schema$LicenseCodeLicenseAlias {
        /**
         * [Output Only] Description of this License Code.
         */
        description?: string | null;
        /**
         * [Output Only] URL of license corresponding to this License Code.
         */
        selfLink?: string | null;
    }
    /**
     * Commitment for a particular license resource.
     */
    export interface Schema$LicenseResourceCommitment {
        /**
         * The number of licenses purchased.
         */
        amount?: string | null;
        /**
         * Specifies the core range of the instance for which this license applies.
         */
        coresPerLicense?: string | null;
        /**
         * Any applicable license URI.
         */
        license?: string | null;
    }
    export interface Schema$LicenseResourceRequirements {
        /**
         * Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.
         */
        minGuestCpuCount?: number | null;
        /**
         * Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
         */
        minMemoryMb?: number | null;
    }
    export interface Schema$LicensesListResponse {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of License resources.
         */
        items?: Schema$License[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$LocalDisk {
        /**
         * Specifies the number of such disks.
         */
        diskCount?: number | null;
        /**
         * Specifies the size of the disk in base-2 GB.
         */
        diskSizeGb?: number | null;
        /**
         * Specifies the desired disk type on the node. This disk type must be a local storage type (e.g.: local-ssd). Note that for nodeTemplates, this should be the name of the disk type and not its URL.
         */
        diskType?: string | null;
    }
    /**
     * Configuration for location policy among multiple possible locations (e.g. preferences for zone selection among zones in a single region).
     */
    export interface Schema$LocationPolicy {
        /**
         * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
         */
        locations?: {
            [key: string]: Schema$LocationPolicyLocation;
        } | null;
    }
    export interface Schema$LocationPolicyLocation {
        /**
         * Preference for a given locaction: ALLOW or DENY.
         */
        preference?: string | null;
    }
    /**
     * Specifies what kind of log the caller must write
     */
    export interface Schema$LogConfig {
        /**
         * Cloud audit options.
         */
        cloudAudit?: Schema$LogConfigCloudAuditOptions;
        /**
         * Counter options.
         */
        counter?: Schema$LogConfigCounterOptions;
        /**
         * Data access options.
         */
        dataAccess?: Schema$LogConfigDataAccessOptions;
    }
    /**
     * Write a Cloud Audit log
     */
    export interface Schema$LogConfigCloudAuditOptions {
        /**
         * Information used by the Cloud Audit Logging pipeline.
         */
        authorizationLoggingOptions?: Schema$AuthorizationLoggingOptions;
        /**
         * The log_name to populate in the Cloud Audit Record.
         */
        logName?: string | null;
    }
    /**
     * Increment a streamz counter with the specified metric and field names.
     *
     * Metric names should start with a '/', generally be lowercase-only, and end in "_count". Field names should not contain an initial slash. The actual exported metric names will have "/iam/policy" prepended.
     *
     * Field names correspond to IAM request parameters and field values are their respective values.
     *
     * Supported field names: - "authority", which is "[token]" if IAMContext.token is present, otherwise the value of IAMContext.authority_selector if present, and otherwise a representation of IAMContext.principal; or - "iam_principal", a representation of IAMContext.principal even if a token or authority selector is present; or - "" (empty string), resulting in a counter with no fields.
     *
     * Examples: counter { metric: "/debug_access_count" field: "iam_principal" \} ==\> increment counter /iam/policy/debug_access_count {iam_principal=[value of IAMContext.principal]\}
     */
    export interface Schema$LogConfigCounterOptions {
        /**
         * Custom fields.
         */
        customFields?: Schema$LogConfigCounterOptionsCustomField[];
        /**
         * The field value to attribute.
         */
        field?: string | null;
        /**
         * The metric to update.
         */
        metric?: string | null;
    }
    /**
     * Custom fields. These can be used to create a counter with arbitrary field/value pairs. See: go/rpcsp-custom-fields.
     */
    export interface Schema$LogConfigCounterOptionsCustomField {
        /**
         * Name is the field name.
         */
        name?: string | null;
        /**
         * Value is the field value. It is important that in contrast to the CounterOptions.field, the value here is a constant that is not derived from the IAMContext.
         */
        value?: string | null;
    }
    /**
     * Write a Data Access (Gin) log
     */
    export interface Schema$LogConfigDataAccessOptions {
        logMode?: string | null;
    }
    /**
     * Represents a machine image resource.
     *
     * A machine image is a Compute Engine resource that stores all the configuration, metadata, permissions, and data from one or more disks required to create a Virtual machine (VM) instance. For more information, see Machine images. (== resource_for {$api_version\}.machineImages ==)
     */
    export interface Schema$MachineImage {
        /**
         * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
         */
        guestFlush?: boolean | null;
        /**
         * [Output Only] A unique identifier for this machine image. The server defines this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] The resource type, which is always compute#machineImage for machine image.
         */
        kind?: string | null;
        /**
         * Encrypts the machine image using a customer-supplied encryption key.
         *
         * After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request.
         *
         * Customer-supplied encryption keys do not protect access to metadata of the machine image.
         *
         * If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
         */
        machineImageEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] The URL for this machine image. The server defines this URL.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKeys?: Schema$SourceDiskEncryptionKey[];
        /**
         * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
         * - projects/project/zones/zone/instances/instance
         */
        sourceInstance?: string | null;
        /**
         * [Output Only] Properties of source instance.
         */
        sourceInstanceProperties?: Schema$SourceInstanceProperties;
        /**
         * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
         */
        status?: string | null;
        /**
         * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
         */
        storageLocations?: string[] | null;
        /**
         * [Output Only] Total size of the storage used by the machine image.
         */
        totalStorageBytes?: string | null;
    }
    /**
     * A list of machine images.
     */
    export interface Schema$MachineImageList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of MachineImage resources.
         */
        items?: Schema$MachineImage[];
        /**
         * [Output Only] The resource type, which is always compute#machineImagesListResponse for machine image lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Machine Type resource.
     *
     * You can use specific machine types for your VM instances based on performance and pricing requirements. For more information, read Machine Types. (== resource_for {$api_version\}.machineTypes ==)
     */
    export interface Schema$MachineType {
        /**
         * [Output Only] A list of accelerator configurations assigned to this machine type.
         */
        accelerators?: Array<{
            guestAcceleratorCount?: number;
            guestAcceleratorType?: string;
        }> | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The number of virtual CPUs that are available to the instance.
         */
        guestCpus?: number | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
         */
        isSharedCpu?: boolean | null;
        /**
         * [Output Only] The type of the resource. Always compute#machineType for machine types.
         */
        kind?: string | null;
        /**
         * [Output Only] Maximum persistent disks allowed.
         */
        maximumPersistentDisks?: number | null;
        /**
         * [Output Only] Maximum total persistent disks size (GB) allowed.
         */
        maximumPersistentDisksSizeGb?: string | null;
        /**
         * [Output Only] The amount of physical memory available to the instance, defined in MB.
         */
        memoryMb?: number | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
         */
        zone?: string | null;
    }
    export interface Schema$MachineTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of MachineTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$MachineTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#machineTypeAggregatedList for aggregated lists of machine types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of machine types.
     */
    export interface Schema$MachineTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of MachineType resources.
         */
        items?: Schema$MachineType[];
        /**
         * [Output Only] Type of resource. Always compute#machineTypeList for lists of machine types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$MachineTypesScopedList {
        /**
         * [Output Only] A list of machine types contained in this scope.
         */
        machineTypes?: Schema$MachineType[];
        /**
         * [Output Only] An informational warning that appears when the machine types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A Managed Instance resource.
     */
    export interface Schema$ManagedInstance {
        /**
         * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values:
         * - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance.
         * - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
         * - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead.
         * - RECREATING The managed instance group is recreating this instance.
         * - DELETING The managed instance group is permanently deleting this instance.
         * - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
         * - RESTARTING The managed instance group is restarting the instance.
         * - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
         * - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
         */
        currentAction?: string | null;
        /**
         * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
         */
        id?: string | null;
        /**
         * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
         */
        instance?: string | null;
        /**
         * [Output Only] Health state of the instance per health-check.
         */
        instanceHealth?: Schema$ManagedInstanceInstanceHealth[];
        /**
         * [Output Only] The status of the instance. This field is empty when the instance does not exist.
         */
        instanceStatus?: string | null;
        /**
         * [Output Only] The intended template of the instance. This field is empty when current_action is one of { DELETING, ABANDONING \}.
         */
        instanceTemplate?: string | null;
        /**
         * [Output Only] Information about the last attempt to create or delete the instance.
         */
        lastAttempt?: Schema$ManagedInstanceLastAttempt;
        /**
         * [Output Only] Preserved state applied from per-instance config for this instance.
         */
        preservedStateFromConfig?: Schema$PreservedState;
        /**
         * [Output Only] Preserved state generated based on stateful policy for this instance.
         */
        preservedStateFromPolicy?: Schema$PreservedState;
        /**
         * [Output Only] Tag describing the version.
         */
        tag?: string | null;
        /**
         * [Output Only] Intended version of this instance.
         */
        version?: Schema$ManagedInstanceVersion;
    }
    export interface Schema$ManagedInstanceInstanceHealth {
        /**
         * [Output Only] The current detailed instance health state.
         */
        detailedHealthState?: string | null;
        /**
         * [Output Only] The URL for the health check that verifies whether the instance is healthy.
         */
        healthCheck?: string | null;
        /**
         * [Output Only] The current instance health state. This field will not get promoted to beta/GA and might be removed from alpha APIs after 01/12/2019. Please use detailed_health_state field instead.
         */
        healthState?: string | null;
    }
    export interface Schema$ManagedInstanceLastAttempt {
        /**
         * [Output Only] Encountered errors during the last attempt to create or delete the instance.
         */
        errors?: {
            errors?: Array<{
                code?: string;
                location?: string;
                message?: string;
            }>;
        } | null;
    }
    export interface Schema$ManagedInstanceVersion {
        /**
         * [Output Only] The intended template of the instance. This field is empty when current_action is one of { DELETING, ABANDONING \}.
         */
        instanceTemplate?: string | null;
        /**
         * [Output Only] Name of the version.
         */
        name?: string | null;
    }
    /**
     * A metadata key/value entry.
     */
    export interface Schema$Metadata {
        /**
         * Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve the resource.
         */
        fingerprint?: string | null;
        /**
         * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
         */
        items?: Array<{
            key?: string;
            value?: string;
        }> | null;
        /**
         * [Output Only] Type of the resource. Always compute#metadata for metadata.
         */
        kind?: string | null;
    }
    /**
     * [Deprecated] Custom authenticator credentials. Custom authenticator credentials.
     */
    export interface Schema$MetadataCredentialsFromPlugin {
        /**
         * Plugin name.
         */
        name?: string | null;
        /**
         * A text proto that conforms to a Struct type definition interpreted by the plugin.
         */
        structConfig?: string | null;
    }
    /**
     * Opaque filter criteria used by loadbalancers to restrict routing configuration to a limited set of loadbalancing proxies. Proxies and sidecars involved in loadbalancing would typically present metadata to the loadbalancers which need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies.
     * For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata.
     * An example for using metadataFilters would be: if loadbalancing involves  Envoys, they will only receive routing configuration when values in metadataFilters match values supplied in <a href="https://www.envoyproxy.io/docs/envoy/latest/api-v2/api/v2/core/base.proto#envoy-api-msg-core-node" Node metadata of their XDS requests to loadbalancers.
     */
    export interface Schema$MetadataFilter {
        /**
         * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria
         * This list must not be empty and can have at the most 64 entries.
         */
        filterLabels?: Schema$MetadataFilterLabelMatch[];
        /**
         * Specifies how individual filterLabel matches within the list of filterLabels contribute towards the overall metadataFilter match.
         * Supported values are:
         * - MATCH_ANY: At least one of the filterLabels must have a matching label in the provided metadata.
         * - MATCH_ALL: All filterLabels must have matching labels in the provided metadata.
         */
        filterMatchCriteria?: string | null;
    }
    /**
     * MetadataFilter label name value pairs that are expected to match corresponding labels presented as metadata to the loadbalancer.
     */
    export interface Schema$MetadataFilterLabelMatch {
        /**
         * Name of metadata label.
         * The name can have a maximum length of 1024 characters and must be at least 1 character long.
         */
        name?: string | null;
        /**
         * The value of the label must match the specified value.
         * value can have a maximum length of 1024 characters.
         */
        value?: string | null;
    }
    /**
     * [Deprecated] Configuration for the mutual Tls mode for peer authentication. Configuration for the mutual Tls mode for peer authentication.
     */
    export interface Schema$MutualTls {
        /**
         * Specifies if the server TLS is configured to be strict or permissive. This field can be set to one of the following: STRICT: Client certificate must be presented, connection is in TLS. PERMISSIVE: Client certificate can be omitted, connection can be either plaintext or TLS.
         */
        mode?: string | null;
    }
    /**
     * The named port. For example: .
     */
    export interface Schema$NamedPort {
        /**
         * The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
         */
        name?: string | null;
        /**
         * The port number, which can be a value between 1 and 65535.
         */
        port?: number | null;
    }
    /**
     * Represents a VPC Network resource.
     *
     * Networks connect resources to each other and to the internet. For more information, read Virtual Private Cloud (VPC) Network. (== resource_for {$api_version\}.networks ==)
     */
    export interface Schema$Network {
        /**
         * Must be set to create a VPC network. If not set, a legacy network is created.
         *
         * When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode.
         *
         * An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges.
         *
         * For custom mode VPC networks, you can add subnets using the subnetworks insert method.
         */
        autoCreateSubnetworks?: boolean | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] URL of the firewall policy the network is associated with.
         */
        firewallPolicy?: string | null;
        /**
         * [Output Only] The gateway address for default routing out of the network, selected by GCP.
         */
        gatewayIPv4?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
         */
        IPv4Range?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#network for networks.
         */
        kind?: string | null;
        /**
         * Maximum Transmission Unit in bytes. The minimum value for this field is 1460 and the maximum value is 1500 bytes.
         */
        mtu?: number | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string | null;
        /**
         * [Output Only] A list of network peerings for the resource.
         */
        peerings?: Schema$NetworkPeering[];
        /**
         * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
         */
        routingConfig?: Schema$NetworkRoutingConfig;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
         */
        subnetworks?: string[] | null;
    }
    /**
     * The network endpoint.
     */
    export interface Schema$NetworkEndpoint {
        /**
         * Metadata defined as annotations on the network endpoint.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * Optional fully qualified domain name of network endpoint. This can only be specified when NetworkEndpointGroup.network_endpoint_type is NON_GCP_FQDN_PORT.
         */
        fqdn?: string | null;
        /**
         * The name for a specific VM instance that the IP address belongs to. This is required for network endpoints of type GCE_VM_IP_PORT. The instance must be in the same zone of network endpoint group.
         *
         * The name must be 1-63 characters long, and comply with RFC1035.
         */
        instance?: string | null;
        /**
         * Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine (either the primary IP or as part of an aliased IP range). If the IP address is not specified, then the primary IP address for the VM instance in the network that the network endpoint group belongs to will be used.
         */
        ipAddress?: string | null;
        /**
         * Optional port number of network endpoint. If not specified, the defaultPort for the network endpoint group will be used.
         */
        port?: number | null;
    }
    /**
     * Represents a collection of network endpoints.
     *
     * A network endpoint group (NEG) defines how a set of endpoints should be reached, whether they are reachable, and where they are located. For more information about using NEGs, see  Setting up external HTTP(S) Load Balancing with internet NEGs,  Setting up zonal NEGs, or  Setting up external HTTP(S) Load Balancing with serverless NEGs. (== resource_for {$api_version\}.networkEndpointGroups ==) (== resource_for {$api_version\}.globalNetworkEndpointGroups ==) (== resource_for {$api_version\}.regionNetworkEndpointGroups ==)
     */
    export interface Schema$NetworkEndpointGroup {
        /**
         * Metadata defined as annotations on the network endpoint group.
         */
        annotations?: {
            [key: string]: string;
        } | null;
        /**
         * Only valid when networkEndpointType is "SERVERLESS". Only one of cloudRun, appEngine or cloudFunction may be set.
         */
        appEngine?: Schema$NetworkEndpointGroupAppEngine;
        /**
         * Only valid when networkEndpointType is "SERVERLESS". Only one of cloudRun, appEngine or cloudFunction may be set.
         */
        cloudFunction?: Schema$NetworkEndpointGroupCloudFunction;
        /**
         * Only valid when networkEndpointType is "SERVERLESS". Only one of cloudRun, appEngine or cloudFunction may be set.
         */
        cloudRun?: Schema$NetworkEndpointGroupCloudRun;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * The default port used if the port number is not specified in the network endpoint.
         */
        defaultPort?: number | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
         */
        kind?: string | null;
        /**
         * This field is only valid when the network endpoint group is used for load balancing. [Deprecated] This field is deprecated.
         */
        loadBalancer?: Schema$NetworkEndpointGroupLbNetworkEndpointGroup;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of the network to which all network endpoints in the NEG belong. Uses "default" project network if unspecified.
         */
        network?: string | null;
        /**
         * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, or SERVERLESS.
         */
        networkEndpointType?: string | null;
        /**
         * The target service url used to set up private service connection to a Google API. An example value is: "asia-northeast3-cloudkms.googleapis.com"
         */
        pscTargetService?: string | null;
        /**
         * [Output Only] The URL of the region where the network endpoint group is located.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Only valid when networkEndpointType is "SERVERLESS". Only one of cloudRun, appEngine cloudFunction or serverlessDeployment may be set.
         */
        serverlessDeployment?: Schema$NetworkEndpointGroupServerlessDeployment;
        /**
         * [Output only] Number of network endpoints in the network endpoint group.
         */
        size?: number | null;
        /**
         * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
         */
        subnetwork?: string | null;
        /**
         * Specify the type of this network endpoint group. Only LOAD_BALANCING is valid for now.
         */
        type?: string | null;
        /**
         * [Output Only] The URL of the zone where the network endpoint group is located.
         */
        zone?: string | null;
    }
    export interface Schema$NetworkEndpointGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkEndpointGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NetworkEndpointGroupsScopedList;
        } | null;
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupAggregatedList for aggregated lists of network endpoint groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Configuration for an App Engine network endpoint group (NEG). The service is optional, may be provided explicitly or in the URL mask. The version is optional and can only be provided explicitly or in the URL mask when service is present.
     *
     * Note: App Engine service must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupAppEngine {
        /**
         * Optional serving service.
         *
         * The service name is case-sensitive and must be 1-63 characters long.
         *
         * Example value: "default", "my-service".
         */
        service?: string | null;
        /**
         * A template to parse service and version fields from a request URL. URL mask allows for routing to multiple App Engine services without having to create multiple Network Endpoint Groups and backend services.
         *
         * For example, the request URLs "foo1-dot-appname.appspot.com/v1" and "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with URL mask "-dot-appname.appspot.com/". The URL mask will parse them to { service = "foo1", version = "v1" \} and { service = "foo1", version = "v2" \} respectively.
         */
        urlMask?: string | null;
        /**
         * Optional serving version.
         *
         * The version name is case-sensitive and must be 1-100 characters long.
         *
         * Example value: "v1", "v2".
         */
        version?: string | null;
    }
    /**
     * Configuration for a Cloud Function network endpoint group (NEG). The function must be provided explicitly or in the URL mask.
     *
     * Note: Cloud Function must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupCloudFunction {
        /**
         * A user-defined name of the Cloud Function.
         *
         * The function name is case-sensitive and must be 1-63 characters long.
         *
         * Example value: "func1".
         */
        function?: string | null;
        /**
         * A template to parse function field from a request URL. URL mask allows for routing to multiple Cloud Functions without having to create multiple Network Endpoint Groups and backend services.
         *
         * For example, request URLs "mydomain.com/function1" and "mydomain.com/function2" can be backed by the same Serverless NEG with URL mask "/". The URL mask will parse them to { function = "function1" \} and { function = "function2" \} respectively.
         */
        urlMask?: string | null;
    }
    /**
     * Configuration for a Cloud Run network endpoint group (NEG). The service must be provided explicitly or in the URL mask. The tag is optional, may be provided explicitly or in the URL mask.
     *
     * Note: Cloud Run service must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupCloudRun {
        /**
         * Cloud Run service is the main resource of Cloud Run.
         *
         * The service must be 1-63 characters long, and comply with RFC1035.
         *
         * Example value: "run-service".
         */
        service?: string | null;
        /**
         * Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information.
         *
         * The tag must be 1-63 characters long, and comply with RFC1035.
         *
         * Example value: "revision-0010".
         */
        tag?: string | null;
        /**
         * A template to parse service and tag fields from a request URL. URL mask allows for routing to multiple Run services without having to create multiple network endpoint groups and backend services.
         *
         * For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2" can be backed by the same Serverless Network Endpoint Group (NEG) with URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" \} and { service="bar2", tag="foo2" \} respectively.
         */
        urlMask?: string | null;
    }
    /**
     * Load balancing specific fields for network endpoint group.
     */
    export interface Schema$NetworkEndpointGroupLbNetworkEndpointGroup {
        /**
         * The default port used if the port number is not specified in the network endpoint. [Deprecated] This field is deprecated.
         */
        defaultPort?: number | null;
        /**
         * The URL of the network to which all network endpoints in the NEG belong. Uses "default" project network if unspecified. [Deprecated] This field is deprecated.
         */
        network?: string | null;
        /**
         * Optional URL of the subnetwork to which all network endpoints in the NEG belong. [Deprecated] This field is deprecated.
         */
        subnetwork?: string | null;
        /**
         * [Output Only] The URL of the zone where the network endpoint group is located. [Deprecated] This field is deprecated.
         */
        zone?: string | null;
    }
    export interface Schema$NetworkEndpointGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkEndpointGroup resources.
         */
        items?: Schema$NetworkEndpointGroup[];
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupList for network endpoint group lists.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NetworkEndpointGroupsAttachEndpointsRequest {
        /**
         * The list of network endpoints to be attached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    export interface Schema$NetworkEndpointGroupsDetachEndpointsRequest {
        /**
         * The list of network endpoints to be detached.
         */
        networkEndpoints?: Schema$NetworkEndpoint[];
    }
    /**
     * Configuration for a Serverless Deployment network endpoint group (NEG). The platform must be provided.
     *
     * Note: The target backend service must be in the same project and located in the same region as the Serverless NEG.
     */
    export interface Schema$NetworkEndpointGroupServerlessDeployment {
        /**
         * The platform of the backend target(s) of this NEG. Possible values include:
         *
         *
         * - apigateway.googleapis.com
         * - appengine.googleapies.com
         * - cloudfunctions.googleapis.com
         * - run.googleapis.com
         */
        platform?: string | null;
        /**
         * The user-defined name of the workload/instance. This value must be provided explicitly or in the urlMask. The resource identified by this value is platform-specific and is as follows:
         *
         *
         * - API Gateway: The gateway id
         * - AppEngine: The service name
         * - Cloud Functions: The function name
         * - Cloud Run: The service name
         */
        resource?: string | null;
        /**
         * A template to parse platform-specific fields from a request URL. URL mask allows for routing to multiple services on the same serverless platform without having to create multiple Network Endpoint Groups and backend services. The fields parsed by this template is platform-specific and are as follows:
         *
         *
         * - API Gateway: The gateway id
         * - AppEngine: The service and version
         * - Cloud Functions: The function
         * - Cloud Run: The service and tag
         */
        urlMask?: string | null;
        /**
         * The optional resource version. The version identified by this value is as platform-specific and is follows:
         *
         *
         * - API Gateway: Unused
         * - AppEngine: The service version
         * - Cloud Functions: Unused
         * - Cloud Run: The service tag
         */
        version?: string | null;
    }
    export interface Schema$NetworkEndpointGroupsListEndpointsRequest {
        /**
         * Optional list of endpoints to query. This is a more efficient but also limited version of filter parameter. Endpoints in the filter must have ip_address and port fields populated, other fields are not supported.
         */
        endpointFilters?: Schema$NetworkEndpointGroupsListEndpointsRequestNetworkEndpointFilter[];
        /**
         * Optional query parameter for showing the health status of each network endpoint. Valid options are SKIP or SHOW. If you don't specify this parameter, the health status of network endpoints will not be provided.
         */
        healthStatus?: string | null;
    }
    export interface Schema$NetworkEndpointGroupsListEndpointsRequestNetworkEndpointFilter {
        networkEndpoint?: Schema$NetworkEndpoint;
    }
    export interface Schema$NetworkEndpointGroupsListNetworkEndpoints {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NetworkEndpointWithHealthStatus resources.
         */
        items?: Schema$NetworkEndpointWithHealthStatus[];
        /**
         * [Output Only] The resource type, which is always compute#networkEndpointGroupsListNetworkEndpoints for the list of network endpoints in the specified network endpoint group.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NetworkEndpointGroupsScopedList {
        /**
         * [Output Only] The list of network endpoint groups that are contained in this scope.
         */
        networkEndpointGroups?: Schema$NetworkEndpointGroup[];
        /**
         * [Output Only] An informational warning that replaces the list of network endpoint groups when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NetworkEndpointWithHealthStatus {
        /**
         * [Output only] The health status of network endpoint;
         */
        healths?: Schema$HealthStatusForNetworkEndpoint[];
        /**
         * [Output only] The network endpoint;
         */
        networkEndpoint?: Schema$NetworkEndpoint;
    }
    /**
     * A network interface resource attached to an instance.
     */
    export interface Schema$NetworkInterface {
        /**
         * An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.
         */
        accessConfigs?: Schema$AccessConfig[];
        /**
         * An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.
         */
        aliasIpRanges?: Schema$AliasIpRange[];
        /**
         * Fingerprint hash of contents stored in this network interface. This field will be ignored when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be provided in order to update the NetworkInterface. The request will fail with error 400 Bad Request if the fingerprint is not provided, or 412 Precondition Failed if the fingerprint is out of date.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The prefix length of the primary internal IPv6 range.
         */
        internalIpv6PrefixLength?: number | null;
        /**
         * An array of IPv6 access configurations for this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there is no ipv6AccessConfig specified, then this instance will have no external IPv6 Internet access.
         */
        ipv6AccessConfigs?: Schema$AccessConfig[];
        /**
         * [Output Only] One of EXTERNAL, INTERNAL to indicate whether the IP can be accessed from the Internet. This field is always inherited from its subnetwork.
         *
         * Valid only if stackType is IPV4_IPV6.
         */
        ipv6AccessType?: string | null;
        /**
         * [Output Only] An IPv6 internal network address for this network interface.
         */
        ipv6Address?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#networkInterface for network interfaces.
         */
        kind?: string | null;
        /**
         * [Output Only] The name of the network interface, which is generated by the server. For network devices, these are eth0, eth1, etc.
         */
        name?: string | null;
        /**
         * URL of the network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used; if the network is not specified but the subnetwork is specified, the network is inferred.
         *
         * If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs:
         * - https://www.googleapis.com/compute/v1/projects/project/global/networks/network
         * - projects/project/global/networks/network
         * - global/networks/default
         */
        network?: string | null;
        /**
         * An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.
         */
        networkIP?: string | null;
        /**
         * The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
         */
        nicType?: string | null;
        /**
         * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It'll be empty if not specified by the users.
         */
        queueCount?: number | null;
        /**
         * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
         *
         * This field can be both set at instance creation and update network interface operations.
         */
        stackType?: string | null;
        /**
         * SubInterfaces help enable L2 communication for the instance over subnetworks that support L2. Every network interface will get a default untagged (vlan not specified) subinterface. Users can specify additional tagged subinterfaces which are sub-fields to the Network Interface.
         */
        subinterfaces?: Schema$NetworkInterfaceSubInterface[];
        /**
         * The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs:
         * - https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnetwork
         * - regions/region/subnetworks/subnetwork
         */
        subnetwork?: string | null;
    }
    export interface Schema$NetworkInterfaceSubInterface {
        /**
         * An IPv4 internal IP address to assign to the instance for this subinterface.
         */
        ipAddress?: string | null;
        /**
         * If specified, this subnetwork must belong to the same network as that of the network interface. If not specified the subnet of network interface will be used. If you specify this property, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs:
         * - https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnetwork
         * - regions/region/subnetworks/subnetwork
         */
        subnetwork?: string | null;
        /**
         * VLAN tag. Should match the VLAN(s) supported by the subnetwork to which this subinterface is connecting.
         */
        vlan?: number | null;
    }
    /**
     * Contains a list of networks.
     */
    export interface Schema$NetworkList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Network resources.
         */
        items?: Schema$Network[];
        /**
         * [Output Only] Type of resource. Always compute#networkList for lists of networks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A network peering attached to a network resource. The message includes the peering name, peer network, peering state, and a flag indicating whether Google Compute Engine should automatically create routes for the peering.
     */
    export interface Schema$NetworkPeering {
        /**
         * Whether Cloud Routers in this network can automatically advertise subnets from the peer network.
         */
        advertisePeerSubnetsViaRouters?: boolean | null;
        /**
         * This field will be deprecated soon. Use the exchange_subnet_routes field instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        autoCreateRoutes?: boolean | null;
        /**
         * Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        exchangeSubnetRoutes?: boolean | null;
        /**
         * Whether to export the custom routes to peer network.
         */
        exportCustomRoutes?: boolean | null;
        /**
         * Whether subnet routes with public IP range are exported. The default value is true, all subnet routes are exported. The IPv4 special-use ranges (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always exported to peers and are not controlled by this field.
         */
        exportSubnetRoutesWithPublicIp?: boolean | null;
        /**
         * Whether to import the custom routes from peer network.
         */
        importCustomRoutes?: boolean | null;
        /**
         * Whether subnet routes with public IP range are imported. The default value is false. The IPv4 special-use ranges (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always imported from peers and are not controlled by this field.
         */
        importSubnetRoutesWithPublicIp?: boolean | null;
        /**
         * Name of this peering. Provided by the client when the peering is created. The name must comply with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all the following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
         */
        network?: string | null;
        /**
         * Maximum Transmission Unit in bytes.
         */
        peerMtu?: number | null;
        /**
         * [Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.
         */
        state?: string | null;
        /**
         * [Output Only] Details about the current state of the peering.
         */
        stateDetails?: string | null;
    }
    export interface Schema$NetworkPerformanceConfig {
        externalIpEgressBandwidthTier?: string | null;
        totalEgressBandwidthTier?: string | null;
    }
    /**
     * A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
     */
    export interface Schema$NetworkRoutingConfig {
        /**
         * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
         */
        routingMode?: string | null;
    }
    export interface Schema$NetworksAddPeeringRequest {
        /**
         * This field will be deprecated soon. Use exchange_subnet_routes in network_peering instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
         */
        autoCreateRoutes?: boolean | null;
        /**
         * This field will be deprecated soon. Use export_custom_routes in network_peering instead. Whether to export the custom routes to peer network.
         */
        exportCustomRoutes?: boolean | null;
        /**
         * This field will be deprecated soon. Use import_custom_routes in network_peering instead. Whether to import the custom routes from peer network.
         */
        importCustomRoutes?: boolean | null;
        /**
         * Name of the peering, which should conform to RFC1035.
         */
        name?: string | null;
        /**
         * Network peering parameters. In order to specify route policies for peering using import and export custom routes, you must specify all peering related parameters (name, peer network, exchange_subnet_routes) in the network_peering field. The corresponding fields in NetworksAddPeeringRequest will be deprecated soon.
         */
        networkPeering?: Schema$NetworkPeering;
        /**
         * URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
         */
        peerNetwork?: string | null;
    }
    export interface Schema$NetworksGetEffectiveFirewallsResponse {
        /**
         * Effective firewalls from firewall policy.
         */
        firewallPolicys?: Schema$NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy[];
        /**
         * Effective firewalls on the network.
         */
        firewalls?: Schema$Firewall[];
        /**
         * Effective firewalls from organization policies.
         */
        organizationFirewalls?: Schema$NetworksGetEffectiveFirewallsResponseOrganizationFirewallPolicy[];
    }
    export interface Schema$NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy {
        /**
         * [Output Only] Deprecated, please use short name instead. The display name of the firewall policy.
         */
        displayName?: string | null;
        /**
         * [Output Only] The name of the firewall policy.
         */
        name?: string | null;
        /**
         * The rules that apply to the network.
         */
        rules?: Schema$FirewallPolicyRule[];
        /**
         * [Output Only] The short name of the firewall policy.
         */
        shortName?: string | null;
        /**
         * [Output Only] The type of the firewall policy.
         */
        type?: string | null;
    }
    /**
     * A pruned SecurityPolicy containing ID and any applicable firewall rules.
     */
    export interface Schema$NetworksGetEffectiveFirewallsResponseOrganizationFirewallPolicy {
        /**
         * [Output Only] The unique identifier for the security policy. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * The rules that apply to the network.
         */
        rules?: Schema$SecurityPolicyRule[];
    }
    export interface Schema$NetworksRemovePeeringRequest {
        /**
         * Name of the peering, which should conform to RFC1035.
         */
        name?: string | null;
    }
    export interface Schema$NetworksUpdatePeeringRequest {
        networkPeering?: Schema$NetworkPeering;
    }
    /**
     * Represent a sole-tenant Node Group resource.
     *
     * A sole-tenant node is a physical server that is dedicated to hosting VM instances only for your specific project. Use sole-tenant nodes to keep your instances physically separated from instances in other projects, or to group your instances together on the same host hardware. For more information, read Sole-tenant nodes. (== resource_for {$api_version\}.nodeGroups ==)
     */
    export interface Schema$NodeGroup {
        /**
         * Specifies how autoscaling should behave.
         */
        autoscalingPolicy?: Schema$NodeGroupAutoscalingPolicy;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
         */
        kind?: string | null;
        /**
         * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
         */
        locationHint?: string | null;
        /**
         * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see  Maintenance policies.
         */
        maintenancePolicy?: string | null;
        maintenanceWindow?: Schema$NodeGroupMaintenanceWindow;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * URL of the node template to create the node group from.
         */
        nodeTemplate?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The total number of nodes in the node group.
         */
        size?: number | null;
        status?: string | null;
        /**
         * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
         */
        zone?: string | null;
    }
    export interface Schema$NodeGroupAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeGroupsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeGroupsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource.Always compute#nodeGroupAggregatedList for aggregated lists of node groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeGroupAutoscalingPolicy {
        /**
         * The maximum number of nodes that the group should have. Must be set if autoscaling is enabled. Maximum value allowed is 100.
         */
        maxNodes?: number | null;
        /**
         * The minimum number of nodes that the group should have.
         */
        minNodes?: number | null;
        /**
         * The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see  Autoscaler modes.
         */
        mode?: string | null;
    }
    /**
     * Contains a list of nodeGroups.
     */
    export interface Schema$NodeGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeGroup resources.
         */
        items?: Schema$NodeGroup[];
        /**
         * [Output Only] Type of resource.Always compute#nodeGroupList for lists of node groups.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Time window specified for daily maintenance operations. GCE's internal maintenance will be performed within this window.
     */
    export interface Schema$NodeGroupMaintenanceWindow {
        /**
         * [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
         */
        duration?: string | null;
        /**
         * [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
         */
        maintenanceDuration?: Schema$Duration;
        /**
         * Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
         */
        startTime?: string | null;
    }
    export interface Schema$NodeGroupNode {
        /**
         * Accelerators for this node.
         */
        accelerators?: Schema$AcceleratorConfig[];
        /**
         * CPU overcommit.
         */
        cpuOvercommitType?: string | null;
        /**
         * Local disk configurations.
         */
        disks?: Schema$LocalDisk[];
        /**
         * Instances scheduled on this node.
         */
        instances?: string[] | null;
        /**
         * The name of the node.
         */
        name?: string | null;
        /**
         * The type of this node.
         */
        nodeType?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Binding properties for the physical server.
         */
        serverBinding?: Schema$ServerBinding;
        /**
         * Server ID associated with this node.
         */
        serverId?: string | null;
        status?: string | null;
    }
    export interface Schema$NodeGroupsAddNodesRequest {
        /**
         * Count of additional nodes to be added to the node group.
         */
        additionalNodeCount?: number | null;
    }
    export interface Schema$NodeGroupsDeleteNodesRequest {
        /**
         * Names of the nodes to delete.
         */
        nodes?: string[] | null;
    }
    export interface Schema$NodeGroupsListNodes {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Node resources.
         */
        items?: Schema$NodeGroupNode[];
        /**
         * [Output Only] The resource type, which is always compute.nodeGroupsListNodes for the list of nodes in the specified node group.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeGroupsScopedList {
        /**
         * [Output Only] A list of node groups contained in this scope.
         */
        nodeGroups?: Schema$NodeGroup[];
        /**
         * [Output Only] An informational warning that appears when the nodeGroup list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeGroupsSetNodeTemplateRequest {
        /**
         * Full or partial URL of the node template resource to be updated for this node group.
         */
        nodeTemplate?: string | null;
    }
    /**
     * Represent a sole-tenant Node Template resource.
     *
     * You can use a template to define properties for nodes in a node group. For more information, read Creating node groups and instances. (== resource_for {$api_version\}.nodeTemplates ==)
     */
    export interface Schema$NodeTemplate {
        accelerators?: Schema$AcceleratorConfig[];
        /**
         * CPU overcommit.
         */
        cpuOvercommitType?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        disks?: Schema$LocalDisk[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
         */
        kind?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Labels to use for node affinity, which will be used in instance scheduling.
         */
        nodeAffinityLabels?: {
            [key: string]: string;
        } | null;
        /**
         * The node type to use for nodes group that are created from this template.
         */
        nodeType?: string | null;
        /**
         * The flexible properties of the desired node type. Node groups that use this node template will create nodes of a type that matches these properties.
         *
         * This field is mutually exclusive with the node_type property; you can only define one or the other, but not both.
         */
        nodeTypeFlexibility?: Schema$NodeTemplateNodeTypeFlexibility;
        /**
         * [Output Only] The name of the region where the node template resides, such as us-central1.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Sets the binding properties for the physical server. Valid values include:
         * - [Default] RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server
         * - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible
         *
         * See Sole-tenant node options for more information.
         */
        serverBinding?: Schema$ServerBinding;
        /**
         * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
         */
        status?: string | null;
        /**
         * [Output Only] An optional, human-readable explanation of the status.
         */
        statusMessage?: string | null;
    }
    export interface Schema$NodeTemplateAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeTemplatesScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeTemplatesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource.Always compute#nodeTemplateAggregatedList for aggregated lists of node templates.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of node templates.
     */
    export interface Schema$NodeTemplateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeTemplate resources.
         */
        items?: Schema$NodeTemplate[];
        /**
         * [Output Only] Type of resource.Always compute#nodeTemplateList for lists of node templates.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeTemplateNodeTypeFlexibility {
        cpus?: string | null;
        localSsd?: string | null;
        memory?: string | null;
    }
    export interface Schema$NodeTemplatesScopedList {
        /**
         * [Output Only] A list of node templates contained in this scope.
         */
        nodeTemplates?: Schema$NodeTemplate[];
        /**
         * [Output Only] An informational warning that appears when the node templates list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represent a sole-tenant Node Type resource.
     *
     * Each node within a node group must have a node type. A node type specifies the total amount of cores and memory for that node. Currently, the only available node type is n1-node-96-624 node type that has 96 vCPUs and 624 GB of memory, available in multiple zones. For more information read Node types. (== resource_for {$api_version\}.nodeTypes ==)
     */
    export interface Schema$NodeType {
        /**
         * [Output Only] The CPU platform used by this node type.
         */
        cpuPlatform?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this node type.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The number of virtual CPUs that are available to the node type.
         */
        guestCpus?: number | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#nodeType for node types.
         */
        kind?: string | null;
        /**
         * [Output Only] Local SSD available to the node type, defined in GB.
         */
        localSsdGb?: number | null;
        /**
         * [Output Only] The amount of physical memory available to the node type, defined in MB.
         */
        memoryMb?: number | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The name of the zone where the node type resides, such as us-central1-a.
         */
        zone?: string | null;
    }
    export interface Schema$NodeTypeAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeTypesScopedList resources.
         */
        items?: {
            [key: string]: Schema$NodeTypesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource.Always compute#nodeTypeAggregatedList for aggregated lists of node types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of node types.
     */
    export interface Schema$NodeTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NodeType resources.
         */
        items?: Schema$NodeType[];
        /**
         * [Output Only] Type of resource.Always compute#nodeTypeList for lists of node types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NodeTypesScopedList {
        /**
         * [Output Only] A list of node types contained in this scope.
         */
        nodeTypes?: Schema$NodeType[];
        /**
         * [Output Only] An informational warning that appears when the node types list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a notification endpoint.
     *
     * A notification endpoint resource defines an endpoint to receive notifications when there are status changes detected by the associated health check service.
     *
     * For more information, see  Health checks overview. (== resource_for {$api_version\}.notificationEndpoint ==) (== resource_for {$api_version\}.regionNotificationEndpoints ==)
     */
    export interface Schema$NotificationEndpoint {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Settings of the gRPC notification endpoint including the endpoint URL and the retry duration.
         */
        grpcSettings?: Schema$NotificationEndpointGrpcSettings;
        /**
         * [Output Only] A unique identifier for this resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#notificationEndpoint for notification endpoints.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the notification endpoint resides. This field applies only to the regional resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
    }
    /**
     * Contains a list of NotificationEndpointsScopedList.
     */
    export interface Schema$NotificationEndpointAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NotificationEndpointsScopedList resources.
         */
        items?: {
            [key: string]: Schema$NotificationEndpointsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a gRPC setting that describes one gRPC notification endpoint and the retry duration attempting to send notification to this endpoint.
     */
    export interface Schema$NotificationEndpointGrpcSettings {
        /**
         * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
         */
        authority?: string | null;
        /**
         * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
         */
        endpoint?: string | null;
        /**
         * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
         */
        payloadName?: string | null;
        /**
         * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed.
         */
        resendInterval?: Schema$Duration;
        /**
         * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
         */
        retryDurationSec?: number | null;
    }
    export interface Schema$NotificationEndpointList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of NotificationEndpoint resources.
         */
        items?: Schema$NotificationEndpoint[];
        /**
         * [Output Only] Type of the resource. Always compute#notificationEndpoint for notification endpoints.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$NotificationEndpointsScopedList {
        /**
         * A list of NotificationEndpoints contained in this scope.
         */
        resources?: Schema$NotificationEndpoint[];
        /**
         * Informational warning which replaces the list of notification endpoints when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents an Operation resource.
     *
     * Google Compute Engine has three Operation resources:
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/globalOperations) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionOperations) * [Zonal](/compute/docs/reference/rest/{$api_version\}/zoneOperations)
     *
     * You can use an operation resource to manage asynchronous API requests. For more information, read Handling API responses.
     *
     * Operations can be global, regional or zonal.
     * - For global operations, use the `globalOperations` resource.
     * - For regional operations, use the `regionOperations` resource.
     * - For zonal operations, use the `zonalOperations` resource.
     *
     * For more information, read  Global, Regional, and Zonal Resources. (== resource_for {$api_version\}.globalOperations ==) (== resource_for {$api_version\}.regionOperations ==) (== resource_for {$api_version\}.zoneOperations ==)
     */
    export interface Schema$Operation {
        /**
         * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
         */
        clientOperationId?: string | null;
        /**
         * [Deprecated] This field is deprecated.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] A textual description of the operation, which is set when the operation is created.
         */
        description?: string | null;
        /**
         * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
         */
        endTime?: string | null;
        /**
         * [Output Only] If errors are generated during processing of the operation, this field will be populated.
         */
        error?: {
            errors?: Array<{
                code?: string;
                location?: string;
                message?: string;
            }>;
        } | null;
        /**
         * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
         */
        httpErrorMessage?: string | null;
        /**
         * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
         */
        httpErrorStatusCode?: number | null;
        /**
         * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
         */
        insertTime?: string | null;
        /**
         * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
         */
        kind?: string | null;
        /**
         * [Output Only] Service-specific metadata attached to this operation.
         */
        metadata?: Schema$Any;
        /**
         * [Output Only] Name of the operation.
         */
        name?: string | null;
        /**
         * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
         */
        operationGroupId?: string | null;
        /**
         * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
         */
        operationType?: string | null;
        /**
         * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
         */
        progress?: number | null;
        /**
         * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
         */
        startTime?: string | null;
        /**
         * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
         */
        status?: string | null;
        /**
         * [Output Only] An optional textual description of the current status of the operation.
         */
        statusMessage?: string | null;
        /**
         * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
         */
        targetId?: string | null;
        /**
         * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
         */
        targetLink?: string | null;
        /**
         * [Output Only] User who requested the operation, for example: `user@example.com`.
         */
        user?: string | null;
        /**
         * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
         */
        warnings?: Array<{
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        }> | null;
        /**
         * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
         */
        zone?: string | null;
    }
    export interface Schema$OperationAggregatedList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A map of scoped operation lists.
         */
        items?: {
            [key: string]: Schema$OperationsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always `compute#operationAggregatedList` for aggregated lists of operations.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than `maxResults`, use the `nextPageToken` as a value for the query parameter `pageToken` in the next list request. Subsequent list requests will have their own `nextPageToken` to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of Operation resources.
     */
    export interface Schema$OperationList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of Operation resources.
         */
        items?: Schema$Operation[];
        /**
         * [Output Only] Type of resource. Always `compute#operations` for Operations resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than `maxResults`, use the `nextPageToken` as a value for the query parameter `pageToken` in the next list request. Subsequent list requests will have their own `nextPageToken` to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$OperationsScopedList {
        /**
         * [Output Only] A list of operations contained in this scope.
         */
        operations?: Schema$Operation[];
        /**
         * [Output Only] Informational warning which replaces the list of operations when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$OrganizationSecurityPoliciesListAssociationsResponse {
        /**
         * A list of associations.
         */
        associations?: Schema$SecurityPolicyAssociation[];
        /**
         * [Output Only] Type of securityPolicy associations. Always compute#organizationSecurityPoliciesListAssociations for lists of securityPolicy associations.
         */
        kind?: string | null;
    }
    /**
     * [Deprecated] Configuration for the origin authentication method. Configuration for the origin authentication method.
     */
    export interface Schema$OriginAuthenticationMethod {
        jwt?: Schema$Jwt;
    }
    /**
     * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
     */
    export interface Schema$OutlierDetection {
        /**
         * The base time that a host is ejected for. The real ejection time is equal to the base ejection time multiplied by the number of times the host has been ejected. Defaults to 30000ms or 30s.
         */
        baseEjectionTime?: Schema$Duration;
        /**
         * Number of errors before a host is ejected from the connection pool. When the backend host is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
         */
        consecutiveErrors?: number | null;
        /**
         * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
         */
        consecutiveGatewayFailure?: number | null;
        /**
         * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
         */
        enforcingConsecutiveErrors?: number | null;
        /**
         * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
         */
        enforcingConsecutiveGatewayFailure?: number | null;
        /**
         * The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
         */
        enforcingSuccessRate?: number | null;
        /**
         * Time interval between ejection analysis sweeps. This can result in both new ejections as well as hosts being returned to service. Defaults to 1 second.
         */
        interval?: Schema$Duration;
        /**
         * Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 50%.
         */
        maxEjectionPercent?: number | null;
        /**
         * The number of hosts in a cluster that must have enough request volume to detect success rate outliers. If the number of hosts is less than this setting, outlier detection via success rate statistics is not performed for any host in the cluster. Defaults to 5.
         */
        successRateMinimumHosts?: number | null;
        /**
         * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that host. Defaults to 100.
         */
        successRateRequestVolume?: number | null;
        /**
         * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900.
         */
        successRateStdevFactor?: number | null;
    }
    /**
     * Next free: 7
     */
    export interface Schema$PacketIntervals {
        /**
         * Average observed inter-packet interval in milliseconds.
         */
        avgMs?: string | null;
        /**
         * From how long ago in the past these intervals were observed.
         */
        duration?: string | null;
        /**
         * Maximum observed inter-packet interval in milliseconds.
         */
        maxMs?: string | null;
        /**
         * Minimum observed inter-packet interval in milliseconds.
         */
        minMs?: string | null;
        /**
         * Number of inter-packet intervals from which these statistics were derived.
         */
        numIntervals?: string | null;
        /**
         * The type of packets for which inter-packet intervals were computed.
         */
        type?: string | null;
    }
    /**
     * Represents a Packet Mirroring resource.
     *
     * Packet Mirroring clones the traffic of specified instances in your Virtual Private Cloud (VPC) network and forwards it to a collector destination, such as an instance group of an internal TCP/UDP load balancer, for analysis or examination. For more information about setting up Packet Mirroring, see Using Packet Mirroring. (== resource_for {$api_version\}.packetMirrorings ==)
     */
    export interface Schema$PacketMirroring {
        /**
         * The Forwarding Rule resource of type loadBalancingScheme=INTERNAL that will be used as collector for mirrored traffic. The specified forwarding rule must have isMirroringCollector set to true.
         */
        collectorIlb?: Schema$PacketMirroringForwardingRuleInfo;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet mirroring policy will not be enforced on the network.
         *
         * The default is TRUE.
         */
        enable?: string | null;
        /**
         * Filter for mirrored traffic. If unspecified, all traffic is mirrored.
         */
        filter?: Schema$PacketMirroringFilter;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#packetMirroring for packet mirrorings.
         */
        kind?: string | null;
        /**
         * PacketMirroring mirroredResourceInfos. MirroredResourceInfo specifies a set of mirrored VM instances, subnetworks and/or tags for which traffic from/to all VM instances will be mirrored.
         */
        mirroredResources?: Schema$PacketMirroringMirroredResourceInfo;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Specifies the mirrored VPC network. Only packets in this network will be mirrored. All mirrored VMs should have a NIC in the given network. All mirrored subnetworks should belong to the given network.
         */
        network?: Schema$PacketMirroringNetworkInfo;
        /**
         * The priority of applying this configuration. Priority is used to break ties in cases where there is more than one matching rule. In the case of two rules that apply for a given Instance, the one with the lowest-numbered priority value wins.
         *
         * Default value is 1000. Valid range is 0 through 65535.
         */
        priority?: number | null;
        /**
         * [Output Only] URI of the region where the packetMirroring resides.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Contains a list of packetMirrorings.
     */
    export interface Schema$PacketMirroringAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PacketMirroring resources.
         */
        items?: {
            [key: string]: Schema$PacketMirroringsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PacketMirroringFilter {
        /**
         * IP CIDR ranges that apply as filter on the source (ingress) or destination (egress) IP in the IP header. Only IPv4 is supported. If no ranges are specified, all traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
         */
        cidrRanges?: string[] | null;
        /**
         * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
         */
        direction?: string | null;
        /**
         * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
         */
        IPProtocols?: string[] | null;
    }
    export interface Schema$PacketMirroringForwardingRuleInfo {
        /**
         * [Output Only] Unique identifier for the forwarding rule; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * Resource URL to the forwarding rule representing the ILB configured as destination of the mirrored traffic.
         */
        url?: string | null;
    }
    /**
     * Contains a list of PacketMirroring resources.
     */
    export interface Schema$PacketMirroringList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PacketMirroring resources.
         */
        items?: Schema$PacketMirroring[];
        /**
         * [Output Only] Type of resource. Always compute#packetMirroring for packetMirrorings.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PacketMirroringMirroredResourceInfo {
        /**
         * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring.
         *
         * Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring.
         *
         * You may specify a maximum of 50 Instances.
         */
        instances?: Schema$PacketMirroringMirroredResourceInfoInstanceInfo[];
        /**
         * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring.
         *
         * You may specify a maximum of 5 subnetworks.
         */
        subnetworks?: Schema$PacketMirroringMirroredResourceInfoSubnetInfo[];
        /**
         * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
         */
        tags?: string[] | null;
    }
    export interface Schema$PacketMirroringMirroredResourceInfoInstanceInfo {
        /**
         * [Output Only] Unique identifier for the instance; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * Resource URL to the virtual machine instance which is being mirrored.
         */
        url?: string | null;
    }
    export interface Schema$PacketMirroringMirroredResourceInfoSubnetInfo {
        /**
         * [Output Only] Unique identifier for the subnetwork; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * Resource URL to the subnetwork for which traffic from/to all VM instances will be mirrored.
         */
        url?: string | null;
    }
    export interface Schema$PacketMirroringNetworkInfo {
        /**
         * [Output Only] Unique identifier for the network; defined by the server.
         */
        canonicalUrl?: string | null;
        /**
         * URL of the network resource.
         */
        url?: string | null;
    }
    export interface Schema$PacketMirroringsScopedList {
        /**
         * A list of packetMirrorings contained in this scope.
         */
        packetMirrorings?: Schema$PacketMirroring[];
        /**
         * Informational warning which replaces the list of packetMirrorings when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service will be used.
     */
    export interface Schema$PathMatcher {
        /**
         * defaultRouteAction takes effect when none of the  pathRules or routeRules match. The load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any  weightedBackendServices.
         * Only one of defaultRouteAction or defaultUrlRedirect must be set.
         * UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a pathMatcher's defaultRouteAction.
         */
        defaultRouteAction?: Schema$HttpRouteAction;
        /**
         * The full or partial URL to the BackendService resource. This will be used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource:
         * - https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService
         * - compute/v1/projects/project/global/backendServices/backendService
         * - global/backendServices/backendService  If defaultRouteAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified.
         * Only one of defaultService, defaultUrlRedirect  or defaultRouteAction.weightedBackendService must be set.
         * Authorization requires one or more of the following Google IAM permissions on the specified resource default_service:
         * - compute.backendBuckets.use
         * - compute.backendServices.use
         */
        defaultService?: string | null;
        /**
         * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect.
         * If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set.
         * Not supported when the URL map is bound to target gRPC proxy.
         */
        defaultUrlRedirect?: Schema$HttpRedirectAction;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Specifies changes to request and response headers that need to take effect for the selected backendService.
         * HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap
         * Note that headerAction is not supported for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        headerAction?: Schema$HttpHeaderAction;
        /**
         * The name to which this PathMatcher is referred by the HostRule.
         */
        name?: string | null;
        /**
         * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis.
         * For example: a pathRule with a path /a/b/c/x will match before /a/b/x irrespective of the order in which those paths appear in this list.
         * Within a given pathMatcher, only one of pathRules or routeRules must be set.
         */
        pathRules?: Schema$PathRule[];
        /**
         * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number.
         * Within a given pathMatcher, you can set only one of pathRules or routeRules.
         */
        routeRules?: Schema$HttpRouteRule[];
    }
    /**
     * A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
     */
    export interface Schema$PathRule {
        /**
         * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
         */
        paths?: string[] | null;
        /**
         * In response to a matching path, the load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If routeAction specifies any  weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any  weightedBackendServices.
         * Only one of routeAction or urlRedirect must be set.
         * UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a pathRule's routeAction.
         */
        routeAction?: Schema$HttpRouteAction;
        /**
         * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any  weightedBackendServices, service must not be specified.
         * Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
         */
        service?: string | null;
        /**
         * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
         * If urlRedirect is specified, service or routeAction must not be set.
         * Not supported when the URL map is bound to target gRPC proxy.
         */
        urlRedirect?: Schema$HttpRedirectAction;
    }
    /**
     * [Deprecated] Configuration for the peer authentication method. Configuration for the peer authentication method.
     */
    export interface Schema$PeerAuthenticationMethod {
        /**
         * Set if mTLS is used for peer authentication.
         */
        mtls?: Schema$MutualTls;
    }
    export interface Schema$PerInstanceConfig {
        /**
         * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance config or the field needs to be unset.
         */
        fingerprint?: string | null;
        /**
         * The name of a per-instance config and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance config with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance config for a VM instance that either doesn't exist or is not part of the group will result in an error.
         */
        name?: string | null;
        /**
         * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
         */
        preservedState?: Schema$PreservedState;
        /**
         * The status of applying this per-instance config on the corresponding managed instance.
         */
        status?: string | null;
    }
    /**
     * [Deprecated] All fields defined in a permission are ANDed.
     */
    export interface Schema$Permission {
        /**
         * Extra custom constraints. The constraints are ANDed together.
         */
        constraints?: Schema$PermissionConstraint[];
        /**
         * Used in Ingress or Egress Gateway cases to specify hosts that the policy applies to. Exact match, prefix match, and suffix match are supported.
         */
        hosts?: string[] | null;
        /**
         * HTTP method.
         */
        methods?: string[] | null;
        /**
         * Negate of hosts. Specifies exclusions.
         */
        notHosts?: string[] | null;
        /**
         * Negate of methods. Specifies exclusions.
         */
        notMethods?: string[] | null;
        /**
         * Negate of paths. Specifies exclusions.
         */
        notPaths?: string[] | null;
        /**
         * Negate of ports. Specifies exclusions.
         */
        notPorts?: string[] | null;
        /**
         * HTTP request paths or gRPC methods. Exact match, prefix match, and suffix match are supported.
         */
        paths?: string[] | null;
        /**
         * Port names or numbers.
         */
        ports?: string[] | null;
    }
    /**
     * Custom constraint that specifies a key and a list of allowed values for Istio attributes.
     */
    export interface Schema$PermissionConstraint {
        /**
         * Key of the constraint.
         */
        key?: string | null;
        /**
         * A list of allowed values.
         */
        values?: string[] | null;
    }
    /**
     * An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources.
     *
     *
     *
     * A `Policy` is a collection of `bindings`. A `binding` binds one or more `members` to a single `role`. Members can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role.
     *
     * For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
     *
     * **JSON example:**
     *
     * { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] \}, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve@example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')", \} \} ], "etag": "BwWWja0YfJA=", "version": 3 \}
     *
     * **YAML example:**
     *
     * bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve@example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= - version: 3
     *
     * For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
     */
    export interface Schema$Policy {
        /**
         * Specifies cloud audit logging configuration for this policy.
         */
        auditConfigs?: Schema$AuditConfig[];
        /**
         * Associates a list of `members` to a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one member.
         */
        bindings?: Schema$Binding[];
        /**
         * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy.
         *
         * **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
         */
        etag?: string | null;
        iamOwned?: boolean | null;
        /**
         * If more than one rule is specified, the rules are applied in the following manner: - All matching LOG rules are always applied. - If any DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be applied if one or more matching rule requires logging. - Otherwise, if any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging will be applied if one or more matching rule requires logging. - Otherwise, if no rule applies, permission is denied.
         */
        rules?: Schema$Rule[];
        /**
         * Specifies the format of the policy.
         *
         * Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected.
         *
         * Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations:
         *
         * * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions
         *
         * **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
         *
         * If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset.
         *
         * To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        version?: number | null;
    }
    export interface Schema$PreconfiguredWafSet {
        /**
         * List of entities that are currently supported for WAF rules.
         */
        expressionSets?: Schema$WafExpressionSet[];
    }
    /**
     * Preserved state for a given instance.
     */
    export interface Schema$PreservedState {
        /**
         * Preserved disks defined for this instance. This map is keyed with the device names of the disks.
         */
        disks?: {
            [key: string]: Schema$PreservedStatePreservedDisk;
        } | null;
        /**
         * Preserved external IPs defined for this instance. This map is keyed with the name of the network interface.
         */
        externalIPs?: {
            [key: string]: Schema$PreservedStatePreservedNetworkIp;
        } | null;
        /**
         * Preserved internal IPs defined for this instance. This map is keyed with the name of the network interface.
         */
        internalIPs?: {
            [key: string]: Schema$PreservedStatePreservedNetworkIp;
        } | null;
        /**
         * Preserved metadata defined for this instance.
         */
        metadata?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$PreservedStatePreservedDisk {
        /**
         * These stateful disks will never be deleted during autohealing, update, instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole MIG is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
         */
        autoDelete?: string | null;
        /**
         * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
         */
        mode?: string | null;
        /**
         * The URL of the disk resource that is stateful and should be attached to the VM instance.
         */
        source?: string | null;
    }
    export interface Schema$PreservedStatePreservedNetworkIp {
        /**
         * These stateful IPs will never be released during autohealing, update or VM instance recreate operations. This flag is used to configure if the IP reservation should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted.
         */
        autoDelete?: string | null;
        /**
         * Ip address representation
         */
        ipAddress?: Schema$PreservedStatePreservedNetworkIpIpAddress;
    }
    export interface Schema$PreservedStatePreservedNetworkIpIpAddress {
        /**
         * The URL of the reservation for this IP address.
         */
        address?: string | null;
        /**
         * An IPv4 internal network address to assign to the instance for this network interface.
         */
        literal?: string | null;
    }
    /**
     * [Deprecated] All fields defined in a principal are ANDed.
     */
    export interface Schema$Principal {
        /**
         * An expression to specify custom condition.
         */
        condition?: string | null;
        /**
         * The groups the principal belongs to. Exact match, prefix match, and suffix match are supported.
         */
        groups?: string[] | null;
        /**
         * IPv4 or IPv6 address or range (In CIDR format)
         */
        ips?: string[] | null;
        /**
         * The namespaces. Exact match, prefix match, and suffix match are supported.
         */
        namespaces?: string[] | null;
        /**
         * Negate of groups. Specifies exclusions.
         */
        notGroups?: string[] | null;
        /**
         * Negate of IPs. Specifies exclusions.
         */
        notIps?: string[] | null;
        /**
         * Negate of namespaces. Specifies exclusions.
         */
        notNamespaces?: string[] | null;
        /**
         * Negate of users. Specifies exclusions.
         */
        notUsers?: string[] | null;
        /**
         * A map of Istio attribute to expected values. Exact match, prefix match, and suffix match are supported for values. For example, `request.headers[version]: "v1"`. The properties are ANDed together.
         */
        properties?: {
            [key: string]: string;
        } | null;
        /**
         * The user names/IDs or service accounts. Exact match, prefix match, and suffix match are supported.
         */
        users?: string[] | null;
    }
    /**
     * Represents a Project resource.
     *
     * A project is used to organize resources in a Google Cloud Platform environment. For more information, read about the  Resource Hierarchy. (== resource_for {$api_version\}.projects ==)
     */
    export interface Schema$Project {
        /**
         * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
         */
        commonInstanceMetadata?: Schema$Metadata;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
         */
        defaultNetworkTier?: string | null;
        /**
         * [Output Only] Default service account used by VMs running in this project.
         */
        defaultServiceAccount?: string | null;
        /**
         * An optional textual description of the resource.
         */
        description?: string | null;
        /**
         * Restricted features enabled for use on this project.
         */
        enabledFeatures?: string[] | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is not the project ID, and is just a unique ID used by Compute Engine to identify resources.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#project for projects.
         */
        kind?: string | null;
        /**
         * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
         */
        name?: string | null;
        /**
         * [Output Only] Quotas assigned to this project.
         */
        quotas?: Schema$Quota[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * The naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
         */
        usageExportLocation?: Schema$UsageExportLocation;
        /**
         * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
         */
        xpnProjectStatus?: string | null;
    }
    export interface Schema$ProjectsDisableXpnResourceRequest {
        /**
         * Service resource (a.k.a service project) ID.
         */
        xpnResource?: Schema$XpnResourceId;
    }
    export interface Schema$ProjectsEnableXpnResourceRequest {
        /**
         * Service resource (a.k.a service project) ID.
         */
        xpnResource?: Schema$XpnResourceId;
    }
    export interface Schema$ProjectsGetXpnResources {
        /**
         * [Output Only] Type of resource. Always compute#projectsGetXpnResources for lists of service resources (a.k.a service projects)
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * Service resources (a.k.a service projects) attached to this project as their shared VPC host.
         */
        resources?: Schema$XpnResourceId[];
    }
    export interface Schema$ProjectsListXpnHostsRequest {
        /**
         * Optional organization ID managed by Cloud Resource Manager, for which to list shared VPC host projects. If not specified, the organization will be inferred from the project.
         */
        organization?: string | null;
    }
    export interface Schema$ProjectsSetDefaultNetworkTierRequest {
        /**
         * Default network tier to be set.
         */
        networkTier?: string | null;
    }
    export interface Schema$ProjectsSetDefaultServiceAccountRequest {
        /**
         * Email address of the service account.
         */
        email?: string | null;
    }
    /**
     * A public advertised prefix represents an aggregated IP prefix or netblock which customers bring to cloud. The IP prefix is a single unit of route advertisement and is announced globally to the internet.
     */
    export interface Schema$PublicAdvertisedPrefix {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * The IPv4 address to be used for reverse DNS verification.
         */
        dnsVerificationIp?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * The IPv4 address range, in CIDR format, represented by this public advertised prefix.
         */
        ipCidrRange?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
         */
        publicDelegatedPrefixs?: Schema$PublicAdvertisedPrefixPublicDelegatedPrefix[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The shared secret to be used for reverse DNS verification.
         */
        sharedSecret?: string | null;
        /**
         * The status of the public advertised prefix.
         */
        status?: string | null;
    }
    export interface Schema$PublicAdvertisedPrefixList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PublicAdvertisedPrefix resources.
         */
        items?: Schema$PublicAdvertisedPrefix[];
        /**
         * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a CIDR range which can be used to assign addresses.
     */
    export interface Schema$PublicAdvertisedPrefixPublicDelegatedPrefix {
        /**
         * The IP address range of the public delegated prefix
         */
        ipRange?: string | null;
        /**
         * The name of the public delegated prefix
         */
        name?: string | null;
        /**
         * The project number of the public delegated prefix
         */
        project?: string | null;
        /**
         * The region of the public delegated prefix if it is regional. If absent, the prefix is global.
         */
        region?: string | null;
        /**
         * The status of the public delegated prefix. Possible values are: INITIALIZING: The public delegated prefix is being initialized and addresses cannot be created yet. ANNOUNCED: The public delegated prefix is active.
         */
        status?: string | null;
    }
    /**
     * A PublicDelegatedPrefix resource represents an IP block within a PublicAdvertisedPrefix that is configured within a single cloud scope (global or region). IPs in the block can be allocated to resources within that scope. Public delegated prefixes may be further broken up into smaller IP blocks in the same scope as the parent block.
     */
    export interface Schema$PublicDelegatedPrefix {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * The IPv4 address range, in CIDR format, represented by this public delegated prefix.
         */
        ipCidrRange?: string | null;
        /**
         * If true, the prefix will be live migrated.
         */
        isLiveMigration?: boolean | null;
        /**
         * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
         */
        parentPrefix?: string | null;
        /**
         * The list of sub public delegated prefixes that exist for this public delegated prefix.
         */
        publicDelegatedSubPrefixs?: Schema$PublicDelegatedPrefixPublicDelegatedSubPrefix[];
        /**
         * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] The status of the public delegated prefix.
         */
        status?: string | null;
    }
    export interface Schema$PublicDelegatedPrefixAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PublicDelegatedPrefixesScopedList resources.
         */
        items?: {
            [key: string]: Schema$PublicDelegatedPrefixesScopedList;
        } | null;
        /**
         * [Output Only] Type of the resource. Always compute#publicDelegatedPrefixAggregatedList for aggregated lists of public delegated prefixes.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PublicDelegatedPrefixesScopedList {
        /**
         * [Output Only] A list of PublicDelegatedPrefixes contained in this scope.
         */
        publicDelegatedPrefixes?: Schema$PublicDelegatedPrefix[];
        /**
         * [Output Only] Informational warning which replaces the list of public delegated prefixes when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$PublicDelegatedPrefixList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of PublicDelegatedPrefix resources.
         */
        items?: Schema$PublicDelegatedPrefix[];
        /**
         * [Output Only] Type of the resource. Always compute#publicDelegatedPrefixList for public delegated prefixes.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a sub PublicDelegatedPrefix.
     */
    export interface Schema$PublicDelegatedPrefixPublicDelegatedSubPrefix {
        /**
         * Name of the project scoping this PublicDelegatedSubPrefix.
         */
        delegateeProject?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * The IPv4 address range, in CIDR format, represented by this sub public delegated prefix.
         */
        ipCidrRange?: string | null;
        /**
         * Whether the sub prefix is delegated to create Address resources in the delegatee project.
         */
        isAddress?: boolean | null;
        /**
         * The name of the sub public delegated prefix.
         */
        name?: string | null;
        /**
         * [Output Only] The region of the sub public delegated prefix if it is regional. If absent, the sub prefix is global.
         */
        region?: string | null;
        /**
         * [Output Only] The status of the sub public delegated prefix.
         */
        status?: string | null;
    }
    /**
     * A quotas entry.
     */
    export interface Schema$Quota {
        /**
         * [Output Only] Quota limit for this metric.
         */
        limit?: number | null;
        /**
         * [Output Only] Name of the quota metric.
         */
        metric?: string | null;
        /**
         * [Output Only] Owning resource. This is the resource on which this quota is applied.
         */
        owner?: string | null;
        /**
         * [Output Only] Current usage of this metric.
         */
        usage?: number | null;
    }
    export interface Schema$RbacPolicy {
        /**
         * Name of the RbacPolicy.
         */
        name?: string | null;
        /**
         * The list of permissions.
         */
        permissions?: Schema$Permission[];
        /**
         * The list of principals.
         */
        principals?: Schema$Principal[];
    }
    /**
     * Represents a reference to a resource.
     */
    export interface Schema$Reference {
        /**
         * [Output Only] Type of the resource. Always compute#reference for references.
         */
        kind?: string | null;
        /**
         * A description of the reference type with no implied semantics. Possible values include:
         * - MEMBER_OF
         */
        referenceType?: string | null;
        /**
         * URL of the resource which refers to the target.
         */
        referrer?: string | null;
        /**
         * URL of the resource to which this reference points.
         */
        target?: string | null;
    }
    /**
     * Represents a Region resource.
     *
     * A region is a geographical area where a resource is located. For more information, read Regions and Zones. (== resource_for {$api_version\}.regions ==)
     */
    export interface Schema$Region {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this region.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] Textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#region for regions.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Quotas assigned to this region.
         */
        quotas?: Schema$Quota[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] Status of the region, either UP or DOWN.
         */
        status?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        supportsPzs?: boolean | null;
        /**
         * [Output Only] A list of zones available in this region, in the form of resource URLs.
         */
        zones?: string[] | null;
    }
    /**
     * Contains a list of autoscalers.
     */
    export interface Schema$RegionAutoscalerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Autoscaler resources.
         */
        items?: Schema$Autoscaler[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionCommitmentsUpdateReservationsRequest {
        /**
         * A list of two reservations to transfer GPUs and local SSD between.
         */
        reservations?: Schema$Reservation[];
    }
    export interface Schema$RegionDisksAddResourcePoliciesRequest {
        /**
         * Resource policies to be added to this disk.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$RegionDisksRemoveResourcePoliciesRequest {
        /**
         * Resource policies to be removed from this disk.
         */
        resourcePolicies?: string[] | null;
    }
    export interface Schema$RegionDisksResizeRequest {
        /**
         * The new size of the regional persistent disk, which is specified in GB.
         */
        sizeGb?: string | null;
    }
    export interface Schema$RegionDiskTypeList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of DiskType resources.
         */
        items?: Schema$DiskType[];
        /**
         * [Output Only] Type of resource. Always compute#regionDiskTypeList for region disk types.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of InstanceGroup resources.
     */
    export interface Schema$RegionInstanceGroupList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroup resources.
         */
        items?: Schema$InstanceGroup[];
        /**
         * The resource type.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * RegionInstanceGroupManagers.deletePerInstanceConfigs
     */
    export interface Schema$RegionInstanceGroupManagerDeleteInstanceConfigReq {
        /**
         * The list of instance names for which we want to delete per-instance configs on this managed instance group.
         */
        names?: string[] | null;
    }
    /**
     * Contains a list of managed instance groups.
     */
    export interface Schema$RegionInstanceGroupManagerList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceGroupManager resources.
         */
        items?: Schema$InstanceGroupManager[];
        /**
         * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of managed instance groups that exist in th regional scope.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * RegionInstanceGroupManagers.patchPerInstanceConfigs
     */
    export interface Schema$RegionInstanceGroupManagerPatchInstanceConfigReq {
        /**
         * The list of per-instance configs to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$RegionInstanceGroupManagersAbandonInstancesRequest {
        /**
         * The URLs of one or more instances to abandon. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    /**
     * RegionInstanceGroupManagers.applyUpdatesToInstances
     */
    export interface Schema$RegionInstanceGroupManagersApplyUpdatesRequest {
        /**
         * Flag to update all instances instead of specified list of ?instances?. If the flag is set to true then the instances may not be specified in the request.
         */
        allInstances?: boolean | null;
        /**
         * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
        /**
         * The maximal action that should be performed on the instances. By default REPLACE. This field is deprecated, please use most_disruptive_allowed_action.
         */
        maximalAction?: string | null;
        /**
         * The minimal action that you want to perform on each instance during the update:
         * - REPLACE: At minimum, delete the instance and create it again.
         * - RESTART: Stop the instance and start it again.
         * - REFRESH: Do not stop the instance.
         * - NONE: Do not disrupt the instance at all.  By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
         */
        minimalAction?: string | null;
        /**
         * The most disruptive action that you want to perform on each instance during the update:
         * - REPLACE: Delete the instance and create it again.
         * - RESTART: Stop the instance and start it again.
         * - REFRESH: Do not stop the instance.
         * - NONE: Do not disrupt the instance at all.  By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
         */
        mostDisruptiveAllowedAction?: string | null;
    }
    /**
     * RegionInstanceGroupManagers.createInstances
     */
    export interface Schema$RegionInstanceGroupManagersCreateInstancesRequest {
        /**
         * [Required] List of specifications of per-instance configs.
         */
        instances?: Schema$PerInstanceConfig[];
    }
    export interface Schema$RegionInstanceGroupManagersDeleteInstancesRequest {
        /**
         * The URLs of one or more instances to delete. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
        /**
         * Skip instances which cannot be deleted (instances not belonging to this managed group, already being deleted or being abandoned). If `false`, fail whole flow, if such instance is passed. DEPRECATED: Use skip_instances_on_validation_error instead.
         */
        skipInapplicableInstances?: boolean | null;
    }
    export interface Schema$RegionInstanceGroupManagersListErrorsResponse {
        /**
         * [Output Only] The list of errors of the managed instance group.
         */
        items?: Schema$InstanceManagedByIgmError[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$RegionInstanceGroupManagersListInstanceConfigsResp {
        /**
         * [Output Only] The list of PerInstanceConfig.
         */
        items?: Schema$PerInstanceConfig[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionInstanceGroupManagersListInstancesResponse {
        /**
         * A list of managed instances.
         */
        managedInstances?: Schema$ManagedInstance[];
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$RegionInstanceGroupManagersRecreateRequest {
        /**
         * The URLs of one or more instances to recreate. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersResizeAdvancedRequest {
        /**
         * If this flag is true, the managed instance group attempts to create all instances initiated by this resize request only once. If there is an error during creation, the managed instance group does not retry create this instance, and we will decrease the targetSize of the request instead. If the flag is false, the group attempts to recreate each instance continuously until it succeeds.
         *
         * This flag matters only in the first attempt of creation of an instance. After an instance is successfully created while this flag is enabled, the instance behaves the same way as all the other instances created with a regular resize request. In particular, if a running instance dies unexpectedly at a later time and needs to be recreated, this mode does not affect the recreation behavior in that scenario.
         *
         * This flag is applicable only to the current resize request. It does not influence other resize requests in any way.
         *
         * You can see which instances ar being created in which mode by calling the get or listManagedInstances API.
         */
        noCreationRetries?: boolean | null;
        /**
         * The number of running instances that the managed instance group should maintain at any given time. The group automatically adds or removes instances to maintain the number of instances specified by this parameter.
         */
        targetSize?: number | null;
    }
    export interface Schema$RegionInstanceGroupManagersResumeInstancesRequest {
        /**
         * The URLs of one or more instances to resume. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersSetAutoHealingRequest {
        autoHealingPolicies?: Schema$InstanceGroupManagerAutoHealingPolicy[];
    }
    export interface Schema$RegionInstanceGroupManagersSetTargetPoolsRequest {
        /**
         * Fingerprint of the target pools information, which is a hash of the contents. This field is used for optimistic locking when you update the target pool entries. This field is optional.
         */
        fingerprint?: string | null;
        /**
         * The URL of all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
         */
        targetPools?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersSetTemplateRequest {
        /**
         * URL of the InstanceTemplate resource from which all new instances will be created.
         */
        instanceTemplate?: string | null;
    }
    export interface Schema$RegionInstanceGroupManagersStartInstancesRequest {
        /**
         * The URLs of one or more instances to start. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersStopInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to stop the instances, skipping initialization on them.
         */
        forceStop?: boolean | null;
        /**
         * The URLs of one or more instances to stop. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    export interface Schema$RegionInstanceGroupManagersSuspendInstancesRequest {
        /**
         * If this flag is set to true, the Instance Group Manager will proceed to suspend the instances, skipping initialization on them.
         */
        forceSuspend?: boolean | null;
        /**
         * The URLs of one or more instances to suspend. This can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
         */
        instances?: string[] | null;
    }
    /**
     * RegionInstanceGroupManagers.updatePerInstanceConfigs
     */
    export interface Schema$RegionInstanceGroupManagerUpdateInstanceConfigReq {
        /**
         * The list of per-instance configs to insert or patch on this managed instance group.
         */
        perInstanceConfigs?: Schema$PerInstanceConfig[];
    }
    export interface Schema$RegionInstanceGroupsListInstances {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of InstanceWithNamedPorts resources.
         */
        items?: Schema$InstanceWithNamedPorts[];
        /**
         * The resource type.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionInstanceGroupsListInstancesRequest {
        /**
         * Instances in which state should be returned. Valid options are: 'ALL', 'RUNNING'. By default, it lists all instances.
         */
        instanceState?: string | null;
        /**
         * Name of port user is interested in. It is optional. If it is set, only information about this ports will be returned. If it is not set, all the named ports will be returned. Always lists all instances.
         */
        portName?: string | null;
    }
    export interface Schema$RegionInstanceGroupsSetNamedPortsRequest {
        /**
         * The fingerprint of the named ports information for this instance group. Use this optional property to prevent conflicts when multiple users change the named ports settings concurrently. Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in your request to ensure that you do not overwrite changes that were applied from another concurrent request.
         */
        fingerprint?: string | null;
        /**
         * The list of named ports to set for this instance group.
         */
        namedPorts?: Schema$NamedPort[];
    }
    export interface Schema$RegionInstantSnapshotsExportRequest {
        /**
         * Parameters to export the changed blocks.
         */
        exportParams?: Schema$InstantSnapshotExportParams;
    }
    /**
     * Contains a list of region resources.
     */
    export interface Schema$RegionList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Region resources.
         */
        items?: Schema$Region[];
        /**
         * [Output Only] Type of resource. Always compute#regionList for lists of regions.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RegionSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string | null;
        /**
         * The labels to set for this resource.
         */
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$RegionSetPolicyRequest {
        /**
         * Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use 'policy' to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
         */
        etag?: string | null;
        /**
         * REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    export interface Schema$RegionTargetHttpsProxiesSetSslCertificatesRequest {
        /**
         * New set of SslCertificate resources to associate with this TargetHttpsProxy resource. Currently exactly one SslCertificate resource must be specified.
         */
        sslCertificates?: string[] | null;
    }
    export interface Schema$RegionUrlMapsValidateRequest {
        /**
         * Content of the UrlMap to be validated.
         */
        resource?: Schema$UrlMap;
    }
    /**
     * A policy that specifies how requests intended for the route's backends are shadowed to a separate mirrored backend service. Loadbalancer does not wait for responses from the shadow service. Prior to sending traffic to the shadow service, the host / authority header is suffixed with -shadow.
     */
    export interface Schema$RequestMirrorPolicy {
        /**
         * The full or partial URL to the BackendService resource being mirrored to.
         */
        backendService?: string | null;
    }
    /**
     * Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read  Reserving zonal resources. (== resource_for {$api_version\}.reservations ==)
     */
    export interface Schema$Reservation {
        /**
         * [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
         */
        commitment?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#reservations for reservations.
         */
        kind?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Share-settings for shared-reservation
         */
        shareSettings?: Schema$AllocationShareSettings;
        /**
         * Reservation for instances with specific machine shapes.
         */
        specificReservation?: Schema$AllocationSpecificSKUReservation;
        /**
         * Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
         */
        specificReservationRequired?: boolean | null;
        /**
         * [Output Only] The status of the reservation.
         */
        status?: string | null;
        /**
         * Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
         */
        zone?: string | null;
    }
    /**
     * Specifies the reservations that this instance can consume from.
     */
    export interface Schema$ReservationAffinity {
        /**
         * Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See  Consuming reserved instances for examples.
         */
        consumeReservationType?: string | null;
        /**
         * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
         */
        key?: string | null;
        /**
         * Corresponds to the label values of a reservation resource.
         */
        values?: string[] | null;
    }
    /**
     * Contains a list of reservations.
     */
    export interface Schema$ReservationAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Allocation resources.
         */
        items?: {
            [key: string]: Schema$ReservationsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$ReservationList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of Allocation resources.
         */
        items?: Schema$Reservation[];
        /**
         * [Output Only] Type of resource.Always compute#reservationsList for listsof reservations
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$ReservationsResizeRequest {
        /**
         * Number of allocated resources can be resized with minimum = 1 and maximum = 1000.
         */
        specificSkuCount?: string | null;
    }
    export interface Schema$ReservationsScopedList {
        /**
         * A list of reservations contained in this scope.
         */
        reservations?: Schema$Reservation[];
        /**
         * Informational warning which replaces the list of reservations when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Commitment for a particular resource (a Commitment is composed of one or more of these).
     */
    export interface Schema$ResourceCommitment {
        /**
         * Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
         */
        acceleratorType?: string | null;
        /**
         * The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.
         */
        amount?: string | null;
        /**
         * Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
         */
        type?: string | null;
    }
    export interface Schema$ResourceGroupReference {
        /**
         * A URI referencing one of the instance groups or network endpoint groups listed in the backend service.
         */
        group?: string | null;
    }
    export interface Schema$ResourcePoliciesScopedList {
        /**
         * A list of resourcePolicies contained in this scope.
         */
        resourcePolicies?: Schema$ResourcePolicy[];
        /**
         * Informational warning which replaces the list of resourcePolicies when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Resource Policy resource. You can use resource policies to schedule actions for some Compute Engine resources. For example, you can use them to schedule persistent disk snapshots.
     *
     * (== resource_for {$api_version\}.resourcePolicies ==)
     */
    export interface Schema$ResourcePolicy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        description?: string | null;
        /**
         * Resource policy for instances for placement configuration.
         */
        groupPlacementPolicy?: Schema$ResourcePolicyGroupPlacementPolicy;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Resource policy for scheduling instance operations.
         */
        instanceSchedulePolicy?: Schema$ResourcePolicyInstanceSchedulePolicy;
        /**
         * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
         */
        kind?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        region?: string | null;
        /**
         * [Output Only] The system status of the resource policy.
         */
        resourceStatus?: Schema$ResourcePolicyResourceStatus;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Resource policy for persistent disks for creating snapshots.
         */
        snapshotSchedulePolicy?: Schema$ResourcePolicySnapshotSchedulePolicy;
        /**
         * [Output Only] The status of resource policy creation.
         */
        status?: string | null;
        /**
         * Resource policy applicable to VMs for infrastructure maintenance.
         */
        vmMaintenancePolicy?: Schema$ResourcePolicyVmMaintenancePolicy;
    }
    /**
     * Contains a list of resourcePolicies.
     */
    export interface Schema$ResourcePolicyAggregatedList {
        etag?: string | null;
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ResourcePolicy resources.
         */
        items?: {
            [key: string]: Schema$ResourcePoliciesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Time window specified for daily operations.
     */
    export interface Schema$ResourcePolicyDailyCycle {
        /**
         * Defines a schedule with units measured in months. The value determines how many months pass between the start of each cycle.
         */
        daysInCycle?: number | null;
        /**
         * [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
         */
        duration?: string | null;
        /**
         * Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
         */
        startTime?: string | null;
    }
    /**
     * A GroupPlacementPolicy specifies resource placement configuration. It specifies the failure bucket separation as well as network locality
     */
    export interface Schema$ResourcePolicyGroupPlacementPolicy {
        /**
         * The number of availability domains instances will be spread across. If two instances are in different availability domain, they will not be put in the same low latency network
         */
        availabilityDomainCount?: number | null;
        /**
         * Specifies network collocation
         */
        collocation?: string | null;
        /**
         * Specifies network locality
         */
        locality?: string | null;
        /**
         * Scope specifies the availability domain to which the VMs should be spread.
         */
        scope?: string | null;
        /**
         * Specifies instances to hosts placement relationship
         */
        style?: string | null;
        /**
         * Number of vms in this placement group
         */
        vmCount?: number | null;
    }
    /**
     * Time window specified for hourly operations.
     */
    export interface Schema$ResourcePolicyHourlyCycle {
        /**
         * [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
         */
        duration?: string | null;
        /**
         * Defines a schedule with units measured in hours. The value determines how many hours pass between the start of each cycle.
         */
        hoursInCycle?: number | null;
        /**
         * Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
         */
        startTime?: string | null;
    }
    /**
     * An InstanceSchedulePolicy specifies when and how frequent certain operations are performed on the instance.
     */
    export interface Schema$ResourcePolicyInstanceSchedulePolicy {
        /**
         * The expiration time of the schedule. The timestamp is an RFC3339 string.
         */
        expirationTime?: string | null;
        /**
         * The start time of the schedule. The timestamp is an RFC3339 string.
         */
        startTime?: string | null;
        /**
         * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
         */
        timeZone?: string | null;
        /**
         * Specifies the schedule for starting instances.
         */
        vmStartSchedule?: Schema$ResourcePolicyInstanceSchedulePolicySchedule;
        /**
         * Specifies the schedule for stopping instances.
         */
        vmStopSchedule?: Schema$ResourcePolicyInstanceSchedulePolicySchedule;
    }
    /**
     * Schedule for an instance operation.
     */
    export interface Schema$ResourcePolicyInstanceSchedulePolicySchedule {
        /**
         * Specifies the frequency for the operation, using the unix-cron format.
         */
        schedule?: string | null;
    }
    export interface Schema$ResourcePolicyList {
        etag?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of ResourcePolicy resources.
         */
        items?: Schema$ResourcePolicy[];
        /**
         * [Output Only] Type of resource.Always compute#resourcePoliciesList for listsof resourcePolicies
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains output only fields. Use this sub-message for all output fields set on ResourcePolicy. The internal structure of this "status" field should mimic the structure of ResourcePolicy proto specification.
     */
    export interface Schema$ResourcePolicyResourceStatus {
        /**
         * [Output Only] Specifies a set of output values reffering to the instance_schedule_policy system status. This field should have the same name as corresponding policy field.
         */
        instanceSchedulePolicy?: Schema$ResourcePolicyResourceStatusInstanceSchedulePolicyStatus;
    }
    export interface Schema$ResourcePolicyResourceStatusInstanceSchedulePolicyStatus {
        /**
         * [Output Only] The last time the schedule successfully ran. The timestamp is an RFC3339 string.
         */
        lastRunStartTime?: string | null;
        /**
         * [Output Only] The next time the schedule is planned to run. The actual time might be slightly different. The timestamp is an RFC3339 string.
         */
        nextRunStartTime?: string | null;
    }
    /**
     * A snapshot schedule policy specifies when and how frequently snapshots are to be created for the target disk. Also specifies how many and how long these scheduled snapshots should be retained.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicy {
        /**
         * Retention policy applied to snapshots created by this resource policy.
         */
        retentionPolicy?: Schema$ResourcePolicySnapshotSchedulePolicyRetentionPolicy;
        /**
         * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
         */
        schedule?: Schema$ResourcePolicySnapshotSchedulePolicySchedule;
        /**
         * Properties with which snapshots are created such as labels, encryption keys.
         */
        snapshotProperties?: Schema$ResourcePolicySnapshotSchedulePolicySnapshotProperties;
    }
    /**
     * Policy for retention of scheduled snapshots.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicyRetentionPolicy {
        /**
         * Maximum age of the snapshot that is allowed to be kept.
         */
        maxRetentionDays?: number | null;
        /**
         * TODO(b/165626794): Remove this field Specifies the behavior to apply to existing, scheduled snapshots snapshots if the policy is changed.
         */
        onPolicySwitch?: string | null;
        /**
         * Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
         */
        onSourceDiskDelete?: string | null;
    }
    /**
     * A schedule for disks where the schedueled operations are performed.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicySchedule {
        dailySchedule?: Schema$ResourcePolicyDailyCycle;
        hourlySchedule?: Schema$ResourcePolicyHourlyCycle;
        weeklySchedule?: Schema$ResourcePolicyWeeklyCycle;
    }
    /**
     * Specified snapshot properties for scheduled snapshots created by this policy.
     */
    export interface Schema$ResourcePolicySnapshotSchedulePolicySnapshotProperties {
        /**
         * Chain name that the snapshot is created in.
         */
        chainName?: string | null;
        /**
         * Indication to perform a 'guest aware' snapshot.
         */
        guestFlush?: boolean | null;
        /**
         * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
         */
        storageLocations?: string[] | null;
    }
    export interface Schema$ResourcePolicyVmMaintenancePolicy {
        concurrencyControlGroup?: Schema$ResourcePolicyVmMaintenancePolicyConcurrencyControl;
        /**
         * Maintenance windows that are applied to VMs covered by this policy.
         */
        maintenanceWindow?: Schema$ResourcePolicyVmMaintenancePolicyMaintenanceWindow;
    }
    /**
     * A concurrency control configuration. Defines a group config that, when attached to an instance, recognizes that instance as part of a group of instances where only up the concurrency_limit of instances in that group can undergo simultaneous maintenance. For more information: go/concurrency-control-design-doc
     */
    export interface Schema$ResourcePolicyVmMaintenancePolicyConcurrencyControl {
        concurrencyLimit?: number | null;
    }
    /**
     * A maintenance window for VMs. When set, we restrict our maintenance operations to this window.
     */
    export interface Schema$ResourcePolicyVmMaintenancePolicyMaintenanceWindow {
        dailyMaintenanceWindow?: Schema$ResourcePolicyDailyCycle;
    }
    /**
     * Time window specified for weekly operations.
     */
    export interface Schema$ResourcePolicyWeeklyCycle {
        /**
         * Up to 7 intervals/windows, one for each day of the week.
         */
        dayOfWeeks?: Schema$ResourcePolicyWeeklyCycleDayOfWeek[];
    }
    export interface Schema$ResourcePolicyWeeklyCycleDayOfWeek {
        /**
         * Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
         */
        day?: string | null;
        /**
         * [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
         */
        duration?: string | null;
        /**
         * Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
         */
        startTime?: string | null;
    }
    /**
     * Contains output only fields. Use this sub-message for actual values set on Instance attributes as compared to the value requested by the user (intent) in their instance CRUD calls.
     */
    export interface Schema$ResourceStatus {
        scheduling?: Schema$ResourceStatusScheduling;
    }
    export interface Schema$ResourceStatusScheduling {
        /**
         * Specifies the availability domain (AD), which this instance should be scheduled on. The AD belongs to the spread GroupPlacementPolicy resource policy that has been assigned to the instance. Specify a value between 1-max count of availability domains in your GroupPlacementPolicy. See go/placement-policy-extension for more details.
         */
        availabilityDomain?: number | null;
    }
    /**
     * A rollout policy configuration.
     */
    export interface Schema$RolloutPolicy {
        /**
         * An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone that is not explicitly stated.
         */
        defaultRolloutTime?: string | null;
        /**
         * Location based rollout policies to apply to the resource.
         *
         * Currently only zone names are supported and must be represented as valid URLs, like: zones/us-central1-a.
         *
         * The value expects an RFC3339 timestamp on or after which the update is considered rolled out to the specified location.
         */
        locationRolloutPolicies?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Represents a Route resource.
     *
     * A route defines a path from VM instances in the VPC network to a specific destination. This destination can be inside or outside the VPC network. For more information, read the Routes overview. (== resource_for {$api_version\}.routes ==)
     */
    export interface Schema$Route {
        /**
         * Whether this route can conflict with existing subnetworks. Setting this to true allows this route to conflict with subnetworks that have already been configured on the corresponding network.
         */
        allowConflictingSubnetworks?: boolean | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this field when you create the resource.
         */
        description?: string | null;
        /**
         * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported.
         */
        destRange?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of this resource. Always compute#routes for Route resources.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
         */
        name?: string | null;
        /**
         * Fully-qualified URL of the network that this route applies to.
         */
        network?: string | null;
        /**
         * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL:  projects/project/global/gateways/default-internet-gateway
         */
        nextHopGateway?: string | null;
        /**
         * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs:
         * - 10.128.0.56
         * - https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
         * - regions/region/forwardingRules/forwardingRule
         */
        nextHopIlb?: string | null;
        /**
         * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example:
         * https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
         */
        nextHopInstance?: string | null;
        /**
         * [Output Only] The URL to an InterconnectAttachment which is the next hop for the route. This field will only be populated for the dynamic routes generated by Cloud Router with a linked interconnectAttachment.
         */
        nextHopInterconnectAttachment?: string | null;
        /**
         * The network IP address of an instance that should handle matching packets. Only IPv4 is supported.
         */
        nextHopIp?: string | null;
        /**
         * The URL of the local network if it should handle matching packets.
         */
        nextHopNetwork?: string | null;
        /**
         * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
         */
        nextHopPeering?: string | null;
        /**
         * The URL to a VpnTunnel that should handle matching packets.
         */
        nextHopVpnTunnel?: string | null;
        /**
         * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
         */
        priority?: number | null;
        /**
         * [Output Only] Server-defined fully-qualified URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * A list of instance tags to which this route applies.
         */
        tags?: string[] | null;
        /**
         * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
         */
        warnings?: Array<{
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        }> | null;
    }
    /**
     * Contains a list of Route resources.
     */
    export interface Schema$RouteList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Route resources.
         */
        items?: Schema$Route[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Cloud Router resource.
     *
     * For more information about Cloud Router, read the Cloud Router overview.
     */
    export interface Schema$Router {
        /**
         * BGP information specific to this router.
         */
        bgp?: Schema$RouterBgp;
        /**
         * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
         */
        bgpPeers?: Schema$RouterBgpPeer[];
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Field to indicate if a router is dedicated to use with encrypted Interconnect Attachment (IPsec-encrypted Cloud Interconnect feature).
         * Not currently available in all Interconnect locations.
         */
        encryptedInterconnectRouter?: boolean | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * Router interfaces. Each interface requires either one linked resource, (for example, linkedVpnTunnel), or IP address and IP address range (for example, ipRange), or both.
         */
        interfaces?: Schema$RouterInterface[];
        /**
         * [Output Only] Type of resource. Always compute#router for routers.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * A list of NAT services created in this router.
         */
        nats?: Schema$RouterNat[];
        /**
         * URI of the network to which this router belongs.
         */
        network?: string | null;
        /**
         * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
    }
    /**
     * Description-tagged IP ranges for the router to advertise.
     */
    export interface Schema$RouterAdvertisedIpRange {
        /**
         * User-specified description for the IP range.
         */
        description?: string | null;
        /**
         * The IP range to advertise. The value must be a CIDR-formatted string.
         */
        range?: string | null;
    }
    /**
     * Contains a list of routers.
     */
    export interface Schema$RouterAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Router resources.
         */
        items?: {
            [key: string]: Schema$RoutersScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RouterBgp {
        /**
         * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
         */
        advertisedGroups?: string[] | null;
        /**
         * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
         */
        advertisedIpRanges?: Schema$RouterAdvertisedIpRange[];
        /**
         * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
         */
        advertiseMode?: string | null;
        /**
         * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
         */
        asn?: number | null;
        /**
         * The interval in seconds between BGP keepalive messages that are sent to the peer.
         * Not currently available publicly.
         * Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer.
         * BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers.
         * If set, this value must be between 20 and 60. The default is 20.
         */
        keepaliveInterval?: number | null;
    }
    export interface Schema$RouterBgpPeer {
        /**
         * User-specified list of prefix groups to advertise in custom mode, which can take one of the following options:
         * - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets.
         * - ALL_VPC_SUBNETS: Advertises the router's own VPC subnets. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
         */
        advertisedGroups?: string[] | null;
        /**
         * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
         */
        advertisedIpRanges?: Schema$RouterAdvertisedIpRange[];
        /**
         * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
         */
        advertisedRoutePriority?: number | null;
        /**
         * User-specified flag to indicate which mode to use for advertisement.
         */
        advertiseMode?: string | null;
        /**
         * BFD configuration for the BGP peering.
         * Not currently available publicly.
         */
        bfd?: Schema$RouterBgpPeerBfd;
        /**
         * The status of the BGP peer connection.
         * Not currently available publicly.
         * If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
         */
        enable?: string | null;
        /**
         * Name of the interface the BGP peer is associated with.
         */
        interfaceName?: string | null;
        /**
         * IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
         */
        ipAddress?: string | null;
        /**
         * [Output Only] The resource that configures and manages this BGP peer.
         * - MANAGED_BY_USER is the default value and can be managed by you or other users
         * - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
         */
        managementType?: string | null;
        /**
         * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
         */
        peerAsn?: number | null;
        /**
         * IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
         */
        peerIpAddress?: string | null;
        /**
         * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
         */
        routerApplianceInstance?: string | null;
    }
    export interface Schema$RouterBgpPeerBfd {
        /**
         * The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router.
         * Not currently available publicly.
         * If set, this value must be between 100 and 30000.
         * The default is 300.
         */
        minReceiveInterval?: number | null;
        /**
         * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router.
         * Not currently available publicly.
         * If set, this value must be between 100 and 30000.
         * The default is 300.
         */
        minTransmitInterval?: number | null;
        /**
         * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is PASSIVE.
         */
        mode?: string | null;
        /**
         * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable.
         * Not currently available publicly.
         * If set, the value must be a value between 2 and 16.
         * The default is 3.
         */
        multiplier?: number | null;
        /**
         * The BFD packet mode for this BGP peer. If set to CONTROL_AND_ECHO, BFD echo mode is enabled for this BGP peer. In this mode, if the peer router also has BFD echo mode enabled, BFD echo packets will be sent to the other router. If the peer router does not have BFD echo mode enabled, only control packets will be sent. If set to CONTROL_ONLY, BFD echo mode is disabled for this BGP peer. If this router and the peer router have a multihop connection, this should be set to CONTROL_ONLY as BFD echo mode is only supported on singlehop connections. The default is CONTROL_AND_ECHO.
         */
        packetMode?: string | null;
        /**
         * The BFD session initialization mode for this BGP peer.
         * Not currently available publicly.
         * If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is PASSIVE.
         */
        sessionInitializationMode?: string | null;
        /**
         * The minimum interval, in milliseconds, between BFD control packets transmitted to and received from the peer router when BFD echo mode is enabled on both routers. The actual transmit and receive intervals are negotiated between the two routers and are equal to the greater of this value and the corresponding interval on the other router. If set, this value must be between 1000 and 30000. The default is 5000.
         */
        slowTimerInterval?: number | null;
    }
    export interface Schema$RouterInterface {
        /**
         * IP address and range of the interface. The IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate the address as it represents the IP address of the interface.
         */
        ipRange?: string | null;
        /**
         * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
         */
        linkedInterconnectAttachment?: string | null;
        /**
         * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
         */
        linkedVpnTunnel?: string | null;
        /**
         * [Output Only] The resource that configures and manages this interface.
         * - MANAGED_BY_USER is the default value and can be managed directly by users.
         * - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
         */
        managementType?: string | null;
        /**
         * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
         */
        privateIpAddress?: string | null;
        /**
         * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        redundantInterface?: string | null;
        /**
         * The URL of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
         */
        subnetwork?: string | null;
    }
    /**
     * Contains a list of Router resources.
     */
    export interface Schema$RouterList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Router resources.
         */
        items?: Schema$Router[];
        /**
         * [Output Only] Type of resource. Always compute#router for routers.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
     */
    export interface Schema$RouterNat {
        /**
         * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
         */
        drainNatIps?: string[] | null;
        enableEndpointIndependentMapping?: boolean | null;
        /**
         * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
         */
        icmpIdleTimeoutSec?: number | null;
        /**
         * Configure logging on this NAT.
         */
        logConfig?: Schema$RouterNatLogConfig;
        /**
         * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
         */
        minPortsPerVm?: number | null;
        /**
         * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
         */
        name?: string | null;
        /**
         * Specify the NatIpAllocateOption, which can take one of the following values:
         * - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs.
         * - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
         */
        natIpAllocateOption?: string | null;
        /**
         * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
         */
        natIps?: string[] | null;
        /**
         * A list of rules associated with this NAT.
         */
        rules?: Schema$RouterNatRule[];
        /**
         * Specify the Nat option, which can take one of the following values:
         * - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat.
         * - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat.
         * - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
         */
        sourceSubnetworkIpRangesToNat?: string | null;
        /**
         * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
         */
        subnetworks?: Schema$RouterNatSubnetworkToNat[];
        /**
         * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
         */
        tcpEstablishedIdleTimeoutSec?: number | null;
        /**
         * Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
         */
        tcpTimeWaitTimeoutSec?: number | null;
        /**
         * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
         */
        tcpTransitoryIdleTimeoutSec?: number | null;
        /**
         * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
         */
        udpIdleTimeoutSec?: number | null;
    }
    /**
     * Configuration of logging on a NAT.
     */
    export interface Schema$RouterNatLogConfig {
        /**
         * Indicates whether or not to export logs. This is false by default.
         */
        enable?: boolean | null;
        /**
         * Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values:
         * - ERRORS_ONLY: Export logs only for connection failures.
         * - TRANSLATIONS_ONLY: Export logs only for successful connections.
         * - ALL: Export logs for all connections, successful and unsuccessful.
         */
        filter?: string | null;
    }
    export interface Schema$RouterNatRule {
        /**
         * The action to be enforced for traffic that matches this rule.
         */
        action?: Schema$RouterNatRuleAction;
        /**
         * An optional description of this rule.
         */
        description?: string | null;
        /**
         * CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding ?action? is enforced.
         *
         * The following examples are valid match expressions:
         *
         * "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')"
         *
         * "destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'"
         */
        match?: string | null;
        /**
         * An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
         */
        ruleNumber?: number | null;
    }
    export interface Schema$RouterNatRuleAction {
        /**
         * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project.
         */
        sourceNatActiveIps?: string[] | null;
        /**
         * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only.
         */
        sourceNatDrainIps?: string[] | null;
    }
    /**
     * Defines the IP ranges that want to use NAT for a subnetwork.
     */
    export interface Schema$RouterNatSubnetworkToNat {
        /**
         * URL for the subnetwork resource that will use NAT.
         */
        name?: string | null;
        /**
         * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
         */
        secondaryIpRangeNames?: string[] | null;
        /**
         * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
         */
        sourceIpRangesToNat?: string[] | null;
    }
    export interface Schema$RoutersPreviewResponse {
        /**
         * Preview of given router.
         */
        resource?: Schema$Router;
    }
    export interface Schema$RoutersScopedList {
        /**
         * A list of routers contained in this scope.
         */
        routers?: Schema$Router[];
        /**
         * Informational warning which replaces the list of routers when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$RouterStatus {
        /**
         * Best routes for this router's network.
         */
        bestRoutes?: Schema$Route[];
        /**
         * Best routes learned by this router.
         */
        bestRoutesForRouter?: Schema$Route[];
        bgpPeerStatus?: Schema$RouterStatusBgpPeerStatus[];
        natStatus?: Schema$RouterStatusNatStatus[];
        /**
         * URI of the network to which this router belongs.
         */
        network?: string | null;
    }
    export interface Schema$RouterStatusBgpPeerStatus {
        /**
         * Routes that were advertised to the remote BGP peer
         */
        advertisedRoutes?: Schema$Route[];
        bfdStatus?: Schema$BfdStatus;
        /**
         * IP address of the local BGP interface.
         */
        ipAddress?: string | null;
        /**
         * URL of the VPN tunnel that this BGP peer controls.
         */
        linkedVpnTunnel?: string | null;
        /**
         * Name of this BGP peer. Unique within the Routers resource.
         */
        name?: string | null;
        /**
         * Number of routes learned from the remote BGP Peer.
         */
        numLearnedRoutes?: number | null;
        /**
         * IP address of the remote BGP interface.
         */
        peerIpAddress?: string | null;
        /**
         * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
         */
        routerApplianceInstance?: string | null;
        /**
         * BGP state as specified in RFC1771.
         */
        state?: string | null;
        /**
         * Status of the BGP peer: {UP, DOWN\}
         */
        status?: string | null;
        /**
         * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
         */
        uptime?: string | null;
        /**
         * Time this session has been up, in seconds. Format: 145
         */
        uptimeSeconds?: string | null;
    }
    /**
     * Status of a NAT contained in this router.
     */
    export interface Schema$RouterStatusNatStatus {
        /**
         * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
         */
        autoAllocatedNatIps?: string[] | null;
        /**
         * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
         */
        drainAutoAllocatedNatIps?: string[] | null;
        /**
         * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
         */
        drainUserAllocatedNatIps?: string[] | null;
        /**
         * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
         */
        minExtraNatIpsNeeded?: number | null;
        /**
         * Unique name of this NAT.
         */
        name?: string | null;
        /**
         * Number of VM endpoints (i.e., Nics) that can use NAT.
         */
        numVmEndpointsWithNatMappings?: number | null;
        /**
         * Status of rules in this NAT.
         */
        ruleStatus?: Schema$RouterStatusNatStatusNatRuleStatus[];
        /**
         * A list of fully qualified URLs of reserved IP address resources.
         */
        userAllocatedNatIpResources?: string[] | null;
        /**
         * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
         */
        userAllocatedNatIps?: string[] | null;
    }
    /**
     * Status of a NAT Rule contained in this NAT.
     */
    export interface Schema$RouterStatusNatStatusNatRuleStatus {
        /**
         * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
         */
        activeNatIps?: string[] | null;
        /**
         * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
         */
        drainNatIps?: string[] | null;
        /**
         * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.
         */
        minExtraIpsNeeded?: number | null;
        /**
         * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
         */
        numVmEndpointsWithNatMappings?: number | null;
        /**
         * Rule number of the rule.
         */
        ruleNumber?: number | null;
    }
    export interface Schema$RouterStatusResponse {
        /**
         * Type of resource.
         */
        kind?: string | null;
        result?: Schema$RouterStatus;
    }
    /**
     * A rule to be applied in a Policy.
     */
    export interface Schema$Rule {
        /**
         * Required
         */
        action?: string | null;
        /**
         * Additional restrictions that must be met. All conditions must pass for the rule to match.
         */
        conditions?: Schema$Condition[];
        /**
         * Human-readable description of the rule.
         */
        description?: string | null;
        /**
         * If one or more 'in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
         */
        ins?: string[] | null;
        /**
         * The config returned to callers of tech.iam.IAM.CheckPolicy for any entries that match the LOG action.
         */
        logConfigs?: Schema$LogConfig[];
        /**
         * If one or more 'not_in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries.
         */
        notIns?: string[] | null;
        /**
         * A permission is a string of form '..' (e.g., 'storage.buckets.list'). A value of '*' matches all permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
         */
        permissions?: string[] | null;
    }
    /**
     * An instance-attached disk resource.
     */
    export interface Schema$SavedAttachedDisk {
        /**
         * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
         */
        autoDelete?: boolean | null;
        /**
         * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
         */
        boot?: boolean | null;
        /**
         * Specifies the name of the disk attached to the source instance.
         */
        deviceName?: string | null;
        /**
         * The encryption key for the disk.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The size of the disk in base-2 GB.
         */
        diskSizeGb?: string | null;
        /**
         * [Output Only] URL of the disk type resource. For example: projects/project/zones/zone/diskTypes/pd-standard or pd-ssd
         */
        diskType?: string | null;
        /**
         * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * Specifies zero-based index of the disk that is attached to the source instance.
         */
        index?: number | null;
        /**
         * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
         */
        interface?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
         */
        kind?: string | null;
        /**
         * [Output Only] Any valid publicly visible licenses.
         */
        licenses?: string[] | null;
        /**
         * The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.
         */
        mode?: string | null;
        /**
         * Specifies a URL of the disk attached to the source instance.
         */
        source?: string | null;
        /**
         * [Output Only] A size of the storage used by the disk's snapshot by this machine image.
         */
        storageBytes?: string | null;
        /**
         * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
         */
        storageBytesStatus?: string | null;
        /**
         * Specifies the type of the attached disk, either SCRATCH or PERSISTENT.
         */
        type?: string | null;
    }
    export interface Schema$ScalingScheduleStatus {
        /**
         * [Output Only] The last time the scaling schedule became active. Note: this is a timestamp when a schedule actually became active, not when it was planned to do so. The timestamp is in RFC3339 text format.
         */
        lastStartTime?: string | null;
        /**
         * [Output Only] The next time the scaling schedule is to become active. Note: this is a timestamp when a schedule is planned to run, but the actual time might be slightly different. The timestamp is in RFC3339 text format.
         */
        nextStartTime?: string | null;
        /**
         * [Output Only] The current state of a scaling schedule.
         */
        state?: string | null;
    }
    /**
     * Sets the scheduling options for an Instance. NextID: 20
     */
    export interface Schema$Scheduling {
        /**
         * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted.
         *
         * By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
         */
        automaticRestart?: boolean | null;
        /**
         * Specifies the availability domain (AD), which this instance should be scheduled on. The AD belongs to the spread GroupPlacementPolicy resource policy that has been assigned to the instance. Specify a value between 1-max count of availability domains in your GroupPlacementPolicy. See go/placement-policy-extension for more details.
         */
        availabilityDomain?: number | null;
        /**
         * Defines whether the instance is tolerant of higher cpu latency. This can only be set during instance creation, or when the instance is not currently running. It must not be set if the preemptible option is also set.
         */
        latencyTolerant?: boolean | null;
        /**
         * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
         */
        locationHint?: string | null;
        /**
         * Specifies the number of hours after instance creation where the instance won't be scheduled for maintenance.
         */
        maintenanceFreezeDurationHours?: number | null;
        /**
         * Specifies whether this VM may be a stable fleet VM. Setting this to "Periodic" designates this VM as a Stable Fleet VM.
         *
         * See go/stable-fleet-ug for more details.
         */
        maintenanceInterval?: string | null;
        /**
         * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
         */
        minNodeCpus?: number | null;
        /**
         * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
         */
        nodeAffinities?: Schema$SchedulingNodeAffinity[];
        /**
         * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
         */
        onHostMaintenance?: string | null;
        /**
         * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
         */
        preemptible?: boolean | null;
    }
    /**
     * Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled.
     */
    export interface Schema$SchedulingNodeAffinity {
        /**
         * Corresponds to the label key of Node resource.
         */
        key?: string | null;
        /**
         * Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
         */
        operator?: string | null;
        /**
         * Corresponds to the label values of Node resource.
         */
        values?: string[] | null;
    }
    /**
     * An instance's screenshot.
     */
    export interface Schema$Screenshot {
        /**
         * [Output Only] The Base64-encoded screenshot data.
         */
        contents?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#screenshot for the screenshots.
         */
        kind?: string | null;
    }
    /**
     * [Deprecated] The configuration to access the SDS server. The configuration to access the SDS server.
     */
    export interface Schema$SdsConfig {
        /**
         * The configuration to access the SDS server over GRPC.
         */
        grpcServiceConfig?: Schema$GrpcServiceConfig;
    }
    export interface Schema$SecurityPoliciesListPreconfiguredExpressionSetsResponse {
        preconfiguredExpressionSets?: Schema$SecurityPoliciesWafConfig;
    }
    export interface Schema$SecurityPoliciesWafConfig {
        wafRules?: Schema$PreconfiguredWafSet;
    }
    /**
     * Represents a Google Cloud Armor security policy resource.
     *
     * Only external backend services that use load balancers can reference a security policy. For more information, see  Google Cloud Armor security policy overview. (== resource_for {$api_version\}.securityPolicies ==)
     */
    export interface Schema$SecurityPolicy {
        adaptiveProtectionConfig?: Schema$SecurityPolicyAdaptiveProtectionConfig;
        /**
         * A list of associations that belong to this policy.
         */
        associations?: Schema$SecurityPolicyAssociation[];
        cloudArmorConfig?: Schema$SecurityPolicyCloudArmorConfig;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * User-provided name of the Organization security plicy. The name should be unique in the organization in which the security policy is created. This should only be used when SecurityPolicyType is FIREWALL. The name must be 1-63 characters long, and comply with https://www.ietf.org/rfc/rfc1035.txt. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        displayName?: string | null;
        /**
         * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make get() request to the security policy.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.
         *
         * To see the latest fingerprint, make get() request to the security policy.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] The parent of the security policy.
         */
        parent?: string | null;
        /**
         * A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
         */
        rules?: Schema$SecurityPolicyRule[];
        /**
         * [Output Only] Total count of all security policy rule tuples. A security policy can not exceed a set number of tuples.
         */
        ruleTupleCount?: number | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The type indicates the intended use of the security policy. CLOUD_ARMOR policies apply to backend services. FIREWALL policies apply to organizations.
         */
        type?: string | null;
    }
    /**
     * Configuration options for Cloud Armor Adaptive Protection (CAAP).
     */
    export interface Schema$SecurityPolicyAdaptiveProtectionConfig {
        /**
         * If set to true, enables Cloud Armor Machine Learning.
         */
        layer7DdosDefenseConfig?: Schema$SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig;
    }
    /**
     * Configuration options for L7 DDoS detection.
     */
    export interface Schema$SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig {
        /**
         * If set to true, enables CAAP for L7 DDoS detection.
         */
        enable?: boolean | null;
        /**
         * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules.
         */
        ruleVisibility?: string | null;
    }
    export interface Schema$SecurityPolicyAssociation {
        /**
         * The resource that the security policy is attached to.
         */
        attachmentId?: string | null;
        /**
         * [Output Only] The display name of the security policy of the association.
         */
        displayName?: string | null;
        /**
         * The name for an association.
         */
        name?: string | null;
        /**
         * [Output Only] The security policy ID of the association.
         */
        securityPolicyId?: string | null;
    }
    /**
     * Configuration options for Cloud Armor.
     */
    export interface Schema$SecurityPolicyCloudArmorConfig {
        /**
         * If set to true, enables Cloud Armor Machine Learning.
         */
        enableMl?: boolean | null;
    }
    export interface Schema$SecurityPolicyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of SecurityPolicy resources.
         */
        items?: Schema$SecurityPolicy[];
        /**
         * [Output Only] Type of resource. Always compute#securityPolicyList for listsof securityPolicies
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$SecurityPolicyReference {
        securityPolicy?: string | null;
    }
    /**
     * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
     */
    export interface Schema$SecurityPolicyRule {
        /**
         * The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
         */
        action?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * The direction in which this rule applies. This field may only be specified when versioned_expr is set to FIREWALL.
         */
        direction?: string | null;
        /**
         * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
         *
         * This field may only be specified when the versioned_expr is set to FIREWALL.
         */
        enableLogging?: boolean | null;
        /**
         * Optional, additional actions that are performed on headers.
         */
        headerAction?: Schema$SecurityPolicyRuleHttpHeaderAction;
        /**
         * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
         */
        kind?: string | null;
        /**
         * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
         */
        match?: Schema$SecurityPolicyRuleMatcher;
        /**
         * If set to true, the specified action is not enforced.
         */
        preview?: boolean | null;
        /**
         * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
         */
        priority?: number | null;
        /**
         * Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
         */
        rateLimitOptions?: Schema$SecurityPolicyRuleRateLimitOptions;
        /**
         * This must be specified for redirect actions. Cannot be specified for any other actions.
         */
        redirectTarget?: string | null;
        /**
         * Identifier for the rule. This is only unique within the given security policy. This can only be set during rule creation, if rule number is not specified it will be generated by the server.
         */
        ruleNumber?: string | null;
        /**
         * [Output Only] Calculation of the complexity of a single firewall security policy rule.
         */
        ruleTupleCount?: number | null;
        /**
         * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
         *
         * This field may only be specified when versioned_expr is set to FIREWALL.
         */
        targetResources?: string[] | null;
        /**
         * A list of service accounts indicating the sets of instances that are applied with this rule.
         */
        targetServiceAccounts?: string[] | null;
    }
    export interface Schema$SecurityPolicyRuleHttpHeaderAction {
        /**
         * The list of request headers to add or overwrite if they?re already present.
         */
        requestHeadersToAdds?: Schema$SecurityPolicyRuleHttpHeaderActionHttpHeaderOption[];
    }
    export interface Schema$SecurityPolicyRuleHttpHeaderActionHttpHeaderOption {
        /**
         * The name of the header to set.
         */
        headerName?: string | null;
        /**
         * The value to set the named header to.
         */
        headerValue?: string | null;
    }
    /**
     * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
     */
    export interface Schema$SecurityPolicyRuleMatcher {
        /**
         * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
         */
        config?: Schema$SecurityPolicyRuleMatcherConfig;
        /**
         * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.
         */
        expr?: Schema$Expr;
        /**
         * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
         */
        versionedExpr?: string | null;
    }
    export interface Schema$SecurityPolicyRuleMatcherConfig {
        /**
         * CIDR IP address range.
         *
         * This field may only be specified when versioned_expr is set to FIREWALL.
         */
        destIpRanges?: string[] | null;
        /**
         * Pairs of IP protocols and ports that the rule should match.
         *
         * This field may only be specified when versioned_expr is set to FIREWALL.
         */
        destPorts?: Schema$SecurityPolicyRuleMatcherConfigDestinationPort[];
        /**
         * Pairs of IP protocols and ports that the rule should match.
         *
         * This field may only be specified when versioned_expr is set to FIREWALL.
         */
        layer4Configs?: Schema$SecurityPolicyRuleMatcherConfigLayer4Config[];
        /**
         * CIDR IP address range. Maximum number of src_ip_ranges allowed is 10.
         */
        srcIpRanges?: string[] | null;
    }
    export interface Schema$SecurityPolicyRuleMatcherConfigDestinationPort {
        /**
         * The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
         */
        ipProtocol?: string | null;
        /**
         * An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port.
         *
         * Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
         *
         * This field may only be specified when versioned_expr is set to FIREWALL.
         */
        ports?: string[] | null;
    }
    export interface Schema$SecurityPolicyRuleMatcherConfigLayer4Config {
        /**
         * The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
         */
        ipProtocol?: string | null;
        /**
         * An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port.
         *
         * Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
         *
         * This field may only be specified when versioned_expr is set to FIREWALL.
         */
        ports?: string[] | null;
    }
    export interface Schema$SecurityPolicyRuleRateLimitOptions {
        /**
         * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
         */
        banDurationSec?: number | null;
        /**
         * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
         */
        banThreshold?: Schema$SecurityPolicyRuleRateLimitOptionsThreshold;
        /**
         * Action to take when requests are under the given threshold. When requests are throttled, this is also the action for all requests which are not dropped. Valid options are "allow", "fairshare", and "drop_overload".
         */
        conformAction?: string | null;
        /**
         * Determines the key to enforce the threshold_rps limit on. If key is "IP", each IP has this limit enforced separately, whereas "ALL_IPs" means a single limit is applied to all requests matching this rule.
         */
        enforceOnKey?: string | null;
        /**
         * When a request is denied, returns the HTTP response code specified. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502.
         */
        exceedAction?: string | null;
        /**
         * Threshold at which to begin ratelimiting.
         */
        rateLimitThreshold?: Schema$SecurityPolicyRuleRateLimitOptionsThreshold;
    }
    export interface Schema$SecurityPolicyRuleRateLimitOptionsThreshold {
        /**
         * Number of HTTP(S) requests for calculating the threshold.
         */
        count?: number | null;
        /**
         * Interval over which the threshold is computed.
         */
        intervalSec?: number | null;
    }
    /**
     * The authentication and authorization settings for a BackendService.
     */
    export interface Schema$SecuritySettings {
        /**
         * [Deprecated] Use clientTlsPolicy instead.
         */
        authentication?: string | null;
        /**
         * [Deprecated] Authentication policy defines what authentication methods can be accepted on backends, and if authenticated, which method/certificate will set the request principal. request principal.
         */
        authenticationPolicy?: Schema$AuthenticationPolicy;
        /**
         * [Deprecated] Authorization config defines the Role Based Access Control (RBAC) config. Authorization config defines the Role Based Access Control (RBAC) config.
         */
        authorizationConfig?: Schema$AuthorizationConfig;
        /**
         * Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how clients should authenticate with this service's backends.
         * clientTlsPolicy only applies to a global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         * If left blank, communications are not encrypted.
         * Note: This field currently has no impact.
         */
        clientTlsPolicy?: string | null;
        /**
         * [Deprecated] TLS Settings for the backend service.
         */
        clientTlsSettings?: Schema$ClientTlsSettings;
        /**
         * Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual TLS handshake with an server/endpoint for this BackendService. When the server presents its X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If the field contains one of the specified values, the communication continues. Otherwise, it fails. This additional check enables the client to verify that the server is authorized to run the requested service.
         * Note that the contents of the server certificate's subjectAltName field are configured by the Public Key Infrastructure which provisions server identities.
         * Only applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode).
         * Note: This field currently has no impact.
         */
        subjectAltNames?: string[] | null;
    }
    /**
     * An instance's serial console output.
     */
    export interface Schema$SerialPortOutput {
        /**
         * [Output Only] The contents of the console output.
         */
        contents?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#serialPortOutput for serial port output.
         */
        kind?: string | null;
        /**
         * [Output Only] The position of the next byte of content, regardless of whether the content exists, following the output returned in the `contents` property. Use this value in the next request as the start parameter.
         */
        next?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * The starting byte position of the output that was returned. This should match the start parameter sent with the request. If the serial console output exceeds the size of the buffer (1 MB), older output is overwritten by newer content. The output start value will indicate the byte position of the output that was returned, which might be different than the `start` value that was specified in the request.
         */
        start?: string | null;
    }
    export interface Schema$ServerBinding {
        type?: string | null;
    }
    /**
     * The TLS settings for the server.
     */
    export interface Schema$ServerTlsSettings {
        /**
         * Configures the mechanism to obtain security certificates and identity information.
         */
        proxyTlsContext?: Schema$TlsContext;
        /**
         * A list of alternate names to verify the subject identity in the certificate presented by the client.
         */
        subjectAltNames?: string[] | null;
        /**
         * Indicates whether connections should be secured using TLS. The value of this field determines how TLS is enforced. This field can be set to one of the following:
         * - SIMPLE Secure connections with standard TLS semantics.
         * - MUTUAL Secure connections to the backends using mutual TLS by presenting client certificates for authentication.
         */
        tlsMode?: string | null;
    }
    /**
     * A service account.
     */
    export interface Schema$ServiceAccount {
        /**
         * Email address of the service account.
         */
        email?: string | null;
        /**
         * The list of scopes to be made available for this service account.
         */
        scopes?: string[] | null;
    }
    /**
     * Represents a ServiceAttachment resource.
     *
     * A service attachment represents a service that a producer has exposed. It encapsulates the load balancer which fronts the service runs and a list of NAT IP ranges that the producers uses to represent the consumers connecting to the service. next tag = 19
     */
    export interface Schema$ServiceAttachment {
        /**
         * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
         */
        connectionPreference?: string | null;
        /**
         * Projects that are allowed to connect to this service attachment.
         */
        consumerAcceptLists?: Schema$ServiceAttachmentConsumerProjectLimit[];
        /**
         * [Output Only] An array of forwarding rules for all the consumers connected to this service attachment.
         */
        consumerForwardingRules?: Schema$ServiceAttachmentConsumerForwardingRule[];
        /**
         * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
         */
        consumerRejectLists?: string[] | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
         */
        enableProxyProtocol?: boolean | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
         */
        natSubnets?: string[] | null;
        /**
         * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
         */
        producerForwardingRule?: string | null;
        /**
         * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * The URL of a service serving the endpoint identified by this service attachment.
         */
        targetService?: string | null;
    }
    /**
     * Contains a list of ServiceAttachmentsScopedList.
     */
    export interface Schema$ServiceAttachmentAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ServiceAttachmentsScopedList resources.
         */
        items?: {
            [key: string]: Schema$ServiceAttachmentsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * [Output Only] A consumer forwarding rule connected to this service attachment. [Deprecated] Do not use.
     */
    export interface Schema$ServiceAttachmentConsumerForwardingRule {
        /**
         * The url of a consumer forwarding rule.
         */
        forwardingRule?: string | null;
        /**
         * The status of the forwarding rule.
         */
        status?: string | null;
    }
    export interface Schema$ServiceAttachmentConsumerProjectLimit {
        /**
         * The value of the limit to set.
         */
        connectionLimit?: number | null;
        /**
         * The project id or number for the project to set the limit for.
         */
        projectIdOrNum?: string | null;
    }
    export interface Schema$ServiceAttachmentList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of ServiceAttachment resources.
         */
        items?: Schema$ServiceAttachment[];
        /**
         * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$ServiceAttachmentsScopedList {
        /**
         * A list of ServiceAttachments contained in this scope.
         */
        resources?: Schema$ServiceAttachment[];
        /**
         * Informational warning which replaces the list of service attachments when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A set of Shielded Instance options.
     */
    export interface Schema$ShieldedInstanceConfig {
        /**
         * Defines whether the instance has integrity monitoring enabled. Enabled by default.
         */
        enableIntegrityMonitoring?: boolean | null;
        /**
         * Defines whether the instance has Secure Boot enabled. Disabled by default.
         */
        enableSecureBoot?: boolean | null;
        /**
         * Defines whether the instance has the vTPM enabled. Enabled by default.
         */
        enableVtpm?: boolean | null;
    }
    /**
     * A shielded Instance identity entry.
     */
    export interface Schema$ShieldedInstanceIdentity {
        /**
         * An Endorsement Key (EK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
         */
        encryptionKey?: Schema$ShieldedInstanceIdentityEntry;
        /**
         * [Output Only] Type of the resource. Always compute#shieldedInstanceIdentity for shielded Instance identity entry.
         */
        kind?: string | null;
        /**
         * An Attestation Key (AK) made by the RSA 2048 algorithm issued to the Shielded Instance's vTPM.
         */
        signingKey?: Schema$ShieldedInstanceIdentityEntry;
    }
    /**
     * A Shielded Instance Identity Entry.
     */
    export interface Schema$ShieldedInstanceIdentityEntry {
        /**
         * A PEM-encoded X.509 certificate. This field can be empty.
         */
        ekCert?: string | null;
        /**
         * A PEM-encoded public key.
         */
        ekPub?: string | null;
    }
    /**
     * The policy describes the baseline against which Instance boot integrity is measured.
     */
    export interface Schema$ShieldedInstanceIntegrityPolicy {
        /**
         * Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
         */
        updateAutoLearnPolicy?: boolean | null;
    }
    /**
     * A set of Shielded VM options.
     */
    export interface Schema$ShieldedVmConfig {
        /**
         * Defines whether the instance has integrity monitoring enabled.
         */
        enableIntegrityMonitoring?: boolean | null;
        /**
         * Defines whether the instance has Secure Boot enabled.
         */
        enableSecureBoot?: boolean | null;
        /**
         * Defines whether the instance has the vTPM enabled.
         */
        enableVtpm?: boolean | null;
    }
    /**
     * A shielded VM identity entry.
     */
    export interface Schema$ShieldedVmIdentity {
        /**
         * An Endorsement Key (EK) issued to the Shielded VM's vTPM.
         */
        encryptionKey?: Schema$ShieldedVmIdentityEntry;
        /**
         * [Output Only] Type of the resource. Always compute#shieldedVmIdentity for shielded VM identity entry.
         */
        kind?: string | null;
        /**
         * An Attestation Key (AK) issued to the Shielded VM's vTPM.
         */
        signingKey?: Schema$ShieldedVmIdentityEntry;
    }
    /**
     * A Shielded Instance Identity Entry.
     */
    export interface Schema$ShieldedVmIdentityEntry {
        /**
         * A PEM-encoded X.509 certificate. This field can be empty.
         */
        ekCert?: string | null;
        /**
         * A PEM-encoded public key.
         */
        ekPub?: string | null;
    }
    /**
     * The policy describes the baseline against which VM instance boot integrity is measured.
     */
    export interface Schema$ShieldedVmIntegrityPolicy {
        /**
         * Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
         */
        updateAutoLearnPolicy?: boolean | null;
    }
    /**
     * Represents a customer-supplied Signing Key used by Cloud CDN Signed URLs
     */
    export interface Schema$SignedUrlKey {
        /**
         * Name of the key. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        keyName?: string | null;
        /**
         * 128-bit key value used for signing the URL. The key value must be a valid RFC 4648 Section 5 base64url encoded string.
         */
        keyValue?: string | null;
    }
    /**
     * Represents a Persistent Disk Snapshot resource.
     *
     * You can use snapshots to back up data on a regular interval. For more information, read  Creating persistent disk snapshots. (== resource_for {$api_version\}.snapshots ==)
     */
    export interface Schema$Snapshot {
        /**
         * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
         */
        autoCreated?: boolean | null;
        /**
         * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
         */
        chainName?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Size of the source disk, specified in GB.
         */
        diskSizeGb?: string | null;
        /**
         * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
         */
        downloadBytes?: string | null;
        /**
         * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
         */
        guestFlush?: boolean | null;
        /**
         * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
         */
        guestOsFeatures?: Schema$GuestOsFeature[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a snapshot.
         */
        labelFingerprint?: string | null;
        /**
         * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
         */
        licenseCodes?: string[] | null;
        /**
         * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
         */
        licenses?: string[] | null;
        /**
         * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
         */
        locationHint?: string | null;
        /**
         * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource's resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Encrypts the snapshot using a customer-supplied encryption key.
         *
         * After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request.
         *
         * Customer-supplied encryption keys do not protect access to metadata of the snapshot.
         *
         * If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
         */
        snapshotEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * The source disk used to create this snapshot.
         */
        sourceDisk?: string | null;
        /**
         * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
         */
        sourceDiskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
         */
        sourceDiskId?: string | null;
        /**
         * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
         */
        status?: string | null;
        /**
         * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
         */
        storageBytes?: string | null;
        /**
         * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
         */
        storageBytesStatus?: string | null;
        /**
         * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
         */
        storageLocations?: string[] | null;
    }
    /**
     * Contains a list of Snapshot resources.
     */
    export interface Schema$SnapshotList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Snapshot resources.
         */
        items?: Schema$Snapshot[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$SourceDiskEncryptionKey {
        /**
         * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
         */
        diskEncryptionKey?: Schema$CustomerEncryptionKey;
        /**
         * URL of the disk attached to the source instance. This can be a full or valid partial URL. For example, the following are valid values:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
         * - projects/project/zones/zone/disks/disk
         * - zones/zone/disks/disk
         */
        sourceDisk?: string | null;
    }
    /**
     * A specification of the parameters to use when creating the instance template from a source instance.
     */
    export interface Schema$SourceInstanceParams {
        /**
         * Attached disks configuration. If not provided, defaults are applied: For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
         */
        diskConfigs?: Schema$DiskInstantiationConfig[];
    }
    export interface Schema$SourceInstanceProperties {
        /**
         * Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
         */
        canIpForward?: boolean | null;
        /**
         * Whether the instance created from this machine image should be protected against deletion.
         */
        deletionProtection?: boolean | null;
        /**
         * An optional text description for the instances that are created from this machine image.
         */
        description?: string | null;
        /**
         * An array of disks that are associated with the instances that are created from this machine image.
         */
        disks?: Schema$SavedAttachedDisk[];
        /**
         * A list of guest accelerator cards' type and count to use for instances created from this machine image.
         */
        guestAccelerators?: Schema$AcceleratorConfig[];
        /**
         * Labels to apply to instances that are created from this machine image.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The machine type to use for instances that are created from this machine image.
         */
        machineType?: string | null;
        /**
         * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
         */
        metadata?: Schema$Metadata;
        /**
         * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
         */
        minCpuPlatform?: string | null;
        /**
         * An array of network access configurations for this interface.
         */
        networkInterfaces?: Schema$NetworkInterface[];
        /**
         * PostKeyRevocationActionType of the instance.
         */
        postKeyRevocationActionType?: string | null;
        /**
         * Specifies the scheduling options for the instances that are created from this machine image.
         */
        scheduling?: Schema$Scheduling;
        /**
         * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
         */
        serviceAccounts?: Schema$ServiceAccount[];
        /**
         * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
         */
        tags?: Schema$Tags;
    }
    /**
     * Represents an SSL Certificate resource.
     *
     * Google Compute Engine has two SSL Certificate resources:
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/sslCertificates) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionSslCertificates)
     *
     *
     *
     * The sslCertificates are used by:
     * - external HTTPS load balancers
     * - SSL proxy load balancers
     *
     * The regionSslCertificates are used by internal HTTPS load balancers.
     *
     * Optionally, certificate file contents that you upload can contain a set of up to five PEM-encoded certificates. The API call creates an object (sslCertificate) that holds this data. You can use SSL keys and certificates to secure connections to a load balancer. For more information, read  Creating and using SSL certificates, SSL certificates quotas and limits, and  Troubleshooting SSL certificates. (== resource_for {$api_version\}.sslCertificates ==) (== resource_for {$api_version\}.regionSslCertificates ==)
     */
    export interface Schema$SslCertificate {
        /**
         * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
         */
        certificate?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Expire time of the certificate. RFC3339
         */
        expireTime?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
         */
        kind?: string | null;
        /**
         * Configuration and status of a managed SSL certificate.
         */
        managed?: Schema$SslCertificateManagedSslCertificate;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
         */
        privateKey?: string | null;
        /**
         * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
         */
        region?: string | null;
        /**
         * [Output only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Configuration and status of a self-managed SSL certificate.
         */
        selfManaged?: Schema$SslCertificateSelfManagedSslCertificate;
        /**
         * [Output Only] Domains associated with the certificate via Subject Alternative Name.
         */
        subjectAlternativeNames?: string[] | null;
        /**
         * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
         */
        type?: string | null;
    }
    export interface Schema$SslCertificateAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of SslCertificatesScopedList resources.
         */
        items?: {
            [key: string]: Schema$SslCertificatesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#sslCertificateAggregatedList for lists of SSL Certificates.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of SslCertificate resources.
     */
    export interface Schema$SslCertificateList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of SslCertificate resources.
         */
        items?: Schema$SslCertificate[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Configuration and status of a managed SSL certificate.
     */
    export interface Schema$SslCertificateManagedSslCertificate {
        /**
         * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
         */
        domains?: string[] | null;
        /**
         * [Output only] Detailed statuses of the domains specified for managed certificate resource.
         */
        domainStatus?: {
            [key: string]: string;
        } | null;
        /**
         * [Output only] Status of the managed certificate resource.
         */
        status?: string | null;
    }
    /**
     * Configuration and status of a self-managed SSL certificate.
     */
    export interface Schema$SslCertificateSelfManagedSslCertificate {
        /**
         * A local certificate file. The certificate must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
         */
        certificate?: string | null;
        /**
         * A write-only private key in PEM format. Only insert requests will include this field.
         */
        privateKey?: string | null;
    }
    export interface Schema$SslCertificatesScopedList {
        /**
         * List of SslCertificates contained in this scope.
         */
        sslCertificates?: Schema$SslCertificate[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$SSLHealthCheck {
        /**
         * The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string | null;
        /**
         * Specifies how port is selected for health checking, can be one of following values:
         * USE_FIXED_PORT: The port number in port is used for health checking.
         * USE_NAMED_PORT: The portName is used for health checking.
         * USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
         *
         *
         * If not specified, SSL health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
         */
        request?: string | null;
        /**
         * The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
         */
        response?: string | null;
    }
    export interface Schema$SslPoliciesList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of SslPolicy resources.
         */
        items?: Schema$SslPolicy[];
        /**
         * [Output Only] Type of the resource. Always compute#sslPoliciesList for lists of sslPolicies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$SslPoliciesListAvailableFeaturesResponse {
        features?: string[] | null;
    }
    /**
     * Represents an SSL Policy resource.
     *
     * Use SSL policies to control the SSL features, such as versions and cipher suites, offered by an HTTPS or SSL Proxy load balancer. For more information, read  SSL Policy Concepts. (== resource_for {$api_version\}.sslPolicies ==)
     */
    export interface Schema$SslPolicy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * A list of features enabled when the selected profile is CUSTOM. The
         * - method returns the set of features that can be specified in this list. This field must be empty if the profile is not CUSTOM.
         */
        customFeatures?: string[] | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The list of features enabled in the SSL policy.
         */
        enabledFeatures?: string[] | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a SslPolicy. An up-to-date fingerprint must be provided in order to update the SslPolicy, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an SslPolicy.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output only] Type of the resource. Always compute#sslPolicyfor SSL policies.
         */
        kind?: string | null;
        /**
         * The minimum version of SSL protocol that can be used by the clients to establish a connection with the load balancer. This can be one of TLS_1_0, TLS_1_1, TLS_1_2.
         */
        minTlsVersion?: string | null;
        /**
         * Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients. This can be one of COMPATIBLE, MODERN, RESTRICTED, or CUSTOM. If using CUSTOM, the set of SSL features to enable must be specified in the customFeatures field.
         */
        profile?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Security settings for the proxy. This field is only applicable to a global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         */
        tlsSettings?: Schema$ServerTlsSettings;
        /**
         * [Output Only] If potential misconfigurations are detected for this SSL policy, this field will be populated with warning messages.
         */
        warnings?: Array<{
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        }> | null;
    }
    export interface Schema$SslPolicyReference {
        /**
         * URL of the SSL policy resource. Set this to empty string to clear any existing SSL policy associated with the target proxy resource.
         */
        sslPolicy?: string | null;
    }
    export interface Schema$StatefulPolicy {
        preservedState?: Schema$StatefulPolicyPreservedState;
    }
    /**
     * Configuration of preserved resources.
     */
    export interface Schema$StatefulPolicyPreservedState {
        /**
         * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
         */
        disks?: {
            [key: string]: Schema$StatefulPolicyPreservedStateDiskDevice;
        } | null;
        /**
         * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
         */
        externalIPs?: {
            [key: string]: Schema$StatefulPolicyPreservedStateNetworkIp;
        } | null;
        /**
         * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
         */
        internalIPs?: {
            [key: string]: Schema$StatefulPolicyPreservedStateNetworkIp;
        } | null;
    }
    export interface Schema$StatefulPolicyPreservedStateDiskDevice {
        /**
         * These stateful disks will never be deleted during autohealing, update or VM instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
         */
        autoDelete?: string | null;
    }
    export interface Schema$StatefulPolicyPreservedStateNetworkIp {
        /**
         * These stateful IPs will never be released during autohealing, update or VM instance recreate operations. This flag is used to configure if the IP reservation should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted.
         */
        autoDelete?: string | null;
    }
    /**
     * Represents a Subnetwork resource.
     *
     * A subnetwork (also known as a subnet) is a logical partition of a Virtual Private Cloud network with one primary IP range and zero or more secondary IP ranges. For more information, read  Virtual Private Cloud (VPC) Network. (== resource_for {$api_version\}.subnetworks ==)
     */
    export interface Schema$Subnetwork {
        /**
         * Can only be specified if VPC flow logging for this subnetwork is enabled. Sets the aggregation interval for collecting flow logs. Increasing the interval time reduces the amount of generated flow logs for long-lasting connections. Default is an interval of 5 seconds per connection. Valid values: INTERVAL_5_SEC, INTERVAL_30_SEC, INTERVAL_1_MIN, INTERVAL_5_MIN, INTERVAL_10_MIN, INTERVAL_15_MIN.
         */
        aggregationInterval?: string | null;
        /**
         * Whether this subnetwork can conflict with static routes. Setting this to true allows this subnetwork's primary and secondary ranges to conflict with routes that have already been configured on the corresponding network. Static routes will take precedence over the subnetwork route if the route prefix length is at least as large as the subnetwork prefix length.
         *
         * Also, packets destined to IPs within subnetwork may contain private/sensitive data and are prevented from leaving the virtual network. Setting this field to true will disable this feature.
         *
         * The default value is false and applies to all existing subnetworks and automatically created subnetworks.
         *
         * This field cannot be set to true at resource creation time.
         */
        allowSubnetCidrRoutesOverlap?: boolean | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
         */
        description?: string | null;
        /**
         * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is to disable flow logging. This field isn't supported with the purpose field set to INTERNAL_HTTPS_LOAD_BALANCER.
         */
        enableFlowLogs?: boolean | null;
        /**
         * Enables Layer2 communication on the subnetwork.
         */
        enableL2?: boolean | null;
        /**
         * Deprecated in favor of enable in PrivateIpv6GoogleAccess. Whether the VMs in this subnet can directly access Google services via internal IPv6 addresses. This field can be both set at resource creation time and updated using patch.
         */
        enablePrivateV6Access?: boolean | null;
        /**
         * [Output Only] The range of external IPv6 addresses that are owned by this subnetwork.
         */
        externalIpv6Prefix?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
         */
        fingerprint?: string | null;
        /**
         * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5, which means half of all collected logs are reported.
         */
        flowSampling?: number | null;
        /**
         * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
         */
        gatewayAddress?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
         */
        ipCidrRange?: string | null;
        /**
         * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet cannot enable direct path.
         */
        ipv6AccessType?: string | null;
        /**
         * [Output Only] The range of internal IPv6 addresses that are owned by this subnetwork.
         */
        ipv6CidrRange?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
         */
        kind?: string | null;
        /**
         * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
         */
        logConfig?: Schema$SubnetworkLogConfig;
        /**
         * Can only be specified if VPC flow logging for this subnetwork is enabled. Configures whether metadata fields should be added to the reported VPC flow logs. Options are INCLUDE_ALL_METADATA, EXCLUDE_ALL_METADATA, and CUSTOM_METADATA. Default is EXCLUDE_ALL_METADATA.
         */
        metadata?: string | null;
        /**
         * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. Only networks that are in the distributed mode can have subnetworks. This field can be set only at resource creation time.
         */
        network?: string | null;
        /**
         * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
         */
        privateIpGoogleAccess?: boolean | null;
        /**
         * The private IPv6 google access type for the VMs in this subnet. This is an expanded field of enablePrivateV6Access. If both fields are set, privateIpv6GoogleAccess will take priority.
         *
         * This field can be both set at resource creation time and updated using patch.
         */
        privateIpv6GoogleAccess?: string | null;
        /**
         * Deprecated in favor of enable PrivateIpv6GoogleAccess on instance directly. The service accounts can be used to selectively turn on Private IPv6 Google Access only on the VMs primary service account matching the value. This value only takes effect when PrivateIpv6GoogleAccess is ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE_FOR_SERVICE_ACCOUNTS or ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE_FOR_SERVICE_ACCOUNTS.
         */
        privateIpv6GoogleAccessServiceAccounts?: string[] | null;
        /**
         * The purpose of the resource. This field can be either PRIVATE_RFC_1918 or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with purpose set to INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is reserved for Internal HTTP(S) Load Balancing. If unspecified, the purpose defaults to PRIVATE_RFC_1918. The enableFlowLogs field isn't supported with the purpose field set to INTERNAL_HTTPS_LOAD_BALANCER.
         */
        purpose?: string | null;
        /**
         * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
         */
        region?: string | null;
        /**
         * The role of subnetwork. Currently, this field is only used when purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
         */
        role?: string | null;
        /**
         * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
         */
        secondaryIpRanges?: Schema$SubnetworkSecondaryRange[];
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * The stack type for this subnet to identify whether the IPv6 feature is enabled or not. If not specified IPV4_ONLY will be used.
         *
         * This field can be both set at resource creation time and updated using patch.
         */
        stackType?: string | null;
        /**
         * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY CREATING: Subnetwork is provisioning DELETING: Subnetwork is being deleted UPDATING: Subnetwork is being updated
         */
        state?: string | null;
        /**
         * A repeated field indicating the VLAN IDs supported on this subnetwork. During Subnet creation, specifying vlan is valid only if enable_l2 is true. During Subnet Update, specifying vlan is allowed only for l2 enabled subnets. Restricted to only one VLAN.
         */
        vlans?: number[] | null;
    }
    export interface Schema$SubnetworkAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of SubnetworksScopedList resources.
         */
        items?: {
            [key: string]: Schema$SubnetworksScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#subnetworkAggregatedList for aggregated lists of subnetworks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of Subnetwork resources.
     */
    export interface Schema$SubnetworkList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Subnetwork resources.
         */
        items?: Schema$Subnetwork[];
        /**
         * [Output Only] Type of resource. Always compute#subnetworkList for lists of subnetworks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * The available logging options for this subnetwork.
     */
    export interface Schema$SubnetworkLogConfig {
        /**
         * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
         */
        aggregationInterval?: string | null;
        /**
         * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is to disable flow logging.
         */
        enable?: boolean | null;
        /**
         * Can only be specified if VPC flow logs for this subnetwork is enabled. Export filter used to define which VPC flow logs should be logged.
         */
        filterExpr?: string | null;
        /**
         * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5, which means half of all collected logs are reported.
         */
        flowSampling?: number | null;
        /**
         * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
         */
        metadata?: string | null;
        /**
         * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
         */
        metadataFields?: string[] | null;
    }
    /**
     * Represents a secondary IP range of a subnetwork.
     */
    export interface Schema$SubnetworkSecondaryRange {
        /**
         * The range of IP addresses belonging to this subnetwork secondary range. Provide this property when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and secondary IP ranges within a network. Only IPv4 is supported. The range can be any range listed in the Valid ranges list.
         */
        ipCidrRange?: string | null;
        /**
         * The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
         */
        rangeName?: string | null;
    }
    export interface Schema$SubnetworksExpandIpCidrRangeRequest {
        /**
         * The IP (in CIDR format or netmask) of internal addresses that are legal on this Subnetwork. This range should be disjoint from other subnetworks within this network. This range can only be larger than (i.e. a superset of) the range previously defined before the update.
         */
        ipCidrRange?: string | null;
    }
    export interface Schema$SubnetworksScopedList {
        /**
         * A list of subnetworks contained in this scope.
         */
        subnetworks?: Schema$Subnetwork[];
        /**
         * An informational warning that appears when the list of addresses is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$SubnetworksSetPrivateIpGoogleAccessRequest {
        privateIpGoogleAccess?: boolean | null;
    }
    /**
     * Subsetting options to make L4 ILB support any number of backend instances
     */
    export interface Schema$Subsetting {
        policy?: string | null;
    }
    /**
     * A set of instance tags.
     */
    export interface Schema$Tags {
        /**
         * Specifies a fingerprint for this request, which is essentially a hash of the tags' contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update tags. You must always provide an up-to-date fingerprint hash in order to update or change tags.
         *
         * To see the latest fingerprint, make get() request to the instance.
         */
        fingerprint?: string | null;
        /**
         * An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
         */
        items?: string[] | null;
    }
    /**
     * Represents a Target gRPC Proxy resource.
     *
     * A target gRPC proxy is a component of load balancers intended for load balancing gRPC traffic. Only global forwarding rules with load balancing scheme INTERNAL_SELF_MANAGED can reference a target gRPC proxy. The target gRPC Proxy references a URL map that specifies how traffic is routed to gRPC backend services. (== resource_for {$api_version\}.targetGrpcProxies ==)
     */
    export interface Schema$TargetGrpcProxy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a TargetGrpcProxy. An up-to-date fingerprint must be provided in order to patch/update the TargetGrpcProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the TargetGrpcProxy.
         */
        fingerprint?: string | null;
        /**
         * [Output Only] The unique identifier for the resource type. The server generates this identifier.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#targetGrpcProxy for target grpc proxies.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL with id for the resource.
         */
        selfLinkWithId?: string | null;
        /**
         * URL to the UrlMap resource that defines the mapping from URL to the BackendService. The protocol field in the BackendService must be set to GRPC.
         */
        urlMap?: string | null;
        /**
         * If true, indicates that the BackendServices referenced by the urlMap may be accessed by gRPC applications without using a sidecar proxy. This will enable configuration checks on urlMap and its referenced BackendServices to not allow unsupported features. A gRPC application must use "xds:///" scheme in the target URI of the service it is connecting to. If false, indicates that the BackendServices referenced by the urlMap will be accessed by gRPC applications via a sidecar proxy. In this case, a gRPC application must not use "xds:///" scheme in the target URI of the service it is connecting to
         */
        validateForProxyless?: boolean | null;
    }
    export interface Schema$TargetGrpcProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetGrpcProxy resources.
         */
        items?: Schema$TargetGrpcProxy[];
        /**
         * [Output Only] Type of the resource. Always compute#targetGrpcProxy for target grpc proxies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetHttpProxiesScopedList {
        /**
         * A list of TargetHttpProxies contained in this scope.
         */
        targetHttpProxies?: Schema$TargetHttpProxy[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Target HTTP Proxy resource.
     *
     * Google Compute Engine has two Target HTTP Proxy resources:
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/targetHttpProxies) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionTargetHttpProxies)
     *
     * A target HTTP proxy is a component of GCP HTTP load balancers.
     *
     * * targetHttpProxies are used by external HTTP load balancers and Traffic Director. * regionTargetHttpProxies are used by internal HTTP load balancers.
     *
     * Forwarding rules reference a target HTTP proxy, and the target proxy then references a URL map. For more information, read Using Target Proxies and  Forwarding rule concepts. (== resource_for {$api_version\}.targetHttpProxies ==) (== resource_for {$api_version\}.regionTargetHttpProxies ==)
     */
    export interface Schema$TargetHttpProxy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a TargetHttpProxy. An up-to-date fingerprint must be provided in order to patch/update the TargetHttpProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the TargetHttpProxy.
         */
        fingerprint?: string | null;
        /**
         * URLs to networkservices.HttpFilter resources enabled for xDS clients using this configuration. For example, https://networkservices.googleapis.com/v1alpha1/projects/project/locations/locationhttpFilters/httpFilter Only filters that handle outbound connection and stream events may be specified. These filters work in conjunction with a default set of HTTP filters that may already be configured by Traffic Director. Traffic Director will determine the final location of these filters within xDS configuration based on the name of the HTTP filter. If Traffic Director positions multiple filters at the same location, those filters will be in the same order as specified in this list.
         * httpFilters only applies for loadbalancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details.
         */
        httpFilters?: string[] | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#targetHttpProxy for target HTTP proxies.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         *
         * When this field is set to true, Envoy proxies set up inbound traffic interception and bind to the IP address and port specified in the forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for inbound requests and handles requests when it receives them.
         *
         * The default is false.
         */
        proxyBind?: boolean | null;
        /**
         * [Output Only] URL of the region where the regional Target HTTP Proxy resides. This field is not applicable to global Target HTTP Proxies.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * URL to the UrlMap resource that defines the mapping from URL to the BackendService.
         */
        urlMap?: string | null;
    }
    export interface Schema$TargetHttpProxyAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetHttpProxiesScopedList resources.
         */
        items?: {
            [key: string]: Schema$TargetHttpProxiesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#targetHttpProxyAggregatedList for lists of Target HTTP Proxies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * A list of TargetHttpProxy resources.
     */
    export interface Schema$TargetHttpProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetHttpProxy resources.
         */
        items?: Schema$TargetHttpProxy[];
        /**
         * Type of resource. Always compute#targetHttpProxyList for lists of target HTTP proxies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetHttpsProxiesScopedList {
        /**
         * A list of TargetHttpsProxies contained in this scope.
         */
        targetHttpsProxies?: Schema$TargetHttpsProxy[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetHttpsProxiesSetCertificateMapRequest {
        /**
         * URL of the Certificate Map to associate with this TargetHttpsProxy.
         */
        certificateMap?: string | null;
    }
    export interface Schema$TargetHttpsProxiesSetQuicOverrideRequest {
        /**
         * QUIC policy for the TargetHttpsProxy resource.
         */
        quicOverride?: string | null;
    }
    export interface Schema$TargetHttpsProxiesSetSslCertificatesRequest {
        /**
         * New set of SslCertificate resources to associate with this TargetHttpsProxy resource. Currently exactly one SslCertificate resource must be specified.
         */
        sslCertificates?: string[] | null;
    }
    /**
     * Represents a Target HTTPS Proxy resource.
     *
     * Google Compute Engine has two Target HTTPS Proxy resources:
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/targetHttpsProxies) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionTargetHttpsProxies)
     *
     * A target HTTPS proxy is a component of GCP HTTPS load balancers.
     *
     * * targetHttpsProxies are used by external HTTPS load balancers. * regionTargetHttpsProxies are used by internal HTTPS load balancers.
     *
     * Forwarding rules reference a target HTTPS proxy, and the target proxy then references a URL map. For more information, read Using Target Proxies and  Forwarding rule concepts. (== resource_for {$api_version\}.targetHttpsProxies ==) (== resource_for {$api_version\}.regionTargetHttpsProxies ==)
     */
    export interface Schema$TargetHttpsProxy {
        /**
         * [Deprecated] Use serverTlsPolicy instead.
         */
        authentication?: string | null;
        /**
         * [Deprecated] Use authorizationPolicy instead.
         */
        authorization?: string | null;
        /**
         * Optional. A URL referring to a networksecurity.AuthorizationPolicy resource that describes how the proxy should authorize inbound traffic. If left blank, access will not be restricted by an authorization policy.
         * Refer to the AuthorizationPolicy resource for additional details.
         * authorizationPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         * Note: This field currently has no impact.
         */
        authorizationPolicy?: string | null;
        /**
         * URL of a certificate map that identifies a certificate map associated with the given target proxy. This field can only be set for global target proxies. If set, sslCertificates will be ignored.
         */
        certificateMap?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a TargetHttpsProxy. An up-to-date fingerprint must be provided in order to patch the TargetHttpsProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the TargetHttpsProxy.
         */
        fingerprint?: string | null;
        /**
         * URLs to networkservices.HttpFilter resources enabled for xDS clients using this configuration. For example, https://networkservices.googleapis.com/beta/projects/project/locations/locationhttpFilters/httpFilter Only filters that handle outbound connection and stream events may be specified. These filters work in conjunction with a default set of HTTP filters that may already be configured by Traffic Director. Traffic Director will determine the final location of these filters within xDS configuration based on the name of the HTTP filter. If Traffic Director positions multiple filters at the same location, those filters will be in the same order as specified in this list.
         * httpFilters only applies for loadbalancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details.
         */
        httpFilters?: string[] | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         *
         * When this field is set to true, Envoy proxies set up inbound traffic interception and bind to the IP address and port specified in the forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for inbound requests and handles requests when it receives them.
         *
         * The default is false.
         */
        proxyBind?: boolean | null;
        /**
         * Specifies the QUIC override policy for this TargetHttpsProxy resource. This setting determines whether the load balancer attempts to negotiate QUIC with clients. You can specify NONE, ENABLE, or DISABLE.
         * - When quic-override is set to NONE, Google manages whether QUIC is used.
         * - When quic-override is set to ENABLE, the load balancer uses QUIC when possible.
         * - When quic-override is set to DISABLE, the load balancer doesn't use QUIC.
         * - If the quic-override flag is not specified, NONE is implied.
         */
        quicOverride?: string | null;
        /**
         * [Output Only] URL of the region where the regional TargetHttpsProxy resides. This field is not applicable to global TargetHttpsProxies.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Optional. A URL referring to a networksecurity.ServerTlsPolicy resource that describes how the proxy should authenticate inbound traffic.
         * serverTlsPolicy only applies to a global TargetHttpsProxy attached to globalForwardingRules with the loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         * If left blank, communications are not encrypted.
         * Note: This field currently has no impact.
         */
        serverTlsPolicy?: string | null;
        /**
         * URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates.
         */
        sslCertificates?: string[] | null;
        /**
         * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not set, the TargetHttpsProxy resource has no SSL policy configured.
         */
        sslPolicy?: string | null;
        /**
         * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL to the BackendService. For example, the following are all valid URLs for specifying a URL map:
         * - https://www.googleapis.compute/v1/projects/project/global/urlMaps/url-map
         * - projects/project/global/urlMaps/url-map
         * - global/urlMaps/url-map
         */
        urlMap?: string | null;
    }
    export interface Schema$TargetHttpsProxyAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetHttpsProxiesScopedList resources.
         */
        items?: {
            [key: string]: Schema$TargetHttpsProxiesScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#targetHttpsProxyAggregatedList for lists of Target HTTP Proxies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of TargetHttpsProxy resources.
     */
    export interface Schema$TargetHttpsProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetHttpsProxy resources.
         */
        items?: Schema$TargetHttpsProxy[];
        /**
         * Type of resource. Always compute#targetHttpsProxyList for lists of target HTTPS proxies.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Target Instance resource.
     *
     * You can use a target instance to handle traffic for one or more forwarding rules, which is ideal for forwarding protocol traffic that is managed by a single source. For example, ESP, AH, TCP, or UDP. For more information, read Target instances. (== resource_for {$api_version\}.targetInstances ==)
     */
    export interface Schema$TargetInstance {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * A URL to the virtual machine instance that handles traffic for this target instance. When creating a target instance, you can provide the fully-qualified URL or a valid partial URL to the desired virtual machine. For example, the following are all valid URLs:
         * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
         * - projects/project/zones/zone/instances/instance
         * - zones/zone/instances/instance
         */
        instance?: string | null;
        /**
         * [Output Only] The type of the resource. Always compute#targetInstance for target instances.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * NAT option controlling how IPs are NAT'ed to the instance. Currently only NO_NAT (default value) is supported.
         */
        natPolicy?: string | null;
        /**
         * The URL of the network this target instance uses to forward traffic. If not specified, the traffic will be forwarded to the network that the default network interface belongs to.
         */
        network?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * [Output Only] URL of the zone where the target instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        zone?: string | null;
    }
    export interface Schema$TargetInstanceAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetInstance resources.
         */
        items?: {
            [key: string]: Schema$TargetInstancesScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of TargetInstance resources.
     */
    export interface Schema$TargetInstanceList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetInstance resources.
         */
        items?: Schema$TargetInstance[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetInstancesScopedList {
        /**
         * A list of target instances contained in this scope.
         */
        targetInstances?: Schema$TargetInstance[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Target Pool resource.
     *
     * Target pools are used for network TCP/UDP load balancing. A target pool references member instances, an associated legacy HttpHealthCheck resource, and, optionally, a backup target pool. For more information, read Using target pools. (== resource_for {$api_version\}.targetPools ==)
     */
    export interface Schema$TargetPool {
        /**
         * The server-defined URL for the resource. This field is applicable only when the containing target pool is serving a forwarding rule as the primary pool, and its failoverRatio field is properly set to a value between [0, 1].
         *
         * backupPool and failoverRatio together define the fallback behavior of the primary target pool: if the ratio of the healthy instances in the primary pool is at or below failoverRatio, traffic arriving at the load-balanced IP will be directed to the backup pool.
         *
         * In case where failoverRatio and backupPool are not set, or all the instances in the backup pool are unhealthy, the traffic will be directed back to the primary pool in the "force" mode, where traffic will be spread to the healthy instances with the best effort, or to all instances when no instance is healthy.
         */
        backupPool?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * This field is applicable only when the containing target pool is serving a forwarding rule as the primary pool (i.e., not as a backup pool to some other target pool). The value of the field must be in [0, 1].
         *
         * If set, backupPool must also be set. They together define the fallback behavior of the primary target pool: if the ratio of the healthy instances in the primary pool is at or below this number, traffic arriving at the load-balanced IP will be directed to the backup pool.
         *
         * In case where failoverRatio is not set or all the instances in the backup pool are unhealthy, the traffic will be directed back to the primary pool in the "force" mode, where traffic will be spread to the healthy instances with the best effort, or to all instances when no instance is healthy.
         */
        failoverRatio?: number | null;
        /**
         * The URL of the HttpHealthCheck resource. A member instance in this pool is considered healthy if and only if the health checks pass. Only legacy HttpHealthChecks are supported. Only one health check may be specified.
         */
        healthChecks?: string[] | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * A list of resource URLs to the virtual machine instances serving this pool. They must live in zones contained in the same region as this pool.
         */
        instances?: string[] | null;
        /**
         * [Output Only] Type of the resource. Always compute#targetPool for target pools.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * [Output Only] URL of the region where the target pool resides.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource with the resource id.
         */
        selfLinkWithId?: string | null;
        /**
         * Session affinity option, must be one of the following values:
         * NONE: Connections from the same client IP may go to any instance in the pool.
         * CLIENT_IP: Connections from the same client IP will go to the same instance in the pool while that instance remains healthy.
         * CLIENT_IP_PROTO: Connections from the same client IP with the same IP protocol will go to the same instance in the pool while that instance remains healthy.
         */
        sessionAffinity?: string | null;
    }
    export interface Schema$TargetPoolAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetPool resources.
         */
        items?: {
            [key: string]: Schema$TargetPoolsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#targetPoolAggregatedList for aggregated lists of target pools.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetPoolInstanceHealth {
        healthStatus?: Schema$HealthStatus[];
        /**
         * [Output Only] Type of resource. Always compute#targetPoolInstanceHealth when checking the health of an instance.
         */
        kind?: string | null;
    }
    /**
     * Contains a list of TargetPool resources.
     */
    export interface Schema$TargetPoolList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetPool resources.
         */
        items?: Schema$TargetPool[];
        /**
         * [Output Only] Type of resource. Always compute#targetPoolList for lists of target pools.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetPoolsAddHealthCheckRequest {
        /**
         * The HttpHealthCheck to add to the target pool.
         */
        healthChecks?: Schema$HealthCheckReference[];
    }
    export interface Schema$TargetPoolsAddInstanceRequest {
        /**
         * A full or partial URL to an instance to add to this target pool. This can be a full or partial URL. For example, the following are valid URLs:
         * - https://www.googleapis.com/compute/v1/projects/project-id/zones/zone/instances/instance-name
         * - projects/project-id/zones/zone/instances/instance-name
         * - zones/zone/instances/instance-name
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$TargetPoolsRemoveHealthCheckRequest {
        /**
         * Health check URL to be removed. This can be a full or valid partial URL. For example, the following are valid URLs:
         * - https://www.googleapis.com/compute/beta/projects/project/global/httpHealthChecks/health-check
         * - projects/project/global/httpHealthChecks/health-check
         * - global/httpHealthChecks/health-check
         */
        healthChecks?: Schema$HealthCheckReference[];
    }
    export interface Schema$TargetPoolsRemoveInstanceRequest {
        /**
         * URLs of the instances to be removed from target pool.
         */
        instances?: Schema$InstanceReference[];
    }
    export interface Schema$TargetPoolsScopedList {
        /**
         * A list of target pools contained in this scope.
         */
        targetPools?: Schema$TargetPool[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetReference {
        target?: string | null;
    }
    export interface Schema$TargetSslProxiesSetBackendServiceRequest {
        /**
         * The URL of the new BackendService resource for the targetSslProxy.
         */
        service?: string | null;
    }
    export interface Schema$TargetSslProxiesSetCertificateMapRequest {
        /**
         * URL of the Certificate Map to associate with this TargetSslProxy.
         */
        certificateMap?: string | null;
    }
    export interface Schema$TargetSslProxiesSetProxyHeaderRequest {
        /**
         * The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
         */
        proxyHeader?: string | null;
    }
    export interface Schema$TargetSslProxiesSetSslCertificatesRequest {
        /**
         * New set of URLs to SslCertificate resources to associate with this TargetSslProxy. Currently exactly one ssl certificate must be specified.
         */
        sslCertificates?: string[] | null;
    }
    /**
     * Represents a Target SSL Proxy resource.
     *
     * A target SSL proxy is a component of a SSL Proxy load balancer. Global forwarding rules reference a target SSL proxy, and the target proxy then references an external backend service. For more information, read Using Target Proxies. (== resource_for {$api_version\}.targetSslProxies ==)
     */
    export interface Schema$TargetSslProxy {
        /**
         * URL of a certificate map that identifies a certificate map associated with the given target proxy. This field can only be set for global target proxies. If set, sslCertificates will be ignored.
         */
        certificateMap?: string | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#targetSslProxy for target SSL proxies.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * URL to the BackendService resource.
         */
        service?: string | null;
        /**
         * URLs to SslCertificate resources that are used to authenticate connections to Backends. At least one SSL certificate must be specified. Currently, you may specify up to 15 SSL certificates.
         */
        sslCertificates?: string[] | null;
        /**
         * URL of SslPolicy resource that will be associated with the TargetSslProxy resource. If not set, the TargetSslProxy resource will not have any SSL policy configured.
         */
        sslPolicy?: string | null;
    }
    /**
     * Contains a list of TargetSslProxy resources.
     */
    export interface Schema$TargetSslProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetSslProxy resources.
         */
        items?: Schema$TargetSslProxy[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetTcpProxiesSetBackendServiceRequest {
        /**
         * The URL of the new BackendService resource for the targetTcpProxy.
         */
        service?: string | null;
    }
    export interface Schema$TargetTcpProxiesSetProxyHeaderRequest {
        /**
         * The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
         */
        proxyHeader?: string | null;
    }
    /**
     * Represents a Target TCP Proxy resource.
     *
     * A target TCP proxy is a component of a TCP Proxy load balancer. Global forwarding rules reference target TCP proxy, and the target proxy then references an external backend service. For more information, read TCP Proxy Load Balancing overview. (== resource_for {$api_version\}.targetTcpProxies ==)
     */
    export interface Schema$TargetTcpProxy {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#targetTcpProxy for target TCP proxies.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
         *
         * When this field is set to true, Envoy proxies set up inbound traffic interception and bind to the IP address and port specified in the forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for inbound requests and handles requests when it receives them.
         *
         * The default is false.
         */
        proxyBind?: boolean | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * URL to the BackendService resource.
         */
        service?: string | null;
    }
    /**
     * Contains a list of TargetTcpProxy resources.
     */
    export interface Schema$TargetTcpProxyList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetTcpProxy resources.
         */
        items?: Schema$TargetTcpProxy[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a Target VPN Gateway resource.
     *
     * The target VPN gateway resource represents a Classic Cloud VPN gateway. For more information, read the the Cloud VPN Overview. (== resource_for {$api_version\}.targetVpnGateways ==)
     */
    export interface Schema$TargetVpnGateway {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] A list of URLs to the ForwardingRule resources. ForwardingRules are created using compute.forwardingRules.insert and associated with a VPN gateway.
         */
        forwardingRules?: string[] | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this TargetVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a TargetVpnGateway.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * URL of the network to which this VPN gateway is attached. Provided by the client when the VPN gateway is created.
         */
        network?: string | null;
        /**
         * [Output Only] URL of the region where the target VPN gateway resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] The status of the VPN gateway, which can be one of the following: CREATING, READY, FAILED, or DELETING.
         */
        status?: string | null;
        /**
         * [Output Only] A list of URLs to VpnTunnel resources. VpnTunnels are created using the compute.vpntunnels.insert method and associated with a VPN gateway.
         */
        tunnels?: string[] | null;
    }
    export interface Schema$TargetVpnGatewayAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetVpnGateway resources.
         */
        items?: {
            [key: string]: Schema$TargetVpnGatewaysScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of TargetVpnGateway resources.
     */
    export interface Schema$TargetVpnGatewayList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of TargetVpnGateway resources.
         */
        items?: Schema$TargetVpnGateway[];
        /**
         * [Output Only] Type of resource. Always compute#targetVpnGateway for target VPN gateways.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TargetVpnGatewaysScopedList {
        /**
         * [Output Only] A list of target VPN gateways contained in this scope.
         */
        targetVpnGateways?: Schema$TargetVpnGateway[];
        /**
         * [Output Only] Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$TCPHealthCheck {
        /**
         * The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string | null;
        /**
         * Specifies how port is selected for health checking, can be one of following values:
         * USE_FIXED_PORT: The port number in port is used for health checking.
         * USE_NAMED_PORT: The portName is used for health checking.
         * USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
         *
         *
         * If not specified, TCP health check follows behavior specified in port and portName fields.
         */
        portSpecification?: string | null;
        /**
         * Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
         */
        proxyHeader?: string | null;
        /**
         * The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
         */
        request?: string | null;
        /**
         * The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
         */
        response?: string | null;
    }
    export interface Schema$TestFailure {
        /**
         * The actual output URL evaluated by load balancer containing the scheme, host, path and query parameters.
         */
        actualOutputUrl?: string | null;
        /**
         * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
         */
        actualRedirectResponseCode?: number | null;
        /**
         * BackendService or BackendBucket returned by load balancer.
         */
        actualService?: string | null;
        /**
         * The expected output URL evaluated by load balancer containing the scheme, host, path and query parameters.
         */
        expectedOutputUrl?: string | null;
        /**
         * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
         */
        expectedRedirectResponseCode?: number | null;
        /**
         * Expected BackendService or BackendBucket resource the given URL should be mapped to.
         */
        expectedService?: string | null;
        /**
         * HTTP headers of the request.
         */
        headers?: Schema$UrlMapTestHeader[];
        /**
         * Host portion of the URL.
         */
        host?: string | null;
        /**
         * Path portion including query parameters in the URL.
         */
        path?: string | null;
    }
    export interface Schema$TestPermissionsRequest {
        /**
         * The set of permissions to check for the 'resource'. Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
         */
        permissions?: string[] | null;
    }
    export interface Schema$TestPermissionsResponse {
        /**
         * A subset of `TestPermissionsRequest.permissions` that the caller is allowed.
         */
        permissions?: string[] | null;
    }
    /**
     * [Deprecated] Defines the mechanism to obtain the client or server certificate. Defines the mechanism to obtain the client or server certificate.
     */
    export interface Schema$TlsCertificateContext {
        /**
         * Specifies the certificate and private key paths. This field is applicable only if tlsCertificateSource is set to USE_PATH.
         */
        certificatePaths?: Schema$TlsCertificatePaths;
        /**
         * Defines how TLS certificates are obtained.
         */
        certificateSource?: string | null;
        /**
         * Specifies the config to retrieve certificates through SDS. This field is applicable only if tlsCertificateSource is set to USE_SDS.
         */
        sdsConfig?: Schema$SdsConfig;
    }
    /**
     * [Deprecated] The paths to the mounted TLS Certificates and private key. The paths to the mounted TLS Certificates and private key.
     */
    export interface Schema$TlsCertificatePaths {
        /**
         * The path to the file holding the client or server TLS certificate to use.
         */
        certificatePath?: string | null;
        /**
         * The path to the file holding the client or server private key.
         */
        privateKeyPath?: string | null;
    }
    /**
     * [Deprecated] The TLS settings for the client or server. The TLS settings for the client or server.
     */
    export interface Schema$TlsContext {
        /**
         * Defines the mechanism to obtain the client or server certificate.
         */
        certificateContext?: Schema$TlsCertificateContext;
        /**
         * Defines the mechanism to obtain the Certificate Authority certificate to validate the client/server certificate. If omitted, the proxy will not validate the server or client certificate.
         */
        validationContext?: Schema$TlsValidationContext;
    }
    /**
     * [Deprecated] Defines the mechanism to obtain the Certificate Authority certificate to validate the client/server certificate. validate the client/server certificate.
     */
    export interface Schema$TlsValidationContext {
        /**
         * The path to the file holding the CA certificate to validate the client or server certificate.
         */
        certificatePath?: string | null;
        /**
         * Specifies the config to retrieve certificates through SDS. This field is applicable only if tlsCertificateSource is set to USE_SDS.
         */
        sdsConfig?: Schema$SdsConfig;
        /**
         * Defines how TLS certificates are obtained.
         */
        validationSource?: string | null;
    }
    export interface Schema$UDPHealthCheck {
        /**
         * The UDP port number for the health check request. Valid values are 1 through 65535.
         */
        port?: number | null;
        /**
         * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
         */
        portName?: string | null;
        /**
         * Raw data of request to send in payload of UDP packet. It is an error if this is empty. The request data can only be ASCII.
         */
        request?: string | null;
        /**
         * The bytes to match against the beginning of the response data. It is an error if this is empty. The response data can only be ASCII.
         */
        response?: string | null;
    }
    /**
     * Upcoming Maintenance notification information.
     */
    export interface Schema$UpcomingMaintenance {
        /**
         * [Output Only] The date when the maintenance will take place. This value is in RFC3339 text format. DEPRECATED: Use start_time_window instead.
         */
        date?: string | null;
        /**
         * [Output Only] The start time window of the maintenance disruption.
         */
        startTimeWindow?: Schema$UpcomingMaintenanceTimeWindow;
        /**
         * [Output Only] The time when the maintenance will take place. This value is in RFC3339 text format. DEPRECATED: Use start_time_window instead.
         */
        time?: string | null;
        /**
         * Defines the type of maintenance.
         */
        type?: string | null;
    }
    /**
     * Represents a window of time using two timestamps: `earliest` and `latest`. This timestamp values are in RFC3339 text format.
     */
    export interface Schema$UpcomingMaintenanceTimeWindow {
        earliest?: string | null;
        latest?: string | null;
    }
    /**
     * Represents a URL Map resource.
     *
     * Google Compute Engine has two URL Map resources:
     *
     * * [Global](/compute/docs/reference/rest/{$api_version\}/urlMaps) * [Regional](/compute/docs/reference/rest/{$api_version\}/regionUrlMaps)
     *
     * A URL map resource is a component of certain types of GCP load balancers and Traffic Director.
     *
     * * urlMaps are used by external HTTP(S) load balancers and Traffic Director. * regionUrlMaps are used by internal HTTP(S) load balancers.
     *
     * For a list of supported URL map features by load balancer type, see the  Load balancing features: Routing and traffic management table.
     *
     * For a list of supported URL map features for Traffic Director, see the  Traffic Director features: Routing and traffic management table.
     *
     * This resource defines mappings from host names and URL paths to either a backend service or a backend bucket.
     *
     * To use the global urlMaps resource, the backend service must have a loadBalancingScheme of either EXTERNAL or INTERNAL_SELF_MANAGED. To use the regionUrlMaps resource, the backend service must have a loadBalancingScheme of INTERNAL_MANAGED. For more information, read URL Map Concepts.
     */
    export interface Schema$UrlMap {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * defaultRouteAction takes effect when none of the  hostRules match. The load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any  weightedBackendServices.
         * Only one of defaultRouteAction or defaultUrlRedirect must be set.
         * UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within defaultRouteAction.
         * defaultRouteAction has no effect when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        defaultRouteAction?: Schema$HttpRouteAction;
        /**
         * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified.
         * Only one of defaultService, defaultUrlRedirect  or defaultRouteAction.weightedBackendService must be set.
         * defaultService has no effect when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        defaultService?: string | null;
        /**
         * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect.
         * If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set.
         * Not supported when the URL map is bound to target gRPC proxy.
         */
        defaultUrlRedirect?: Schema$HttpRedirectAction;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a UrlMap.
         */
        fingerprint?: string | null;
        /**
         * Specifies changes to request and response headers that need to take effect for the selected backendService.
         * The headerAction specified here take effect after headerAction specified under pathMatcher.
         * Note that headerAction is not supported for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        headerAction?: Schema$HttpHeaderAction;
        /**
         * The list of HostRules to use against the URL.
         */
        hostRules?: Schema$HostRule[];
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
         */
        kind?: string | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * The list of named PathMatchers to use against the URL.
         */
        pathMatchers?: Schema$PathMatcher[];
        /**
         * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * The list of expected URL mapping tests. Request to update this UrlMap will succeed only if all of the test cases pass. You can specify a maximum of 100 tests per UrlMap.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        tests?: Schema$UrlMapTest[];
    }
    /**
     * Contains a list of UrlMap resources.
     */
    export interface Schema$UrlMapList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of UrlMap resources.
         */
        items?: Schema$UrlMap[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$UrlMapReference {
        urlMap?: string | null;
    }
    export interface Schema$UrlMapsAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of UrlMapsScopedList resources.
         */
        items?: {
            [key: string]: Schema$UrlMapsScopedList;
        } | null;
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$UrlMapsScopedList {
        /**
         * A list of UrlMaps contained in this scope.
         */
        urlMaps?: Schema$UrlMap[];
        /**
         * Informational warning which replaces the list of backend services when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$UrlMapsValidateRequest {
        /**
         * Content of the UrlMap to be validated.
         */
        resource?: Schema$UrlMap;
    }
    export interface Schema$UrlMapsValidateResponse {
        result?: Schema$UrlMapValidationResult;
    }
    /**
     * Message for the expected URL mappings.
     */
    export interface Schema$UrlMapTest {
        /**
         * The weight to use for the supplied host and path when using advanced routing rules that involve traffic splitting.
         */
        backendServiceWeight?: number | null;
        /**
         * Description of this test case.
         */
        description?: string | null;
        /**
         * The expected output URL evaluated by load balancer containing the scheme, host, path and query parameters.
         * For rules that forward requests to backends, the test passes only when expectedOutputUrl matches the request forwarded by load balancer to backends. For rules with urlRewrite, the test verifies that the forwarded request matches hostRewrite and pathPrefixRewrite in the urlRewrite action. When service is specified, expectedOutputUrl`s scheme is ignored.
         * For rules with urlRedirect, the test passes only if expectedOutputUrl matches the URL in the load balancer's redirect response. If urlRedirect specifies https_redirect, the test passes only if the scheme in expectedOutputUrl is also set to https. If urlRedirect specifies strip_query, the test passes only if expectedOutputUrl does not contain any query parameters.
         * expectedOutputUrl is optional when service is specified.
         */
        expectedOutputUrl?: string | null;
        /**
         * For rules with urlRedirect, the test passes only if expectedRedirectResponseCode matches the HTTP status code in load balancer's redirect response.
         * expectedRedirectResponseCode cannot be set when service is set.
         */
        expectedRedirectResponseCode?: number | null;
        /**
         * The expected URL that should be redirected to for the host and path being tested. [Deprecated] This field is deprecated. Use expected_output_url instead.
         */
        expectedUrlRedirect?: string | null;
        /**
         * HTTP headers for this request. If headers contains a host header, then host must also match the header value.
         */
        headers?: Schema$UrlMapTestHeader[];
        /**
         * Host portion of the URL. If headers contains a host header, then host must also match the header value.
         */
        host?: string | null;
        /**
         * Path portion of the URL.
         */
        path?: string | null;
        /**
         * Expected BackendService or BackendBucket resource the given URL should be mapped to.
         * service cannot be set if expectedRedirectResponseCode is set.
         */
        service?: string | null;
    }
    /**
     * HTTP headers used in UrlMapTests.
     */
    export interface Schema$UrlMapTestHeader {
        /**
         * Header name.
         */
        name?: string | null;
        /**
         * Header value.
         */
        value?: string | null;
    }
    /**
     * Message representing the validation result for a UrlMap.
     */
    export interface Schema$UrlMapValidationResult {
        loadErrors?: string[] | null;
        /**
         * Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.
         */
        loadSucceeded?: boolean | null;
        testFailures?: Schema$TestFailure[];
        /**
         * If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.
         */
        testPassed?: boolean | null;
    }
    /**
     * The spec for modifying the path before sending the request to the matched backend service.
     */
    export interface Schema$UrlRewrite {
        /**
         * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
         * The value must be between 1 and 255 characters.
         */
        hostRewrite?: string | null;
        /**
         * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
         * The value must be between 1 and 1024 characters.
         */
        pathPrefixRewrite?: string | null;
    }
    /**
     * Subnetwork which the current user has compute.subnetworks.use permission on.
     */
    export interface Schema$UsableSubnetwork {
        /**
         * The range of internal addresses that are owned by this subnetwork.
         */
        ipCidrRange?: string | null;
        /**
         * Network URL.
         */
        network?: string | null;
        /**
         * Secondary IP ranges.
         */
        secondaryIpRanges?: Schema$UsableSubnetworkSecondaryRange[];
        /**
         * Subnetwork URL.
         */
        subnetwork?: string | null;
    }
    export interface Schema$UsableSubnetworksAggregatedList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output] A list of usable subnetwork URLs.
         */
        items?: Schema$UsableSubnetwork[];
        /**
         * [Output Only] Type of resource. Always compute#usableSubnetworksAggregatedList for aggregated lists of usable subnetworks.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Secondary IP range of a usable subnetwork.
     */
    export interface Schema$UsableSubnetworkSecondaryRange {
        /**
         * The range of IP addresses belonging to this subnetwork secondary range.
         */
        ipCidrRange?: string | null;
        /**
         * The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
         */
        rangeName?: string | null;
    }
    /**
     * The location in Cloud Storage and naming method of the daily usage report. Contains bucket_name and report_name prefix.
     */
    export interface Schema$UsageExportLocation {
        /**
         * The name of an existing bucket in Cloud Storage where the usage report object is stored. The Google Service Account is granted write access to this bucket. This can either be the bucket name by itself, such as example-bucket, or the bucket name with gs:// or https://storage.googleapis.com/ in front of it, such as gs://example-bucket.
         */
        bucketName?: string | null;
        /**
         * An optional prefix for the name of the usage report object stored in bucketName. If not supplied, defaults to usage. The report is stored as a CSV file named report_name_prefix_gce_YYYYMMDD.csv where YYYYMMDD is the day of the usage according to Pacific Time. If you supply a prefix, it should conform to Cloud Storage object naming conventions.
         */
        reportNamePrefix?: string | null;
    }
    /**
     * Contain information of Nat mapping for a VM endpoint (i.e., NIC).
     */
    export interface Schema$VmEndpointNatMappings {
        /**
         * Name of the VM instance which the endpoint belongs to
         */
        instanceName?: string | null;
        interfaceNatMappings?: Schema$VmEndpointNatMappingsInterfaceNatMappings[];
    }
    /**
     * Contain information of Nat mapping for an interface of this endpoint.
     */
    export interface Schema$VmEndpointNatMappingsInterfaceNatMappings {
        /**
         * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
         */
        drainNatIpPortRanges?: string[] | null;
        /**
         * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
         */
        natIpPortRanges?: string[] | null;
        /**
         * Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.
         */
        numTotalDrainNatPorts?: number | null;
        /**
         * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
         */
        numTotalNatPorts?: number | null;
        /**
         * Information about mappings provided by rules in this NAT.
         */
        ruleMappings?: Schema$VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings[];
        /**
         * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
         */
        sourceAliasIpRange?: string | null;
        /**
         * Primary IP of the VM for this NIC.
         */
        sourceVirtualIp?: string | null;
    }
    /**
     * Contains information of NAT Mappings provided by a NAT Rule.
     */
    export interface Schema$VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings {
        /**
         * List of all drain IP:port-range mappings assigned to this interface by this rule. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
         */
        drainNatIpPortRanges?: string[] | null;
        /**
         * A list of all IP:port-range mappings assigned to this interface by this rule. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
         */
        natIpPortRanges?: string[] | null;
        /**
         * Total number of drain ports across all NAT IPs allocated to this interface by this rule. It equals the aggregated port number in the field drain_nat_ip_port_ranges.
         */
        numTotalDrainNatPorts?: number | null;
        /**
         * Total number of ports across all NAT IPs allocated to this interface by this rule. It equals the aggregated port number in the field nat_ip_port_ranges.
         */
        numTotalNatPorts?: number | null;
        /**
         * Rule number of the NAT Rule.
         */
        ruleNumber?: number | null;
    }
    /**
     * Contains a list of VmEndpointNatMappings.
     */
    export interface Schema$VmEndpointNatMappingsList {
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#vmEndpointNatMappingsList for lists of Nat mappings of VM endpoints.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] A list of Nat mapping information of VM endpoints.
         */
        result?: Schema$VmEndpointNatMappings[];
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Represents a HA VPN gateway.
     *
     * HA VPN is a high-availability (HA) Cloud VPN solution that lets you securely connect your on-premises network to your Google Cloud Virtual Private Cloud network through an IPsec VPN connection in a single region. For more information about Cloud HA VPN solutions, see  Cloud VPN topologies . (== resource_for {$api_version\}.vpnGateways ==)
     */
    export interface Schema$VpnGateway {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve an VpnGateway.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * URL of the network to which this VPN gateway is attached. Provided by the client when the VPN gateway is created.
         */
        network?: string | null;
        /**
         * [Output Only] URL of the region where the VPN gateway resides.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * A list of interfaces on this VPN gateway.
         */
        vpnInterfaces?: Schema$VpnGatewayVpnGatewayInterface[];
    }
    export interface Schema$VpnGatewayAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of VpnGateway resources.
         */
        items?: {
            [key: string]: Schema$VpnGatewaysScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of VpnGateway resources.
     */
    export interface Schema$VpnGatewayList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of VpnGateway resources.
         */
        items?: Schema$VpnGateway[];
        /**
         * [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$VpnGatewaysGetStatusResponse {
        result?: Schema$VpnGatewayStatus;
    }
    export interface Schema$VpnGatewaysScopedList {
        /**
         * [Output Only] A list of VPN gateways contained in this scope.
         */
        vpnGateways?: Schema$VpnGateway[];
        /**
         * [Output Only] Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$VpnGatewayStatus {
        /**
         * List of VPN connection for this VpnGateway.
         */
        vpnConnections?: Schema$VpnGatewayStatusVpnConnection[];
    }
    /**
     * Describes the high availability requirement state for the VPN connection between this Cloud VPN gateway and a peer gateway.
     */
    export interface Schema$VpnGatewayStatusHighAvailabilityRequirementState {
        /**
         * Indicates the high availability requirement state for the VPN connection. Valid values are CONNECTION_REDUNDANCY_MET, CONNECTION_REDUNDANCY_NOT_MET.
         */
        state?: string | null;
        /**
         * Indicates the reason why the VPN connection does not meet the high availability redundancy criteria/requirement. Valid values is INCOMPLETE_TUNNELS_COVERAGE.
         */
        unsatisfiedReason?: string | null;
    }
    /**
     * Contains some information about a VPN tunnel.
     */
    export interface Schema$VpnGatewayStatusTunnel {
        /**
         * The VPN gateway interface this VPN tunnel is associated with.
         */
        localGatewayInterface?: number | null;
        /**
         * The peer gateway interface this VPN tunnel is connected to, the peer gateway could either be an external VPN gateway or GCP VPN gateway.
         */
        peerGatewayInterface?: number | null;
        /**
         * URL reference to the VPN tunnel.
         */
        tunnelUrl?: string | null;
    }
    /**
     * A VPN connection contains all VPN tunnels connected from this VpnGateway to the same peer gateway. The peer gateway could either be a external VPN gateway or GCP VPN gateway.
     */
    export interface Schema$VpnGatewayStatusVpnConnection {
        /**
         * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
         */
        peerExternalGateway?: string | null;
        /**
         * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
         */
        peerGcpGateway?: string | null;
        /**
         * HighAvailabilityRequirementState for the VPN connection.
         */
        state?: Schema$VpnGatewayStatusHighAvailabilityRequirementState;
        /**
         * List of VPN tunnels that are in this VPN connection.
         */
        tunnels?: Schema$VpnGatewayStatusTunnel[];
    }
    /**
     * A VPN gateway interface.
     */
    export interface Schema$VpnGatewayVpnGatewayInterface {
        /**
         * The numeric ID of this VPN gateway interface.
         */
        id?: number | null;
        /**
         * URL of the interconnect attachment resource. When the value of this field is present, the VPN Gateway will be used for IPsec-encrypted Cloud Interconnect; all Egress or Ingress traffic for this VPN Gateway interface will go through the specified interconnect attachment resource.
         * Not currently available in all Interconnect locations.
         */
        interconnectAttachment?: string | null;
        /**
         * [Output Only] The external IP address for this VPN gateway interface.
         */
        ipAddress?: string | null;
    }
    /**
     * Represents a Cloud VPN Tunnel resource.
     *
     * For more information about VPN, read the  the Cloud VPN Overview. (== resource_for {$api_version\}.vpnTunnels ==)
     */
    export interface Schema$VpnTunnel {
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * An optional description of this resource. Provide this property when you create the resource.
         */
        description?: string | null;
        /**
         * [Output Only] Detailed status message for the VPN tunnel.
         */
        detailedStatus?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
         */
        ikeVersion?: number | null;
        /**
         * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
         */
        kind?: string | null;
        /**
         * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
         *
         * To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
         */
        labelFingerprint?: string | null;
        /**
         * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported.
         */
        localTrafficSelector?: string[] | null;
        /**
         * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
         */
        name?: string | null;
        /**
         * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
         */
        peerExternalGateway?: string | null;
        /**
         * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created.
         */
        peerExternalGatewayInterface?: number | null;
        /**
         * URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer GCP VPN gateway.
         */
        peerGcpGateway?: string | null;
        /**
         * IP address of the peer VPN gateway. Only IPv4 is supported.
         */
        peerIp?: string | null;
        /**
         * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
         */
        region?: string | null;
        /**
         * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported.
         */
        remoteTrafficSelector?: string[] | null;
        /**
         * URL of the router resource to be used for dynamic routing.
         */
        router?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
         */
        sharedSecret?: string | null;
        /**
         * Hash of the shared secret.
         */
        sharedSecretHash?: string | null;
        /**
         * [Output Only] The status of the VPN tunnel, which can be one of the following:
         * - PROVISIONING: Resource is being allocated for the VPN tunnel.
         * - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel.
         * - FIRST_HANDSHAKE: Successful first handshake with the peer VPN.
         * - ESTABLISHED: Secure session is successfully established with the peer VPN.
         * - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS
         * - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret).
         * - NEGOTIATION_FAILURE: Handshake failed.
         * - DEPROVISIONING: Resources are being deallocated for the VPN tunnel.
         * - FAILED: Tunnel creation has failed and the tunnel is not ready to be used.
         * - NO_INCOMING_PACKETS: No incoming packets from peer.
         * - REJECTED: Tunnel configuration was rejected, can be result of being denied access.
         * - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources.
         * - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state.
         * - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT.
         * - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
         */
        status?: string | null;
        /**
         * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created.
         */
        targetVpnGateway?: string | null;
        /**
         * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
         */
        vpnGateway?: string | null;
        /**
         * The interface ID of the VPN gateway with which this VPN tunnel is associated.
         */
        vpnGatewayInterface?: number | null;
    }
    export interface Schema$VpnTunnelAggregatedList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of VpnTunnelsScopedList resources.
         */
        items?: {
            [key: string]: Schema$VpnTunnelsScopedList;
        } | null;
        /**
         * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Unreachable resources.
         */
        unreachables?: string[] | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Contains a list of VpnTunnel resources.
     */
    export interface Schema$VpnTunnelList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of VpnTunnel resources.
         */
        items?: Schema$VpnTunnel[];
        /**
         * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$VpnTunnelsScopedList {
        /**
         * A list of VPN tunnels contained in this scope.
         */
        vpnTunnels?: Schema$VpnTunnel[];
        /**
         * Informational warning which replaces the list of addresses when the list is empty.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$WafExpressionSet {
        /**
         * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
         */
        aliases?: string[] | null;
        /**
         * List of available expressions.
         */
        expressions?: Schema$WafExpressionSetExpression[];
        /**
         * Google specified expression set ID. The format should be: - E.g. XSS-20170329
         */
        id?: string | null;
    }
    export interface Schema$WafExpressionSetExpression {
        /**
         * Expression ID should uniquely identify the origin of the expression. E.g. owasp-crs-v020901-id973337 identifies Owasp core rule set version 2.9.1 rule id 973337. The ID could be used to determine the individual attack definition that has been detected. It could also be used to exclude it from the policy in case of false positive.
         */
        id?: string | null;
    }
    /**
     * In contrast to a single BackendService in  HttpRouteAction to which all matching traffic is directed to, WeightedBackendService allows traffic to be split across multiple BackendServices. The volume of traffic for each BackendService is proportional to the weight specified in each WeightedBackendService
     */
    export interface Schema$WeightedBackendService {
        /**
         * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the loadbalancer applies any relevant headerActions specified as part of this backendServiceWeight.
         */
        backendService?: string | null;
        /**
         * Specifies changes to request and response headers that need to take effect for the selected backendService.
         * headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap.
         * Note that headerAction is not supported for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
         * Not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
         */
        headerAction?: Schema$HttpHeaderAction;
        /**
         * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
         * The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backendService, subsequent requests will be sent to the same backendService as determined by the BackendService's session affinity policy.
         * The value must be between 0 and 1000
         */
        weight?: number | null;
    }
    export interface Schema$XpnHostList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] A list of shared VPC host project URLs.
         */
        items?: Schema$Project[];
        /**
         * [Output Only] Type of resource. Always compute#xpnHostList for lists of shared VPC hosts.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    /**
     * Service resource (a.k.a service project) ID.
     */
    export interface Schema$XpnResourceId {
        /**
         * The ID of the service resource. In the case of projects, this field supports project id (e.g., my-project-123) and project number (e.g. 12345678).
         */
        id?: string | null;
        /**
         * The type of the service resource.
         */
        type?: string | null;
    }
    /**
     * Represents a Zone resource.
     *
     * A zone is a deployment area. These deployment areas are subsets of a region. For example the zone us-east1-a is located in the us-east1 region. For more information, read Regions and Zones. (== resource_for {$api_version\}.zones ==)
     */
    export interface Schema$Zone {
        /**
         * [Output Only] Available cpu/platform selections for the zone.
         */
        availableCpuPlatforms?: string[] | null;
        /**
         * [Output Only] Creation timestamp in RFC3339 text format.
         */
        creationTimestamp?: string | null;
        /**
         * [Output Only] The deprecation status associated with this zone.
         */
        deprecated?: Schema$DeprecationStatus;
        /**
         * [Output Only] Textual description of the resource.
         */
        description?: string | null;
        /**
         * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
         */
        id?: string | null;
        /**
         * [Output Only] Type of the resource. Always compute#zone for zones.
         */
        kind?: string | null;
        /**
         * [Output Only] Name of the resource.
         */
        name?: string | null;
        /**
         * [Output Only] Full URL reference to the region which hosts the zone.
         */
        region?: string | null;
        /**
         * [Output Only] Server-defined URL for the resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Status of the zone, either UP or DOWN.
         */
        status?: string | null;
        /**
         * [Output Only] Reserved for future use.
         */
        supportsPzs?: boolean | null;
    }
    export interface Schema$ZoneInstantSnapshotsExportRequest {
        /**
         * Parameters to export the changed blocks.
         */
        exportParams?: Schema$InstantSnapshotExportParams;
    }
    /**
     * Contains a list of zone resources.
     */
    export interface Schema$ZoneList {
        /**
         * [Output Only] Unique identifier for the resource; defined by the server.
         */
        id?: string | null;
        /**
         * A list of Zone resources.
         */
        items?: Schema$Zone[];
        /**
         * Type of resource.
         */
        kind?: string | null;
        /**
         * [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
         */
        nextPageToken?: string | null;
        /**
         * [Output Only] Server-defined URL for this resource.
         */
        selfLink?: string | null;
        /**
         * [Output Only] Informational warning message.
         */
        warning?: {
            code?: string;
            data?: Array<{
                key?: string;
                value?: string;
            }>;
            message?: string;
        } | null;
    }
    export interface Schema$ZoneSetLabelsRequest {
        /**
         * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.
         */
        labelFingerprint?: string | null;
        /**
         * The labels to set for this resource.
         */
        labels?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$ZoneSetPolicyRequest {
        /**
         * Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use 'policy' to specify bindings.
         */
        bindings?: Schema$Binding[];
        /**
         * Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
         */
        etag?: string | null;
        /**
         * REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
         */
        policy?: Schema$Policy;
    }
    export class Resource$Acceleratortypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Retrieves an aggregated list of accelerator types.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.acceleratorTypes.aggregatedList({
         *     // A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *     //
         *     // For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *     //
         *     // You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *     //
         *     // To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         *     filter: 'placeholder-value',
         *     // Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
         *     includeAllScopes: 'placeholder-value',
         *     // The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         *     maxResults: 'placeholder-value',
         *     // Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *     //
         *     // You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *     //
         *     // Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         *     orderBy: 'placeholder-value',
         *     // Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         *     pageToken: 'placeholder-value',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         *     returnPartialSuccess: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "id": "my_id",
         *   //   "items": {},
         *   //   "kind": "my_kind",
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "selfLink": "my_selfLink",
         *   //   "unreachables": [],
         *   //   "warning": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        aggregatedList(params: Params$Resource$Acceleratortypes$Aggregatedlist, options: StreamMethodOptions): GaxiosPromise<Readable>;
        aggregatedList(params?: Params$Resource$Acceleratortypes$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$AcceleratorTypeAggregatedList>;
        aggregatedList(params: Params$Resource$Acceleratortypes$Aggregatedlist, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        aggregatedList(params: Params$Resource$Acceleratortypes$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>, callback: BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>): void;
        aggregatedList(params: Params$Resource$Acceleratortypes$Aggregatedlist, callback: BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$AcceleratorTypeAggregatedList>): void;
        /**
         * Returns the specified accelerator type.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.acceleratorTypes.get({
         *     // Name of the accelerator type to return.
         *     acceleratorType: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // The name of the zone for this request.
         *     zone: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "creationTimestamp": "my_creationTimestamp",
         *   //   "deprecated": {},
         *   //   "description": "my_description",
         *   //   "id": "my_id",
         *   //   "kind": "my_kind",
         *   //   "maximumCardsPerInstance": 0,
         *   //   "name": "my_name",
         *   //   "selfLink": "my_selfLink",
         *   //   "selfLinkWithId": "my_selfLinkWithId",
         *   //   "zone": "my_zone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Acceleratortypes$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Acceleratortypes$Get, options?: MethodOptions): GaxiosPromise<Schema$AcceleratorType>;
        get(params: Params$Resource$Acceleratortypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Acceleratortypes$Get, options: MethodOptions | BodyResponseCallback<Schema$AcceleratorType>, callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        get(params: Params$Resource$Acceleratortypes$Get, callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        get(callback: BodyResponseCallback<Schema$AcceleratorType>): void;
        /**
         * Retrieves a list of accelerator types that are available to the specified project.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.acceleratorTypes.list({
         *     // A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *     //
         *     // For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *     //
         *     // You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *     //
         *     // To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         *     filter: 'placeholder-value',
         *     // The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         *     maxResults: 'placeholder-value',
         *     // Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *     //
         *     // You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *     //
         *     // Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         *     orderBy: 'placeholder-value',
         *     // Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         *     pageToken: 'placeholder-value',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         *     returnPartialSuccess: 'placeholder-value',
         *     // The name of the zone for this request.
         *     zone: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "id": "my_id",
         *   //   "items": [],
         *   //   "kind": "my_kind",
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "selfLink": "my_selfLink",
         *   //   "warning": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Acceleratortypes$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Acceleratortypes$List, options?: MethodOptions): GaxiosPromise<Schema$AcceleratorTypeList>;
        list(params: Params$Resource$Acceleratortypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Acceleratortypes$List, options: MethodOptions | BodyResponseCallback<Schema$AcceleratorTypeList>, callback: BodyResponseCallback<Schema$AcceleratorTypeList>): void;
        list(params: Params$Resource$Acceleratortypes$List, callback: BodyResponseCallback<Schema$AcceleratorTypeList>): void;
        list(callback: BodyResponseCallback<Schema$AcceleratorTypeList>): void;
    }
    export interface Params$Resource$Acceleratortypes$Aggregatedlist extends StandardParameters {
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *
         * For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *
         * You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *
         * To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         */
        filter?: string;
        /**
         * Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
         */
        includeAllScopes?: boolean;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *
         * You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *
         * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         */
        returnPartialSuccess?: boolean;
    }
    export interface Params$Resource$Acceleratortypes$Get extends StandardParameters {
        /**
         * Name of the accelerator type to return.
         */
        acceleratorType?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export interface Params$Resource$Acceleratortypes$List extends StandardParameters {
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *
         * For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *
         * You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *
         * To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *
         * You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *
         * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         */
        returnPartialSuccess?: boolean;
        /**
         * The name of the zone for this request.
         */
        zone?: string;
    }
    export class Resource$Addresses {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Retrieves an aggregated list of addresses.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.addresses.aggregatedList({
         *     // A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *     //
         *     // For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *     //
         *     // You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *     //
         *     // To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         *     filter: 'placeholder-value',
         *     // Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
         *     includeAllScopes: 'placeholder-value',
         *     // The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         *     maxResults: 'placeholder-value',
         *     // Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *     //
         *     // You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *     //
         *     // Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         *     orderBy: 'placeholder-value',
         *     // Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         *     pageToken: 'placeholder-value',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         *     returnPartialSuccess: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "id": "my_id",
         *   //   "items": {},
         *   //   "kind": "my_kind",
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "selfLink": "my_selfLink",
         *   //   "unreachables": [],
         *   //   "warning": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        aggregatedList(params: Params$Resource$Addresses$Aggregatedlist, options: StreamMethodOptions): GaxiosPromise<Readable>;
        aggregatedList(params?: Params$Resource$Addresses$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$AddressAggregatedList>;
        aggregatedList(params: Params$Resource$Addresses$Aggregatedlist, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        aggregatedList(params: Params$Resource$Addresses$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$AddressAggregatedList>, callback: BodyResponseCallback<Schema$AddressAggregatedList>): void;
        aggregatedList(params: Params$Resource$Addresses$Aggregatedlist, callback: BodyResponseCallback<Schema$AddressAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$AddressAggregatedList>): void;
        /**
         * Deletes the specified address resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.addresses.delete({
         *     // Name of the address resource to delete.
         *     address: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Name of the region for this request.
         *     region: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *     // An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.
         *     //
         *     // For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.
         *     //
         *     // The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         *     requestId: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "clientOperationId": "my_clientOperationId",
         *   //   "creationTimestamp": "my_creationTimestamp",
         *   //   "description": "my_description",
         *   //   "endTime": "my_endTime",
         *   //   "error": {},
         *   //   "httpErrorMessage": "my_httpErrorMessage",
         *   //   "httpErrorStatusCode": 0,
         *   //   "id": "my_id",
         *   //   "insertTime": "my_insertTime",
         *   //   "kind": "my_kind",
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "operationGroupId": "my_operationGroupId",
         *   //   "operationType": "my_operationType",
         *   //   "progress": 0,
         *   //   "region": "my_region",
         *   //   "selfLink": "my_selfLink",
         *   //   "selfLinkWithId": "my_selfLinkWithId",
         *   //   "startTime": "my_startTime",
         *   //   "status": "my_status",
         *   //   "statusMessage": "my_statusMessage",
         *   //   "targetId": "my_targetId",
         *   //   "targetLink": "my_targetLink",
         *   //   "user": "my_user",
         *   //   "warnings": [],
         *   //   "zone": "my_zone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Addresses$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Addresses$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Addresses$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Addresses$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Addresses$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * Returns the specified address resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.addresses.get({
         *     // Name of the address resource to return.
         *     address: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Name of the region for this request.
         *     region: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "address": "my_address",
         *   //   "addressType": "my_addressType",
         *   //   "creationTimestamp": "my_creationTimestamp",
         *   //   "description": "my_description",
         *   //   "id": "my_id",
         *   //   "ipVersion": "my_ipVersion",
         *   //   "kind": "my_kind",
         *   //   "labelFingerprint": "my_labelFingerprint",
         *   //   "labels": {},
         *   //   "name": "my_name",
         *   //   "network": "my_network",
         *   //   "networkTier": "my_networkTier",
         *   //   "prefixLength": 0,
         *   //   "purpose": "my_purpose",
         *   //   "region": "my_region",
         *   //   "selfLink": "my_selfLink",
         *   //   "selfLinkWithId": "my_selfLinkWithId",
         *   //   "status": "my_status",
         *   //   "subnetwork": "my_subnetwork",
         *   //   "users": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Addresses$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Addresses$Get, options?: MethodOptions): GaxiosPromise<Schema$Address>;
        get(params: Params$Resource$Addresses$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Addresses$Get, options: MethodOptions | BodyResponseCallback<Schema$Address>, callback: BodyResponseCallback<Schema$Address>): void;
        get(params: Params$Resource$Addresses$Get, callback: BodyResponseCallback<Schema$Address>): void;
        get(callback: BodyResponseCallback<Schema$Address>): void;
        /**
         * Creates an address resource in the specified project by using the data included in the request.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.addresses.insert({
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Name of the region for this request.
         *     region: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *     // An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.
         *     //
         *     // For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.
         *     //
         *     // The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         *     requestId: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "address": "my_address",
         *       //   "addressType": "my_addressType",
         *       //   "creationTimestamp": "my_creationTimestamp",
         *       //   "description": "my_description",
         *       //   "id": "my_id",
         *       //   "ipVersion": "my_ipVersion",
         *       //   "kind": "my_kind",
         *       //   "labelFingerprint": "my_labelFingerprint",
         *       //   "labels": {},
         *       //   "name": "my_name",
         *       //   "network": "my_network",
         *       //   "networkTier": "my_networkTier",
         *       //   "prefixLength": 0,
         *       //   "purpose": "my_purpose",
         *       //   "region": "my_region",
         *       //   "selfLink": "my_selfLink",
         *       //   "selfLinkWithId": "my_selfLinkWithId",
         *       //   "status": "my_status",
         *       //   "subnetwork": "my_subnetwork",
         *       //   "users": []
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "clientOperationId": "my_clientOperationId",
         *   //   "creationTimestamp": "my_creationTimestamp",
         *   //   "description": "my_description",
         *   //   "endTime": "my_endTime",
         *   //   "error": {},
         *   //   "httpErrorMessage": "my_httpErrorMessage",
         *   //   "httpErrorStatusCode": 0,
         *   //   "id": "my_id",
         *   //   "insertTime": "my_insertTime",
         *   //   "kind": "my_kind",
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "operationGroupId": "my_operationGroupId",
         *   //   "operationType": "my_operationType",
         *   //   "progress": 0,
         *   //   "region": "my_region",
         *   //   "selfLink": "my_selfLink",
         *   //   "selfLinkWithId": "my_selfLinkWithId",
         *   //   "startTime": "my_startTime",
         *   //   "status": "my_status",
         *   //   "statusMessage": "my_statusMessage",
         *   //   "targetId": "my_targetId",
         *   //   "targetLink": "my_targetLink",
         *   //   "user": "my_user",
         *   //   "warnings": [],
         *   //   "zone": "my_zone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        insert(params: Params$Resource$Addresses$Insert, options: StreamMethodOptions): GaxiosPromise<Readable>;
        insert(params?: Params$Resource$Addresses$Insert, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        insert(params: Params$Resource$Addresses$Insert, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        insert(params: Params$Resource$Addresses$Insert, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(params: Params$Resource$Addresses$Insert, callback: BodyResponseCallback<Schema$Operation>): void;
        insert(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * Retrieves a list of addresses contained within the specified region.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.addresses.list({
         *     // A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *     //
         *     // For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *     //
         *     // You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *     //
         *     // To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         *     filter: 'placeholder-value',
         *     // The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         *     maxResults: 'placeholder-value',
         *     // Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *     //
         *     // You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *     //
         *     // Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         *     orderBy: 'placeholder-value',
         *     // Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         *     pageToken: 'placeholder-value',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Name of the region for this request.
         *     region: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *     // Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         *     returnPartialSuccess: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "id": "my_id",
         *   //   "items": [],
         *   //   "kind": "my_kind",
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "selfLink": "my_selfLink",
         *   //   "warning": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Addresses$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Addresses$List, options?: MethodOptions): GaxiosPromise<Schema$AddressList>;
        list(params: Params$Resource$Addresses$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Addresses$List, options: MethodOptions | BodyResponseCallback<Schema$AddressList>, callback: BodyResponseCallback<Schema$AddressList>): void;
        list(params: Params$Resource$Addresses$List, callback: BodyResponseCallback<Schema$AddressList>): void;
        list(callback: BodyResponseCallback<Schema$AddressList>): void;
        /**
         * Sets the labels on an Address. To learn more about labels, read the Labeling Resources documentation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.addresses.setLabels({
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // The region for this request.
         *     region: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *     // An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.
         *     //
         *     // For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.
         *     //
         *     // The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         *     requestId: 'placeholder-value',
         *     // Name or id of the resource for this request.
         *     resource: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "labelFingerprint": "my_labelFingerprint",
         *       //   "labels": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "clientOperationId": "my_clientOperationId",
         *   //   "creationTimestamp": "my_creationTimestamp",
         *   //   "description": "my_description",
         *   //   "endTime": "my_endTime",
         *   //   "error": {},
         *   //   "httpErrorMessage": "my_httpErrorMessage",
         *   //   "httpErrorStatusCode": 0,
         *   //   "id": "my_id",
         *   //   "insertTime": "my_insertTime",
         *   //   "kind": "my_kind",
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "operationGroupId": "my_operationGroupId",
         *   //   "operationType": "my_operationType",
         *   //   "progress": 0,
         *   //   "region": "my_region",
         *   //   "selfLink": "my_selfLink",
         *   //   "selfLinkWithId": "my_selfLinkWithId",
         *   //   "startTime": "my_startTime",
         *   //   "status": "my_status",
         *   //   "statusMessage": "my_statusMessage",
         *   //   "targetId": "my_targetId",
         *   //   "targetLink": "my_targetLink",
         *   //   "user": "my_user",
         *   //   "warnings": [],
         *   //   "zone": "my_zone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setLabels(params: Params$Resource$Addresses$Setlabels, options: StreamMethodOptions): GaxiosPromise<Readable>;
        setLabels(params?: Params$Resource$Addresses$Setlabels, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        setLabels(params: Params$Resource$Addresses$Setlabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setLabels(params: Params$Resource$Addresses$Setlabels, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        setLabels(params: Params$Resource$Addresses$Setlabels, callback: BodyResponseCallback<Schema$Operation>): void;
        setLabels(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * Returns permissions that a caller has on the specified resource.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.addresses.testIamPermissions({
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // The name of the region for this request.
         *     region: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *     // Name or id of the resource for this request.
         *     resource: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "permissions": []
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "permissions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        testIamPermissions(params: Params$Resource$Addresses$Testiampermissions, options: StreamMethodOptions): GaxiosPromise<Readable>;
        testIamPermissions(params?: Params$Resource$Addresses$Testiampermissions, options?: MethodOptions): GaxiosPromise<Schema$TestPermissionsResponse>;
        testIamPermissions(params: Params$Resource$Addresses$Testiampermissions, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        testIamPermissions(params: Params$Resource$Addresses$Testiampermissions, options: MethodOptions | BodyResponseCallback<Schema$TestPermissionsResponse>, callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
        testIamPermissions(params: Params$Resource$Addresses$Testiampermissions, callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
        testIamPermissions(callback: BodyResponseCallback<Schema$TestPermissionsResponse>): void;
    }
    export interface Params$Resource$Addresses$Aggregatedlist extends StandardParameters {
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *
         * For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *
         * You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *
         * To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         */
        filter?: string;
        /**
         * Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
         */
        includeAllScopes?: boolean;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *
         * You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *
         * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         */
        returnPartialSuccess?: boolean;
    }
    export interface Params$Resource$Addresses$Delete extends StandardParameters {
        /**
         * Name of the address resource to delete.
         */
        address?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.
         *
         * For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.
         *
         * The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
    }
    export interface Params$Resource$Addresses$Get extends StandardParameters {
        /**
         * Name of the address resource to return.
         */
        address?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
    }
    export interface Params$Resource$Addresses$Insert extends StandardParameters {
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.
         *
         * For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.
         *
         * The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Address;
    }
    export interface Params$Resource$Addresses$List extends StandardParameters {
        /**
         * A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *
         * For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *
         * You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *
         * To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         */
        filter?: string;
        /**
         * The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         */
        maxResults?: number;
        /**
         * Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *
         * You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *
         * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         */
        orderBy?: string;
        /**
         * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         */
        pageToken?: string;
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * Name of the region for this request.
         */
        region?: string;
        /**
         * Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         */
        returnPartialSuccess?: boolean;
    }
    export interface Params$Resource$Addresses$Setlabels extends StandardParameters {
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The region for this request.
         */
        region?: string;
        /**
         * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.
         *
         * For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.
         *
         * The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         */
        requestId?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$RegionSetLabelsRequest;
    }
    export interface Params$Resource$Addresses$Testiampermissions extends StandardParameters {
        /**
         * Project ID for this request.
         */
        project?: string;
        /**
         * The name of the region for this request.
         */
        region?: string;
        /**
         * Name or id of the resource for this request.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$TestPermissionsRequest;
    }
    export class Resource$Autoscalers {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Retrieves an aggregated list of autoscalers.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *       'https://www.googleapis.com/auth/compute.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.autoscalers.aggregatedList({
         *     // A filter expression that filters resources listed in the response. The expression must specify the field name, a comparison operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The comparison operator must be either `=`, `!=`, `\>`, or `<`.
         *     //
         *     // For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`.
         *     //
         *     // You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels.
         *     //
         *     // To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
         *     filter: 'placeholder-value',
         *     // Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
         *     includeAllScopes: 'placeholder-value',
         *     // The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
         *     maxResults: 'placeholder-value',
         *     // Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name.
         *     //
         *     // You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first.
         *     //
         *     // Currently, only sorting by `name` or `creationTimestamp desc` is supported.
         *     orderBy: 'placeholder-value',
         *     // Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
         *     pageToken: 'placeholder-value',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
         *     returnPartialSuccess: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "id": "my_id",
         *   //   "items": {},
         *   //   "kind": "my_kind",
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "selfLink": "my_selfLink",
         *   //   "unreachables": [],
         *   //   "warning": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        aggregatedList(params: Params$Resource$Autoscalers$Aggregatedlist, options: StreamMethodOptions): GaxiosPromise<Readable>;
        aggregatedList(params?: Params$Resource$Autoscalers$Aggregatedlist, options?: MethodOptions): GaxiosPromise<Schema$AutoscalerAggregatedList>;
        aggregatedList(params: Params$Resource$Autoscalers$Aggregatedlist, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        aggregatedList(params: Params$Resource$Autoscalers$Aggregatedlist, options: MethodOptions | BodyResponseCallback<Schema$AutoscalerAggregatedList>, callback: BodyResponseCallback<Schema$AutoscalerAggregatedList>): void;
        aggregatedList(params: Params$Resource$Autoscalers$Aggregatedlist, callback: BodyResponseCallback<Schema$AutoscalerAggregatedList>): void;
        aggregatedList(callback: BodyResponseCallback<Schema$AutoscalerAggregatedList>): void;
        /**
         * Deletes the specified autoscaler.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const compute = google.compute('alpha');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/compute',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await compute.autoscalers.delete({
         *     // Name of the autoscaler to delete.
         *     autoscaler: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}',
         *     // Project ID for this request.
         *     project:
         *       '(?:(?:[-a-z0-9]{1,63}.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))',
         *     // An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed.
         *     //
         *     // For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments.
         *     //
         *     // The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
         *     requestId: 'placeholder-value',
         *     // Name of the zone for this request.
         *     zone: '[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "clientOperationId": "my_clientOperationId",
         *   //   "creationTimestamp": "my_creationTimestamp",
         *   //   "description": "my_description",
         *   //   "endTime": "my_endTime",
         *   //   "error": {},
         *   //   "httpErrorMessage": "my_httpErrorMessage",
         *   //   "httpErrorStatusCode": 0,
         *   //   "id": "my_id",
         *   //   "insertTime": "my_insertTime",
         *   //   "kind": "my_kind",
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "operationGroupId": "my_operationGroupId",
         *   //   "operationType": "my_operationType",
         *   //   "progress": 0,
         *   //   "region": "my_region",
         *   //   "selfLink": "my_selfLink",
         *   //   "selfLinkWithId": "my_selfLinkWithId",
         *   //   "startTime": "my_startTime",
         *   //   "status": "my_status",
         *   //   "statusMessage": "my_statusMessage",
         *   //   "targetId": "my_targetId",
         *   //   "targetLink": "my_targetLink",
         *   //   "user": "my_user",
         *   //   "warnings": [],
         *   //   "zone": "my_zone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Autoscalers$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Autoscalers$Delete, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        delete(params: Params$Resource$Autoscalers$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Autoscalers$Delete, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(params: Params$Resource$Autoscalers$Delete, callback: BodyResponseCallback<Schema$Operation>): void;
        delete(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * Returns the specified autoscaler resource. Gets a list of available autoscalers by making a list() request.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/compute.googleapis.com
         * // - Login into gcloud by running:
    