/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.lock;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.dependency.jsr305.concurrent.GuardedBy;
import org.assertj.swing.dependency.jsr305.concurrent.ThreadSafe;
import org.assertj.swing.exception.ScreenLockException;

@ThreadSafe
public final class ScreenLock {
    private final Lock lock = new ReentrantLock();
    private final Condition released = this.lock.newCondition();
    @GuardedBy(value="lock")
    private Object owner;
    @GuardedBy(value="lock")
    private boolean acquired;

    public void acquire(@Nonnull Object newOwner) {
        this.lock.lock();
        try {
            if (this.alreadyAcquiredBy(newOwner)) {
                return;
            }
            while (this.acquired) {
                this.released.await();
            }
            this.owner = newOwner;
            this.acquired = true;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void release(@Nonnull Object currentOwner) {
        this.lock.lock();
        try {
            if (!this.acquired) {
                throw new ScreenLockException("No lock to release");
            }
            if (this.owner != currentOwner) {
                throw new ScreenLockException(String.format("%s is not the lock owner", currentOwner.toString()));
            }
            this.acquired = false;
            this.owner = null;
            this.released.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquiredBy(@Nonnull Object possibleOwner) {
        this.lock.lock();
        try {
            boolean bl = this.alreadyAcquiredBy(possibleOwner);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean alreadyAcquiredBy(@Nonnull Object possibleOwner) {
        return this.acquired && this.owner == possibleOwner;
    }

    public boolean acquired() {
        this.lock.lock();
        try {
            boolean bl = this.acquired;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Object getOwner() {
        this.lock.lock();
        try {
            Object object = this.owner;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nonnull
    public static ScreenLock instance() {
        return ScreenLockHolder.instance;
    }

    ScreenLock() {
    }

    private static class ScreenLockHolder {
        static ScreenLock instance = new ScreenLock();

        private ScreenLockHolder() {
        }
    }
}

